/*
 * MosP - Mind Open Source Project         http://www.mosp.jp/
 * Copyright (C) 1987-2009 MIND Co., Ltd.  http://www.e-mind.co.jp/
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */
package jp.mosp.common.action;

import java.util.Date;

import jp.mosp.common.common.BaseAction;
import jp.mosp.common.common.BaseVo;
import jp.mosp.common.common.MospConst;
import jp.mosp.common.common.MospException;
import jp.mosp.common.common.MospUtility;
import jp.mosp.common.dao.CmUserDao;
import jp.mosp.common.dto.CmUserDto;
import jp.mosp.common.vo.PasswordVo;

/**
 * pX[hύXʂɂ鏈sB<br><br>
 */
public class PasswordAction extends BaseAction {
	
	// R}h
	private static final String CMD_PASSWORD_SHOW   = "C1050";
	private static final String CMD_PASSWORD_CHANGE = "C1051";
	private static final String CMD_PASS_FORCE      = MospConst.CMD_PASS_FORCE;
	
	/**
	 * RXgN^B<br>
	 * mFsvݒ肷B<br>
	 */
	public PasswordAction() {
		super();
		// ʏݒ
		setCheckAuth   (false);
	}
	
	/**
	 * ANVB<br>
	 */
	public void action() throws Exception {
		// VO
		prepareVo();
		// j[R}hݒ
		setCmdMenu();
		// R}h̏
		if (cmd.equals(CMD_PASSWORD_SHOW)) {
			// \
			show();
		} else if (cmd.equals(CMD_PASSWORD_CHANGE)) {
			// XV
			update();
		} else if (cmd.equals(CMD_PASS_FORCE)) {
			// \(pX[hύX)
			showForce();
		} else {
			throw new MospException(MospConst.EX_CMD_INVALID);
		}
	}
	
	/* (non-Javadoc)
	 * @see jp.mosp.common.common.BaseAction#getSpecificVo()
	 */
	@Override
	protected BaseVo getSpecificVo() {
		return new PasswordVo(cfg, msg, nam, cmd, aspUser, user);
	}
	
	/**
	 * \B<br>
	 * OC[U[̃[U[IDA[U[ݒ肷B<br>
	 * @throws Exception
	 */
	protected void show() throws Exception {
		// VO
		chkInstance(getVo() instanceof PasswordVo);
		PasswordVo vo = (PasswordVo)getVo();
		// ݒ
		vo.setUserId  (user.getUserId  ());
		vo.setUserName(user.getUserName());
		// j[փ{^̕\
		vo.setMode(PasswordVo.MODE_SHOW);
	}
	
	/**
	 * \(pX[hύX)B<br>
	 * OC[U[̃[U[IDA[U[ݒ肷B<br>
	 * @throws Exception
	 */
	protected void showForce() throws Exception {
		// VO
		chkInstance(getVo() instanceof PasswordVo);
		PasswordVo vo = (PasswordVo)getVo();
		// ݒ
		vo.setUserId  (user.getUserId  ());
		vo.setUserName(user.getUserName());
		// j[փ{^̕\
		vo.setMode(PasswordVo.MODE_FORCE_UPDATE);
	}
	
	/**
	 * f[^XV
	 * @param vo ΏVO
	 * @throws Exception
	 */
	private void update() throws Exception {
		// VO
		chkInstance(getVo() instanceof PasswordVo);
		PasswordVo vo = (PasswordVo)getVo();
		// p[^擾
		vo.setParams(request);
		// RlNV̎擾yDAȌ
		getConnection();
		CmUserDao dao = new CmUserDao(cfg, cmd, aspUser, user, conn);
		// DTȌ
		CmUserDto dto = dao.findForUpdate(vo.getUserId());
		// ݊mF
		chkExist(dto);
		// p[^̑ÓmF
		vo.validate(dto.getPassword());
		// l̐ݒ
		dto.setPassword(MospUtility.encrypt(vo.getHdnNewPassword(), hasMospSeJar()));
		// pX[hύXZbgB
		dto.setChangePass(new Date());
		// f[^̍XV
		dao.update(dto);
		// R~bg
		commit();
		// bZ[Wݒ
		vo.setMessage(MospUtility.getMessage(msg, MospConst.MSG_UPDATE, ""));
		// j[փ{^̕\
		vo.setMode(PasswordVo.MODE_SHOW);
	}

	/**
	 * j[R}hݒ
	 * @param vo ݒΏVO
	 * @throws MospException 
	 */
	private void setCmdMenu() throws MospException {
		// VO
		chkInstance(getVo() instanceof PasswordVo);
		PasswordVo vo = (PasswordVo)getVo();
		// ɂݒ
		if (user.getAuthority().equals(MospConst.AUTH_MOSP_ADMIN)) {
			vo.setCmdMenu(MospConst.CMD_ADMIN_MENU);
		} else {
			vo.setCmdMenu(MospConst.CMD_MENU);
		}
	}

}
