/*
 * MosP - Mind Open Source Project         http://www.mosp.jp/
 * Copyright (C) 1987-2009 MIND Co., Ltd.  http://www.e-mind.co.jp/
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */
package jp.mosp.common.action;

import jp.mosp.common.common.BaseAction;
import jp.mosp.common.common.LogUtility;
import jp.mosp.common.common.MospConst;
import jp.mosp.common.common.MospUtility;

/**
 * OAEg@\񋟂B<br><br>
 * OAEgAy[W֑JڂB<br>
 */
public class LogoutAction extends BaseAction {
	
	/**
	 * RXgN^B<br>
	 */
	public LogoutAction() {
		super();
		setCheckAuth(false);
	}
	
	/**
	 * ANVB<br>
	 * OAEgsB<br>
	 */
	public void action() throws Exception {
		// OAEg
		logout();
		// OAEgsR}hݒ
		setCmdAfterLogout();
	}
	
	/**
	 * OAEgB<br>
	 * ZbVAR}hݒ肷B<br>
	 */
	protected void logout() throws Exception {
		// ZbV̏
		if (session != null) {
			session.invalidate();
		}
		session = request.getSession(true);
		// bZ[W̐ݒ
		request.setAttribute(MospConst.ATT_MESSAGE, MospUtility.getMessage(msg, MospConst.MSG_LOGOUT, ""));
		// Oo
		LogUtility.log(request, 4, MospConst.LOG_MOSPINF, MospConst.LOG_MSG_LOGOUT);
	}
	
	/**
	 * OAEgsR}hݒ<br>
	 * ZbVAR}hݒ肷B<br>
	 */
	protected void setCmdAfterLogout() throws Exception {
		// R}hyёJڐ̐ݒ
		setNextCmd(getIndexCommand(false));
		setUrl(MospConst.URL_SRV);
	}
	
}
