/*
 * Copyright (c) 2003, Morpho Project.
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 * 1. Redistributions of source code must retain the above copyright notice,
 *	  this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright notice,
 *	  this list of conditions and the following disclaimer in the documentation
 *	  and/or other materials provided with the distribution.
 * 3. Neither the name of the Morpho Project nor the names of its contributors
 *	  may be used to endorse or promote products derived from this software
 *	  without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGE.
 */
package jp.morpho.webapp.servlet.jsp.tagext.html;

/**
 * <P>
 * HTML üʸ沽뤿Υ᥽åɤޤ
 * ޥ͡㤬ѤǥեȤ HtmlEncoder Ǥ
 * </P>
 * @author Kumiko Hiroi
 */
public class HtmlEncoderImpl
	 implements HtmlEncoder
{
	/**
	 * <P>
	 * HtmlEncoderImpl ޤ
	 * </P>
	 */
	public HtmlEncoderImpl()
	{
		super();
	}

	/**
	 * <P>
	 * HTML üʸ沽ޤ
	 * </P>
	 * @param value HTML üʸޤ String
	 * @return HTML üʸ沽줿 String
	 * @see jp.morpho.webapp.servlet.jsp.tagext.html.HtmlEncoder#encode(String)
	 */
	public synchronized String encode(String value)
	{
		StringBuffer buf = new StringBuffer();
		char[] ca = value.toCharArray();
		for (int i = 0; i < ca.length; i++)
		{
			switch (ca[i])
			{
				//--------------------
				//ISO 8859-1 (Latin 1)
				//--------------------
				case 0x0020:	//no-break space = non-breaking space (U+00A0 ISOnum)
					buf.append("&#160;");
					break;

				//------------------------
				//Controls and Basic Latin
				//------------------------
				case 0x0022:	//quotation mark = APL quote
					buf.append("&#34;");
					break;
				case 0x0026:	//ampersand
					buf.append("&#38;");
					break;
				case 0x003C:	//less-than sign
					buf.append("&#60;");
					break;
				case 0x003E:	//greater-than sign
					buf.append("&#62;");
					break;

				default:
					buf.append(ca[i]);
					break;
			}
		}
		return buf.toString();
	}

}
