/*
 * Copyright (c) 2003, Morpho Project.
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 * 1. Redistributions of source code must retain the above copyright notice,
 *    this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright notice,
 *    this list of conditions and the following disclaimer in the documentation
 *    and/or other materials provided with the distribution.
 * 3. Neither the name of the Morpho Project nor the names of its contributors
 *    may be used to endorse or promote products derived from this software
 *    without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGE.
 */
package jp.morpho.webapp.servlet;

import java.io.IOException;
import java.util.Enumeration;
import java.util.Map;

import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;

import jp.morpho.util.ConversionMap;

/**
 * <P>
 * Υ饹ϡFilter 󥿥եΥȥ󶡤Υ󥿥եΤɬפʺ̤Ǿ¤ޤޤ
 * Filter ϡ꥽ (֥åȡŪƥ) ׵ᡢ꥽αޤϤξФƥե륿󥰺Ȥ¹Ԥ륪֥ȤǤ
 * </P>
 * <P>
 * Filter ϡdoFilter ᥽åɤˤƥե륿󥰤¹Ԥޤ٤Ƥ Filter  FilterConfig ֥ȤإǤΥ֥Ȥ顢ѥ᡼ȡե륿󥰤ɬפʥ꥽Υɤʤɤ˻ѤǤ ServletContext ؤλȤ뤳ȤǤޤ
 * </P>
 * <P>
 * Filter ϡWeb ץꥱһꤵޤ
 * </P>
 * <P>
 * Filter ˤϡΤΤޤ
 * <BR>1) ǧڥե륿
 * <BR>2) ӴƺΥե륿
 * <BR>3) ᡼Ѵե륿
 * <BR>4) ḁ̇̄ե륿
 * <BR>5) Ź沽ե륿
 * <BR>6) ȡ󲽥ե륿
 * <BR>7) ꥽ؤΥ٥Ȥȯե륿
 * <BR>8) XSL/T ե륿
 * <BR>9) MiME ץݥե륿
 * </P>
 * @author Kumiko Hiroi
 */
public abstract class AbstractFilter
	implements Filter
{

	/** ѥ᡼Ǽޥå */
	private ConversionMap parameters = null;

	/** ֥åȥƥ */
	private ServletContext sc = null;

	/**
	 * <P>
	 * AbstractFilter ۤޤ
	 * </P>
	 */
	public AbstractFilter()
	{
		super();
		parameters = new ConversionMap();
	}

	/**
	 * <P>
	 * ե륿ӥϾ֤ˤʤݤˡWeb ƥʤˤäƸƤӽФޤ
	 * ֥åȥƥʤϡե륿򥤥󥹥󥹲ˡinit ᥽åɤ 1 ƤӽФޤ
	 * ե륿˥ե륿󥰺Ȥ¹Ԥ褦׵᤹ˤϡinit ᥽åɤ˽λƤʤФʤޤ
	 * </P>
	 * <P>
	 * Υ᥽åɤϡ٤Ƥνѥ᡼褦˼Ƥޤ
	 * 줿ѥ᡼ϡgetInitParameterMap() ᥽åɤ Map ȤƼǤޤ
	 * Υ᥽åɤ򥪡С饤ɤϡsuper.init(filterConfig) ƤӽФƤ
	 * </P>
	 * <P>
	 * init ᥽åɤΤ줫ξ֤ξ硢Web ƥʤϥե륿򥵡ӥ֤ˤǤޤ
	 * <BR>1.ServletException 򥹥
	 * <BR>2.Web ƥʤˤä줿ˡʤ
	 * </P>
	 * @param filterConfig ֥åȥƥʤˤäƻѤե륿ΤΥ֥
	 * @exception ServletException ե륿Ǥʤä
	 * @see javax.servlet.Filter#init(FilterConfig)
	 */
	public void init(FilterConfig filterConfig) throws ServletException
	{
		sc = filterConfig.getServletContext();
		for(Enumeration enum = filterConfig.getInitParameterNames(); enum.hasMoreElements();)
		{
			String name = (String)enum.nextElement();
			try
			{
				setInitParameter(name, filterConfig.getInitParameter(name));
			}
			catch (Exception e)
			{
			}
		}
	}

	/**
	 * <P>
	 * Filter  doFilter ᥽åɤϡνüˤ꥽򥯥饤Ȥ׵᤹뤳Ȥ򤭤äȤơ׵ȱΥڥݥ˱äϤƤȤˡƥʤ˸ƤӽФޤ
	 * Υ᥽åɤϤ FilterChain ˤäơFilter ׵ȱݥμΥƥƥϤȤǤޤ
	 * </P>
	 * <P>
	 * <DL>
	 * <DD>Filter  doFilter ᥽åɤϡνüˤ꥽򥯥饤Ȥ׵᤹뤳Ȥ򤭤äȤơ׵ȱΥڥݥ˱äϤƤȤˡƥʤ˸ƤӽФޤΥ᥽åɤϤ FilterChain ˤäơFilter ׵ȱݥμΥƥƥϤȤǤޤ
	 * <P>
	 * Υ᥽åɤŵŪʼϡΤ褦˹Ԥޤ
	 * <BR>1. ׵򸡺
	 * <BR>2. ץȤơϥե륿Ѥ˥ƥĤޤϥإåե륿󥰤륫ˤꡢ׵ᥪ֥Ȥåפ
	 * <BR>3. ץȤơϥե륿Ѥ˥ƥĤޤϥإåե륿󥰤륫ˤꡢ֥Ȥåפ
	 * <BR>4. a) FilterChain ֥ȤѤƥμΥƥƥƤӽФ (chain.doFilter())
	 * <BR>4. b) ޤϡ׵ФǤڤ뤿ᡢե륿μΥƥƥ׵ȱΥڥϤʤ
	 * <BR>5. ե륿μΥƥƥƤӽФˡФƥإåľꤹ
	 * </P>
	 * </DL>
	 * </P>
	 * <P>
	 * Υ᥽åɤ϶򤷤Ƥޤ
	 * ɬפǤʤ AbstractFilter 饹Υ֥饹ˤäơΥ᥽åɤǤޤ
	 * </P>
	 * @param request 饤Ȥ֥åȤ˹Ԥ׵ޤ ServletRequest ֥
	 * @param response ֥åȤ饤Ȥޤ ServletResponse ֥
	 * @param chain ե륿
	 * @exception IOException ե륿׵Ȥˡϥ顼Ф줿
	 * @exception ServletException ׵Ǥʤä
	 * @see javax.servlet.Filter#doFilter(ServletRequest, ServletResponse, FilterChain)
	 */
	public void doFilter(
		ServletRequest request,
		ServletResponse response,
		FilterChain chain)
		throws IOException, ServletException
	{
	}

	/**
	 * <P>
	 * ե륿ӥ֤򽪤ݤˡWeb ƥʤˤäƸƤӽФޤ
	 * ե륿 doFilter ᥽åΤ٤ƤΥåɤλ塢ޤϥॢȴ֤᤮ˤΤߡΥ᥽åɤϸƤӽФޤ
	 * Υ᥽åɤƤӽФϡWeb ƥʤϥե륿ΤΥ󥹥󥹤Ф doFilter ٤ȸƤӽФȤϤޤ
	 * </P>
	 * <P>
	 * Υ᥽åɤϡꡢեϥɥ顢åɤʤɤݻƤ꥽뵡񡢤Ӥ٤Ƥλ³Ū֤ȡΥե륿θߤξ֤ȤƱ뤿ε󶡤ޤ
	 * </P>
	 * <P>
	 * Υ᥽åɤ϶򤷤Ƥޤ
	 * ɬפǤʤ AbstractFilter 饹Υ֥饹ˤäơΥ᥽åɤǤޤ
	 * </P>
	 * @see javax.servlet.Filter#destroy()
	 */
	public void destroy()
	{
	}

	/**
	 * <P>
	 * ٤Ƥνѥ᡼Υޥåԥ󥰤Ǽ줿 Map ֤ޤ
	 * ѥ᡼¸ߤʤϡ Map ֤ޤ
	 * </P>
	 * <P>
	 * ֤ Map μϡConversionMap Ǥ
	 * </P>
	 * @return ٤Ƥνѥ᡼Υޥåԥ󥰤Ǽ줿 Map
	 */
	public Map getInitParameterMap()
	{
		return parameters;
	}

	/**
	 * <P>
	 * ѥ᡼ Map ˳Ǽޤ
	 * </P>
	 * @param name ѥ᡼̾
	 * @param value ѥ᡼
	 */
	private void setInitParameter(String name, String value)
	{
		parameters.setString(name, value);
	}

	/**
	 * <P>
	 * ƤӽФ߼¹ԤƤ ServletContext ؤλȤ֤ޤ
	 * </P>
	 * @return ƤӽФ֥åȥƥʤȤäΤ˻ѤƤ ServletContext ֥
	 */
	public ServletContext getServletContext()
	{
		return sc;
	}

}
