/*
 * Copyright (c) 2003, Morpho Project.
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 * 1. Redistributions of source code must retain the above copyright notice,
 *    this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright notice,
 *    this list of conditions and the following disclaimer in the documentation
 *    and/or other materials provided with the distribution.
 * 3. Neither the name of the Morpho Project nor the names of its contributors
 *    may be used to endorse or promote products derived from this software
 *    without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGE.
 */
package jp.morpho.util;

import java.io.InputStream;
import java.io.Reader;
import java.io.Serializable;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;

/**
 * <P>
 * PrimitiveHolderMap μǤ
 * ץߥƥַͤޥåԥ󥰤뤳ȤǤޤ
 * μϡޥåԥ󥰤줿ͤʸѴꡢʸͤѴޤ
 * 㤨СΤ褦˿ͤǼ塢ʸȤƼФȤǤޤ
 * <PRE>
 *     map.setInt("someKey", 999);
 *     String value = map.getString("someKey");
 * </PRE>
 * ʸǼ塢ͤȤƼФȤǤޤ
 * <PRE>
 *     map.setString("someKey", "999");
 *     int value = map.getInt("someKey");
 * </PRE>
 * ʸǼ塢java.util.Date ȤƼФȤǤޤ
 * <PRE>
 *     map.setString("someKey", "2003/04/01");
 *     java.util.Date value = map.getDate("someKey");
 * </PRE>
 * </P>
 * <P>
 * Τ褦ͤѴǽϡWeb ڡեǡʸǼ褦 Web ץꥱǤϡäͭǤ
 * </P>
 * <P>
 * μϡͤϢդ륭 String ξ硢ʸʸ̤ޤ
 *  String ξ硢٤ƾʸѴޤ
 * </P>
 * @author Kenichi Fukuda
 */
public class ConversionMap
	extends MapWrapper
	implements PrimitiveHolderMap, Serializable
{
	//null  String 
	private static final String NULL_STRING = "";

	/**
	 * <P>
	 * ConversionMap ۤơΥޥåפ餹٤ƤΥޥåԥ󥰤 ConversionMap ˥ԡޤ
	 * </P>
	 * @param map åפޥå
	 * @exception IllegalArgumentException ޥåפ null ξ
	 */
	protected ConversionMap(java.util.Map map)
	{
		this();
		putAll(map);
	}

	/**
	 * <P>
	 * ConversionMap ۤޤ
	 * </P>
	 */
	public ConversionMap()
	{
		super(new HashMap());
	}

	private Object getKey(Object key)
	{
		if (key instanceof String)
		{
			return ((String)key).toLowerCase();
		}
		return key;
	}

	/**
	 * <P>
	 * ޥåפΥޥåפͤϥȥ꡼ȤƼޤ
	 * </P>
	 * @param key Ϣդ줿֤ͤ륭
	 * @return ޥåפꤵ줿ޥåפ
	 * @see jp.morpho.util.PrimitiveHolderMap#getInputStream(Object)
	 */
	public synchronized InputStream getInputStream(Object key)
	{
		return (InputStream)get(key);
	}

	/**
	 * <P>
	 * ϥȥ꡼ޥåλΥȴϢդޤ
	 * </P>
	 * @param key ꤵ줿ͤϢդ륭
	 * @param value ꤵ줿˴Ϣդ
	 * @see jp.morpho.util.PrimitiveHolderMap#setInputStream(Object, InputStream)
	 */
	public synchronized void setInputStream(Object key, InputStream value)
	{
		put(key, value);
	}

	/**
	 * <P>
	 * ޥåפΥޥåפͤ java.math.BigDecimal ֥ȤȤƼޤ
	 * </P>
	 * @param key Ϣդ줿֤ͤ륭
	 * @return ޥåפꤵ줿ޥåפ
	 * @see jp.morpho.util.PrimitiveHolderMap#getBigDecimal(Object)
	 */
	public synchronized BigDecimal getBigDecimal(Object key)
	{
		Object obj = get(key);

		if (obj == null)
		{
			return null;
		}

		if (obj instanceof BigDecimal)
		{
			return (BigDecimal)obj;
		}
		else if (obj.toString().trim().length() > 0)
		{
			return new BigDecimal(obj.toString());
		}

		return null;
	}

	/**
	 * <P>
	 *  java.math.BigDecimal ֥ȤޥåλΥȴϢդޤ
	 * </P>
	 * @param key ꤵ줿ͤϢդ륭
	 * @param value ꤵ줿˴Ϣդ
	 * @see jp.morpho.util.PrimitiveHolderMap#setBigDecimal(Object, BigDecimal)
	 */
	public synchronized void setBigDecimal(Object key, BigDecimal value)
	{
		put(key, value);
	}

	/**
	 * <P>
	 * ޥåפΥޥåפͤ java.math.BigInteger ֥ȤȤƼޤ
	 * </P>
	 * @param key Ϣդ줿֤ͤ륭
	 * @return ޥåפꤵ줿ޥåפ
	 * @see jp.morpho.util.PrimitiveHolderMap#getBigInteger(Object)
	 */
	public synchronized BigInteger getBigInteger(Object key)
	{
		Object obj = get(key);

		if (obj == null)
		{
			return null;
		}

		if (obj instanceof BigInteger)
		{
			return (BigInteger)obj;
		}
		else if (obj.toString().trim().length() > 0)
		{
			return new BigInteger(obj.toString());
		}

		return null;
	}

	/**
	 * <P>
	 *  java.math.BigInteger ֥ȤޥåλΥȴϢդޤ
	 * </P>
	 * @param key ꤵ줿ͤϢդ륭
	 * @param value ꤵ줿˴Ϣդ
	 * @see jp.morpho.util.PrimitiveHolderMap#setBigInteger(Object, BigInteger)
	 */
	public synchronized void setBigInteger(Object key, BigInteger value)
	{
		put(key, value);
	}

	/**
	 * <P>
	 * ޥåפΥޥåפͤ Java ץߥ󥰸 boolean ȤƼޤ
	 * </P>
	 * @param key Ϣդ줿֤ͤ륭
	 * @return ޥåפꤵ줿ޥåפ
	 * @see jp.morpho.util.PrimitiveHolderMap#getBoolean(Object)
	 */
	public synchronized boolean getBoolean(Object key)
	{
		Object obj = get(key);

		if (obj == null)
		{
			return false;
		}

		if (obj instanceof Boolean)
		{
			return ((Boolean)obj).booleanValue();
		}
		else
		{
			return Boolean.valueOf(obj.toString()).booleanValue();
		}
	}

	/**
	 * <P>
	 *  boolean ͤޥåλΥȴϢդޤ
	 * </P>
	 * @param key ꤵ줿ͤϢդ륭
	 * @param value ꤵ줿˴Ϣդ
	 * @see jp.morpho.util.PrimitiveHolderMap#setBoolean(Object, boolean)
	 */
	public synchronized void setBoolean(Object key, boolean value)
	{
		put(key, new Boolean(value));
	}

	/**
	 * <P>
	 * ޥåפΥޥåפͤ Java ץߥ󥰸 byte ȤƼޤ
	 * </P>
	 * @param key Ϣդ줿֤ͤ륭
	 * @return ޥåפꤵ줿ޥåפ
	 * @see jp.morpho.util.PrimitiveHolderMap#getByte(Object)
	 */
	public synchronized byte getByte(Object key)
	{
		Object obj = get(key);

		if (obj == null)
		{
			return 0;
		}

		if (obj instanceof Byte)
		{
			return ((Byte)obj).byteValue();
		}
		else if (obj.toString().trim().length() > 0)
		{
			return Byte.valueOf(obj.toString()).byteValue();
		}

		return 0;
	}

	/**
	 * <P>
	 *  byte ͤޥåλΥȴϢդޤ
	 * </P>
	 * @param key ꤵ줿ͤϢդ륭
	 * @param value ꤵ줿˴Ϣդ
	 * @see jp.morpho.util.PrimitiveHolderMap#setByte(Object, byte)
	 */
	public synchronized void setByte(Object key, byte value)
	{
		put(key, new Byte(value));
	}

	/**
	 * <P>
	 * ޥåפΥޥåפͤ Java ץߥ󥰸 byte ȤƼޤ
	 * </P>
	 * @param key Ϣդ줿֤ͤ륭
	 * @return ޥåפꤵ줿ޥåפ
	 * @see jp.morpho.util.PrimitiveHolderMap#getBytes(Object)
	 */
	public synchronized byte[] getBytes(Object key)
	{
		return (byte[])get(key);
	}

	/**
	 * <P>
	 *  byte ޥåλΥȴϢդޤ
	 * </P>
	 * @param key ꤵ줿ͤϢդ륭
	 * @param value ꤵ줿˴Ϣդ
	 * @see jp.morpho.util.PrimitiveHolderMap#setBytes(Object, byte[])
	 */
	public synchronized void setBytes(Object key, byte[] value)
	{
		put(key, value);
	}

	/**
	 * <P>
	 * ޥåפΥޥåפͤ Java ץߥ󥰸 char ȤƼޤ
	 * </P>
	 * @param key Ϣդ줿֤ͤ륭
	 * @return ޥåפꤵ줿ޥåפ
	 * @see jp.morpho.util.PrimitiveHolderMap#getChar(Object)
	 */
	public synchronized char getChar(Object key)
	{
		Object obj = get(key);

		if (obj == null)
		{
			return 0;
		}

		if (obj instanceof Character)
		{
			return ((Character)obj).charValue();
		}
		else if (obj.toString().trim().length() > 0)
		{
			return obj.toString().toCharArray()[0];
		}

		return 0;
	}

	/**
	 * <P>
	 *  char ͤޥåλΥȴϢդޤ
	 * </P>
	 * @param key ꤵ줿ͤϢդ륭
	 * @param value ꤵ줿˴Ϣդ
	 * @see jp.morpho.util.PrimitiveHolderMap#setChar(Object, char)
	 */
	public synchronized void setChar(Object key, char value)
	{
		put(key, new Character(value));
	}

	/**
	 * <P>
	 * ޥåפΥޥåפͤ java.io.Reader ֥ȤȤƼޤ
	 * </P>
	 * @param key Ϣդ줿֤ͤ륭
	 * @return ޥåפꤵ줿ޥåפ
	 * @see jp.morpho.util.PrimitiveHolderMap#getReader(Object)
	 */
	public synchronized Reader getReader(Object key)
	{
		return (Reader)get(key);
	}

	/**
	 * <P>
	 *  java.io.Reader ֥ȤޥåλΥȴϢդޤ
	 * </P>
	 * @param key ꤵ줿ͤϢդ륭
	 * @param value ꤵ줿˴Ϣդ
	 * @see jp.morpho.util.PrimitiveHolderMap#setReader(Object, Reader)
	 */
	public synchronized void setReader(Object key, Reader value)
	{
		put(key, value);
	}

	/**
	 * <P>
	 * ޥåפΥޥåפͤ java.util.Date ֥ȤȤƼޤ
	 * </P>
	 * @param key Ϣդ줿֤ͤ륭
	 * @return ޥåפꤵ줿ޥåפ
	 * @see jp.morpho.util.PrimitiveHolderMap#getDate(Object)
	 */
	public synchronized Date getDate(Object key)
	{
		Object obj = get(key);

		if (obj == null)
		{
			return null;
		}

		if (obj instanceof java.sql.Timestamp)
		{
			//java.sql.Timestamp ֥Ȥξ
			return new java.util.Date(((java.sql.Timestamp)obj).getTime());
		}
		else if (obj instanceof java.sql.Date)
		{
			//java.sql.Date ֥Ȥξ
			return new java.util.Date(((java.sql.Date)obj).getTime());
		}
		else if (obj instanceof java.sql.Time)
		{
			//java.sql.Time ֥Ȥξ
			return new java.util.Date(((java.sql.Time)obj).getTime());
		}
		else if (obj instanceof java.util.Date)
		{
			//java.util.Date ֥Ȥξ
			return (java.util.Date)obj;
		}
		else
		{
			//java.sql.Timestamp ʸɽξ
			try
			{
				return new java.util.Date(java.sql.Timestamp.valueOf(obj.toString()).getTime());
			}
			catch (Exception e)
			{
			}

			//java.sql.Date ʸɽξ
			try
			{
				return new java.util.Date(java.sql.Date.valueOf(obj.toString()).getTime());
			}
			catch (Exception e)
			{
			}

			//java.sql.Time ʸɽξ
			try
			{
				return new java.util.Date(java.sql.Time.valueOf(obj.toString()).getTime());
			}
			catch (Exception e)
			{
			}

			//java.util.Date ʸɽξ
			try
			{
				return new SimpleDateFormat(
					"EEE MMM dd HH:mm:ss zzz yyyy",
					Locale.US).parse(obj.toString());
			}
			catch (Exception e)
			{
			}

			///ʸɽξ
			try
			{
				return DateFormat.getDateTimeInstance().parse(obj.toString());
			}
			catch (Exception e)
			{
			}

			//դʸɽξ
			try
			{
				return DateFormat.getDateInstance().parse(obj.toString());
			}
			catch (Exception e)
			{
			}

			//ʸɽξ
			try
			{
				return DateFormat.getTimeInstance().parse(obj.toString());
			}
			catch (Exception e)
			{
			}
		}

		return null;
	}

	/**
	 * <P>
	 * ޥåפΥޥåפͤʸɽ pattern ǻꤷաѥǲϤơjava.util.Date ֥ȤȤƼޤ
	 * </P>
	 * @param key Ϣդ줿֤ͤ륭
	 * @param pattern աѥ
	 * @return ޥåפꤵ줿ޥåפ
	 * @see jp.morpho.util.PrimitiveHolderMap#parseDate(Object, String)
	 */
	public synchronized Date parseDate(Object key, String pattern)
	{
		Object obj = get(key);

		if (obj == null)
		{
			return null;
		}

		try
		{
			return new SimpleDateFormat(pattern).parse(obj.toString());
		}
		catch (ParseException e)
		{
		}

		return null;
	}

	/**
	 * <P>
	 *  java.util.Date ͤޥåλΥȴϢդޤ
	 * </P>
	 * @param key ꤵ줿ͤϢդ륭
	 * @param value ꤵ줿˴Ϣդ
	 * @see jp.morpho.util.PrimitiveHolderMap#setDate(Object, Date)
	 */
	public synchronized void setDate(Object key, Date value)
	{
		put(key, value);
	}

	/**
	 * <P>
	 * ޥåפΥޥåפͤ Java ץߥ󥰸 double ȤƼޤ
	 * </P>
	 * @param key Ϣդ줿֤ͤ륭
	 * @return ޥåפꤵ줿ޥåפ
	 * @see jp.morpho.util.PrimitiveHolderMap#getDouble(Object)
	 */
	public synchronized double getDouble(Object key)
	{
		Object obj = get(key);

		if (obj == null)
		{
			return 0;
		}

		if (obj instanceof Double)
		{
			return ((Double)obj).doubleValue();
		}
		else if (obj.toString().trim().length() > 0)
		{
			return Double.valueOf(obj.toString()).doubleValue();
		}

		return 0;
	}

	/**
	 * <P>
	 *  double ͤޥåλΥȴϢդޤ
	 * </P>
	 * @param key ꤵ줿ͤϢդ륭
	 * @param value ꤵ줿˴Ϣդ
	 * @see jp.morpho.util.PrimitiveHolderMap#setDouble(Object, double)
	 */
	public synchronized void setDouble(Object key, double value)
	{
		put(key, new Double(value));
	}

	/**
	 * <P>
	 * ޥåפΥޥåפͤ Java ץߥ󥰸 float ȤƼޤ
	 * </P>
	 * @param key Ϣդ줿֤ͤ륭
	 * @return ޥåפꤵ줿ޥåפ
	 * @see jp.morpho.util.PrimitiveHolderMap#getFloat(Object)
	 */
	public synchronized float getFloat(Object key)
	{
		Object obj = get(key);

		if (obj == null)
		{
			return 0;
		}

		if (obj instanceof Float)
		{
			return ((Float)obj).floatValue();
		}
		else if (obj.toString().trim().length() > 0)
		{
			return Double.valueOf(obj.toString()).floatValue();
		}

		return 0;
	}

	/**
	 * <P>
	 *  float ͤޥåλΥȴϢդޤ
	 * </P>
	 * @param key ꤵ줿ͤϢդ륭
	 * @param value ꤵ줿˴Ϣդ
	 * @see jp.morpho.util.PrimitiveHolderMap#setFloat(Object, float)
	 */
	public synchronized void setFloat(Object key, float value)
	{
		put(key, new Float(value));
	}

	/**
	 * <P>
	 * ޥåפΥޥåפͤ Java ץߥ󥰸 int ȤƼޤ
	 * </P>
	 * @param key Ϣդ줿֤ͤ륭
	 * @return ޥåפꤵ줿ޥåפ
	 * @see jp.morpho.util.PrimitiveHolderMap#getInt(Object)
	 */
	public synchronized int getInt(Object key)
	{
		Object obj = get(key);

		if (obj == null)
		{
			return 0;
		}

		if (obj instanceof Integer)
		{
			return ((Integer)obj).intValue();
		}
		else if (obj.toString().trim().length() > 0)
		{
			return Double.valueOf(obj.toString()).intValue();
		}

		return 0;
	}

	/**
	 * <P>
	 *  int ͤޥåλΥȴϢդޤ
	 * </P>
	 * @param key ꤵ줿ͤϢդ륭
	 * @param value ꤵ줿˴Ϣդ
	 * @see jp.morpho.util.PrimitiveHolderMap#setInt(Object, int)
	 */
	public synchronized void setInt(Object key, int value)
	{
		put(key, new Integer(value));
	}

	/**
	 * <P>
	 * ޥåפΥޥåפͤ Java ץߥ󥰸 long ȤƼޤ
	 * </P>
	 * @param key Ϣդ줿֤ͤ륭
	 * @return ޥåפꤵ줿ޥåפ
	 * @see jp.morpho.util.PrimitiveHolderMap#getLong(Object)
	 */
	public synchronized long getLong(Object key)
	{
		Object obj = get(key);

		if (obj == null)
		{
			return 0;
		}

		if (obj instanceof Long)
		{
			return ((Long)obj).longValue();
		}
		else if (obj.toString().trim().length() > 0)
		{
			return Double.valueOf(obj.toString()).longValue();
		}

		return 0;
	}

	/**
	 * <P>
	 *  long ͤޥåλΥȴϢդޤ
	 * </P>
	 * @param key ꤵ줿ͤϢդ륭
	 * @param value ꤵ줿˴Ϣդ
	 * @see jp.morpho.util.PrimitiveHolderMap#setLong(Object, long)
	 */
	public synchronized void setLong(Object key, long value)
	{
		put(key, new Long(value));
	}

	/**
	 * <P>
	 * ޥåפΥޥåפͤ Java ץߥ󥰸 Object ȤƼޤ
	 * </P>
	 * @param key Ϣդ줿֤ͤ륭
	 * @return ޥåפꤵ줿ޥåפ
	 * @see jp.morpho.util.PrimitiveHolderMap#getObject(Object)
	 */
	public synchronized Object getObject(Object key)
	{
		return get(key);
	}

	/**
	 * <P>
	 *  Object ͤޥåλΥȴϢդޤ
	 * </P>
	 * @param key ꤵ줿ͤϢդ륭
	 * @param value ꤵ줿˴Ϣդ
	 * @see jp.morpho.util.PrimitiveHolderMap#setObject(Object, Object)
	 */
	public synchronized void setObject(Object key, Object value)
	{
		put(key, value);
	}

	/**
	 * <P>
	 * ޥåפΥޥåפͤ Java ץߥ󥰸 short ȤƼޤ
	 * </P>
	 * @param key Ϣդ줿֤ͤ륭
	 * @return ޥåפꤵ줿ޥåפ
	 * @see jp.morpho.util.PrimitiveHolderMap#getShort(Object)
	 */
	public synchronized short getShort(Object key)
	{
		Object obj = get(key);

		if (obj == null)
		{
			return 0;
		}

		if (obj instanceof Short)
		{
			return ((Short)obj).shortValue();
		}
		else if (obj.toString().trim().length() > 0)
		{
			return Double.valueOf(obj.toString()).shortValue();
		}

		return 0;
	}

	/**
	 * <P>
	 *  short ͤޥåλΥȴϢդޤ
	 * </P>
	 * @param key ꤵ줿ͤϢդ륭
	 * @param value ꤵ줿˴Ϣդ
	 * @see jp.morpho.util.PrimitiveHolderMap#setShort(Object, short)
	 */
	public synchronized void setShort(Object key, short value)
	{
		put(key, new Short(value));
	}

	/**
	 * <P>
	 * ޥåפΥޥåפͤ Java ץߥ󥰸 String ȤƼޤ
	 * </P>
	 * @param key Ϣդ줿֤ͤ륭
	 * @return ޥåפꤵ줿ޥåפ
	 * @see jp.morpho.util.PrimitiveHolderMap#getString(Object)
	 */
	public synchronized String getString(Object key)
	{
		Object obj = get(key);

		if (obj == null)
		{
			return NULL_STRING;
		}

		if (obj instanceof String)
		{
			return (String)obj;
		}
		else
		{
			return obj.toString();
		}
	}

	/**
	 * <P>
	 *  String ͤޥåλΥȴϢդޤ
	 * </P>
	 * @param key ꤵ줿ͤϢդ륭
	 * @param value ꤵ줿˴Ϣդ
	 * @see jp.morpho.util.PrimitiveHolderMap#setString(Object, String)
	 */
	public synchronized void setString(Object key, String value)
	{
		put(key, value);
	}

	/**
	 * <P>
	 *  ConversionMap ۤơΥޥåפ餹٤ƤΥޥåԥ󥰤ۤ  ConversionMap ˥ԡޤ
	 * Υޥåפ ConversionMap ξϡ֤ޤ
	 * </P>
	 * @param map ۤ ConversionMap ˳Ǽޥåԥ
	 * @return ConversionMap
	 */
	public synchronized static ConversionMap valueOf(Map map)
	{
		if (map instanceof ConversionMap)
		{
			return (ConversionMap)map;
		}
		else
		{
			return new ConversionMap(map);
		}
	}

	/**
	 * <P>
	 * ꤵ줿˥ޥåפƤͤξ true ֤ޤ
	 * </P>
	 * @param key ޥåפƤͤǤ뤫ɤȽꤵ륭
	 * @return ꤵ줿˥ޥåפƤͤξ true
	 */
	public synchronized boolean isArray(Object key)
	{
		return this.getObject(key).getClass().isArray();
	}

	/**
	 * <P>
	 * ޥåפΥΥޥåԥ󥰤ݻ true ֤ޤ
	 * </P>
	 * @param key ޥåפˤ뤫ɤȽꤵ륭
	 * @return ޥåפΥΥޥåԥ󥰤ݻ true
	 * @see java.util.Map#containsKey(Object)
	 */
	public boolean containsKey(Object key)
	{
		return super.containsKey(getKey(key));
	}

	/**
	 * <P>
	 * Υޥåפǻꤵ줿˥ޥåפƤ֤ͤޤ
	 * ޥåפΥΥޥåԥ󥰤ݻƤʤ null ֤ޤ
	 * ͤ null ϡޥåפΥޥåԥ󥰤ݻƤʤȤ򼨤ȤϤޤ
	 * ĤޤꡢޥåפŪ˥ null ˥ޥåפ뤳Ȥ⤢ޤ
	 * containsKey(Object) ᥽åɤȤȡ 2 Ĥξʬ뤳ȤǤޤ
	 * <P>
	 * @param key Ϣդ줿֤ͤ륭
	 * @return ޥåפꤵ줿˥ޥåԥ󥰤Ƥ͡ΥФޥåԥ󥰤ޥåפˤʤ  null
	 * @see java.util.Map#get(Object)
	 */
	public Object get(Object key)
	{
		return super.get(getKey(key));
	}

	/**
	 * <P>
	 * ͤȻꤵ줿򤳤Υޥåפ˴Ϣդޤ
	 * ޥåפˤΥΥޥåԥ󥰤ݻƤ硢Ť֤ͤޤ
	 * <P>
	 * @param key ꤵͤϢդ륭
	 * @param value ꤵ륭˴Ϣդ
	 * @return ꤵ줿˴Ϣ͡ޤϡΥޥåԥ󥰤ʤä null null ϡConversionMap  null Ȼꤵ줿ϢդƤȤ򼨤⤢
	 * @see java.util.Map#put(Object, Object)
	 */
	public Object put(Object key, Object value)
	{
		return super.put(getKey(key), value);
	}

	/**
	 * <P>
	 * Υޥåפ餹٤ƤΥޥåԥ󥰤ޥåפ˥ԡޤ
	 * ˤꡢޥåפΥޥå˸ߤ륭Τ٤ƤФƻäƤޥåԥ󥰤֤ޤ
	 * <P>
	 * @param map ޥåפ˳Ǽޥåԥ
	 * @see java.util.Map#putAll(Map)
	 */
	public void putAll(Map map)
	{
		Object[] keys = map.keySet().toArray();
		for (int i = 0; i < keys.length; i++)
		{
			put(getKey(keys[i]), map.get(keys[i]));
		}
	}

	/**
	 * <P>
	 * Фޥåԥ󥰤СΥޥåפޤ
	 * <P>
	 * @param key ޥåԥ󥰤ޥåפ륭
	 * @return ꤵ줿˴Ϣ͡ޤϡΥޥåԥ󥰤ʤä null null ϡޥåפ null Ȼꤵ줿ϢդƤȤ򼨤⤢
	 * @see java.util.Map#remove(Object)
	 */
	public Object remove(Object key)
	{
		return super.remove(getKey(key));
	}

	/**
	 * <P>
	 * ꤵ줿˥ޥåפƤͤ NULL ξ true ֤ޤ
	 * </P>
	 * @param key ޥåפƤͤ NULL Ǥ뤫ɤȽꤵ륭
	 * @return ꤵ줿˥ޥåפƤͤ NULL ξ true
	 */
	public synchronized boolean isNull(Object key)
	{
		return ((this.getObject(key) == null) ? true : false);
	}

}
