/*
 * Copyright (c) 2003, Morpho Project.
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 * 1. Redistributions of source code must retain the above copyright notice,
 *	  this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright notice,
 *	  this list of conditions and the following disclaimer in the documentation
 *	  and/or other materials provided with the distribution.
 * 3. Neither the name of the Morpho Project nor the names of its contributors
 *	  may be used to endorse or promote products derived from this software
 *	  without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGE.
 */
package jp.morpho.config;

import java.util.HashMap;
import java.util.Map;
import java.util.Vector;

import org.xml.sax.Attributes;

/**
 * <P>
 * ƼΡɤݥ饹Ǥ
 * ΡɤȤϡһҤ˵Ҥ륿Ǥ
 * </P>
 * <P>
 * Υ饹ϡϰۤʤ뤬פʵǽ϶̤Ǥ롢ʣΥΡɤݲǤ
 * Ȥ set  get ʤɳƼΥΡɤǤ⡢ΡɤΥĥ꡼¤䡢°γǼˡʤɤ϶̤ޤ
 * </P>
 * <P>
 * Node 饹Υ֥饹ˤϡ줾ۤʤξΥåȤǼ졢֥Ȥηˡۤʤޤ
 * ΥΡɤϤ٤ơNode 饹Υ֥饹ˤäƼǤޤ
 * </P>
 * @author Kumiko Hiroi
 */
public abstract class Node
	extends Vector
{
	private Node parent = null;
	private Map attributes = null;

	/**
	 * <P>
	 * ƥΡɤȥΡɤ°ꤷ Node ֥Ȥޤ
	 * </P>
	 * @param parent ΥΡɤοƥΡ
	 * @param attributes ΥΡɤ°
	 */
	public Node(Node parent, Attributes attributes)
	{
		super();

		this.parent = parent;
		if (attributes != null)
		{
			this.attributes = new HashMap();
			for (int i = 0; i < attributes.getLength(); i++)
			{
				String key = attributes.getLocalName(i);
				if (key == null || key.equals(""))
				{
					key = attributes.getQName(i);
				}
				this.attributes.put(key, attributes.getValue(i));
			}
		}
	}

	/**
	 * <P>
	 * ΥΡɤΤ٤Ƥ°ޥåפ줿 ConversionMap ֥Ȥޤ
	 * </P>
	 * @return ٤Ƥ°ޥåפ줿 ConversionMap ֥
	 */
	public Map getAttributes()
	{
		return attributes;
	}

	/**
	 * <P>
	 * ꤵ줿̾°ͤޤ
	 * </P>
	 * @return °
	 */
	public String getAttribute(String name)
	{
		return (String)attributes.get(name);
	}

	/**
	 * <P>
	 * ΥΡɤοƥΡɤޤ
	 * </P>
	 * @return ƥΡ
	 */
	public Node getParent()
	{
		return parent;
	}

	/**
	 * <P>
	 * ΥΡɤ class °˻ꤵ줿饹ޤ
	 * </P>
	 * @return class °˻ꤵ줿饹
	 * @exception ClassNotFoundException 饹Ĥʤä
	 */
	protected Class getNodeClass() throws ClassNotFoundException
	{
		String className = getAttribute("class");
		if (className == null)
		{
			return null;
		}

		return Thread.currentThread().getContextClassLoader().loadClass(className);
	}

	/**
	 * <P>
	 * ΥΡɤ name °˻ꤵ줿̾ޤ
	 * ̾ 1 ʸܤʸѴޤ
	 * </P>
	 * @return name °˻ꤵ줿̾
	 */
	protected String getNodeName()
	{
		String name = getAttribute("name");
		if (name == null || name.length() == 0)
		{
			return "";
		}
		else if (name.length() == 1)
		{
			return name.toUpperCase();
		}
		else
		{
			return name.substring(0, 1).toUpperCase() + name.substring(1);
		}
	}

	/**
	 * <P>
	 * ꤵ줿֥Ȥɽͤޤ
	 * ֥Ȥ Node ֥Ȥξϡ Node ֥Ȥɽͤޤ
	 * </P>
	 * @param obj ͤ륪֥
	 * @return ֥Ȥɽ
	 */
	protected Object getValue(Object obj) throws ConfigureException
	{
		try
		{
			if (size() == 0)
			{
				return null;
			}

			int first = 0;
			int last = size() - 1;

			Object item = null;
			while (first <= last)
			{
				item = get(first);
				if (!(item instanceof String))
				{
					break;
				}
				item = ((String) item).trim();
				if (((String) item).length() > 0)
				{
					break;
				}
				first++;
			}

			while (first < last)
			{
				item = get(last);
				if (!(item instanceof String))
				{
					break;
				}
				item = ((String) item).trim();
				if (((String) item).length() > 0)
				{
					break;
				}
				last--;
			}

			if (first > last)
			{
				return null;
			}

			Object value = null;

			if (first == last)
			{
				value = getItemValue(obj, get(first));
			}
			else
			{
				StringBuffer buf = new StringBuffer();
				synchronized (buf)
				{
					for (int i = first; i <= last; i++)
					{
						Object o = get(i);
						buf.append(getItemValue(obj, o));
					}
					value = buf.toString();
				}
			}

			if (value != null && value instanceof String)
			{
				return ((String) value).trim();
			}
			return value;
		}
		catch (Exception e)
		{
			throw new ConfigureException(e);
		}
	}

	/**
	 * <P>
	 * ֥ item ɽͤޤ
	 * item  Node ֥Ȥξϡitem.configure(obj) ƤӽФƷ줿֥Ȥ֤ޤ
	 * </P>
	 * @param obj item  Node ֥Ȥξ˷륪֥
	 * @return item ɽ
	 */
	protected Object getItemValue(Object obj, Object item) throws ConfigureException
	{
		try
		{
			if (item instanceof String)
			{
				return item;
			}

			Node node = (Node) item;
			return node.configure(obj);
		}
		catch (Exception e)
		{
			throw new ConfigureException(e);
		}
	}

	/**
	 * <P>
	 * Υ᥽åɤݥ᥽åɤΤᲿ⤷ޤ
	 * Υ᥽åɤϡȤΥΡɤΥ֤ͤˡ֥饹ˤäƼޤ
	 * </P>
	 * @return 
	 */
	public abstract int getTag();

	/**
	 * <P>
	 * Υ᥽åɤݥ᥽åɤΤᲿ⤷ޤ
	 * Υ᥽åɤϡꤵ줿֥Ȥ뤿ˡ֥饹ˤäƼޤ
	 * </P>
	 * @param obj 륪֥
	 * @return Υ᥽åɤ֤ͤ뤳ȤϤޤ
	 * @exception ConfigureException ֥ȤǤʤä
	 */
	public abstract Object configure(Object obj) throws ConfigureException;

	/**
	 * <P>
	 * ꤵ줿֥Ȥޤ
	 * </P>
	 * @param obj 륪֥
	 * @param index ΥΡɤ˳Ǽ줿ҥΡɤΥꥹȤΥǥå
	 * @exception ConfigureException ֥ȤǤʤä
	 */
	public void configure(Object obj, int index) throws ConfigureException
	{
		try
		{
			for (int i = index; i < size(); i++)
			{
				Object o = get(i);
				if (o instanceof String)
				{
					continue;
				}
				Node node = (Node) o;
				node.configure(obj);
			}
		}
		catch (Exception e)
		{
			throw new ConfigureException(e);
		}
	}

}
