/*
 * Copyright (c) 2003, Morpho Project.
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 * 1. Redistributions of source code must retain the above copyright notice,
 *	  this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright notice,
 *	  this list of conditions and the following disclaimer in the documentation
 *	  and/or other materials provided with the distribution.
 * 3. Neither the name of the Morpho Project nor the names of its contributors
 *	  may be used to endorse or promote products derived from this software
 *	  without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGE.
 */
package jp.morpho.config;

import org.xml.sax.Attributes;

/**
 * <P>
 * ArgNode 饹ϡarg ɽޤ
 * arg ˤϡ#PCDATA call new  SystemProperty ޤ뤳ȤǤޤ
 * </P>
 * <P>
 * 㤨 arg ϡΤ褦һ˵Ҥޤ
 * </P>
 * <P>
 * <PRE>
 *     &lt;call name="someMethod"&gt;&lt;arg&gt;someValue&lt;/arg&gt;&lt;/call&gt;
 * </PRE>
 * </P>
 * <P>
 * ϡΤ褦ʥɤ񤯤ȤƱǤ
 * </P>
 * <P>
 * <PRE>
 *     someObject.someMethod("someValue");
 * </PRE>
 * </P>
 * @author Kumiko Hiroi
 */
public class ArgNode extends Node
{

	/**
	 * <P>
	 * ƥΡɤȥΡɤ°ꤷ ArgNode ֥Ȥޤ
	 * </P>
	 * @param parent ΥΡɤοƥΡ
	 * @param attributes ΥΡɤ°
	 */
	public ArgNode(Node parent, Attributes attributes)
	{
		super(parent, attributes);
	}

	/**
	 * <P>
	 * ֤ͤޤ
	 * </P>
	 * @return 
	 * @see jp.morpho.config.Node#getTag()
	 */
	public int getTag()
	{
		return NodeTypes.ARG;
	}

	/**
	 * <P>
	 * Υ饹 configure ᥽åɤ򥵥ݡȤޤ
	 * Υ᥽åɤƤӽФȡ㳰 ConfigureException ޤ
	 * </P>
	 * @param obj 륪֥
	 * @return Υ᥽åɤ֤ͤޤ
	 * @exception ConfigureException ֥ȤǤʤä
	 * @see jp.morpho.config.Node#configure(Object)
	 */
	public Object configure(Object obj) throws ConfigureException
	{
		throw new ConfigureException("Method unsupported");
	}

}
