/*
 * Decompiled with CFR 0.152.
 */
package jp.morpho.webapp.servlet;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.util.logging.Logger;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import jp.morpho.util.ConversionMap;
import jp.morpho.webapp.servlet.AbstractFilter;
import jp.morpho.webapp.servlet.http.impl.HttpActionRequestImpl;

public class CharacterEncodingFilter
extends AbstractFilter {
    private Logger log = Logger.getLogger("jp.morpho");
    private static final String DEFAULT_CHARACTERENCODING_FROM = "ISO8859_1";
    private static final String DEFAULT_CHARACTERENCODING_TO = "Windows-31J";
    private static final String INITPARAM_CHARACTERENCODING = "characterEncoding";

    public void init(FilterConfig filterConfig) throws ServletException {
        super.init(filterConfig);
        ConversionMap parameters = ConversionMap.valueOf(this.getInitParameterMap());
        String characterEncoding = parameters.getString(INITPARAM_CHARACTERENCODING);
        if (characterEncoding == null || characterEncoding.trim().length() == 0) {
            characterEncoding = DEFAULT_CHARACTERENCODING_TO;
        }
        filterConfig.getServletContext().setAttribute("jp.morpho.webapp.servlet.ServletContext.characterEncoding", (Object)characterEncoding);
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        this.log.fine("doFilter");
        String contentType = request.getContentType();
        int contentLength = request.getContentLength();
        HttpActionRequestImpl actioinRequest = new HttpActionRequestImpl((HttpServletRequest)request);
        ConversionMap formValues = (ConversionMap)actioinRequest.getParameterMap();
        Object[] keyNames = formValues.keySet().toArray();
        int i = 0;
        while (i < keyNames.length) {
            String keyName = keyNames[i].toString();
            if (formValues.isArray(keyName)) {
                Object[] values = (Object[])formValues.getObject(keyName);
                int j = 0;
                while (j < values.length) {
                    if (values[j] instanceof String) {
                        values[j] = this.encode((String)values[j]);
                    }
                    ++j;
                }
                formValues.setObject(keyName, values);
            } else if (formValues.getObject(keyName) instanceof String) {
                formValues.setString(keyName, this.encode(formValues.getString(keyName)));
            }
            ++i;
        }
        chain.doFilter(request, response);
    }

    private String encode(String value) throws UnsupportedEncodingException {
        String encodingValue = null;
        encodingValue = value == null ? null : new String(value.getBytes(DEFAULT_CHARACTERENCODING_FROM), (String)this.getServletContext().getAttribute("jp.morpho.webapp.servlet.ServletContext.characterEncoding"));
        return encodingValue;
    }
}

