/*
 * Copyright (c) 2003, Morpho Project.
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 * 1. Redistributions of source code must retain the above copyright notice,
 *    this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright notice,
 *    this list of conditions and the following disclaimer in the documentation
 *    and/or other materials provided with the distribution.
 * 3. Neither the name of the Morpho Project nor the names of its contributors
 *    may be used to endorse or promote products derived from this software
 *    without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGE.
 */
package jp.morpho.webapp.action;

import jp.morpho.webapp.PluginContext;
import jp.morpho.webapp.PluginException;
import jp.morpho.webapp.PluginKeys;

/**
 * <P>
 * Υ饹ϡActionMappingManager 󥿥եΥȥ󶡤Υ󥿥եΤɬפʺ̤Ǿ¤ޤޤ
 * ޥåԥ󥰥ޥ͡ˤϡΥ饹ĥơĤΥ᥽åɤɬפޤ
 * ActionMappingManager 󥿥եλͤǿ侩Ƥ褦ˡ̾ϡʤ void 󥹥ȥ饯󶡤Ƥ
 * </P>
 * @author user
 */
public abstract class AbstractActionMappingManager
	implements ActionMappingManager
{

	/**
	 * <P>
	 * ׵륹ơΥѥ᡼֤̾ޤ
	 * </P>
	 * @return ׵륹ơΥѥ᡼̾
	 * @see jp.morpho.webapp.action.ActionMappingManager#getStatusParameterName()
	 */
	public abstract String getStatusParameterName();

	/**
	 * <P>
	 * ׵륢Υѥ᡼֤̾ޤ
	 * </P>
	 * @return ׵륢Υѥ᡼̾
	 * @see jp.morpho.webapp.action.ActionMappingManager#getActionParameterName()
	 */
	public abstract String getActionParameterName();

	/**
	 * <P>
	 * ϥɥ֤ޤ
	 * ϥɥϡActionMappingManager  getActionHandlers(String, String, String) ᥽åɤ getActionView(String, String) ᥽åɤƤӽФޤ
	 * </P>
	 * @param servletPath ޥåԥ󥰤б URL
	 * @param status ׵륹ơ
	 * @param action ׵륢
	 * @return ϥɥ
	 * @see jp.morpho.webapp.action.ActionMappingManager#getActionHandlerChain(String, String, String)
	 */
	public abstract ActionHandlerChain getActionHandlerChain(
		String servletPath,
		String status,
		String action);

	/**
	 * <P>
	 * ϥɥ֤ޤ
	 * ֤줿ϥɥϡϥɥ doActionHandler ᥽åɤǽ˸ƤӽФޤ
	 * </P>
	 * <P>
	 * Υ᥽åɤϡ׵륢ϥɥ뤿ˡϥɥ󤫤ƤӽФޤ
	 * </P>
	 * @param servletPath ޥåԥ󥰤б URL
	 * @param status ׵륹ơ
	 * @param action ׵륢
	 * @return ϥɥ
	 * @see jp.morpho.webapp.action.ActionMappingManager#getActionHandlers(String, String, String)
	 */
	public abstract ActionHandler[] getActionHandlers(
		String servletPath,
		String status,
		String action)
		throws ActionMappingNotFoundException;

	/**
	 * <P>
	 * ӥ塼Υѥ (JSP ʤ) ֤ޤ
	 * ӥ塼ϡϥɥ doActionHandler ᥽åɤǡϥɥ餬ƤӽФ줿塢˥󥯥롼ɤޤ
	 * </P>
	 * <P>
	 * ơͤϡϥɥѹ뤳Ȥ뤿ᡢ֥åȤ׵äͤɬפޤ
	 * Υ᥽åɤϡϥɥ doActionHandler ᥽åɤǡ٤ƤΥϥɥ餬¹Ԥ줿˸ƤӽФޤ
	 * </P>
	 * @param servletPath ޥåԥ󥰤б URL
	 * @param status ׵륹ơ
	 * @return ӥ塼Υѥ
	 * @see jp.morpho.webapp.action.ActionMappingManager#getActionView(String, String)
	 */
	public abstract String getActionView(String servletPath, String status)
		throws ActionMappingNotFoundException;

	/**
	 * <P>
	 * ץ饰̤뤿Υ֤ޤ
	 * ץ饰Υϡѥå̾Ʊ§˽ɬפޤ
	 * λͤǤϡjp.morpho.* ˰פ̾ͽ󤷤Ƥޤ
	 * </P>
	 * @return ץ饰̤뤿Υ
	 * @see jp.morpho.webapp.Plugin#getPluginKey()
	 */
	public final String getPluginKey()
	{
		return PluginKeys.actionMappingManager;
	}

	/**
	 * <P>
	 * ץ饰󥳥ƥȤꤷޤ
	 * ե졼Ǥϡץ饰󥤥󥹥󥹤ɲä줿ˤΥ᥽åɤƤӽФޤ
	 * </P>
	 * @param fc Υ󥹥󥹤ɲä FrameworkContext ֥
	 * @exception PluginException Υ᥽åɤˤäƥ졢餫Υ顼Ǿ㳲ȯȤ򼨤
	 */
	public void setPluginContext(PluginContext fc)
		throws PluginException
	{
	}

	/**
	 * <P>
	 * pluginActivate ᥽åɤϡ󥹥󥹤֤ˤʤȤ˸ƤӽФޤ
	 * 󥹥󥹤ޤ
	 * </P>
	 * @exception PluginException Υ᥽åɤˤäƥ졢餫Υ顼Ǿ㳲ȯȤ򼨤
	 */
	public void pluginActivate()
		throws PluginException
	{
	}

	/**
	 * <P>
	 * ե졼Ǥϡץ饰󥪥֥Ȥ֤ͭ򽪤餻ˤΥ᥽åɤƤӽФޤ
	 * ٤ƤΥ꥽ޤ
	 * </P>
	 * @exception PluginException Υ᥽åɤˤäƥ졢餫Υ顼Ǿ㳲ȯȤ򼨤
	 */
	public void pluginRemove()
		throws PluginException
	{
	}

}
