<?php
require_once APP_HOME . LIB_SMARTY_DIR . '/Smarty.class.php';

/**
 * SmartyѤơ
 * ƥץ졼ȤؤͤȲɽԤΥ饹Ǥ
 * 
 * @author YAMAOKA Hiroyuki
 * @package moony.core
 */
class View {

	/** @var object Smarty饹Υ󥹥 */
	var $smarty;

	/** @var array ƥץ졼Ȥꤹѥ᡼ */
	var $items;

	/** @var string ̾ */
	var $action_name;

	/**
	 * 󥹥ȥ饯Ǥ
	 * 
	 * @access public
	 */
	function View() {
	}

	/**
	 * Ԥޤ
	 * 
	 * @access public
	 * @param string $action_name ̾
	 */
	function init($action_name) {

		$this->smarty =& new Smarty();

		$this->smarty->template_dir = APP_HOME . LIB_SMARTY_TEMPLATE_DIR;
		$this->smarty->compile_dir = APP_HOME . LIB_SMARTY_COMPILE_DIR;

		$this->items = array();
		$this->action_name = $action_name;
	}

	/**
	 * ƥץ졼Ȥꤹѥ᡼ꤷޤ
	 * 
	 * @access public
	 * @param string $key ѥ᡼
	 * @param mixed $value ѥ᡼
	 */
	function assign($key, $value) {
		$this->items[$key] = $value;
	}

	/**
	 * ƥץ졼ɽԤޤ
	 * 
	 * @access public
	 * @param string $name ƥץ졼ȥե̾ʥǥե<code>null</code>
	 */
	function forward($name = null) {

		if (strlen($name) == 0) {
			$this->display($this->action_name . '.' . LIB_SMARTY_TEMPLATE_EXT);
			return;
		}

		$this->display($name . '.' . LIB_SMARTY_TEMPLATE_EXT);
    }

	/**
	 * ƥץ졼Ȥ˥ѥ᡼ꤷɽԤޤ
	 * 
	 * @access private
	 * @param string $template ƥץ졼ȥե̾
	 */
	function display($template) {

		foreach ($this->items as $key => $value) {
			$this->smarty->assign($key, $value);
		}

		$this->smarty->display($template);
    }
}
?>