<?php
$base = dirname(dirname(__FILE__));
define('APP_HOME', $base);

require_once APP_HOME . '/lib/moony/config.php';


if ($_SERVER['argc'] != 2) {
	$message = "Parameter Error...\n";
	$message .= "usage: /path/to/php generate.php [action_name]\n";
	die($message);
}

$action_name = $_SERVER['argv'][1];

$action_dir = $base . ACTION_DIR;
$template_dir = $base . LIB_SMARTY_TEMPLATE_DIR;

$action_file = $action_dir . '/' . $action_name . 'Action.class.php';
$template_file = $template_dir . '/' . $action_name . '.' . LIB_SMARTY_TEMPLATE_EXT;

if (file_exists($action_file)) {
	die("Error: Action Class File Already Exists\n");
}
if (file_exists($template_file)) {
	die("Error: Template File Already Exists\n");
}

$skelton_dir = APP_HOME . '/_codegen/skelton';
$action_tpl = file_get_contents($skelton_dir . '/action.skl');
$template_tpl = file_get_contents($skelton_dir . '/template.skl');

$action_content = sprintf($action_tpl, $action_name . 'Action');
$template_content = sprintf($template_tpl, $action_name);

$fp = fopen($action_file, 'w');
fputs($fp, $action_content);
fclose($fp);

$fp = fopen($template_file, 'w');
fputs($fp, $template_content);
fclose($fp);

echo "Skelton for '$action_name' Successfully Generated!\n";
?>
