;;; monkey.el --- major mode for browsing program source as each project

;;; vWFNgǗEmacs-Lisp
;;; dired  etag  navi ̋@\𕹂
;;; It must be one of "C++","C","Pascal","Java","Emacs-Lisp","Lisp Interaction","Perl","PHP","CPerl","TeX","Text","HTML","Ruby".
;;;

;;; License

;; This program is free software; you can redistribute it and/or
;; modify it under the terms of the GNU General Public License
;; as published by the Free Software Foundation; either version 2
;; of the License, or (at your option) any later version.

;; This program is distributed in the hope that it will be useful,
;; but WITHOUT ANY WARRANTY; without even the implied warranty of
;; MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
;; GNU General Public License for more details.

;; You should have received a copy of the GNU General Public License
;; along with this program; if not, write to the Free Software
;; Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

;;; Developer

;; tkoba
;; talltale@users.sourceforge.jp


;;; Dependencies

;;
;; This needs common lisp (cl.el)
;;


;;; Usage

;; Place monkey package in your Emacs lisp path (eg. site-lisp)
;; 
;; Rewrite following variables in monkey-config.el
;;
;; `emacs-bin-file-path'
;; `monkey-installed-path'
;;
;; And add to your .emacs file:
;;   (require 'monkey)

;; Recomend to define global-map as below
;;
;; (define-key global-map "\C-cp" 'monkey-project) ; call each programing project 
;; (define-key global-map "\C-cj" 'monkey-jumper)  ; jump to function definition
;; (define-key global-map "\C-cb" 'monkey-jumper-jump-to-back) ; back to privious point
;; (define-key global-map "\C-cf" 'monkey-describe-one-file) ; describe one file as list of class , functions

;;
;; When you are in the MONKEY-MY-PROJECT frame , which show a tree view of directory 
;; you can use following commands
;;   [RET]      `monkey-describe-my-project-read' move to directory or open file
;;   [space]    `monkey-describe-my-project-read' move to directory or open file or show function list
;;   "n"        `next-line'                       move to next line
;;   "p"        `previous-line'                   move to previous line
;;   "q"        `monkey-frame-quit'               quit monkey-project-mode
;;   "b"        `monkey-builder'                  update MTAG (function lists file)
;;   "\C-d\C-f" `monkey-make-directory'           make new directory
;;   "\C-d\C-d" `monkey-delete-directory'         delete directory
;;   "\C-x\C-f" `monkey-find-file'                make new file
;;   "\C-x\C-c" `monkey-copy-file'                duplicate file on line to another
;;   "\C-x\C-r" `monkey-rename-file'              rename file name on line to another
;;   "\C-x\C-d" `monkey-delete-file'              delete file on line



;;; Code:

;; ------------------------------------------
;; read a library file
;; ------------------------------------------

(require 'cl)


;; ------------------------------------------
;; read a config file
;; ------------------------------------------

(require 'monkey-config)


;; ---------------------------------------------------------
;; monkey-builder MAKE MTAG file start
;; ---------------------------------------------------------

(defconst tags-file-path nil
  "The file containing tree of monkey project.")
(defconst monkey-matches nil)
(defconst tags-insert-file-name-format        "\n%s\n")
(defconst tags-insert-functions-format        "%s,%s\n")

(defconst monkey-project-root nil)
(defconst monkey-project-type nil
"the programing type of a project.")

(defun monkey-builder (dir inputs)
  "vWFNgc[\At@Cɏo͂.
DIRŎw肵fBNgȉċAIɓǂݍ݁A
INPUTSŎw肵gq̃t@CƂ̒̊֐WA
TAGSŎw肵t@Cɏ."
  (interactive
   (list (monkey-read-directory)
         (monkey-read-inputs)))
  (monkey-tags-file tags-name monkey-project-root)
  (monkey-regexps-set monkey-project-type)

  ;; MTAGt@CʃvZXō\z
  (if (null (process-status "monkey-script"))
      (progn
        (setq proc
              (start-process "monkey-script" ; process name
                             "monkey-script-message" ; buffer name to display message from process
                             emacs-bin-file-path ; monkey-config.el
                             "--script" (expand-file-name "monkey-script.el" monkey-installed-path) ; monkey-config.el
                             "-eval" (concat "(monkey-script \"" 
                                             monkey-project-root 
                                             "\" \"" 
                                             monkey-project-type
                                             "\")")))
        (set-process-sentinel proc 'monkey-sentinel) ; ʒm
        (message (concat "Start building " tags-name)))
    (message "Proccess is running"))
  )


(defun monkey-tags-file (tags directory)
"set tag file full path name"
  (setq tags-file-path (expand-file-name tags directory))
  tags-file-path)

(defun monkey-read-directory ()
  "for intractive. set root directory"
  (if (or (null monkey-project-root) (null (file-directory-p monkey-project-root)))
      (setq monkey-project-root (monkey-read-project-root))
    monkey-project-root))

(defun monkey-read-inputs ()
  "for intractive. set programming language type"
  (when (null monkey-project-type)
    (setq monkey-project-type (read-from-minibuffer "Input programming language type: "))))


(defun monkey-sentinel (proc state)
  "called when PROC status is changed"
  (let ((ps (process-status proc)))
    (when (eq ps 'exit) ; I
      (message (concat "Finish !! building " tags-name))
      (sleep-for 3))))


;; ---------------------------------------------------------
;; monkey-builder MAKE MTAG file end
;; ---------------------------------------------------------













;; -------------------------------------------------------------------------------
;; monkey-jumper start
;;
;; TODO WvۂɃEBhE𕪊
;; TODO ZNgt[𗧂グ܂܂ł{̂Ił悤ɂ
;; TODO WvԂɂǂ悤ɂ
;; -------------------------------------------------------------------------------
(defconst monkey-jumper-back nil)

(defun monkey-jumper (needle mtag)
  "w肵t@CANXA֐ (MTAGɊi[ꂽ̂ȂȂł) ɃWv.
NEEDLE  MTAG ̒ŌYt@Cׂ̃obt@ɓWJApointYʒuɈړ."
  ;; point ʒuO̒Pǂݍ݁AftHgƂāAinteractiveN
  (interactive 
   (list (monkey-read-needle-to-search)
         (monkey-read-directory)))
  ;; build if not exists
  (monkey-is-tag)
  (let (needle-list file-name aim-point tmp-point) 
    (save-excursion
      ;; tags t@Cobt@WJ
      (set-buffer (find-file-noselect tags-file-path))
      (goto-char (point-min))
      ;; }b`SăXgAbv
      (while (re-search-forward (concat "[^a-zA-Z0-9\-\_]+" needle "[^a-zA-Z0-9\-\_]+") nil t) ; TODO ֐Ɏĝ͉pnCtAXROK
        (setq tmp-point (point))
        (search-backward "\n\n")
        (skip-chars-forward "\n")
        (setq file-name (buffer-substring (point) (progn (end-of-line) (point))))
        (goto-char tmp-point)
        (end-of-line)
        (search-backward ",")
        (setq aim-point (string-to-number (buffer-substring (+ 1 (point)) (progn (end-of-line) (point)))))
        (setq needle-list (cons (cons file-name aim-point) needle-list))))
      ;; ⃊Xǧɂď𕪂
      (cond ((null needle-list) (error "NO matche in TAG file.")) ;󂾂ꍇ̓G[I
            ((= 1 (length needle-list)) (monkey-jumper-jump-no-frame (car needle-list))) ;₪P̏ꍇ̓Wv
            (t (monkey-jumper-list-up needle-list t))))) ;₪̏ꍇ̓ZNgt[

(defun monkey-read-needle-to-search()
  "for interactive: get default word and read from mini buffer"
  (let (default prompt)
    (skip-chars-backward "a-zA-Z0-9\\-\\_")
    (setq default (buffer-substring (point) (progn (skip-chars-forward "a-zA-Z0-9\\-\\_") (point)))) ; TODO ֐Ɏĝ͉pnCtAXROK
    (setq prompt (read-from-minibuffer "monkey-jump to : " default))))

;;
;; L[t[ɃqbgWv₪ꍇ̃ZNgobt@쐬
(defconst monkey-jumper-buffer nil)
(defconst monkey-jumper-buffer-name "MONKEY-JUMPER-LIST")
;; mode map
(defconst monkey-jumper-mode-name "monkey-jumper-mode")
(defconst monkey-jumper-local-map nil)
(defun monkey-jumper-mode ()
  (setq major-mode 'monkey-jumper-mode)
  (setq mode-name monkey-jumper-mode-name)
  (let ((map (make-sparse-keymap)))
    (define-key map "n" 'next-line)
    (define-key map "p" 'previous-line)
    (define-key map "\r" 'monkey-jumper-jump-from-buffer-list) ;[RET] Wv
    (define-key map " " 'monkey-jumper-jump-from-buffer-list) ;[ ] Wv
    (define-key map "q" 'monkey-frame-quit) ;[q] ŏI
    (setq monkey-jumper-local-map map)
    (use-local-map monkey-jumper-local-map)))

(defun monkey-jumper-list-up (&optional needle-list on-off)
  "qbgWv₪ꍇ̃ZNgEBhE
ʃt[J.[hWv[hɂ.Xg̓eo."
  (interactive)
  (monkey-jumper-set-back-point)
  ;; Get the buffer to play with
  (unless (buffer-live-p monkey-jumper-buffer)
    (setq monkey-jumper-buffer (get-buffer-create monkey-jumper-buffer-name)))
  ;; Do the frame thing
  (if (frame-live-p monkey-frame)
      (select-frame monkey-frame)
    (monkey-frame-create))
  ;; Set  the buffer to play with
  (set-buffer monkey-jumper-buffer)
  ;; Set Major Mode
  (monkey-jumper-mode)
  (setq buffer-read-only nil) ; unlock
  ;; Write all list
  (dolist (row needle-list)
    (prin1 row monkey-jumper-buffer)
    (insert "\n"))
  (goto-char (point-min))
  (setq buffer-read-only t)   ; lock
  ;; Switch to the project-frame
  (monkey-switch-buffer-attached-frame monkey-jumper-buffer monkey-frame))

(defun monkey-jumper-jump-from-buffer-list ()
  "list buffer ǂݎăWvɓn"
  (interactive)
  (beginning-of-line)
  (monkey-jumper-jump-frame (read monkey-jumper-buffer)))

(defun monkey-jumper-jump-frame (lst)
  "jump to the function in other frame."
  (monkey-switch-buffer-attached-frame (find-file-noselect (car lst)))
  (goto-char (cdr lst)))


(defun monkey-jumper-jump-no-frame (lst)
  "jump to the function in this frame."
  (monkey-jumper-set-back-point)
  (when (or (eq monkey-jumper-buffer (current-buffer)) (eq monkey-describe-one-file-buffer (current-buffer)))
      (other-frame 1))
  (find-file (car lst))
  (goto-char (cdr lst)))

(defun monkey-jumper-jump-to-back ()
  "jump to back function."
  (interactive)
  (when (null monkey-jumper-back)
    (error "no back point"))
  (let ((jumper-goto-now monkey-jumper-back))
    (monkey-jumper-set-back-point)
    (find-file (car jumper-goto-now))
    (goto-char (cdr jumper-goto-now))))

(defun monkey-jumper-set-back-point ()
    (setq monkey-jumper-back (cons (buffer-file-name (current-buffer)) (point))))

(defun monkey-is-tag (&optional exec-flag)
  (setq tags-file-path (monkey-tags-file tags-name monkey-project-root))
  (when (or exec-flag (null (file-exists-p tags-file-path)) (null monkey-project-root))
    (call-interactively 'monkey-builder)))

;; -------------------------------------------------------------------------------
;; monkey-jumper end
;; -------------------------------------------------------------------------------




















;; ---------------------------------------------------------
;; monkey project mode
;; ---------------------------------------------------------

(defconst my-project-name nil
"a project name use now.")
(defconst monkey-project-alist nil
"a list of project name.")
(defconst monkey-project-dot-file "~/.monkey"
"a file name for monkey setting of project.")
(defconst monkey-my-project-list nil
"the list for a project.")
(defconst monkey-project-alist nil
"alist of all projects' name.")

(defun monkey-project (project-name)
  "major mode for viewing the programing project.
RET      `monkey-describe-my-project-read' move to directory or open file
space    `monkey-describe-my-project-read' move to directory or open file or show function list
n        `next-line'                       move to next line
p        `previous-line'                   move to previous line
q        `monkey-frame-quit'               quit monkey-project-mode
b        `monkey-builder'                  update MTAG (function lists file)
\C-d\C-f `monkey-make-directory'           make new directory
\C-d\C-d `monkey-delete-directory'         delete directory
\C-x\C-f `monkey-find-file'                make new file
\C-x\C-c `monkey-copy-file'                duplicate file on line to another
\C-x\C-r `monkey-rename-file'              rename file name on line to another
\C-x\C-d `monkey-delete-file'              delete file on line
"
  (interactive (list
                (monkey-read-project-name)))
  (monkey-load-my-project)
  (monkey-save-project-information)
  (monkey-is-tag)
  (monkey-describe-my-project t))

(defun monkey-read-project-name ()
  "for intractive. set a project name use now"
  (monkey-project-names-from-dot-monkey)
  (let* ((completion-ignore-case t))
    (setq my-project-name (completing-read "Input project name: " monkey-project-alist nil nil))))

(defun monkey-project-names-from-dot-monkey ()
  "Load project names from .monkey."
  (save-excursion
    (set-buffer (find-file-noselect monkey-project-dot-file))
    (widen)
    (goto-char (point-min))
    (while (re-search-forward "\\[\\(.*\\)\\]:" nil t)
        (setq monkey-project-alist (cons (buffer-substring (match-beginning 1) (match-end 1)) monkey-project-alist)))
    (kill-buffer nil)
    monkey-project-alist))

(defun monkey-load-my-project ()
  "Load project path , programing languadge type."
  (save-excursion
    (set-buffer (find-file-noselect monkey-project-dot-file))
    (widen)
    (goto-char (point-min))
    (if (search-forward (concat "[" my-project-name "]:") nil t) ; .monkey ɊYvWFNgꍇ
        (let (monkey-my-project-list)
          (setq monkey-my-project-list (read (current-buffer)))
          (setq monkey-project-root (car monkey-my-project-list))
          (setq monkey-project-type (cdr monkey-my-project-list))))
    (kill-buffer nil)
    (unless (and monkey-project-root monkey-project-type) ; .monkey ɊYvWFNgȂꍇ
      (call-interactively 'monkey-read-about-project)) ; vWFNg[gƃvO^Cv͂
    ))

(defun monkey-read-about-project (&optional project-root project-type)
  (interactive (list
                (monkey-read-project-root)
                (monkey-read-project-type))))

(defun monkey-read-project-root ()
  "for interactive.vWFNg[g̃pX͂B"
  (let (path ans)
    (if (and (boundp 'running-xemacs) running-xemacs)
        (setq path (read-directory-name (format "[%s] Input project root directory path: " my-project-name) default-directory default-directory nil))
      (setq path (read-file-name (format "[%s] Input project root directory path: " my-project-name) default-directory default-directory nil)))
    ;; VfBNgw肵ꍇ́AfBNg쐬
    (when (null (file-directory-p (directory-file-name path)))
      (setq ans (read-from-minibuffer (format "[%s] make directory %s: y/n " my-project-name path)))
      (if (equal "y" (downcase (substring ans 0 1)))
          (monkey-make-directory-recursive path)
        (setq path (monkey-read-project-root))))
    (when path (setq monkey-project-root path))
    path))

(defun monkey-read-project-type ()
  "for interactive"
  (let (type)
    (setq type (read-from-minibuffer "Input project programing type: " (when monkey-project-type monkey-project-type)))
    (when type (setq monkey-project-type type))
    type))


(defun monkey-save-project-information ()
  "save project root and program type in file"
  (save-excursion
    (set-buffer (find-file-noselect monkey-project-dot-file))
    (let ((information (concat "[" my-project-name "]:(\"" monkey-project-root "\" . \"" monkey-project-type "\")\n")))
      (if (re-search-forward (concat "\\[" my-project-name "\\]:.*\n") nil 0 nil) ; goto-char point-max if not hit
          (replace-match information) ; replace if hit
        (insert information))) ; insert in point-max if not hit
    (basic-save-buffer)
    (kill-buffer nil)))

(defun monkey-make-directory-recursive (path)
  (let ((me (directory-file-name path))
        (parent (directory-file-name (file-name-directory (directory-file-name path)))))
    (when (null (file-directory-p parent)) ; if parent directory is not exist
        (monkey-make-directory-recursive parent))
    (make-directory me)))

;; buffer
(defconst monkey-my-project-buffer nil)
(defconst monkey-my-project-buffer-name "MONKEY-MY-PROJECT")
(defconst monkey-my-project-buffer-mode-name "Monkey-Project")
;; mode map
(defconst monkey-project-mode-name "monkey-project-mode")
(defconst monkey-project-local-map nil)
(defun monkey-project-mode ()
  (let ((map (make-sparse-keymap)))
    (setq major-mode 'monkey-project-mode)
    (setq mode-name monkey-project-mode-name)
    (define-key map "\r" 'monkey-describe-my-project-read) ;[RET] fBNg̓t@Cֈړ
    (define-key map " "  'monkey-describe-my-project-read) ;[ ] fBNg̓t@Cֈړ̓t@C̊֐Xg\
    (define-key map "n" 'next-line)                        ;[n] ̍s
    (define-key map "p" 'previous-line)                    ;[p] O̍s
    (define-key map "q" 'monkey-frame-quit)                ;[q] I
    (define-key map "b" 'monkey-builder)                   ;[b] MTAGXV
    (define-key map "\C-d\C-f" 'monkey-make-directory)             
    (define-key map "\C-d\C-d" 'monkey-delete-directory)             
    (define-key map "\C-x\C-f" 'monkey-find-file)             
    (define-key map "\C-x\C-c" 'monkey-copy-file)             
    (define-key map "\C-x\C-r" 'monkey-rename-file)             
    (define-key map "\C-x\C-d" 'monkey-delete-file)             
    (setq monkey-project-local-map map)
    (use-local-map monkey-project-local-map)))


(defun monkey-describe-my-project (on-off &optional dir)
  "describe a project in a monkey frame."
  (interactive)
  ;; Get the buffer to play with
  (unless (buffer-live-p monkey-my-project-buffer)
    (setq monkey-my-project-buffer (get-buffer-create monkey-my-project-buffer-name)))
  ;; Do the frame thing
  (if (frame-live-p monkey-frame)
      (select-frame monkey-frame)
    (monkey-frame-create))
  ;; Set  the buffer to play with
  (set-buffer monkey-my-project-buffer)
  ;; Set Major Mode
  (monkey-project-mode)
  (setq buffer-read-only nil) ; unlock
  ;; t@CSďo
  (erase-buffer)
  (let (pwd files file-name file-info files-for-sort)
    (setq pwd (if dir dir monkey-project-root))
    (setq files (cdr (directory-files pwd t))) ; . current directory ͏
    (insert (format "%s\n" pwd))               ; pwd 
    (dolist (row files)
      (if (file-directory-p row) ; fBNgƃt@CɕW
          (setq file-info "+ ")
        (setq file-info "- "))
      (setq file-name (file-name-nondirectory row)) ; t@Ĉ݂ɂ
      (unless (member file-name monkey-exclusion-files-list) ; Ot@C͏
        (setq files-for-sort (cons (format "%s%s\n" file-info file-name) files-for-sort))))
    ;; fBNg擪ɂ\[g
    (setq files-for-sort (sort files-for-sort 'string<))
    (dolist (row files-for-sort)            ; t@C
      (insert row))
    (monkey-describe-my-project-put-directory-name-face)
    (goto-char (point-min)))
  (setq buffer-read-only t)   ; lock
  ;; Switch to the project-frame
  (monkey-switch-buffer-attached-frame monkey-my-project-buffer monkey-frame))

(defface monkey-directory-name-face
  '((t (:foreground "dodgerblue1" :underline t))) nil)

(defun monkey-describe-my-project-put-directory-name-face ()
  "Put face to monkey-describe-my-project."
  (goto-char (point-min))
  (while (re-search-forward "\\+ \\(.*\\)" nil t)
    (put-text-property (match-beginning 1) (match-end 1) 'face 'monkey-directory-name-face)))


(defun monkey-describe-my-project-read ()
  "describe a chile directory in the directory list in the directory list or jump to a file in other frame."
  (interactive)
  (if (eq monkey-describe-one-file-buffer (current-buffer))
      (monkey-describe-one-file-jump)
    (let (pwd file-name file-path (this-key (upcase (this-command-keys))))
      (setq file-name (buffer-substring (progn (beginning-of-line) (+ 2 (point))) (progn (end-of-line) (point))))
      (setq pwd (buffer-substring (progn (goto-char (point-min)) (point)) (progn (end-of-line) (point))))
      (setq file-path (expand-file-name file-name pwd))
      (cond ((file-directory-p file-path) (monkey-describe-my-project t file-path))
            ((string= this-key " ") (monkey-describe-one-file file-path))
            (t (monkey-switch-buffer-attached-frame (find-file-noselect file-path)))))))

;;
;; describe one file's classes and functions
(defconst monkey-describe-one-file-buffer nil)
(defconst monkey-describe-one-file-buffer-name "MONKEY-DESCRIBE")

(defun monkey-describe-one-file (file-path)
  "describe one file's classes and functions."
  ;; build if not exists
  (monkey-is-tag)
  (monkey-describe-my-project t)
  (interactive (list (monkey-read-one-file-path)))
  (let (one-file-tmp)
    (save-excursion
      (set-buffer (get-buffer-create " *tmp*")) ; tmp obt@̍쐬
      (erase-buffer)
      (insert-file-contents file-path)
      (monkey-regexps-set monkey-project-type)
      (while (re-search-forward monkey-regexps nil t)
        (setq one-file-tmp (concat 
                            one-file-tmp
                            (format tags-insert-functions-format 
                                    (buffer-substring (match-beginning 1) (match-end 1)) 
                                    (match-beginning 1)))))
      (kill-buffer " *tmp*")
      ;; Get the buffer to play with
      (if (null (buffer-live-p monkey-describe-one-file-buffer))
          (progn (select-window (split-window))
                 (setq monkey-describe-one-file-buffer (get-buffer-create monkey-describe-one-file-buffer-name))
                 (switch-to-buffer monkey-describe-one-file-buffer))
        (set-buffer monkey-describe-one-file-buffer))
      (monkey-project-mode)
      (setq buffer-read-only nil) ; unlock
      (erase-buffer)
      (insert file-path "\n" one-file-tmp)
      (monkey-describe-one-file-put-face)
      (setq buffer-read-only t)   ; lock
      (goto-char (point-min)))))
(defun monkey-read-one-file-path ()
  "for interactive.t@CpX͂B"
  (read-file-name "Input file path: " default-directory nil t (file-name-nondirectory buffer-file-name)))

(defun monkey-describe-one-file-jump ()
  "Jump to FILE from describe-one-file  LIST."
  (interactive)
  (let (needle-list file-name aim-point)
    (save-excursion
      (end-of-line)
      (search-backward ",")
      (setq aim-point (string-to-number (buffer-substring (+ 1 (point)) (progn (end-of-line) (point)))))
      (goto-char (point-min))
      (setq file-name (buffer-substring (point) (progn (end-of-line) (point))))
      (push (cons file-name aim-point) needle-list))
    (monkey-jumper-jump-no-frame (car needle-list))))

(defface font-face-2nd
  '((t (:foreground "goldenrod" :underline t))) nil)
(defface font-face-3rd
  '((t (:foreground "rosybrown" :underline t))) nil)
(defface font-face-4th
  '((t (:foreground "SpringGreen3" :underline t))) nil)
(defface font-face-5th
  '((t (:foreground "salmon3" :underline t))) nil)
(defun monkey-describe-one-file-put-face ()
  "Put face to monkey-describe-one-file-buffer."
  (goto-char (point-min))
  (monkey-regexps-set monkey-project-type)
  (while (re-search-forward monkey-regexps nil t)
    (when (match-beginning 2)
      (put-text-property (match-beginning 2) (match-end 2) 'face 'font-face-2nd))
    (when (match-beginning 3)
      (put-text-property (match-beginning 3) (match-end 3) 'face 'font-face-3rd))
    (when (match-beginning 4)
      (put-text-property (match-beginning 4) (match-end 4) 'face 'font-face-4th))
    (when (match-beginning 5)
      (put-text-property (match-beginning 5) (match-end 5) 'face 'font-face-5th))))

(defun monkey-make-directory ()
  "wrapper of make-directory."
  (interactive)
  (let* ((default-directory (monkey-current-directory)))
    (call-interactively 'make-directory)))
(defun monkey-delete-directory ()
  "wrapper of delete-directory."
  (interactive)
  (let* ((default-directory (monkey-current-directory)))
    (call-interactively 'delete-directory)))
(defun monkey-find-file ()
  "wrapper of find-file."
  (interactive)
  (let* ((default-directory (monkey-current-directory)))
    (call-interactively 'find-file)
    (insert "\n")
    (save-buffer)
    (erase-buffer)
    (save-buffer)
    (kill-buffer (current-buffer))))
(defun monkey-copy-file (src dist)
  "wrapper of copy-file."
  (interactive
   (list (monkey-file-read-src "Copy")
         (monkey-file-read-dest "Copy")))
  (copy-file src dist))
(defun monkey-rename-file (src dist)
  "wrapper of rename-file."
  (interactive
   (list (monkey-file-read-src "Move")
         (monkey-file-read-dest "Move")))
  (rename-file src dist))
(defun monkey-delete-file (src)
  "wrapper of delete-file."
  (interactive
   (list (monkey-file-read-src "Remove")))
  (delete-file src))

(defun monkey-file-read-src (msg)
  "read file name to do something from."
  (read-file-name (format "%s file From: " msg) (monkey-current-directory (monkey-current-file-name)) nil t))
(defun monkey-file-read-dest (msg)
  "read file name to do something to."
  (read-from-minibuffer (format "%s file To: " msg) (monkey-current-directory) nil nil))
(defun monkey-current-directory (&optional filename)
  "read directory path form 1st line of current buffer or read file name and add to directory path."
  (if (null filename)
      (progn (setq filename "hoge")
             (file-name-directory (expand-file-name filename (buffer-substring (progn (goto-char (point-min)) (point)) (progn (end-of-line) (point))))))
    (expand-file-name filename (buffer-substring (progn (goto-char (point-min)) (point)) (progn (end-of-line) (point))))))
(defun monkey-current-file-name ()
  "read file name from current line."
  (buffer-substring 
   (progn (beginning-of-line) (skip-chars-forward "-+ ") (point))
   (progn (end-of-line) (skip-chars-backward " ") (point))))







;; ---------------------------------------------------
;; frame 
;; ---------------------------------------------------

(defconst monkey-frame nil
  "The frame displaying monkey.")

(defconst monkey-frame-name "Monkey")

;; dframe Â炢̂ŁAt[֐쐬
(defun monkey-frame-create ()
  ;; j^[̍[ɕ\
  (unless (assoc 'left monkey-frame-create-parameters)
    (push (cons 'left (- (x-display-pixel-width) (cdr (assoc 'width monkey-frame-create-parameters)))) monkey-frame-create-parameters))
  ;;(before-make-frame-hook)
  (setq monkey-frame (make-frame monkey-frame-create-parameters))
  ;;(after-make-frame-hook)
  (select-frame monkey-frame)
  monkey-frame
  )

(defun monkey-frame-quit ()
  "quit monkey frame."
  (interactive)
  (let ((buffer-alist (buffer-list monkey-frame)))
    (dolist (bf buffer-alist)
      (when (string-match "MONKEY" (buffer-name bf))
        (kill-buffer bf))))
  (delete-frame monkey-frame))


(defvar monkey-frame-create-parameters
  '(
    ;; [t[łӖl

    (name . "Monkey")
    ;;t[̖OBp[^`title'w肵Ȃ`nil'łƁAt[̓t[^Cg̃ftHgɂȂB`name'w肵ȂƁA
    ;;EmacsIɃt[ݒ肷i*Note Frame Titles::jB
    ;;t[ƂɃt[𖾎IɎw肷ƁA̖ÓiEmacs̎s`t@C̖ÔɁjt[X\[X
    ;;T߂ɂgB
    (width . 100)
    ;;t[̓̕Pʂ̕BisNZPʂ̕𓾂ɂ`frame-pixel-width'ĂяoB*Note Size and Position::QƁBj
    ;;@@@ 
    ;;(buffer-list . '(monkey-my-project-buffer monkey-jumper-buffer))
    ;;̃t[őIꂽobt@Ƃŋ߂ɑIꂽ̂珇ɕׂXgB
    ;;@@@ 
    ;;(buffer-predicate . monkey-my-project-buffer)
    ;;̃t[̃obt@q֐Bꂪ`nil'łȂ΁A֐`other-buffer'iIĂt[j̏qgpāA
    ;;ǂ̃obt@ɂ邩肷B`other-buffer'͊eobt@ƂɃobt@ƂĂ̏qĂяoB̏qꂪ`nil'ȊOԂƓY
    ;;obt@IԁB

    ;; (title . )
    ;; ;;t[̃^Cg`title'`nil'ȊOłƁAt[̃EBhEVXe̘gɃ^CgB
    ;; ;;܂A`mode-line-frame-identification'`%F' i*Note %-Constructs::jgĂ΁AYt[̃[hsɂ^CgBEmacsEB
    ;; ;;hEVXegĂȂꍇɂ́A͕ʂ̓[hsɕ\x1̃t[\łB*Note Frame Titles::B
    ;; (height . )
    ;; ;;t[̓̕Pʂ̍BisNZPʂ̍𓾂ɂ`frame-pixel-height'ĂяoB*Note Size and Position::QƁBj


    ;; GUIt[ł݈̂Ӗl
    (user-position . t)
    ;;`make-frame'ĂяoƂɂ́Ap[^`left'`top'̒l[U[̊]\ꍇɂ͂̃p[^̒lɂ`nil'ȊOw肷邱ƁB
    ;;Ȃ`nil'w肷B
    (minibuffer . nil)
    ;;̃t[ɓƎ̃~jobt@邩ǂ\Bl`t'͂邱Ƃ\A`nil'͂ȂƂ\B`only'́Ãt[~jobt@
    ;;ł邱Ƃ\Biʂ̃t[́jl~jobt@łƁAVȃt[͂̃~jobt@gB
    (border-width . 0)
    ;;EBhEg̃sNZPʂ̕B
    (unsplittable . nil)
    ;;`nil'ȊOłƁÃt[̃EBhEĎIɕȂB
    (menu-bar-lines . 0)
    ;;t[̏[Ɋ蓖Ă郁j[o[̍šBftHg1łB*Note Menu Bar::BiXc[LbggEmacsł́Aj[
    ;;o[1słB̏ꍇA0傫Ȑw肵ǂɈӖBj


    ;; (auto-raise . )
    ;; ;;t[IƂɃt[OɈړ邩ǂ\i`nil'ȊOłƂ̂悤ɂjB
    ;; (auto-lower . )
    ;; ;;t[̑I~߂ƂɃt[ֈړ邩ǂ\i`nil'ȊOłƂ̂悤ɂjB
    ;; (mouse-color . )
    ;; ;;}EX|C^̕\FB
    ;; (cursor-color . )
    ;; ;;|Cg\J[\̕\FB
    ))


(defun monkey-switch-buffer-attached-frame (&optional buffer frame)
  "Switch to BUFFER in the attached frame, and raise that frame."
  (interactive)
  ;; Assume we are in the dedicated frame.
  (if frame 
      (select-frame-set-input-focus frame)
    (other-frame 1))
  ;; Now switch buffers
  (if buffer
      (cond ((null (monkey-visible-buffer-list)) (switch-to-buffer buffer))
            ((member buffer monkey-buffer-list-in-frame) (unless (get-buffer-window buffer) (switch-to-buffer buffer)))
            (t (monkey-switch-to-new-window buffer)))
    (call-interactively 'switch-to-buffer nil nil)))

(defconst monkey-buffer-list-in-frame nil
  "buffer list which is visible.")

(defun monkey-visible-buffer-list ()
  "Return buffer list which is visible in current window."
  (setq monkey-buffer-list-in-frame nil)
  (walk-windows 'monkey-visible-buffer-get nil nil)
  monkey-buffer-list-in-frame)

(defun monkey-visible-buffer-get (win)
"Used by `monkey-visible-buffer-list'. Push buffer into variable MONKEY-BUFFER-LIST-IN-FRAME."
  (let ((buf (window-buffer win)))
	(if (and
         (not (member buf monkey-buffer-list-in-frame))
         (not (equal (buffer-name buf) "*scratch*"))
         (not (equal (buffer-name buf) "*Messages*")))
	    (push buf monkey-buffer-list-in-frame)))) ; cl.el K{

(defun monkey-switch-to-new-window (buffer)
  "Create new window for buffer."
  (let ((split-base-buffer-list monkey-buffer-list-in-frame))
    (delete monkey-my-project-buffer split-base-buffer-list)
    (switch-to-buffer (car split-base-buffer-list)))
  (split-window-vertically)
  (switch-to-buffer-other-window buffer)
  (shrink-window-if-larger-than-buffer (frame-selected-window))) ; IĂwindow̑傫buffer̕\ɏ\ȑ傫ɏk߂



;; ---------------------------------------------------
;; frame end
;; ---------------------------------------------------






(provide 'monkey)

;;; monkey.el
