/*
 * Decompiled with CFR 0.152.
 */
package org.monache.lib.httpclient;

import java.io.IOException;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.CredentialsProvider;
import org.apache.http.client.HttpClient;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.impl.client.BasicCredentialsProvider;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.monache.lib.httpclient.ApacheHttpClient;
import org.monache.lib.httpclient.HttpClientException;

public class BasicAuthenticationHttpClient
extends ApacheHttpClient {
    private String user = null;
    private String password = null;
    private int connectionTimeout = 0;
    private int socketTimeout = 0;
    private CloseableHttpClient httpClient = null;

    public BasicAuthenticationHttpClient(String host, int port, String user, String password, int connectionTimeout, int socketTimeout) throws HttpClientException {
        this.setHost(host);
        this.setPort(port);
        this.setUser(user);
        this.setPassword(password);
        this.setConnectionTimeout(connectionTimeout);
        this.setSocketTimeout(socketTimeout);
        this.init();
    }

    public BasicAuthenticationHttpClient() {
    }

    protected void init() throws HttpClientException {
        this.getHttpClient();
    }

    public synchronized HttpClient getHttpClient() throws HttpClientException {
        if (this.httpClient == null) {
            RequestConfig requestConfig = RequestConfig.custom().setConnectTimeout(this.getConnectionTimeout()).setSocketTimeout(this.getSocketTimeout()).build();
            BasicCredentialsProvider credsProvider = new BasicCredentialsProvider();
            credsProvider.setCredentials(new AuthScope(this.getHost(), this.getPort()), (Credentials)new UsernamePasswordCredentials(this.getUser(), this.getPassword()));
            this.httpClient = HttpClients.custom().setDefaultCredentialsProvider((CredentialsProvider)credsProvider).setDefaultRequestConfig(requestConfig).build();
        }
        return this.httpClient;
    }

    public void close() throws HttpClientException {
        if (this.httpClient != null) {
            try {
                this.httpClient.close();
            }
            catch (IOException e) {
                throw new HttpClientException(e);
            }
        }
    }

    public String getUser() {
        return this.user;
    }

    public void setUser(String user) {
        this.user = user;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public int getConnectionTimeout() {
        return this.connectionTimeout;
    }

    public void setConnectionTimeout(int connectionTimeout) {
        this.connectionTimeout = connectionTimeout;
    }

    public int getSocketTimeout() {
        return this.socketTimeout;
    }

    public void setSocketTimeout(int socketTimeout) {
        this.socketTimeout = socketTimeout;
    }
}

