/*
 * Decompiled with CFR 0.152.
 */
package org.monache.lib.api.impl;

import java.math.BigDecimal;
import org.monache.lib.api.AbstractCoinAPI;
import org.monache.lib.api.CoinAPIException;
import org.monache.lib.api.SendToAddress;
import org.monache.lib.api.result.SendToAddressResult;
import org.monache.lib.jsonrpc.JsonRPCClient;
import org.monache.lib.jsonrpc.JsonRPCv1RequestObject;
import org.monache.lib.jsonrpc.JsonRPCv1ResponseObject;

public class SendToAddressImpl
extends AbstractCoinAPI
implements SendToAddress {
    protected static final String METHOD = "sendtoaddress";

    public SendToAddressResult call(JsonRPCClient jsonRPCClient, String toAddress, BigDecimal amount) throws CoinAPIException {
        return this.call(jsonRPCClient, toAddress, amount, null, null);
    }

    public SendToAddressResult call(JsonRPCClient jsonRPCClient, String toAddress, BigDecimal amount, String comment, String commentTo) throws CoinAPIException {
        try {
            if (jsonRPCClient == null) {
                throw new NullPointerException("jsonRPCClient is null.");
            }
            if (toAddress == null || toAddress.length() == 0) {
                throw new NullPointerException("toAddress is null or empty.");
            }
            if (amount == null) {
                throw new NullPointerException("amount is null.");
            }
            JsonRPCv1RequestObject requestObject = new JsonRPCv1RequestObject();
            requestObject.setMethod(METHOD);
            if (comment == null && commentTo == null) {
                requestObject.setParams(new Object[]{toAddress, amount});
            } else {
                if (comment == null) {
                    comment = "*";
                }
                if (commentTo == null) {
                    commentTo = "*";
                }
                requestObject.setParams(new Object[]{toAddress, amount, comment, commentTo});
            }
            JsonRPCv1ResponseObject responseObject = jsonRPCClient.call(requestObject, JsonRPCv1ResponseObject.class);
            SendToAddressResult result = new SendToAddressResult();
            result.setJsonString(responseObject.getJsonString());
            result.setTransactionId((String)responseObject.getResult());
            return result;
        }
        catch (Exception e) {
            throw new CoinAPIException("Error: " + e.getMessage(), e);
        }
    }
}

