/*
 * Decompiled with CFR 0.152.
 */
package org.monache.lib.api.impl;

import java.math.BigDecimal;
import org.monache.lib.api.AbstractCoinAPI;
import org.monache.lib.api.CoinAPIException;
import org.monache.lib.api.SendFrom;
import org.monache.lib.api.result.SendFromResult;
import org.monache.lib.jsonrpc.JsonRPCClient;
import org.monache.lib.jsonrpc.JsonRPCv1RequestObject;
import org.monache.lib.jsonrpc.JsonRPCv1ResponseObject;

public class SendFromImpl
extends AbstractCoinAPI
implements SendFrom {
    protected static final String METHOD = "sendfrom";

    public SendFromResult call(JsonRPCClient jsonRPCClient, String fromAccount, String toAddress, BigDecimal amount) throws CoinAPIException {
        return this.call(jsonRPCClient, fromAccount, toAddress, amount, null, null, null);
    }

    public SendFromResult call(JsonRPCClient jsonRPCClient, String fromAccount, String toAddress, BigDecimal amount, String comment, String commentTo) throws CoinAPIException {
        return this.call(jsonRPCClient, fromAccount, toAddress, amount, null, comment, commentTo);
    }

    public SendFromResult call(JsonRPCClient jsonRPCClient, String fromAccount, String toAddress, BigDecimal amount, Integer minconf) throws CoinAPIException {
        return this.call(jsonRPCClient, fromAccount, toAddress, amount, minconf, null, null);
    }

    public SendFromResult call(JsonRPCClient jsonRPCClient, String fromAccount, String toAddress, BigDecimal amount, Integer minconf, String comment, String commentTo) throws CoinAPIException {
        try {
            if (jsonRPCClient == null) {
                throw new NullPointerException("jsonRPCClient is null.");
            }
            if (fromAccount == null || fromAccount.length() == 0) {
                throw new NullPointerException("fromAccount is null.");
            }
            if (toAddress == null || fromAccount.length() == 0) {
                throw new NullPointerException("toAddress is null.");
            }
            if (amount == null) {
                throw new NullPointerException("amount is null.");
            }
            JsonRPCv1RequestObject requestObject = new JsonRPCv1RequestObject();
            requestObject.setMethod(METHOD);
            if (minconf == null && comment == null && commentTo == null) {
                requestObject.setParams(new Object[]{fromAccount, toAddress, amount});
            } else {
                Object objMinconf = minconf;
                if (objMinconf == null) {
                    objMinconf = "*";
                }
                if (comment == null) {
                    comment = "*";
                }
                if ((commentTo = comment) == null) {
                    commentTo = "*";
                }
                requestObject.setParams(new Object[]{fromAccount, toAddress, amount, objMinconf, comment, commentTo});
            }
            JsonRPCv1ResponseObject responseObject = jsonRPCClient.call(requestObject, JsonRPCv1ResponseObject.class);
            SendFromResult result = new SendFromResult();
            result.setJsonString(responseObject.getJsonString());
            result.setTransactionId((String)responseObject.getResult());
            return result;
        }
        catch (Exception e) {
            throw new CoinAPIException("Error: " + e.getMessage(), e);
        }
    }
}

