/*
Copyright (c) 2004 bayside
All rights reserved.

Redistribution and use in source and binary forms, with or without
modification, are permitted provided that the following conditions
are met:
1. Redistributions of source code must retain the above copyright
   notice, this history of conditions and the following disclaimer.
2. Redistributions in binary form must reproduce the above copyright
   notice, this history of conditions and the following disclaimer in the
   documentation and/or other materials provided with the distribution.
3. The name of the author may not be used to endorse or promote products
   derived from this software without specific prior written permission.

THIS SOFTWARE IS PROVIDED BY THE AUTHOR ``AS IS'' AND ANY EXPRESS OR
IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT, INDIRECT,
INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT
NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
(INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
*/

#include <baygui.h>

/**
 アプリケーションランチャー
*/
class Glaunch : public Window {
private:
	int prevIndex;
	ListBox *list;

public:
	Glaunch() {
		char name[15];
		int size, attr;

		setRect(0, 22, 108 + INSETS_LEFT + INSETS_RIGHT, 250 + INSETS_TOP + INSETS_BOTTOM);
		setTitle("mokon");
		
		// 前回の選択位置
		prevIndex = -1;
		
		// アプリ一覧リスト
		list = new ListBox();
		list->setRect(0, 0, 108, 250);
		add(list);

		// APPSに移動
		if (syscall_cd("/APPS/BAYGUI") != 0) {
			return;
		}

		// ディレクトリを開く
		if (syscall_dir_open()) {
			return;
		}

		// ディレクトリ内のファイル検索
		while (syscall_dir_read(name, &size, &attr) == 0) {
			if ((attr & ATTRIBUTE_DIRECTORY) != 0) {
				// . と .. は除外する
				if (strcmp(name,".") != 0 &&
					strcmp(name,"..") != 0)
				{
					list->add(name);
				}
			} else {
				// BayGUIアプリのみをピックアップ (*.EX5)
				// GLAUNCHとGSHELLは対象からはずす
				if (name[strlen(name) - 1] == '5' && 
					strcmp(name,"GLAUNCH.EX5") != 0 &&
					strcmp(name,"GSHELL.EX5") != 0)
				{
					list->add(name);
				}
			}
		}
		syscall_dir_close();
	}

	virtual ~Glaunch() {
		delete(list);
	}

	/** アプリ実行 */
	void execute() {
		char name[24];
		char *item = list->getSelectedItem();
		if (prevIndex != -1 && item != NULL && strlen(item) > 0) {
			strcpy(name, "/APPS/BAYGUI/");
			strcat(name, item);
			// *.APP の場合
			if (item[strlen(item) - 1] == 'P') {
				strcat(name, "/");
				strcat(name, item);
				// 拡張子をAPPからEX5に変換
				name[strlen(name) - 3] = 'E';
				name[strlen(name) - 2] = 'X';
				name[strlen(name) - 1] = '5';
			}
			// アプリ実行
			prevIndex = -1;
			monapi_call_process_execute_file(name, MONAPI_FALSE);
		}
	}

	/** イベントハンドラ */
	virtual void onEvent(Event *event) {
		if (event->type == ITEM_SELECTED) {
			// 前の選択位置と同じ（ダブルクリック）
			if (prevIndex == list->getSelectedIndex()) {
				execute();
			} else {
				prevIndex = list->getSelectedIndex();
			}
		} else if (event->type == KEY_PRESSED) {
			// ENTERキー押下
			if (((KeyEvent *)event)->keycode == VKEY_ENTER) {
				execute();
			}
		}
	}
};

/** モナーアイコン（パレット） */
static unsigned int monaIconPalette [4] = {
	0xffc0c0c0,
	0xfffefefe,
	0xff000000,
	0xfffc6604,
};

/** モナーアイコン（データ） */
static char monaIconData [15][16] = {
	{0x0,0x0,0x0,0x0,0x2,0x0,0x0,0x0,0x0,0x0,0x2,0x0,0x0,0x0,0x0,0x0},
	{0x0,0x0,0x0,0x2,0x1,0x2,0x0,0x0,0x0,0x2,0x1,0x2,0x0,0x0,0x0,0x0},
	{0x0,0x0,0x0,0x2,0x1,0x2,0x0,0x0,0x0,0x2,0x1,0x2,0x0,0x0,0x0,0x0},
	{0x0,0x0,0x2,0x1,0x1,0x1,0x2,0x2,0x2,0x1,0x1,0x1,0x2,0x0,0x0,0x0},
	{0x0,0x0,0x2,0x1,0x1,0x1,0x1,0x1,0x1,0x1,0x1,0x1,0x1,0x2,0x0,0x0},
	{0x0,0x2,0x1,0x1,0x1,0x1,0x1,0x1,0x1,0x1,0x1,0x1,0x1,0x1,0x2,0x0},
	{0x0,0x2,0x1,0x1,0x1,0x2,0x1,0x1,0x1,0x1,0x1,0x2,0x1,0x1,0x2,0x0},
	{0x2,0x1,0x1,0x1,0x2,0x1,0x1,0x1,0x1,0x1,0x1,0x1,0x2,0x1,0x1,0x2},
	{0x2,0x1,0x1,0x1,0x1,0x1,0x1,0x1,0x1,0x1,0x1,0x1,0x1,0x1,0x1,0x2},
	{0x2,0x1,0x1,0x1,0x1,0x1,0x2,0x1,0x1,0x1,0x2,0x1,0x1,0x1,0x1,0x2},
	{0x2,0x1,0x1,0x1,0x1,0x1,0x1,0x2,0x2,0x2,0x1,0x1,0x1,0x1,0x1,0x2},
	{0x0,0x2,0x1,0x1,0x1,0x1,0x1,0x2,0x3,0x2,0x1,0x1,0x1,0x1,0x2,0x0},
	{0x0,0x2,0x1,0x1,0x1,0x1,0x1,0x1,0x2,0x1,0x1,0x1,0x1,0x1,0x2,0x0},
	{0x0,0x0,0x2,0x2,0x1,0x1,0x1,0x1,0x1,0x1,0x1,0x1,0x1,0x2,0x0,0x0},
	{0x0,0x0,0x0,0x0,0x2,0x2,0x2,0x2,0x2,0x2,0x2,0x2,0x2,0x0,0x0,0x0},
};

/** ディスクアイコン（パレット）*/
static unsigned int diskIconPalette [16] = {
	0xff040204,
	0xff04be04,
	0xff3c4644,
	0xff8c8e8c,
	0xffcccecc,
	0xffdc0604,
	0xff6c7674,
	0xffacaeac,
	0xffeceeec,
	0xff4c5654,
	0xffdcdedc,
	0xffbcbebc,
	0x00fc0204,
	0xff040604,
	0xff161300,
	0xff000000,
};

/** ディスクアイコン（データ）*/
static unsigned char diskIconData [32][32] = {
	{0xc,0xc,0xc,0xc,0xc,0xc,0xc,0xc,0xc,0xc,0xc,0xc,0xc,0xc,0xc,0xc,0xc,0xc,0xc,0xc,0xc,0xc,0xc,0xc,0xc,0xc,0xc,0xc,0xc,0xc,0xc,0xc},
	{0xc,0xc,0xc,0xc,0xc,0xc,0xc,0xc,0xc,0xc,0xc,0xc,0xc,0xc,0xc,0xc,0xc,0xc,0xc,0xc,0xc,0xc,0xc,0xc,0xc,0xc,0xc,0xc,0xc,0xc,0xc,0xc},
	{0xc,0xc,0xc,0xc,0xc,0xc,0xc,0xc,0xc,0xc,0xc,0xc,0xc,0xc,0xc,0xc,0xc,0xc,0xc,0xc,0xc,0xc,0xc,0xc,0xc,0xc,0xc,0xc,0xc,0xc,0xc,0xc},
	{0xc,0xc,0xc,0xc,0xc,0xc,0xc,0xc,0xc,0xc,0xc,0xc,0xc,0xc,0xc,0xc,0xc,0xc,0xc,0xc,0xc,0xc,0xc,0xc,0xc,0xc,0xc,0xc,0xc,0xc,0xc,0xc},
	{0xc,0xc,0xc,0xc,0xc,0xc,0xc,0xc,0xc,0xc,0xc,0xc,0xc,0xc,0xc,0xc,0xc,0xc,0xc,0xc,0xc,0xc,0xc,0xc,0xc,0xc,0xc,0xc,0xc,0xc,0xc,0xc},
	{0xc,0xc,0xc,0xc,0xc,0xc,0xc,0xc,0xc,0xc,0xc,0xc,0xc,0xc,0xc,0xc,0xc,0xc,0xc,0xc,0xc,0xc,0xc,0xc,0xc,0xc,0xc,0xc,0xc,0xc,0xc,0xc},
	{0xc,0xc,0xc,0xc,0xc,0xc,0xc,0xc,0xc,0xc,0xc,0xc,0xc,0xc,0xc,0xc,0xc,0xc,0xc,0xc,0xc,0xc,0xc,0xc,0xc,0xc,0xc,0xc,0xc,0xc,0xc,0xc},
	{0xc,0xc,0xc,0xc,0xc,0xc,0xc,0xc,0xc,0xc,0xc,0xc,0xc,0xc,0xc,0xc,0xc,0xc,0xc,0xc,0xc,0xc,0xc,0xc,0xc,0xc,0xc,0xc,0xc,0xc,0xc,0xc},
	{0xc,0xc,0xc,0xc,0xc,0xc,0xc,0xc,0xc,0xc,0xc,0xc,0xc,0xc,0xc,0xc,0xc,0xc,0xc,0xc,0xc,0xc,0xc,0xc,0xc,0xc,0xc,0xc,0xc,0xc,0xc,0xc},
	{0xc,0xc,0xc,0xc,0xc,0xc,0xc,0xc,0xc,0xc,0xc,0xc,0xc,0xc,0xc,0xc,0xc,0xc,0xc,0xc,0xc,0xc,0xc,0xc,0xc,0xc,0xc,0xc,0xc,0xc,0xc,0xc},
	{0xc,0xc,0xc,0xc,0xc,0xc,0xc,0xc,0xc,0xc,0xc,0xc,0xc,0xc,0xc,0xc,0xc,0xc,0xc,0xc,0xc,0xc,0xc,0xc,0xc,0xc,0xc,0xc,0xc,0xc,0xc,0xc},
	{0xc,0xc,0xc,0xc,0xc,0xc,0xc,0xc,0xc,0xc,0xc,0xc,0xc,0xc,0xc,0xc,0xc,0xc,0xc,0xc,0xc,0xc,0xc,0xc,0xc,0xc,0xc,0xc,0xc,0xc,0xc,0xc},
	{0xc,0xc,0xc,0xc,0xc,0xc,0xc,0xc,0xc,0xc,0xc,0xc,0xc,0xc,0xc,0xc,0xc,0xc,0xc,0xc,0xc,0xc,0xc,0xc,0xc,0xc,0xc,0xc,0xc,0xc,0xc,0xc},
	{0xc,0xc,0xc,0xc,0xc,0xc,0xc,0xc,0xc,0xc,0xc,0xc,0xc,0xc,0xc,0xc,0xc,0xc,0xc,0xc,0xc,0xc,0xc,0xc,0xc,0xc,0xc,0xc,0xc,0xc,0xc,0xc},
	{0xc,0xc,0xc,0xc,0xc,0xc,0xc,0xc,0xc,0xc,0xc,0xc,0xc,0xc,0xc,0xc,0xc,0xc,0xc,0xc,0xc,0xc,0xc,0xc,0xc,0xc,0xc,0xc,0xc,0xc,0xc,0xc},
	{0xc,0xc,0xc,0xc,0xc,0xc,0xc,0xc,0xc,0xc,0xc,0xc,0xc,0xc,0xc,0xc,0xc,0xc,0xc,0xc,0xc,0xc,0xc,0xc,0xc,0xc,0xc,0xc,0xc,0xc,0xc,0xc},
	{0xc,0xc,0xc,0xc,0xc,0xc,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0xc,0xc,0xc,0xc,0xc,0xc,0xc,0xc,0xc},
	{0xc,0xc,0xc,0xc,0xc,0x0,0x8,0xa,0xa,0xa,0xa,0xa,0xa,0xa,0xa,0xa,0xa,0xa,0xa,0xa,0xa,0xa,0xb,0x0,0xc,0xc,0xc,0xc,0xc,0xc,0xc,0xc},
	{0xc,0xc,0xc,0xc,0x0,0x8,0xa,0xa,0xa,0xa,0xa,0xa,0xa,0xa,0xa,0xa,0xa,0xa,0xa,0xa,0xa,0xa,0xa,0xb,0x0,0xc,0xc,0xc,0xc,0xc,0xc,0xc},
	{0xc,0xc,0xc,0x0,0x8,0xa,0xa,0xa,0xa,0xa,0xa,0xa,0xa,0xa,0xa,0xa,0xa,0xa,0xa,0xa,0xa,0xa,0xa,0xa,0xb,0x0,0xc,0xc,0xc,0xc,0xc,0xc},
	{0xc,0xc,0x0,0x8,0xa,0xa,0xa,0xa,0xa,0xa,0xa,0xa,0xa,0xa,0xa,0xa,0xa,0xa,0xa,0xa,0xa,0xa,0xa,0xa,0xa,0xb,0x0,0xc,0xc,0xc,0xc,0xc},
	{0xc,0x0,0x8,0xa,0x4,0xa,0xa,0x4,0xa,0xa,0x4,0xa,0xa,0x4,0xa,0xa,0x4,0xa,0xa,0x4,0xa,0xa,0x4,0xa,0xa,0xa,0xb,0x0,0xc,0xc,0xc,0xc},
	{0x0,0x8,0x8,0x8,0x8,0x8,0x8,0x8,0x8,0x8,0x8,0x8,0x8,0x8,0x8,0x8,0x8,0x8,0x8,0x8,0x8,0x8,0x8,0x8,0x8,0x8,0x8,0xb,0x0,0xc,0xc,0xc},
	{0x0,0x8,0x8,0x8,0xa,0x8,0xa,0xa,0xa,0x4,0xa,0x4,0x4,0x4,0x4,0x4,0x4,0xb,0x4,0xb,0xb,0xb,0xb,0xb,0x7,0xb,0xb,0x3,0x0,0xc,0xc,0xc},
	{0x0,0xb,0x7,0x3,0x7,0x3,0x7,0x3,0x7,0x3,0x3,0x3,0x3,0x3,0x3,0x3,0x3,0x3,0x3,0x3,0x3,0x3,0x3,0x3,0x3,0x3,0x3,0x6,0x0,0xc,0xc,0xc},
	{0x0,0x8,0x8,0x8,0x4,0x8,0xa,0xa,0xa,0x4,0xa,0x4,0x4,0x4,0x4,0x4,0x4,0xb,0x4,0xb,0xb,0xb,0xb,0xb,0xb,0xb,0xb,0x6,0x0,0xc,0xc,0xc},
	{0x0,0x8,0x8,0x8,0x8,0xa,0xa,0x4,0xa,0xa,0xb,0x4,0x4,0xb,0x4,0x4,0xb,0x4,0xb,0x7,0xb,0xb,0x7,0xb,0xb,0x7,0xb,0x6,0x0,0xc,0xc,0xc},
	{0x0,0x8,0x8,0x8,0x1,0x1,0xa,0xa,0xa,0x4,0xa,0x4,0x4,0x4,0x4,0x4,0x4,0xb,0x4,0xb,0xb,0xb,0xb,0xb,0xb,0xb,0xb,0x6,0x0,0x2,0xc,0xc},
	{0x0,0x8,0x8,0x8,0x5,0x5,0xa,0xa,0xa,0xa,0x4,0x4,0x4,0x4,0x4,0x4,0x4,0x4,0xb,0xb,0xb,0xb,0xb,0xb,0xb,0xb,0xb,0x6,0x0,0x2,0x2,0xc},
	{0xd,0x8,0x8,0x8,0xa,0xa,0xa,0xa,0xa,0xa,0xa,0x4,0x4,0x4,0x4,0x4,0x4,0xb,0x4,0xb,0xb,0xb,0xb,0xb,0xb,0xb,0xb,0x6,0x0,0x2,0x2,0x2},
	{0x0,0x7,0x3,0x3,0x3,0x3,0x3,0x3,0x3,0x3,0x3,0x3,0x3,0x3,0x3,0x3,0x3,0x3,0x3,0x6,0x6,0x6,0x6,0x6,0x6,0x6,0x6,0x9,0x0,0x2,0x2,0x2},
	{0x0,0x0,0xd,0x0,0xd,0x0,0xd,0x0,0xd,0x0,0xd,0x0,0xd,0x0,0xd,0x0,0xd,0x0,0xd,0x0,0xd,0x0,0xd,0x0,0xd,0x0,0xd,0x0,0x2,0x2,0x2,0xc},
};

/** 端末アイコン（パレット）*/
static unsigned int terminalIconPalette [16] = {
	0xff040604,
	0xff8c8e8c,
	0xff6466cc,
	0xffdbdddb,
	0xff444644,
	0x00fc0204,
	0xff049efc,
	0xff040654,
	0xfff4f6f4,
	0xffbbbdbb,
	0xff9c9efc,
	0xff242624,
	0xff545654,
	0xffcccefc,
	0xff343664,
	0xff141614,
};

/** 端末アイコン（データ）*/
static unsigned char terminalIconData [32][32] = {
	{0x5,0x5,0x5,0x5,0x5,0x5,0x5,0x5,0x5,0x5,0x5,0x5,0x5,0x5,0x4,0xb,0x0,0x5,0x5,0x5,0x5,0x5,0x5,0x5,0x5,0x5,0x5,0x5,0x5,0x5,0x5,0x5},
	{0x5,0x5,0x5,0x5,0x5,0x5,0x5,0x5,0x5,0x5,0x5,0x5,0x4,0xf,0x1,0x9,0x1,0x4,0x0,0x0,0x5,0x5,0x5,0x5,0x5,0x5,0x5,0x5,0x5,0x5,0x5,0x5},
	{0x5,0x5,0x5,0x5,0x5,0x5,0x5,0x5,0x5,0x5,0x4,0xb,0x1,0x9,0x8,0x8,0x8,0x3,0x9,0x1,0x4,0x0,0x5,0x5,0x5,0x5,0x5,0x5,0x5,0x5,0x5,0x5},
	{0x5,0x5,0x5,0x5,0x5,0x5,0x5,0x5,0x4,0xf,0x1,0x9,0x3,0x8,0x8,0x3,0x3,0x3,0x3,0x3,0x1,0x1,0x4,0x0,0x5,0x5,0x5,0x5,0x5,0x5,0x5,0x5},
	{0x5,0x5,0x5,0x5,0x5,0x5,0x5,0x4,0x1,0x4,0x9,0x3,0x8,0x3,0x3,0x3,0x3,0x3,0x3,0x3,0x3,0xd,0x9,0x1,0x4,0x0,0x5,0x5,0x5,0x5,0x5,0x5},
	{0x5,0x5,0x5,0x5,0x5,0x5,0x5,0x4,0x9,0x9,0x1,0x4,0x9,0x8,0x3,0x3,0x3,0x3,0x3,0x3,0x3,0x3,0x3,0x3,0x9,0x1,0x4,0x0,0x5,0x5,0x5,0x5},
	{0x5,0x5,0x5,0x5,0x5,0x5,0x5,0x4,0x9,0x9,0x9,0x9,0x1,0x4,0x9,0x8,0x3,0x3,0x3,0x3,0x3,0x3,0x3,0x3,0x9,0x9,0x1,0x0,0x0,0x5,0x5,0x5},
	{0x5,0x5,0x5,0x5,0x5,0x5,0x5,0x4,0x9,0x0,0x4,0x9,0x9,0x9,0x1,0x4,0x9,0x8,0xd,0x3,0x3,0x3,0x3,0x9,0x9,0x1,0x0,0xb,0x0,0x5,0x5,0x5},
	{0x5,0x5,0x5,0x5,0x5,0x5,0x5,0x4,0x9,0x0,0xa,0x0,0x4,0x9,0x9,0x9,0x1,0x4,0x9,0x8,0x3,0x9,0x9,0x1,0x0,0xf,0x4,0xb,0x0,0x5,0x5,0x5},
	{0x5,0x5,0x5,0x5,0x5,0x5,0x5,0x4,0x9,0x0,0x6,0xa,0xe,0x0,0x4,0x9,0x9,0x9,0x1,0x4,0x1,0xc,0x0,0xb,0xc,0xc,0x4,0xf,0x0,0x5,0x5,0x5},
	{0x5,0x5,0x5,0x5,0x5,0x5,0x5,0x4,0x9,0x0,0xa,0xa,0xa,0x6,0xe,0x0,0x4,0x9,0x9,0x9,0x9,0x1,0xc,0xc,0xc,0xc,0x4,0xb,0x0,0x5,0x5,0x5},
	{0x5,0x5,0x5,0x5,0x5,0x5,0x5,0x4,0x9,0x0,0xa,0xa,0x6,0xa,0xa,0xa,0xe,0x0,0x4,0x9,0x9,0x1,0x4,0xc,0xc,0xc,0xe,0xb,0x0,0x5,0x5,0x5},
	{0x5,0x5,0x5,0x5,0x5,0x5,0x5,0x4,0x9,0x0,0xa,0x6,0xa,0xa,0xa,0x6,0xa,0xa,0x0,0x0,0x9,0x1,0xe,0xc,0xc,0xc,0x4,0xb,0x0,0x5,0x5,0x5},
	{0x5,0x5,0x5,0x5,0x5,0x5,0x5,0x4,0x9,0x0,0x6,0xa,0xa,0xa,0x6,0xa,0xa,0xa,0x6,0x0,0x9,0x1,0xc,0xc,0xc,0x4,0x4,0xb,0x0,0x5,0x5,0x5},
	{0x5,0x5,0x5,0x5,0x5,0x5,0x5,0x4,0x0,0x0,0xa,0xa,0xa,0x6,0xa,0xa,0xa,0x6,0xa,0x0,0x9,0x1,0xc,0xc,0xc,0xc,0x4,0xb,0x0,0x5,0x5,0x5},
	{0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x6,0xa,0xa,0x0,0x9,0x1,0xc,0xc,0xc,0xc,0x4,0xb,0x0,0x5,0x5,0x5},
	{0x0,0x2,0x2,0x2,0x2,0x2,0x2,0x0,0xd,0xd,0xd,0xd,0xd,0xd,0xd,0x0,0xe,0xa,0xa,0x0,0x9,0x1,0xc,0xc,0xc,0x4,0x4,0xb,0x0,0x5,0x5,0x5},
	{0x0,0x2,0x2,0x2,0x7,0x2,0x2,0x0,0xd,0xd,0x0,0xd,0xd,0xd,0xd,0x0,0xe,0x2,0x6,0x0,0x9,0x1,0xc,0xc,0xc,0xc,0x4,0xf,0x0,0x5,0x5,0x5},
	{0x0,0x2,0x2,0x2,0x7,0x2,0x0,0xd,0xd,0xd,0x0,0xd,0xd,0xd,0xd,0x0,0xe,0x2,0xa,0x0,0x9,0x1,0x4,0xc,0xc,0xc,0x4,0xb,0x0,0x5,0x5,0x5},
	{0x0,0x2,0x2,0x2,0x2,0x2,0x0,0xd,0xd,0xd,0xd,0xd,0xd,0xd,0xd,0x0,0xe,0x4,0xa,0x0,0x9,0x1,0xc,0xc,0xc,0xc,0xe,0xb,0x0,0x5,0x5,0x5},
	{0x0,0x2,0x2,0x2,0x2,0x2,0x0,0xd,0xd,0xd,0xd,0xd,0xd,0xd,0xd,0x0,0xe,0x2,0x0,0x0,0x9,0x1,0xc,0x4,0x4,0xc,0x4,0xf,0x0,0x5,0x5,0x5},
	{0x0,0x2,0x2,0x2,0x2,0x2,0x0,0xd,0xd,0xd,0xd,0xd,0xd,0xd,0xd,0x0,0xe,0x2,0x9,0x9,0x9,0x1,0xc,0xc,0xc,0xc,0x4,0xb,0x0,0x4,0x5,0x5},
	{0x0,0x2,0x2,0x2,0x2,0x2,0x0,0x0,0x0,0x0,0xd,0xd,0xd,0xd,0xd,0x0,0xe,0x4,0x9,0x9,0x9,0x1,0xc,0xc,0xc,0xc,0x4,0xb,0x0,0xb,0x4,0x5},
	{0x0,0x2,0x2,0x2,0x2,0x2,0x2,0x2,0x0,0xd,0xd,0xd,0xd,0xd,0xd,0x0,0xe,0x2,0x0,0x1,0x9,0x1,0x4,0xc,0xc,0xc,0x4,0xb,0x0,0xb,0xb,0xb},
	{0x0,0x2,0x2,0x2,0x7,0x2,0x2,0x2,0x0,0xd,0xd,0x0,0xd,0xd,0xd,0x0,0xe,0x2,0x9,0x9,0x9,0x1,0xc,0xc,0xc,0x4,0x4,0xb,0x0,0xf,0xb,0xb},
	{0x0,0x2,0x2,0x2,0x2,0x7,0x7,0x7,0x0,0x0,0x0,0xd,0xd,0xd,0xd,0x0,0xe,0x2,0x9,0x9,0x9,0x1,0xc,0xc,0xc,0x4,0x4,0x0,0x0,0xb,0xb,0x4},
	{0x0,0x2,0x2,0x2,0x2,0x2,0x2,0x2,0x0,0xd,0xd,0xd,0xd,0xd,0xd,0x0,0xe,0x2,0x9,0x9,0x9,0x1,0xc,0x4,0x4,0xb,0x0,0x0,0xb,0xb,0x4,0x4},
	{0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0xe,0x2,0x9,0x9,0x9,0x1,0x4,0xb,0x0,0x0,0xb,0xb,0x4,0x4,0x5,0x5},
	{0x5,0x5,0xe,0xe,0xe,0xe,0xe,0xe,0xe,0x0,0xe,0xe,0xe,0xe,0xe,0xe,0xe,0xb,0x4,0x1,0x9,0x4,0x0,0x0,0xb,0xb,0x0,0x0,0x5,0x5,0x5,0x5},
	{0x5,0x5,0x5,0x5,0x2,0x2,0x2,0x2,0x2,0x2,0x0,0x2,0x2,0x2,0x2,0xb,0x0,0xb,0xb,0xb,0x0,0x0,0xb,0xb,0x0,0x0,0x5,0x5,0x5,0x5,0x5,0x5},
	{0x5,0x5,0x5,0x5,0x5,0x5,0x5,0x5,0x5,0x5,0x5,0x5,0x5,0x5,0x5,0x5,0x5,0x0,0xf,0xb,0xb,0xb,0x0,0x0,0x5,0x5,0x5,0x5,0x5,0x5,0x5,0x5},
	{0x5,0x5,0x5,0x5,0x5,0x5,0x5,0x5,0x5,0x5,0x5,0x5,0x5,0x5,0x5,0x5,0x5,0x5,0x5,0xf,0xf,0xf,0x5,0x5,0x5,0x5,0x5,0x5,0x5,0x5,0x5,0x5},
};

/** ゴミ箱アイコン（パレット）*/
static unsigned int trashboxIconPalette [16] = {
	0xff040604,
	0xff7c7e7c,
	0xff3c3e3c,
	0xffbcbebc,
	0x00fc0204,
	0xffb4b6b4,
	0xff6c6e6c,
	0xffe4e6e4,
	0xff242624,
	0xff545654,
	0xff8c968c,
	0xfff4f6f4,
	0xffd00082,
	0xff400000,
	0xff161300,
	0xff000000,
};

/** ゴミ箱アイコン（データ）*/
static unsigned char trashboxIconData [32][32] = {
	{0x4,0x4,0x4,0x4,0x4,0x4,0x8,0x4,0x4,0x4,0x4,0x4,0x4,0x4,0x4,0x8,0x4,0x4,0x4,0x4,0x4,0x4,0x4,0x4,0x4,0x4,0x4,0x4,0x4,0x4,0x4,0x4},
	{0x4,0x4,0x4,0x4,0x4,0x8,0x7,0x8,0x4,0x4,0x4,0x4,0x4,0x4,0x8,0x7,0x8,0x4,0x4,0x4,0x4,0x4,0x4,0x4,0x4,0x4,0x4,0x4,0x4,0x4,0x4,0x4},
	{0x4,0x4,0x4,0x4,0x8,0x7,0x7,0x7,0x0,0x8,0x8,0x8,0x8,0x8,0xb,0xb,0xb,0x8,0x4,0x4,0x4,0x4,0x4,0x4,0x4,0x4,0x4,0x4,0x4,0x4,0x4,0x4},
	{0x4,0x4,0x4,0x0,0x8,0x8,0x8,0x8,0x8,0x8,0x8,0x8,0x8,0xb,0xb,0xb,0xb,0xb,0x8,0x4,0x4,0x4,0x4,0x4,0x4,0x4,0x4,0x4,0x4,0x4,0x4,0x4},
	{0x4,0x0,0x0,0x7,0x8,0xb,0x7,0x7,0x7,0x7,0x7,0x8,0xb,0xb,0x7,0x8,0xb,0x3,0x3,0x0,0x4,0x4,0x4,0x4,0x4,0x4,0x4,0x4,0x4,0x4,0x4,0x4},
	{0x0,0x0,0x3,0x7,0x8,0x7,0xb,0x7,0x7,0x7,0x8,0xb,0xb,0xb,0x8,0x7,0x8,0x5,0x5,0x8,0x4,0x4,0x4,0x4,0x4,0x4,0x4,0x4,0x4,0x4,0x4,0x4},
	{0x0,0x0,0x5,0x3,0x8,0xb,0x7,0x7,0x7,0x8,0xb,0xb,0xb,0x8,0x7,0x7,0x7,0x8,0x2,0x6,0x0,0x4,0x4,0x4,0x4,0x4,0x4,0x4,0x4,0x4,0x4,0x4},
	{0x0,0x1,0x0,0x3,0x8,0x7,0x7,0x7,0x8,0xb,0xb,0x7,0x8,0x7,0x7,0x5,0x3,0x2,0x2,0xa,0x0,0x4,0x4,0x4,0x4,0x4,0x4,0x4,0x4,0x4,0x4,0x4},
	{0x0,0xb,0xa,0x0,0x0,0x0,0x7,0x8,0xb,0x7,0x7,0x8,0x3,0x5,0x6,0x2,0x2,0x6,0xa,0xa,0x0,0x4,0x4,0x4,0x4,0x4,0x4,0x4,0x4,0x4,0x4,0x4},
	{0x0,0xa,0x7,0xb,0x1,0x9,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x8,0x8,0xa,0xa,0xa,0x9,0x2,0x0,0x4,0x4,0x4,0x4,0x4,0x4,0x4,0x4,0x4,0x4,0x4},
	{0x0,0xa,0x7,0x7,0xb,0xb,0x5,0x5,0x5,0x3,0x3,0x3,0x5,0x5,0xa,0xa,0x6,0x6,0x9,0x2,0x0,0x4,0x4,0x4,0x4,0x4,0x4,0x4,0x4,0x4,0x4,0x4},
	{0x4,0x8,0x2,0x7,0x7,0x7,0x7,0x7,0x7,0x5,0x5,0x5,0x1,0xa,0x1,0x6,0x8,0x0,0x0,0x0,0x0,0x0,0x4,0x4,0x4,0x4,0x4,0x4,0x4,0x4,0x4,0x4},
	{0x4,0x0,0x1,0x9,0x6,0x3,0x7,0x7,0x7,0x5,0x5,0x5,0xa,0xa,0x1,0x8,0x2,0x7,0x7,0x1,0x5,0x5,0x0,0x4,0x4,0x4,0x4,0x4,0x4,0x4,0x4,0x4},
	{0x4,0x0,0x5,0x5,0x5,0x1,0xa,0x6,0x2,0x2,0x2,0x2,0x2,0x2,0x2,0x9,0x7,0x7,0x1,0x7,0x7,0x5,0x0,0x4,0x4,0x4,0x4,0x4,0x4,0x4,0x4,0x4},
	{0x4,0x0,0x5,0x5,0x5,0x7,0x7,0x7,0x7,0x5,0x5,0x5,0xa,0xa,0x0,0x7,0x7,0x5,0x7,0xb,0xb,0x7,0x5,0x0,0x4,0x4,0x4,0x4,0x4,0x4,0x4,0x4},
	{0x4,0x0,0x5,0x1,0x5,0x7,0xb,0x7,0x1,0x7,0x7,0x5,0x5,0x0,0x3,0x7,0x7,0x5,0xb,0xb,0xb,0xb,0x7,0x0,0x4,0x4,0x4,0x4,0x4,0x4,0x4,0x4},
	{0x4,0x0,0x5,0x6,0x5,0x7,0x7,0x1,0x5,0x5,0x7,0x5,0x9,0x0,0x5,0xb,0x7,0x5,0xb,0xb,0x7,0xb,0x7,0xa,0x0,0x4,0x4,0x4,0x4,0x4,0x4,0x4},
	{0x4,0x0,0x5,0x1,0x5,0x7,0x7,0x1,0x5,0x5,0x7,0x5,0x9,0x0,0x7,0xb,0x3,0x7,0xb,0xb,0xb,0xb,0xb,0x7,0x0,0x4,0x4,0x4,0x4,0x4,0x4,0x4},
	{0x4,0x0,0x5,0x1,0x5,0x7,0x7,0x1,0x5,0x5,0x7,0x5,0x9,0x0,0x7,0x7,0x5,0xb,0xb,0xb,0xb,0xb,0x2,0x2,0x2,0x0,0x4,0x4,0x4,0x4,0x4,0x4},
	{0x4,0x0,0x5,0x1,0x5,0x7,0xb,0x1,0x5,0x5,0x7,0x5,0x9,0x0,0x7,0x7,0x5,0x7,0x7,0xb,0xb,0x7,0x8,0x5,0x2,0x0,0x4,0x4,0x4,0x4,0x4,0x4},
	{0x4,0x0,0x5,0x6,0x5,0x7,0x7,0x6,0x5,0x5,0x7,0x5,0x9,0x0,0x5,0x5,0x5,0x7,0x7,0x7,0xb,0x3,0x2,0x0,0x8,0xa,0x0,0x4,0x4,0x4,0x4,0x4},
	{0x4,0x0,0x5,0x1,0x5,0x7,0x7,0x1,0x5,0x5,0x7,0x5,0x9,0x0,0x5,0x5,0xa,0x7,0x7,0x7,0xb,0x5,0x5,0x0,0x2,0xb,0x0,0x8,0x8,0x4,0x4,0x4},
	{0x4,0x0,0x5,0x1,0x5,0x7,0xb,0x1,0x5,0x5,0x7,0x5,0x9,0x0,0x5,0x5,0xa,0x3,0x7,0xa,0x2,0x2,0x2,0x8,0xb,0x0,0x8,0x8,0x8,0x8,0x4,0x4},
	{0x4,0x0,0x5,0x1,0x5,0x7,0x7,0x1,0x5,0x5,0x7,0x5,0x9,0x0,0xa,0xa,0x1,0x3,0x3,0xa,0x0,0xa,0xa,0x2,0xb,0x0,0x8,0x8,0x8,0x8,0x8,0x4},
	{0x4,0x0,0x5,0x6,0x5,0x7,0xb,0x6,0x5,0x5,0x7,0x5,0x9,0x0,0xa,0xa,0x1,0x5,0x5,0x1,0x2,0x0,0xa,0xa,0x0,0x8,0x8,0x8,0x8,0x0,0x8,0x8},
	{0x4,0x0,0x5,0x6,0x5,0x7,0x7,0x1,0x5,0x5,0x7,0x5,0x9,0x0,0x2,0x1,0x9,0xa,0x5,0x1,0x2,0x8,0x0,0x0,0x0,0x8,0x8,0x8,0x8,0x8,0x8,0x8},
	{0x4,0x0,0x5,0x5,0x5,0x7,0xb,0x1,0x5,0x5,0x7,0x3,0x9,0x9,0x8,0x9,0x9,0x9,0x5,0x1,0x6,0x2,0x2,0x2,0x0,0x8,0x0,0x8,0x8,0x8,0x8,0x8},
	{0x4,0x0,0x5,0x5,0x7,0x7,0xb,0x1,0x5,0x5,0x7,0x5,0x9,0x1,0x0,0x9,0x2,0x9,0x1,0xa,0xa,0x2,0x2,0x2,0x0,0x8,0x8,0x8,0x8,0x8,0x8,0x4},
	{0x4,0x8,0x1,0x7,0x7,0xb,0xb,0x7,0x6,0x7,0x7,0x5,0x5,0x9,0x0,0x2,0x9,0x9,0xa,0x5,0x5,0xa,0x2,0x0,0x8,0x8,0x8,0x8,0x8,0x8,0x4,0x4},
	{0x4,0x4,0x8,0x0,0x5,0xb,0xb,0x7,0x7,0x7,0x7,0x5,0x5,0x5,0xa,0x8,0x9,0x9,0x2,0xa,0xa,0xa,0x2,0x0,0x8,0x8,0x8,0x8,0x4,0x4,0x4,0x4},
	{0x4,0x4,0x4,0x4,0x0,0x0,0x0,0x5,0x5,0x3,0x3,0x5,0x5,0x1,0x0,0x0,0x2,0x2,0x2,0x9,0x1,0x9,0x0,0x8,0x8,0x8,0x4,0x4,0x4,0x4,0x4,0x4},
	{0x4,0x4,0x4,0x4,0x4,0x4,0x4,0x8,0x0,0x0,0x0,0x0,0x0,0x8,0x8,0x8,0x8,0x0,0x0,0x0,0x0,0x0,0x8,0x8,0x4,0x4,0x4,0x4,0x4,0x4,0x4,0x4},
};

#define DISKICON      0
#define TERMINALICON  1
#define TRASHBOXICON  2

class ShortCut : public Window {
private:
	int type;

public:
	ShortCut(int type) {
		this->type = type;
		if (this->type == DISKICON) {
			setRect(720, 22, 64, 64);
			setTitle("Mona HD");
		} else if (this->type == TERMINALICON) {
			setRect(720, 86, 64, 64);
			setTitle("た～みなる");
		} else if (this->type == TRASHBOXICON) {
			setRect(720, 510, 64, 64);
			setTitle("ゴミ箱");
		}
	}

	/** ウィンドウ生成時に呼ばれる */
	virtual void create() {
		Window::create();
		this->_window->TransparencyKey = 0xfffcfcfc;
		this->_window->Flags |= WINDOWFLAGS_BOTTOMMOST | WINDOWFLAGS_NOBORDER;
	}

	/** 再描画 */
	virtual void onPaint(Graphics *g) {
		if (this->_buffer == NULL) return;
		
		int w = this->width;
		int h = this->height;
		
		g->setColor(0xfffcfcfc);
		g->fillRect(0,0,w,h);
		
		for (int i = 0; i < 32; i++) {
			for (int j = 0; j < 32; j++) {
				// ディスクアイコン
				if (this->type == DISKICON) {
					g->drawPixel(16 + j, i, diskIconPalette[(int)(diskIconData[i][j])]);
				// 端末アイコン
				} else if (this->type == TERMINALICON) {
					g->drawPixel(16 + j, i, terminalIconPalette[(int)(terminalIconData[i][j])]);
				// ゴミ箱アイコン
				} else if (this->type == TRASHBOXICON) {
					g->drawPixel(16 + j, i, trashboxIconPalette[(int)(trashboxIconData[i][j])]);
				}
			}
		}
		
		// タイトル
		int fw = this->_metrics->getWidth(getTitle());
		int fh = this->_metrics->getHeight(getTitle());
		g->setColor(COLOR_WHITE);
		g->fillRect((w - fw)/2 - 4, 36, fw + 8, 12);
		g->setColor(COLOR_BLACK);
		g->drawText(getTitle(), (w - fw)/2, 36);
		
		// _gへの描画が反映されると困るので直接ウィンドウを更新
		MonAPI::Message::sendReceive(NULL, guisvrID, MSG_GUISERVER_DRAWWINDOW, getHandle());
	}

	/** イベントハンドラ */
	virtual void postEvent(Event *event) {
		int w = this->width;
		int h = this->height;
		
		if (event->type == MOUSE_RELEASED) {
			// 視覚効果
			if (this->type == DISKICON || this->type == TERMINALICON) {
				MonAPI::Message::sendReceive(NULL, this->guisvrID, MSG_GUISERVER_EXPANSIONEFFECT,
					MAKE_DWORD(this->x + w/2, this->y + h/2),
					MAKE_DWORD(this->x, this->y),
					MAKE_DWORD(64, 64)
				);
			}
			// アプリケーション実行
			if (this->type == DISKICON) {
				monapi_call_process_execute_file("/APPS/BAYGUI/GLAUNCH.EX5 FILE", MONAPI_FALSE);
			} else if (this->type == TERMINALICON) {
				monapi_call_process_execute_file("/APPS/BAYGUI/GSHELL.EX5", MONAPI_FALSE);
			}
		}
	}
};

/** メイン */
int MonaMain(List<char*>* pekoe) {
	if (pekoe->size() == 0) {
		monapi_call_process_execute_file("/APPS/BAYGUI/GLAUNCH.EX5 DISK", MONAPI_FALSE);
		monapi_call_process_execute_file("/APPS/BAYGUI/GLAUNCH.EX5 TERM", MONAPI_FALSE);
		monapi_call_process_execute_file("/APPS/BAYGUI/GLAUNCH.EX5 TRASH", MONAPI_FALSE);
	} else {
		char *arg0 = pekoe->get(0);
		if (strcmp(arg0, "DISK") == 0) {
			ShortCut *shortcut = new ShortCut(0);
			shortcut->run();
			delete(shortcut);
		} else if (strcmp(arg0, "TERM") == 0) {
			ShortCut *shortcut = new ShortCut(1);
			shortcut->run();
			delete(shortcut);
		} else if (strcmp(arg0, "TRASH") == 0) {
			ShortCut *shortcut = new ShortCut(2);
			shortcut->run();
			delete(shortcut);
		} else if (strcmp(arg0, "FILE") == 0) {
			Glaunch *launch = new Glaunch();
			launch->run();
			delete(launch);
		}
	}
	return 0;
}
