/*
Copyright (c) 2004 bayside
All rights reserved.

Redistribution and use in source and binary forms, with or without
modification, are permitted provided that the following conditions
are met:
1. Redistributions of source code must retain the above copyright
   notice, this list of conditions and the following disclaimer.
2. Redistributions in binary form must reproduce the above copyright
   notice, this list of conditions and the following disclaimer in the
   documentation and/or other materials provided with the distribution.
3. The name of the author may not be used to endorse or promote products
   derived from this software without specific prior written permission.

THIS SOFTWARE IS PROVIDED BY THE AUTHOR ``AS IS'' AND ANY EXPRESS OR
IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT, INDIRECT,
INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT
NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
(INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
*/

#include <baygui.h>

static int color4bit[16][3] = {
	{   0,   0,   0 }, { 128,  0,   0 }, {  0, 128,   0 }, { 128, 128,   0},
	{   0,   0, 128 }, { 128,  0, 128 }, {  0, 128, 128 }, { 192, 192, 192},
	{ 128, 128, 128 }, { 255,  0,   0 }, {  0, 255,   0 }, { 255, 255,   0},
	{   0,   0, 255 }, { 255,  0, 255 }, {  0, 255, 255 }, { 255, 255, 255}
};

static int point[16][2] = {
	{ 196, 100 }, { 187,  61 }, { 164,  29 }, { 129,   9 }, {  90,   5 },
	{  53,  17 }, {  23,  44 }, {   7,  81 }, {   7, 119 }, {  23, 156 },
	{  53, 183 }, {  90, 195 }, { 129, 191 }, { 164, 171 }, { 187, 139 },
	{ 196, 100 }
};

class GBBall : public Window {
private:
	Label *label;

public:
	GBBall(){
		setRect((800 - 212) / 2, (600 - 228) / 2, 212, 228);
		setTitle("bball");
	}
	void onPaint(Graphics *g) {
		int i, j;
		g->setColor(0, 0, 0);
		g->fillRect(0, 0, 200, 200);
		for (i = 0; i <= 14; i++) {
			int x0, y0, dis;
			x0 = point[i][0];
			y0 = point[i][1];
			for (j = i + 1; j <= 15; j++) {
				dis = j - i; /* 2̓_̋ */
				if (dis >= 8)
				dis = 15 - dis; /* tɐ */
				if (dis != 0) {
				g->setColor(color4bit[16 - dis][0],color4bit[16 - dis][1],color4bit[16 - dis][2]);
				g->drawLine(x0, y0, point[j][0], point[j][1]);
				}
			}
		}
	}
};

int MonaMain(List<char*>* pekoe) {
	GBBall *bball = new GBBall();
	bball->run();
	delete(bball);
	return 0;
}
