/*!
    \file   MoTcp.cpp
    \brief  TCPvgRNX

    Copyright (c) 2004 Yamami
    All rights reserved.
    License=MIT/X License

    \author  Yamami
    \version $Revision: 1.1 $
    \date   create:2004/10/11 update:$Date: 2004/10/31 14:29:43 $
*/

/*! \class MoTcp
 *  \brief IPvgRNX
 */



#include "MoTcp.h"
#include "MonesConfig.h"
#include "MonesGlobal.h"

/*!
    \brief initialize
         MoTcp RXgN^
    \author Yamami
    \date   create:2004/10/11 update:$Date: 2004/10/31 14:29:43 $
*/
MoTcp::MoTcp()
{

}

/*!
    \brief initialize
         MoTcp initTcp
    \author Yamami
    \param  AbstractMonic *pminsNic [in] NICNXւ̃|C^
    \date   create:2004/10/11 update:$Date: 2004/10/31 14:29:43 $
*/
void MoTcp::initTcp(AbstractMonic *pminsNic ) 
{
    //NICNXێ
    insAbstractNic = pminsNic;
    return;
}


/*!
    \brief initialize
         MoTcp fXNgN^
    \author Yamami
    \date   create:2004/10/11 update:$Date: 2004/10/31 14:29:43 $
*/
MoTcp::~MoTcp() 
{

}


/*!
    \brief send_tcp
         TCPf[^o
    \param  T_TSOCK *sock [in] ʐMwTCP\Pbg\
    \param  char flags [in] tO
    \param  struct Packet *packet [in] \Pbg
    \param  char *data [in] Mf[^
    \param  dword size [in] Mf[^̃TCY
    \return 

    \author Yamami
    \date   create:2004/09/20 update:2004/09/20
*/
void send_tcp(T_TSOCK *sock, char flags, struct Packet *packet, char *data, dword size)
{
    dword tsize;
    dword sum;
    char *ip_hdr;
    char *tcp_hdr;
    char *tcp_body;

    //pPbg̃|C^AC[Tlbgwb_ƂB
    packet->ptr = packet->buffer + SIZEOF_ETHERHDR;
    //pPbg̃TCÝATCPwb_+f[^TCY
    packet->size = SIZEOF_TCPHDR + size;
    //IPwb_ւ̃|C^́ApPbg̃|C^
    ip_hdr = packet->ptr;
    //TCPwb_̃|C^́AIPwb_AIPwb_TCYvX
    tcp_hdr = ip_hdr + SIZEOF_IPHDR;
    //TCP{fBւ̃|C^́ATCPwb_ATCPwb_TCY
    tcp_body = tcp_hdr + SIZEOF_TCPHDR;

    // TCPf[^̃Zbg
    memcpy(tcp_body, data, size);

/*
    // TCPwb_̃Zbg
    packet_put_n(tcp_hdr, tcphdr_src_port, sock->myport);
    packet_put_n(tcp_hdr, tcphdr_dest_port, sock->youport);
    packet_put_nl(tcp_hdr, tcphdr_opt_mss, 0x020405b4); // kind = 2, len = 4, mss = 1460
    tcp_hdr[tcphdr_len] &= 0x0f;
    tcp_hdr[tcphdr_len] |= (5 + 1) << 4; // Unit is 32bit words

    tcp_hdr[tcphdr_flag] = flags & 0x3f;
    packet_put_n(tcp_hdr, tcphdr_chksum, 0);
    packet_put_n(tcp_hdr, tcphdr_urg, 0);

    packet_put_nl(tcp_hdr, tcphdr_ack, sock->ack);
    packet_put_nl(tcp_hdr, tcphdr_seq, sock->seq);

    // pseudo header & checksum
    packet_put_nl(tcp_hdr, pseudo_dest, node_ip_addr);
    packet_put_nl(tcp_hdr, pseudo_src, sock->ip);
    tcp_hdr[pseudo_zero]  = 0;
    tcp_hdr[pseudo_proto] = 6;
    tsize = size + SIZEOF_TCPHDR;
    if (size & 0x01) {  // size is odd
    //tsize++;
        tcp_hdr[tsize] = 0x00;
    }
    packet_put_n(tcp_hdr, pseudo_len, tsize);
    sum = calc_chksum(tcp_hdr + pseudo_src, tsize + 12);
    packet_put_n(tcp_hdr, tcphdr_chksum, sum);

    // IPwb_̃Zbg
    ip_hdr[iphdr_protocol] = IP_PROTO_TCP;
    packet_put_nl(ip_hdr, iphdr_src_addr, node_ip_addr);
    packet_put_nl(ip_hdr, iphdr_dest_addr, sock->ip);

    //IPNXőM
    ip_output(packet);

    //V[PXԍ
    if (flags & (TCP_FLAG_SYN | TCP_FLAG_FIN)) {
        sock->seq++;
    } else if (size > 0) {
        sock->seq += size;
    }
*/

}
