/*!
    \file   MoEther.cpp
    \brief  C[TlbgNX

    Copyright (c) 2004 Yamami
    All rights reserved.
    License=MIT/X License

    \author  Yamami
    \version $Revision: 1.3 $
    \date   create:2004/08/12 update:$Date: 2004/10/31 14:29:43 $
*/

/*! \class MoEther
 *  \brief C[TlbgNX
 */



#include "MonesGlobal.h"
#include "MoEther.h"


/*!
    \brief initialize
         MoEther RXgN^
    \author Yamami
    \date   create:2004/08/12 update:
*/
MoEther::MoEther()
{
    //printf("MoEther Constructor\n");
}

/*!
    \brief initialize
         MoEther etherInit
    \author Yamami
    \param  AbstractMonic *pminsNic [in] hCoNXւ̃|C^({́AۃNX)
    \date   create:2004/08/12 update:
*/
void MoEther::etherInit(AbstractMonic *pminsNic) 
{

    //printf("MoEther init\n");
    
    //C[Tlbgt[ێXg 
    /* keyinfo list */
    Ether_FrameList_ = new HList<ETHER_FRAME*>();

    //ێNIChCo֊i[
    insAbstractNic = pminsNic;

    //ARPNXCX^X  Yamami?? ARPIPNX̓CX^XׂH
    //2004/09/04 ARPNX́Amones.cpp(C)ŃCX^XAO[o|C^ŕێB
    //g_MoArp = new MoArp();
    //g_MoArp->initArp(insAbstractNic);

    return;
}


/*!
    \brief initialize
         MoEther fXNgN^
    \author Yamami
    \date   create:2004/08/12 update:
*/
MoEther::~MoEther() 
{
    delete Ether_FrameList_;
}


/*!
    \brief setEtherFrame
         C[Tlbgt[Zbg
    \param  byte* frameBuf [in] C[Tlbgt[obt@ւ̃|C^
    \param  byte *mac [in] C[Tlbgt[TCY
    \return int  
        
    \author Yamami
    \date   create:2004/08/12 update:
*/
int MoEther::setEtherFrame(byte *frameBuf, int size)
{
    
    // allocate ETHER_FRAME
    ETHER_FRAME* frame = (ETHER_FRAME*)malloc(sizeof(ETHER_FRAME));
    // t[̃Rs[
    memcpy(frame , frameBuf , size);

    //ŁApPbg[eBeBNXgāAGfBAϊ
    //t[^Cv
    frame->type = MoPacUtl::packet_get_2byte(frameBuf , 12);
    
    //Xgɒǉ
    Ether_FrameList_->add(frame);

    return 0;

}


/*!
    \brief getEtherFrame
         C[Tlbgt[擾 
    \param  byte* frameBuf [in] C[Tlbgt[obt@ւ̃|C^
    \return int  
        
    \author Yamami
    \date   create:2004/08/12 update:
*/
int MoEther::getEtherFrame(ETHER_FRAME *frameBuf)
//int MoEther::getEtherFrame()
{
    

    ETHER_FRAME* tempEther = Ether_FrameList_->removeAt(Ether_FrameList_->size() - 1);

    if (tempEther == NULL) {
        printf("tmp Null!!\n");
        return 0;
    }

    /* copy to keyinfo */
    memcpy(frameBuf, tempEther, sizeof(ETHER_FRAME));
    
    free(tempEther);
    
    return 1;

}


/*!
    \brief receiveEther
         C[Tlbgt[M 
    \return int  
        
    \author Yamami
    \date   create:2004/08/22 update:
*/
int MoEther::receiveEther()
{
    int reti;
    
    // allocate ETHER_FRAME
    ETHER_FRAME* frame = (ETHER_FRAME*)malloc(sizeof(ETHER_FRAME));
    
    reti = getEtherFrame(frame);

    //YamamifobO
    //int i;
    //for(i=0;i<60;i++){
    //    printf("%d:%x ",i,frame->data[i]);
    //}
    //printf("\n");

    // t[evgRɓn
    switch(frame->type)
    {
        case ETHER_PROTO_IP:
            return g_MoIp->receiveIp((IP_HEADER*)frame->data);
            break;
        case ETHER_PROTO_ARP:
            return g_MoArp->receiveArp((ARP_HEADER*)frame->data);
            break;
            
    }
    
    return 0;
}


/*!
    \brief sendEther
         C[Tlbgt[M 
    \param  byte *pkt [in] MpPbgւ̃|C^
    \param  dword dest_ip [in] MIPAhX
    \param  dword size [in] MTCY
    \return int  
        
    \author Yamami
    \date   create:2004/08/28 update:
*/
void MoEther::sendEther(byte *pkt , dword dest_ip , dword size)
{

    //Yamami??  ḾAAvR[͂ MŃNXׂ͕H
    //byte   *mac;

    /* ARP e[u */
    //mac=arp_lookup(dest_ip);
    
    //M
    //frame_output( pkt, mac, size, ETHER_PROTO_IP );
}

