/*!
    \file   MoPacUtl.cpp
    \brief  Mona pPbg[eBeBNX

    Copyright (c) 2004 Yamami
    All rights reserved.
    License=MIT/X License

    \author  Yamami
    \version $Revision: 1.2 $
    \date   create:2004/08/18 update:$Date: 2004/09/20 15:29:03 $
*/

/*! \class MoPacUtl
 *  \brief Mona pPbg[eBeBNX
 */



#include "MoPacUtl.h"


/*!
    \brief initialize
         MoPacUtl RXgN^
    \author Yamami
    \date   create:2004/08/12 update:
*/
MoPacUtl::MoPacUtl()
{

}

/*!
    \brief initialize
         MoEther init
    \author Yamami
    \date   create:2004/08/12 update:
*/



/*!
    \brief initialize
         MoPacUtl fXNgN^
    \author Yamami
    \date   create:2004/08/12 update:
*/
MoPacUtl::~MoPacUtl() 
{

}


/*!
    \brief packet_get_4byte
         4oCgpPbg擾
         lbg[NGfBAϊ
    \param  byte *buf [in] Ώۃobt@
    \param  int offset [in] ΏۃItZbg
    \return dword 擾l
    
    \author Yamami
    \date   create:2004/08/18 update:
*/
dword MoPacUtl::packet_get_4byte(byte *buf, int offset)
{
    dword a, b, c;

    a = (dword)buf[offset++] << 24;
    b = (dword)buf[offset++] << 16;
    c = (dword)buf[offset++] << 8;

    return a | b | c | buf[offset];
}

/*!
    \brief packet_get_2byte
         2oCgpPbg擾
         lbg[NGfBAϊ
    \param  byte *buf [in] Ώۃobt@
    \param  int offset [in] ΏۃItZbg
    \return word 擾l
    
    \author Yamami
    \date   create:2004/08/18 update:
*/
word MoPacUtl::packet_get_2byte(byte *buf, dword offset)
{
    word a;

    a = buf[offset++] << 8;
    
    return a | buf[offset];
}


/*!
    \brief packet_put_4byte
         4oCgpPbgݒ
         lbg[NGfBAϊ
    \param  byte *buf [in] Ώۃobt@
    \param  int offset [in] ΏۃItZbg
    \param  idword [in] ݒl
    \return void 
    
    \author Yamami
    \date   create:2004/08/18 update:
*/
void MoPacUtl::packet_put_4byte(byte* buf, int offset, dword val)
{
    buf += offset;
    *buf++ = (val >> 24) & 0xff;
    *buf++ = (val >> 16) & 0xff;
    *buf++ = (val >>  8) & 0xff;
    *buf = val & 0xff;
}

/*!
    \brief packet_put_2byte
         2oCgpPbgݒ
         lbg[NGfBAϊ
    \param  byte *buf [in] Ώۃobt@
    \param  int offset [in] ΏۃItZbg
    \param  iword [in] ݒl
    \return void 
    
    \author Yamami
    \date   create:2004/08/18 update:
*/
void MoPacUtl::packet_put_2byte(byte* buf, int offset, word val)
{
    buf += offset;
    *buf++ = (val >> 8) & 0xff;
    *buf = val & 0xff;
}



/*!
    \brief calcCheckSum
         `FbNT֐
    \param  dword *data [in] `FbNΏ
    \param  int size [in] `FbNΏۃTCY
    \return word 
    
    \author Yamami
    \date   create:2004/09/20 update:
*/
word MoPacUtl::calcCheckSum(dword *data,int size)
{
    union{
        unsigned long long u64;
        dword            u32[2];
        word             u16[4];
    }sum;

    dword tmp;


    sum.u64=0;
    for(;size>=sizeof(dword);size-=sizeof(dword))
        sum.u64+=*data++;
    if(size>0)sum.u64+=*data&((1<<(size*8))-1);

    tmp=sum.u32[1];
    sum.u32[1]=0;
    sum.u64+=tmp;
    tmp=sum.u32[1];
    sum.u32[1]=0;
    sum.u32[0]+=tmp;

    tmp=sum.u16[1];
    sum.u16[1]=0;
    sum.u32[0]+=tmp;
    tmp=sum.u16[1];
    sum.u16[1]=0;
    sum.u16[0]+=tmp;

    return ~sum.u16[0];
}
