/*!
    \file  MoIcmp.h
    \brief ICMPvgRNX wb_

    Copyright (c) 2004 Yamami
    All rights reserved.
    License=MIT/X Licnese

    \author  Yamami 
    \version $Revision: 1.1 $
    \date   create:2004/09/20 update:$Date: 2004/09/20 15:29:03 $
*/
#ifndef _MONA_MOICMP_
#define _MONA_MOICMP_

#include <sys/types.h>
#include <sys/HashMap.h>
#include <monapi.h>

#include "MoPacUtl.h"
#include "MonesDefine.h"
#include "AbstractMonic.h"
#include "MoIp.h"

/*! 
 *  \struct ICMP_HEADER
 *  \brief ICMPwb_\
 */
typedef struct{
    unsigned char  type;        /* ICMP^CvB */
    unsigned char  code;        /* ICMPR[hB */
    unsigned short chksum;      /* `FbNTB */
    char           data[0];     /* f[^B */
}ICMP_HEADER;



/*!
    MoIcmp class
*/
class MoIcmp
{
    
  public:
    
    //RXgN^
    MoIcmp();
    ~MoIcmp();
    void initIp(AbstractMonic*);

    int receiveIcmp(IP_HEADER*);

  private:
    
    void transIcmp(dword , byte , byte , ICMP_HEADER*, int );
    //NIChCo
    AbstractMonic* insAbstractNic;

};

#endif
