/*!
    \file   MoIcmp.cpp
    \brief  ICMPvgRNX

    Copyright (c) 2004 Yamami
    All rights reserved.
    License=MIT/X License

    \author  Yamami
    \version $Revision: 1.4 $
    \date   create:2004/09/20 update:$Date: 2004/12/09 07:57:18 $
*/

/*! \class MoIcmp
 *  \brief ICMPvgRNX
 */



#include "MoIcmp.h"
#include "MonesConfig.h"
#include "MonesGlobal.h"

/*!
    \brief initialize
         MoIcmp RXgN^
    \author Yamami
    \date   create:2004/09/20 update:
*/
MoIcmp::MoIcmp()
{

}

/*!
    \brief initialize
         MoIcmp initIp
    \author Yamami
    \param  AbstractMonic *pminsNic [in] NICNXւ̃|C^
    \date   create:2004/09/20 update:
*/
void MoIcmp::initIp(AbstractMonic *pminsNic ) 
{
    //NICNXێ
    insAbstractNic = pminsNic;
    return;
}


/*!
    \brief initialize
         MoIcmp fXNgN^
    \author Yamami
    \date   create:2004/08/20 update:
*/
MoIcmp::~MoIcmp() 
{

}


/*!
    \brief receiveIcmp
         ICMPvgRM 
    \param  IP_HEADER *ipHead [in] IPwb_ւ̃|C^
    \return int  
        
    \author Yamami
    \date   create:2004/09/20 update:2004/09/20
*/
int MoIcmp::receiveIcmp(IP_HEADER *ipHead)
{
    
    int icmp_size;
    ICMP_HEADER *icmp;

    icmp=(ICMP_HEADER*)ipHead->data;

    icmp_size=MoPacUtl::swapShort(ipHead->len)-sizeof(IP_HEADER);

    /* `FbNT̊mFB */
    if(MoPacUtl::calcCheckSum((dword*)icmp,icmp_size)){
        return 0;
    }


    switch(icmp->type)
    {
        case ICMP_TYPE_ECHOREQ:
            transIcmp(ipHead->srcip,ICMP_TYPE_ECHOREP,0,icmp,icmp_size);
            break;
        case ICMP_TYPE_ECHOREP:
            saveRecv(ipHead,icmp_size+sizeof(IP_HEADER));
            break;
    }

    return 0;
}


/*!
    \brief transIcmp
         ICMPM 
    \param  word dstip [in] MIPAhX
    \param  byte type [in] ICMP^Cv
    \param  ICMP_HEADER *icmpHead [in] ICMPwb_ւ̃|C^
    \param  int size [in] pPbgTCY
    \return 
        
    \author Yamami
    \date   create:2004/09/20 update:2004/09/20
*/
void MoIcmp::transIcmp(dword dstip, byte type, byte code, ICMP_HEADER *icmpHead, int size)
{
    
    TRANS_BUF_INFO tbi;

    //ICMPwb_[̐ݒ
    icmpHead->type=type;
    icmpHead->code=code;
    icmpHead->chksum=0;
    icmpHead->chksum=MoPacUtl::calcCheckSum((dword*)icmpHead,size);

    //Mobt@e[u̐ݒ
    tbi.data[2]=NULL;
    tbi.size[2]=0;
    tbi.data[1]=(char*)icmpHead;
    tbi.size[1]=size;
    tbi.ipType=IPPROTO_ICMP;

    g_MoIp->transIp(&tbi,dstip,0,0);
}


/*!
    \brief saveRecv
         ICMPM 
    \param  IP_HEADER *ipHead [in] IPwb_
    \param  int size [in] pPbgTCY
    \return 
    \author Yamami
    \date   create:2004/09/20 update:2004/09/20
*/
void MoIcmp::saveRecv(IP_HEADER *ipHead, int size)
{
    MessageInfo info;
    MONES_IP_REGIST *regist;

//YamamifobO
printf("MoIcmp::saveRecv Call!!\n");

    //o^ĂvZXɒʒmB
    for (int i = 0; i < MonesRList->size() -1; i++) {
        regist = MonesRList->get(i);
        
        if(regist->ip == MoPacUtl::swapLong(ipHead->srcip) ){
            //o^ĂIPւ̃vCȂ΁AbZ[Wʒm
            // create message
            Message::create(&info, MSG_MONES_ICMP_NOTICE, 0, 0, 0, NULL);
            // send
            if (Message::send(regist->tid, &info)) {
                //printf("MoIcmp::saveRecv error\n");
            }
            break;
            
        }
    }
}
