/*!
    \file  AbstractMonic.cpp
    \brief NICNX

    Copyright (c) 2004 Yamami
    WITHOUT ANY WARRANTY

    \author  Yamami
    \version $Revision: 1.5 $
    \date   create:2004/09/04 update:$Date: 2004/11/23 14:29:04 $
*/


/*! \class AbstractMonic
 *  \brief NICNX
 */


#include "AbstractMonic.h"

/*!
    \brief AbstractMonic RXgN^

    \author Yamami
    \date   create:2004/09/04 update:
*/
AbstractMonic::AbstractMonic()
{
    //
}


/*!
    \brief AbstractMonic fXNgN^

    \author Yamami
    \date   create:2004/09/04 update:
*/
AbstractMonic::~AbstractMonic()
{
    //
}


/*!
    \brief disable netRecv interrupt

    \author Yamami
    \date   create:2004/08/08 update:
*/
void AbstractMonic::disableNetWork() 
{

    byte IrqMask;
    int  nicIrqNo;
    
    IrqMask = 0x00;
    
    //qNX̃Qb^[ŁAIRQ擾
    nicIrqNo = getNicIRQ();
    
    if(0 <= nicIrqNo && nicIrqNo <= 7){
        //IRQ͈̔͂A0`7ł
        //PIC-0}X^IMR(0x21)֊荞݃}XN
        IrqMask = 1 << (nicIrqNo - 0);
        outp8(0x21, (inp8(0x21) | IrqMask));
    }
    else if(8 <= nicIrqNo && nicIrqNo <= 15){
    
        //IRQ͈̔͂A8`15ł
        //PIC-1X[uIMR(0xA1)֊荞݃}XN
        IrqMask = 1 << (nicIrqNo - 8);
        outp8(0xA1, (inp8(0xA1) | IrqMask));
    
    }
    
}


/*!
    \brief enable netRecv interrupt

    \author Yamami
    \date   create:2004/08/08 update:
*/
void AbstractMonic::enableNetWork() 
{

    byte IrqMask;
    int  nicIrqNo;
    
    IrqMask = 0xFF;

    //qNX̃Qb^[ŁAIRQ擾
    nicIrqNo = getNicIRQ();

    if(0 <= nicIrqNo && nicIrqNo <= 7){
        //IRQ͈̔͂A0`7ł
        //PIC-0}X^IMR(0x21)֊荞݃}XN
        IrqMask = IrqMask ^ (1 << (nicIrqNo - 0));  //XOR Yrbĝ0ƂB
        outp8(0x21, (inp8(0x21) & IrqMask));
    }
    else if(8 <= nicIrqNo && nicIrqNo <= 15){
    
        //IRQ̃JXP[h}XN
        outp8(0x21, (inp8(0x21) & 0xFB)); /* IR2 cascade */
    
        //IRQ͈̔͂A8`15ł
        //PIC-1X[uIMR(0xA1)֊荞݃}XN
        IrqMask = IrqMask ^ (1 << (nicIrqNo - 8));  //XOR Yrbĝ0ƂB
        outp8(0xA1, (inp8(0xA1) & IrqMask));
    }
    
}
