/*
Copyright (c) 2004 bayside
All rights reserved.

Redistribution and use in source and binary forms, with or without
modification, are permitted provided that the following conditions
are met:
1. Redistributions of source code must retain the above copyright
   notice, this list of conditions and the following disclaimer.
2. Redistributions in binary form must reproduce the above copyright
   notice, this list of conditions and the following disclaimer in the
   documentation and/or other materials provided with the distribution.
3. The name of the author may not be used to endorse or promote products
   derived from this software without specific prior written permission.

THIS SOFTWARE IS PROVIDED BY THE AUTHOR ``AS IS'' AND ANY EXPRESS OR
IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT, INDIRECT,
INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT
NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
(INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
*/

#include <baygui.h>

static unsigned int versionIcon_palette[] = {
	0xff242224,
	0xff9c9a9c,
	0xffcccecc,
	0xffeceeec,
	0xffec7264,
	0xffc4c2c4,
	0xffdcdedc,
	0xfffcfefc,
};

static unsigned char versionIcon_data[] = {
	0x5,0x5,0x5,0x5,0x5,0x5,0x5,0x5,0x5,0x5,0x5,0x5,0x5,0x5,0x5,0x5,0x5,0x5,0x5,0x5,0x5,0x5,0x5,0x5,0x5,0x5,0x5,0x5,0x5,0x5,0x5,0x5,
	0x5,0x5,0x5,0x5,0x5,0x5,0x5,0x5,0x5,0x5,0x5,0x5,0x5,0x5,0x5,0x5,0x5,0x5,0x5,0x5,0x5,0x5,0x5,0x5,0x5,0x5,0x5,0x5,0x5,0x5,0x5,0x5,
	0x5,0x5,0x5,0x5,0x5,0x5,0x5,0x5,0x5,0x5,0x5,0x0,0x5,0x5,0x5,0x5,0x5,0x5,0x5,0x5,0x5,0x0,0x5,0x5,0x5,0x5,0x5,0x5,0x5,0x5,0x5,0x5,
	0x5,0x5,0x5,0x5,0x5,0x5,0x5,0x5,0x5,0x5,0x0,0x3,0x0,0x5,0x5,0x5,0x5,0x5,0x5,0x5,0x0,0x3,0x0,0x5,0x5,0x5,0x5,0x5,0x5,0x5,0x5,0x5,
	0x5,0x5,0x5,0x5,0x5,0x5,0x5,0x5,0x5,0x0,0x6,0x7,0x3,0x0,0x5,0x5,0x5,0x5,0x5,0x0,0x3,0x7,0x3,0x0,0x5,0x5,0x5,0x5,0x5,0x5,0x5,0x5,
	0x5,0x5,0x5,0x5,0x5,0x5,0x5,0x5,0x0,0x6,0x3,0x7,0x3,0x0,0x5,0x5,0x5,0x5,0x5,0x0,0x3,0x7,0x7,0x3,0x0,0x5,0x5,0x5,0x5,0x5,0x5,0x5,
	0x5,0x5,0x5,0x5,0x5,0x5,0x5,0x5,0x0,0x6,0x3,0x7,0x7,0x3,0x0,0x0,0x0,0x0,0x0,0x3,0x7,0x7,0x7,0x3,0x0,0x5,0x5,0x5,0x5,0x5,0x5,0x5,
	0x5,0x5,0x5,0x5,0x5,0x5,0x5,0x0,0x6,0x3,0x7,0x7,0x7,0x7,0x3,0x3,0x3,0x3,0x3,0x7,0x7,0x7,0x7,0x7,0x3,0x0,0x5,0x5,0x5,0x5,0x5,0x5,
	0x5,0x5,0x5,0x5,0x5,0x5,0x0,0x6,0x3,0x3,0x7,0x7,0x2,0x0,0x7,0x7,0x7,0x7,0x7,0x7,0x7,0x7,0x0,0x2,0x7,0x3,0x0,0x5,0x5,0x5,0x5,0x5,
	0x5,0x5,0x5,0x5,0x5,0x5,0x0,0x6,0x3,0x3,0x7,0x7,0x0,0x7,0x7,0x7,0x0,0x7,0x7,0x7,0x0,0x7,0x7,0x0,0x7,0x3,0x0,0x5,0x5,0x5,0x5,0x5,
	0x5,0x5,0x5,0x5,0x5,0x5,0x0,0x6,0x3,0x3,0x7,0x7,0x7,0x7,0x7,0x7,0x1,0x0,0x0,0x0,0x1,0x7,0x7,0x7,0x7,0x6,0x0,0x5,0x5,0x5,0x5,0x5,
	0x5,0x5,0x5,0x5,0x5,0x5,0x0,0x2,0x3,0x3,0x7,0x7,0x7,0x7,0x7,0x7,0x7,0x0,0x4,0x0,0x7,0x7,0x7,0x7,0x7,0x3,0x0,0x5,0x5,0x5,0x5,0x5,
	0x5,0x5,0x5,0x5,0x5,0x5,0x5,0x0,0x6,0x3,0x7,0x7,0x7,0x7,0x7,0x7,0x7,0x1,0x0,0x1,0x7,0x7,0x7,0x7,0x3,0x0,0x5,0x5,0x5,0x5,0x5,0x5,
	0x5,0x5,0x5,0x5,0x5,0x5,0x5,0x0,0x2,0x3,0x3,0x7,0x7,0x7,0x7,0x7,0x7,0x7,0x0,0x7,0x7,0x7,0x7,0x7,0x3,0x0,0x5,0x5,0x5,0x5,0x5,0x5,
	0x5,0x5,0x5,0x5,0x5,0x5,0x5,0x5,0x0,0x6,0x3,0x3,0x3,0x7,0x7,0x7,0x7,0x7,0x7,0x7,0x7,0x7,0x3,0x3,0x0,0x5,0x5,0x5,0x5,0x5,0x5,0x5,
	0x5,0x5,0x5,0x5,0x5,0x5,0x5,0x0,0x6,0x3,0x3,0x7,0x7,0x7,0x7,0x7,0x7,0x7,0x7,0x7,0x7,0x7,0x7,0x7,0x3,0x0,0x5,0x5,0x5,0x5,0x5,0x5,
	0x5,0x5,0x5,0x5,0x5,0x5,0x0,0x6,0x3,0x3,0x7,0x7,0x7,0x7,0x7,0x7,0x7,0x7,0x7,0x7,0x7,0x7,0x7,0x7,0x7,0x3,0x0,0x5,0x5,0x5,0x5,0x5,
	0x5,0x5,0x5,0x5,0x5,0x5,0x0,0x6,0x3,0x3,0x7,0x7,0x7,0x7,0x7,0x7,0x7,0x7,0x7,0x7,0x7,0x7,0x7,0x7,0x7,0x3,0x0,0x5,0x5,0x5,0x5,0x5,
	0x5,0x5,0x5,0x5,0x5,0x5,0x0,0x6,0x3,0x3,0x7,0x7,0x7,0x7,0x7,0x7,0x7,0x7,0x7,0x7,0x7,0x7,0x7,0x7,0x7,0x3,0x0,0x5,0x5,0x5,0x5,0x5,
	0x5,0x5,0x5,0x5,0x5,0x5,0x0,0x2,0x3,0x3,0x7,0x7,0x7,0x7,0x7,0x7,0x7,0x7,0x7,0x7,0x7,0x7,0x7,0x7,0x7,0x3,0x0,0x5,0x5,0x5,0x5,0x5,
	0x5,0x5,0x5,0x5,0x5,0x5,0x0,0x6,0x3,0x3,0x7,0x7,0x7,0x7,0x7,0x7,0x7,0x7,0x7,0x7,0x7,0x7,0x7,0x7,0x7,0x6,0x0,0x5,0x5,0x5,0x5,0x5,
	0x5,0x5,0x5,0x5,0x5,0x5,0x5,0x0,0x2,0x3,0x3,0x7,0x7,0x7,0x7,0x7,0x7,0x7,0x7,0x7,0x7,0x7,0x7,0x7,0x3,0x0,0x5,0x5,0x5,0x5,0x5,0x5,
	0x5,0x5,0x5,0x5,0x5,0x5,0x5,0x5,0x0,0x6,0x3,0x3,0x7,0x7,0x7,0x7,0x3,0x0,0x6,0x7,0x7,0x7,0x7,0x3,0x0,0x5,0x5,0x5,0x5,0x5,0x5,0x5,
	0x5,0x5,0x5,0x5,0x5,0x5,0x5,0x5,0x0,0x6,0x3,0x3,0x7,0x7,0x7,0x7,0x3,0x0,0x6,0x7,0x7,0x7,0x7,0x3,0x0,0x5,0x5,0x5,0x5,0x5,0x5,0x5,
	0x5,0x5,0x5,0x5,0x5,0x5,0x5,0x5,0x0,0x6,0x3,0x3,0x7,0x7,0x7,0x7,0x3,0x0,0x6,0x7,0x7,0x7,0x7,0x3,0x0,0x5,0x5,0x5,0x5,0x5,0x5,0x5,
	0x5,0x5,0x5,0x5,0x5,0x5,0x5,0x5,0x0,0x6,0x3,0x3,0x7,0x7,0x7,0x3,0x3,0x0,0x6,0x7,0x7,0x7,0x3,0x3,0x0,0x5,0x5,0x5,0x5,0x5,0x5,0x5,
	0x5,0x5,0x5,0x5,0x5,0x5,0x5,0x0,0x6,0x3,0x3,0x7,0x7,0x7,0x7,0x7,0x7,0x3,0x0,0x6,0x7,0x7,0x7,0x7,0x3,0x0,0x5,0x5,0x5,0x5,0x5,0x5,
	0x5,0x5,0x5,0x5,0x5,0x5,0x0,0x2,0x3,0x3,0x7,0x7,0x7,0x7,0x7,0x7,0x7,0x7,0x3,0x0,0x6,0x7,0x7,0x7,0x7,0x3,0x0,0x5,0x5,0x5,0x5,0x5,
	0x5,0x5,0x5,0x5,0x5,0x5,0x0,0x6,0x3,0x3,0x7,0x7,0x7,0x7,0x7,0x7,0x7,0x7,0x3,0x0,0x6,0x7,0x7,0x7,0x7,0x3,0x0,0x5,0x5,0x5,0x5,0x5,
	0x5,0x5,0x5,0x5,0x5,0x5,0x0,0x6,0x3,0x3,0x7,0x7,0x7,0x7,0x7,0x7,0x7,0x7,0x3,0x0,0x6,0x7,0x7,0x7,0x7,0x3,0x0,0x5,0x5,0x5,0x5,0x5,
	0x5,0x5,0x5,0x5,0x5,0x5,0x5,0x0,0x6,0x3,0x3,0x3,0x3,0x3,0x3,0x3,0x3,0x3,0x0,0x6,0x3,0x3,0x3,0x3,0x3,0x0,0x5,0x5,0x5,0x5,0x5,0x5,
	0x5,0x5,0x5,0x5,0x5,0x5,0x5,0x5,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x7,0x0,0x0,0x0,0x0,0x0,0x0,0x5,0x5,0x5,0x5,0x5,0x5,0x5,
};

class GVersion : public Window
{
public:
	GVersion::GVersion()
	{
		setRect((800 - 270 - 12) / 2, (600 - 150 - 28) / 2, 282, 178);
		setTitle("ﾊﾞｰｼﾞｮﾝ情報");
	}

	GVersion::~GVersion()
	{
	}

	void GVersion::onPaint(Graphics *g)
	{
		int i, j, psNum = 0;
		MemoryInfo meminfo;
		PsInfo psinfo;
		
		// バージョンアイコン
		for (i = 0; i < 32; i++) {
			for (j = 0; j < 32; j++) {
				g->drawPixel(12 + j, 7 + i, versionIcon_palette[versionIcon_data[i * 32 + j]]);
			}
		}

		// 全起動プロセス数
		syscall_get_memory_info(&meminfo);
		syscall_set_ps_dump();
		while (syscall_read_ps_dump(&psinfo) == 0) {
			psNum++;
		}
		
		char mesg1[64], mesg2[64], mesg3[64], mesg4[64];
		sprintf(mesg1, "%dKB", meminfo.totalMemoryL / 1024, mesg1);
		sprintf(mesg2, "%dKB", meminfo.freePageNum * meminfo.pageSize / 1024, mesg2);
		sprintf(mesg3, "%dKB", meminfo.totalPageNum * meminfo.pageSize / 1024, mesg3);
		sprintf(mesg4, "%d個", psNum);

		g->setColor(0,0,0);
		g->drawText(BAYGUI_VERSION, 50, 10);
		g->drawText("copyright (C) 2004, bayside", 50, 26);
		g->setColor(96,96,96);
		g->drawRect(10,50,250,90);
		g->drawText("シェル 32bit / カーネル 32bit", 15, 55);
		g->drawText("全物理メモリ", 15, 71);
		g->drawText("有効ページプール", 15, 87);
		g->drawText("全ページプール", 15, 103);
		g->drawText("全起動プロセス数", 15, 119);
		g->drawText(mesg1, 156, 71);
		g->drawText(mesg2, 156, 87);
		g->drawText(mesg3, 156, 103);
		g->drawText(mesg4, 156, 119);
	}
};

/** メイン */
int MonaMain(List<char*>* pekoe)
{
	GVersion *version = new GVersion();
	version->run();
	return 0;
}
