#!/bin/bash
# copy Make One Linux to Linux File System
# Written by Keicho Kondo 2006.06.09
# Contact: dgel@users.sourceforge.jp
# License GPL

# ChangeLog
# 2007-06-18 Keicho Kondo
# - Bugfix (compressed image cannot be copyed)
# 2007-06-10 Keicho Kondo
# - Fix for Make One Linux 0.7.0
# 2006-04-03 Keicho Kondo
# - Modify install2win.bat for Linux System.

CDROM="${0%/*}"
MOLDIR="/mol"

# get information from Make One Linux System
MOLFLAG="${CDROM}/boot/livecd.sgn"
[ -f "${MOLFLAG}" ] && . ${MOLFLAG}
if [ -n "${MOL_VERSION}" ]; then
	MOL_VERSION="mol-${MOL_VERSION}"
else
	MOL_VERSION="mol-$(date +%Y%m%d)"
fi

# set kernel and initrd information
KERNEL="/boot/vmlinuz-${MOL_VERSION}"
INITRD="/boot/initrd-${MOL_VERSION}.img"
if [ -f "${KERNEL}" ]; then
	mv -f "${KERNEL}" "${KERNEL}.bak"
	rm -f "${KERNEL}"
fi
if [ -f "${INITRD}" ]; then
	mv -f "${INITRD}" "${INITRD}.bak"
	rm -f "${INITRD}"
fi

[ -d "${MOLDIR}" ] || mkdir ${MOLDIR}

#install -m 644 ${CDROM}/mol/* ${MOLDIR}/
for f in $(find ${CDROM}/mol); do
	if [ -z "$f" ] || [ "$f" == "${CDROM}/mol" ]; then
		continue
	elif [ -d "$f" ]; then
		install -d -m 755 ${MOLDIR}/${f#${CDROM}/mol/}
	elif [ -f "$f" ]; then
		install -m 644 $f ${MOLDIR}/${f#${CDROM}/mol/}
	fi
done
install -m 644 ${CDROM}/boot/isolinux/vmlinuz ${KERNEL}
install -m 644 ${CDROM}/boot/isolinux/initrd.img ${INITRD}
install -m 755 ${CDROM}/boot/grub/*.sh ${MOLDIR}/
install -m 644 ${CDROM}/boot/livecd.sgn /boot/

#
# install Make One Linux to linux boot loader
#
${MOLDIR}/setup.sh
