#!/bin/bash
# copy Make One Linux to Linux File System
# Written by Keicho Kondo 2006.04.03
# Contact: dgel@users.sourceforge.jp
# License GPL

# ChangeLog
# 2006-04-03 Keicho Kondo
# - Modify install2win.bat for Linux System.

CDROM="${0%/*}"
MOLDIR="/MOL"

# get information from Make One Linux System
MOLFLAG="${CDROM}/MOL/MOLFLAG"
if [ -f "${MOLFLAG}" ]
then
	. ${MOLFLAG}
else
	MOLVERSION="x.x.x"
	KERNEL_RELEASE="mol-${MOLVERSION}"
fi

# set kernel and initrd information
KERNEL="/boot/vmlinuz-${KERNEL_RELEASE}"
INITRD="/boot/initrd-mol-${MOLVERSION}.img"
if [ -f "${KERNEL}" ]
then
	mv -f "${KERNEL}" "${KERNEL}.bak"
	rm -f "${KERNEL}"
fi
if [ -f "${INITRD}" ]
then
	mv -f "${INITRD}" "${INITRD}.bak"
	rm -f "${INITRD}"
fi

[ -d "${MOLDIR}" ] || mkdir ${MOLDIR}

install -m 644 ${CDROM}/MOL/* ${MOLDIR}/
install -m 644 ${CDROM}/boot/isolinux/vmlinuz ${KERNEL}
install -m 644 ${CDROM}/boot/isolinux/initrd.img ${INITRD}
install -m 755 ${CDROM}/boot/grub/*.sh ${MOLDIR}/

#
# install Make One Linux to linux boot loader
#
${MOLDIR}/setup.sh
