%define name        squashfs
%define version     2.2
%define origrelease r2
%define release     %{origrelease}mol4.rhel4
%define kernel      %(uname -r)

Summary:     Squashfs is a compressed read-only file system.
Summary(ja): Squashfsは読み取り専用圧縮ファイルシステムです。
Name:        %{name}
Version:     %{version}
Release:     %{release}
Source0:     %{name}%{version}-%{origrelease}.tar.gz
Source1:     select-patch
Source2:     mkkmodule.conf
License:     GNU GPL version2
Group:       System Environment/Kernel
Packager:    Keicho Kondo <dgel@users.sourceforge.jp>
Vendor:      Make One Linux Project
BuildRoot:   %{_tmppath}/%{name}-%{version}-root

%description
squashfs is a compressed read-only file system.
This program contains 2 packages.
    squashfs-tools
    squashfs-module

%description -l ja
squashfsは読み取り専用ファイルシステムです。
このプログラムには下記の２つのパッケージが含まれています。
    squashfs-tools
    squashfs-module

%prep
rm -rf ${RPM_BUILD_ROOT}
%setup -n %{name}%{version}-%{origrelease}
. %{_sourcedir}/select-patch
cp -a %{_sourcedir}/mkkmodule.conf ./linux-${KVERSION}/mkkmodule.conf

%build
. %{_sourcedir}/select-patch
pushd squashfs-tools
make
strip mksquashfs
popd
pushd ./linux-${KVERSION}
mkkmodule
popd

%install
. %{_sourcedir}/select-patch
install -m 0755 -D squashfs-tools/mksquashfs ${RPM_BUILD_ROOT}/usr/bin/mksquashfs
install -m 0644 -D linux-${KVERSION}/squashfs.ko ${RPM_BUILD_ROOT}/lib/modules/%{kernel}/kernel/fs/squashfs/squashfs.ko
touch ${RPM_BUILD_ROOT}/lib/modules/%{kernel}/kernel/fs/squashfs/squashfs.ko

%clean
rm -rf ${RPM_BUILD_ROOT}

%changelog
* Fri Mar 24 2006 Keicho Kondo <dgel@users.sourceforge.jp> 2.2-r2mol4.rhel4
- added suffix, rhel4.
* Wed Mar 08 2006 Keicho Kondo <dgel@users.sourceforge.jp>
- fixed bug (select-patch and mkkmodule.conf file does not exist).
* Tue Jan 10 2006 Keicho Kondo <dgel@users.sourceforge.jp> 2.2-r2mol3
- modified dgel to Keicho Kondo.
* Sun Jan 08 2006 Keicho Kondo <dgel@users.sourceforge.jp>
- modified dgel's mail address
* Sun Jan 01 2006 Keicho Kondo <dgel@users.sourceforge.jp> 2.2-r2mol2
- initial build for Make One Linux

#-----------------------------------------------------------------------

%package tools
Summary:     Create a squashfs images
Summary(ja): squashfsイメージファイルを作成する
Group:       System Environment/Kernel

%description tools
squashfs-tools is a program for creating squashfs images.

%description tools -l ja
squashfs-toolsはsquashfsイメージファイルを作成するためのプログラムです。

%files tools
%defattr(-,root,root)
%doc CHANGES ACKNOWLEDGEMENTS COPYING README README-2.0 README-2.1 README-AMD64 PERFORMANCE.README INSTALL
/usr/bin/mksquashfs

%changelog tools
* Fri Mar 24 2006 Keicho Kondo <dgel@users.sourceforge.jp> 2.2-r2mol4.rhel4
- added suffix, rhel4.
* Sun Jan 08 2006 Keicho Kondo <dgel@users.sourceforge.jp> 2.2-r2mol3
- modified dgel's mail address
* Sun Jan 01 2006 Keicho Kondo <dgel@users.sourceforge.jp> 2.2-r2mol2
- initial build for Make One Linux
* Sat Nov 19 2005 Keicho Kondo <dgel@users.sourceforge.jp> 2.2-r2mol1
- renamed package
- use mkkmodule.sh, not mkkernelmodule.sh
* Mon Nov 7 2005 Keicho Kondo <dgel@users.sourceforge.jp> 2.2-r2mod2
- add BuildPrereq tag
* Sat Oct 8 2005 Keicho Kondo <dgel@users.sourceforge.jp> 2.2-r2mod1
- update to 2.2-r2
* Mon Jun 13 2005 Keicho Kondo <dgel@users.sourceforge.jp> 2.1-r2mod2
- recompile for CentOS 4.1
* Sun Jun 5 2005 Keicho Kondo <dgel@users.sourceforge.jp> 2.1-r2mod1
- initial build for Make One Disk

#-----------------------------------------------------------------------

%package module-%{kernel}
Summary:     Squashfs Kernel Module
Summary(ja): Squashfsカーネルモジュール
Group:       System Environment/Kernel
BuildPrereq: mkkmodule

%description module-%{kernel}
squashfs-module is a kernel module which provides squashfs support.

%description module-%{kernel} -l ja
squashfs-moduleはsquashfsファイルシステムをサポートするカーネルモジュールです。

%post module-%{kernel}
if [ -f /boot/System.map-%{kernel} ]; then
        /sbin/depmod -a -F /boot/System.map-%{kernel} %{kernel} || :
else
        /sbin/depmod -a || :
fi

%postun module-%{kernel}
if [ -f /boot/System.map-%{uname} ]; then
        /sbin/depmod -a -F /boot/System.map-%{kernel} %{kernel} || :
else
        /sbin/depmod -a || :
fi

%files module-%{kernel}
%defattr(-,root,root)
/lib/modules/%{kernel}/kernel/fs/squashfs/squashfs.ko

%changelog module-%{kernel}
* Fri Mar 24 2006 Keicho Kondo <dgel@users.sourceforge.jp> 2.2-r2mol4.rhel4
- added suffix, rhel4.
* Sun Jan 08 2006 Keicho Kondo <dgel@users.sourceforge.jp> 2.2-r2mol3
- modified dgel's mail address
* Sun Jan 01 2006 Keicho Kondo <dgel@users.sourceforge.jp> 2.2-r2mol2
- initial build for Make One Linux
* Fri Nov 18 2005 Keicho Kondo <dgel@users.sourceforge.jp> 2.2-r2mol1
- renamed package
* Mon Nov 7 2005 Keicho Kondo <dgel@users.sourceforge.jp> 2.2-r2mod2
- add BuildPrereq tag
* Sat Oct 8 2005 Keicho Kondo <dgel@users.sourceforge.jp> 2.2-r2mod1
- Initial build for Make One Disk

