%define name        mkkmodule
%define version     0.1.5
%define release     0mol1

Summary:     A software for making kernel modules.
Summary(ja): カーネルモジュール作成ソフトウェア
Name:        %{name}
Version:     %{version}
Release:     %{release}
Source0:     %{name}-%{version}.tar.gz
License:     GNU GPL version2
Group:       System Environment/Kernel
Packager:    Keicho Kondo <dgel@users.sourceforge.jp>
Vendor:      Make One Linux Project
BuildRoot:   %{_tmppath}/%{name}-%{version}-root
BuildArch:   noarch

%description
mkkmodule is a program for making kernel modules from your linux kernel source tree.

%description -l ja
mkkmoduleは現在起動しているLinuxカーネル用のモジュールを作成するためのプログラムです。
カーネル全体を再構築する必要はありません。
一般ユーザでも作成が可能です（インストールにはroot権限が必要です）。

%prep
rm -rf ${RPM_BUILD_ROOT}
%setup -n %{name}-%{version}
%configure

%build
make

%install
%makeinstall

%clean
rm -rf ${RPM_BUILD_ROOT}

%files
%defattr(-,root,root)
%doc AUTHORS README README.jp COPYING ChangeLog NEWS
%config /etc/%{name}/mkkmodule.conf.template
%config /etc/%{name}/sample/mkkmodule.conf.ntfs
%config /etc/%{name}/sample/mkkmodule.conf.reiserfs
%config /etc/%{name}/sample/mkkmodule.conf.squashfs
/usr/bin/mkkmodule

%changelog
* Tue Aug 22 2006 Keicho Kondo <dgel@users.sourceforge.jp> 0.1.5-0mol1
- removed mkrpmdir.sh.
* Wed May 03 2006 Keicho Kondo <dgel@users.sourceforge.jp> 0.1.4-0mol1
- update to 0.1.4.
- added modpost creating section for newer kernel Makefiles in mkkmodule.
- modified make prepare-all section in mkkmodule.
- modified getkernelsource function to use recursive call.
- modified chkkernelsource function to get return code.
* Fri Mar 24 2006 Keicho Kondo <dgel@users.sourceforge.jp> 0.1.3-0mol1
- update to 0.1.3.
- added English document.
- added .jp suffix to Japanese document.
* Tue Jan 10 2006 Keicho Kondo <dgel@users.sourceforge.jp> 0.1.2-0mol1
- modified dgel to Keicho Kondo.
* Sun Jan 08 2006 Keicho Kondo <dgel@users.sourceforge.jp>
- modified Keicho's mail address
* Sun Jan 01 2006 Keicho Kondo <dgel@users.sourceforge.jp> 0.1.1-0mol1
- modified README and AUTHORS about Linux-NTFS project's URL.
- fixed README about usage information.
* Sat Dec 10 2005 Keicho Kondo <dgel@users.sourceforge.jp> 0.1.1-mol1
- renamed configuration files, kernel-module to mkkmodule.
- added AUTHORS.
* Sat Nov 19 2005 Keicho Kondo <dgel@users.sourceforge.jp>
- renamed package
- added ChangeLog NEWS
- fixed mkkmodule.sh output clearer
- fixed mkrpmdir.sh
* Mon Nov 7 2005 Keicho Kondo <dgel@users.sourceforge.jp> 0.1-0mod2
- add BuildArch tag
* Wed Oct 5 2005 Keicho Kondo <dgel@users.sourceforge.jp> 0.1-0mod1
- initial build

