#!/exec/busybox-mol ash
#========================================================#
# Make One Linux General Startup Script 3                #
#  (C)2005-2006 Keicho Kondo <dgel@users.sourceforge.jp> #
#========================================================#
#


## === Setup Environment === ##
## Set some paths ##
looproot=/MOL/MOL           # Loopback image file
loopswap=/MOL/mol.swp       # Loopback swap file
moddir=/modules             # Kernel modules directory
sysdir=/MOL                 # Main system directory
MOLVERSION=/etc/mol/VERSION # MOL version number
IMAGEFLAG=/MOL/MOLFLAG      # Image system flag
RAWFLAG=$MOLVERSION         # Raw system flag
PATH="/exec:/sbin:/bin:/usr/sbin:/usr/bin:." # Command Search Path
export PATH

## Set color ##
RESET="]R"       # Reset fb color mode
CRE="
[K"       # Erase to end of line
CLEAR="c"        # Clear and reset Screen
NORMAL="[0;39m"  # Normal Color
RED="[1;31m"     # Failure or error message
GREEN="[1;32m"   # Success message
YELLOW="[1;33m"  # Descriptions
BLUE="[1;34m"    # System message
MAGENTA="[1;35m" # Found devices or drivers
CYAN="[1;36m"    # Questions
WHITE="[1;37m"   # Hint

## Set alias for busybox ##
alias '['='busybox-mol ['
alias 'ash'='busybox-mol ash'
alias 'cat'='busybox-mol cat'
alias 'cp'='busybox-mol cp'
alias 'chroot'='busybox-mol chroot'
alias 'echo'='busybox-mol echo'
alias 'insmod'='busybox-mol insmod'
alias 'losetup'='busybox-mol losetup'
alias 'mkdir'='busybox-mol mkdir'
alias 'mount'='busybox-mol mount'
alias 'pivot_root'='busybox-mol pivot_root'
#alias 'rm'='busybox-mol rm'
alias 'rmdir'='busybox-mol rmdir'
alias 'rmmod'='busybox-mol rmmod'
alias 'sh'='busybox-mol sh'
alias 'test'='busybox-mol test'
alias 'umount'='busybox-mol umount'

## Set functions ##
# Mount Function
pmount()
{
	BUILTIN_FS="iso9660 ext3 vfat ntfs ext2 reiserfs"
	for fs in ${BUILTIN_FS}
	do
		if [ -b "$1" ] && mount -t $fs $3 $1 $2 >/dev/null 2>&1
		then
			FOUND_FS="$fs"
			return 0
		fi
	done
	echo "mount fail"
	return 1
}

# Check Boot Parameter
checkbootparam()
{
	case "$CMDLINE" in
		*\ $1*) return 0 ;;
		$1*)    return 0 ;;
	esac
	return 1
}

# Check Module to Load
chkinsmod()
{
	if [ -f "$1" ]
	then
		insmod "$*" >/dev/null 2>&1
	fi
}

# Fix Broken Links
fixlink()
{
	## Example ##
	# relivelink /MOL+/var/lib/xkb /MOL/usr/X11R6/lib/X11/xkb/compiled
	# /MOL+/usr/X11R6/lib/X11/xkb/compiled -> /MOL+/var/lib/xkb

	## Argument ##
	SOURCE="$1"
	DEST="$2"

	## Environment ##
	# INITDIR is a directory in which we start making symlinks.
	INITDIR="$3"
	# RWDIR is a writable directory.
	RWDIR="/MOL+"
	# RODIR is a read-only directory.
	RODIR="${sysdir}"
	
	## Error ##
	if [ -z "${SOURCE}" -o -z "${DEST}" -o -z "${INITDIR}" ] || [ -n "$4" ]
	then
		echo "Usage: relivelink source destination initdir"
		return 1
	elif [ ! -e "${SOURCE}" ]
	then
		echo "Cannot find ${SOURCE}"
		return 1
	elif [ ! -e "${DEST}" ]
	then
		echo "Cannot find ${DEST}"
		return 1
	fi
	
	## Initialize ##
	DEST="${DEST#${RODIR}${INITDIR}}"
	
	## Start ##
	cd "${RWDIR}${INITDIR}"
	CURRENT_SOURCE="${RODIR}${INITDIR}"
	ln -sn ${CURRENT_SOURCE}/* . >/dev/null 2>&1
	
	for current in $(echo "${DEST}" | sed -e 's@/@ @g')
	do
		# for target
		if [ "${current}" = "${DEST##*/}" ]
		then
			rm -rf "${current}"
			ln -s "${SOURCE}" "${current}"
			break
		# for not exist
		elif [ ! -e "${current}" ]
		then
			mkdir -p "${RWDIR}${INITDIR}${DEST}"
		# for symlink
		elif [ -L "${current}" ]
		then
			rm -f "${current}"
			mkdir -p "${RWDIR}${INITDIR}${DEST}"
		# for directory
		elif [ -d "${current}" ]
		then :
		# else
		else
			echo "Bad Destination. failed!"
			return 1
		fi
		cd "${current}"
		CURRENT_SOURCE="${CURRENT_SOURCE}/${current}"
		ln -sn ${CURRENT_SOURCE}/* . >/dev/null 2>&1
	done
}

# Ask user for modules
askmodules()
{
	TYPE="$1"; shift
	echo "${BLUE}${TYPE} modules available:${WHITE}"
	FLAG=""
	for m in "$@"
	do
		if [ -f "${moddir}/scsi/$m" ]
		then
			[ -z "$FLAG" ] && { echo -n "	$m"; FLAG="on"; } || { echo "		$m"; FLAG=""; }
		fi
	done
	[ -n "$FLAG" ] && echo
	echo "${CYAN}Load ${TYPE} Modules?${NORMAL}"
	echo "${CYAN}[Enter full filename(s) (space-separated), Return for autoprobe, ${WHITE}n${CYAN} for none] ${NORMAL}"
	echo -n "${CYAN}insmod module(s)> ${NORMAL}"
	read MODULES
	case "$MODULES" in n|N) MODULES=""; ;; y|"") MODULES="$*"; ;; esac
}

# Try to load the given modules (full path or current directory)
loadmodules()
{
	TYPE="$1"; shift
	[ -n "$INTERACTIVE" ] && echo "6" > /proc/sys/kernel/printk
	for i in "$@"
	do
		echo -n "${CRE}${BLUE}Probing ${TYPE}... ${MAGENTA}$i${NORMAL}"
		if [ -f "${moddir}/scsi/$i" ] && insmod -f ${moddir}/scsi/$i >/dev/null 2>&1
		then
			case "$TYPE" in scsi|SCSI) FOUND_SCSI="yes"; ;; esac
		fi
	done
	[ -n "$INTERACTIVE" ] && echo "0" > /proc/sys/kernel/printk
	echo -n "${CRE}"
}

# Mount modules disk
mountmodules()
{
	TYPE="$1"; shift
	echo -n "${CRE}${CYAN}Please insert ${TYPE} modules disk and hit Return. ${NORMAL}"
	read a
	echo -n "${CRE}${BLUE}Mounting ${TYPE} modules disk... ${NORMAL}"
	if pmount /dev/fd0 ${moddir}/scsi "-o ro"
	then
		echo "${GREEN}OK.${NORMAL}"
		return 0
	fi
	echo "${RED}NOT FOUND.${NORMAL}"
	return 1
}

# Unmount modules disk
umountmodules()
{
	TYPE="$1"; shift
	echo -n "${CRE}${BLUE}Unmounting ${TYPE} modules disk... ${NORMAL}"
	umount ${moddir}/scsi 2>/dev/null
	echo "${GREEN}DONE.${NORMAL}"
}

# Emergency Shell
startash()
{
	echo "${CRE}${RED}Can't find ${MAGENTA}Make One Linux System${RED}, sorry.${NORMAL}"
	echo "${RED}Dropping you to a (very limited) shell.${NORMAL}"
	echo "${RED}Press reset button to quit.${NORMAL}"
	echo

	PS1=" mod # "
	export PS1
	echo "6" > /proc/sys/kernel/printk
	trap 1 2 3 15

	exec /exec/busybox ash
}


## === Pre-Mount === ##
## Exec some necessary commands ##
trap "" 1 2 3 15                      # Don't allow interrupt signals
exec >/dev/console </dev/console 2>&1 # Clean I/O
umask 0022                            # Set permittion mask
echo
echo "${RED}Make ${CYAN}One ${MAGENTA}Linux ${WHITE}Start ${YELLOW}!!${NORMAL}"
mount -t proc /proc /proc             # Mount process filesystem
echo "0" >/proc/sys/kernel/printk     # Disable kernel messages

## Check boot command line ##
echo "${BLUE}Checking Boot Command Line${NORMAL}"
CMDLINE="$(cat /proc/cmdline)"
# "boot=" contains "romode", "rwmode", or "overlay".
if checkbootparam "boot="       ; then MODE="$boot"     ; fi
#if checkbootparam "boot=romode" ; then boot="-o ro"     ; fi
#if checkbootparam "boot=rwmode" ; then RWMODE="yes"     ; fi
#if checkbootparam "boot=overlay"; then OVERLAY="yes"    ; fi
if checkbootparam "rwdevice="   ; then RWSYS_DEV="$rwdevice"; fi
if checkbootparam "image="      ; then looproot="$image"; fi
# "home=" option contains "skel" or "myconf".
if checkbootparam "home="       ; then HOME="$home"     ; fi
if checkbootparam "from="       ; then BOOTFROM="$from" ; fi
if checkbootparam "expert"      ; then INTERACTIVE="yes"; :>/interactive; fi
if checkbootparam "addmodules"  ; then ADDMODULES="yes" ; fi
if checkbootparam "noscsi"      ; then NOSCSI="yes"     ; fi
if checkbootparam "nousb"       ; then NOUSB2="yes"     ; fi
if checkbootparam "nofirewire"  ; then NOFIREWIRE="yes" ; fi
if checkbootparam "noraid"      ; then NORAID="yes"     ; fi
if checkbootparam "nodma"       ; then NODMA="yes"      ; fi
if checkbootparam "toram="      ; then COPYTO="yes"     ; COPYTORAM="$toram"; fi
if checkbootparam "tohd="       ; then COPYTO="yes"     ; COPYTOHD="$tohd"  ; fi


## Load kernel modules ##
echo "${BLUE}Loading Modules${NORMAL}"
# for scsi
chkinsmod ${moddir}/scsi/scsi_mod.*o
chkinsmod ${moddir}/cdrom.*o
chkinsmod ${moddir}/scsi/sr_mod.*.o
# for usb storage
chkinsmod ${moddir}/usbcore.*o
[ -z "${NOUSB2}" ] && chkinsmod ${moddir}/ehci-hcd.*o
chkinsmod ${moddir}/uhci-hcd.*o
chkinsmod ${moddir}/ohci-hcd.*o
chkinsmod ${moddir}/storage/usb-storage.*o
chkinsmod ${moddir}/storage/sd_mod.*o
# for usb keyboard
chkinsmod ${moddir}/usbhid.*o
# for loop
chkinsmod ${moddir}/loop.*o
# for cdrom
chkinsmod ${moddir}/ide-cd.*o
chkinsmod ${moddir}/isofs.*o
# for native language support
chkinsmod ${moddir}/nls_cp437.*o
chkinsmod ${moddir}/nls_utf8.*o
# for some filesystems
chkinsmod ${moddir}/fat.*o
chkinsmod ${moddir}/vfat.*o
chkinsmod ${moddir}/ntfs.*o
chkinsmod ${moddir}/jbd.*o
chkinsmod ${moddir}/ext3.*o
chkinsmod ${moddir}/reiserfs.*o

# Check for SCSI
if [ -z "$NOSCSI" ]
then
	if [ -n "$INTERACTIVE" ]; then
		# Let the user select interactively
		askmodules SCSI $(cd ${moddir}/scsi; echo *.*o)
	else
		# Trying to do kind of /proc/pci hardware detection
		PROCPCI="`cat /proc/pci 2>/dev/null`"
		ISA_SCSI="aha1740.*o aha1542.*o aha152x.*o pas16.*o psi240i.*o qlogicfas.*o qlogicfc.*o seagate.*o t128.*o u14-34f.*o wd7000.*o"
		SCSI_PROBE="$ISA_SCSI"
		case "$PROCPCI" in *[Aa][Ii][Cc]-|*[Aa][Hh][Aa]-*) SCSI_PROBE="$SCSI_PROBE aic7xxx.*o" ;; esac
		case "$PROCPCI" in *[Bb][Uu][Ss][Ll][Oo][Gg][Ii][Cc]*) SCSI_PROBE="$SCSI_PROBE BusLogic.*o" ;; esac
		case "$PROCPCI" in *53[Cc]8*) SCSI_PROBE="$SCSI_PROBE ncr53c8xx.*o" ;; esac
		case "$PROCPCI" in *53[Cc]406*) SCSI_PROBE="$SCSI_PROBE NCR53c406a.*o" ;; esac
		case "$PROCPCI" in *[Ii][Nn][Ii][Tt][Ii][Oo]\ *|*[Ii][Nn][Ii]-[Aa]100[Uu]2[Ww]*) SCSI_PROBE="$SCSI_PROBE initio.*o" ;; esac
		case "$PROCPCI" in *[Mm][Pp][Tt]*[Ss][Cc][Ss][Ii]*) SCSI_PROBE="$SCSI_PROBE mptscsih.*o" ;; esac
		case "$PROCPCI" in *[Aa][Dd][Vv][Aa][Nn][Cc][Ee][Dd]\ [Ss][Yy][Ss]*) SCSI_PROBE="$SCSI_PROBE advansys.*o" ;; esac
		case "$PROCPCI" in *[Aa][Tt][Pp]8|*[Aa][Ee][Cc]6*) SCSI_PROBE="$SCSI_PROBE atp870u.*o" ;; esac
		case "$PROCPCI" in *[Dd][Tt][Cc]*) SCSI_PROBE="$SCSI_PROBE dtc.*o" ;; esac
		case "$PROCPCI" in *[Ee][Aa][Tt][Aa]*) SCSI_PROBE="$SCSI_PROBE eata.*o" ;; esac
		case "$PROCPCI" in *[Ff]*[Dd][Oo][Mm][Aa][Ii][Nn]*) SCSI_PROBE="$SCSI_PROBE fdomain.*o" ;; esac
		case "$PROCPCI" in *[Gg][Dd][Tt]\ *) SCSI_PROBE="$SCSI_PROBE gdth.*o" ;; esac
		case "$PROCPCI" in *[Mm][Ee][Gg][Aa][Rr][Aa][Ii][Dd]*) SCSI_PROBE="$SCSI_PROBE megaraid.*o" ;; esac
		case "$PROCPCI" in *[Pp][Cc][Ii]-22*) SCSI_PROBE="$SCSI_PROBE pci2220i.*o" ;; esac
		case "$PROCPCI" in *[Pp][Cc][Ii]-2000*) SCSI_PROBE="$SCSI_PROBE pci2000.*o" ;; esac
		case "$PROCPCI" in *[Qq][Ll][Oo][Gg][Ii][Cc]*) SCSI_PROBE="$SCSI_PROBE qlogicisp.*o" ;; esac
		case "$PROCPCI" in *53[Cc]974*) SCSI_PROBE="$SCSI_PROBE tmscsim.*o" ;; esac
		case "$PROCPCI" in *[Uu][Ll][Tt][Rr][Aa][Ss][Tt][Oo][Rr]*) SCSI_PROBE="$SCSI_PROBE ultrastor.*o" ;; esac
		case "$PROCPCI" in *3[Ww][Aa][Rr][Ee]*) SCSI_PROBE="$SCSI_PROBE 3w-xxxx.*o" ;; esac
		# these are the autoprobe-safe modules
		MODULES="$SCSI_PROBE"
	fi
	echo -n "${CRE}${BLUE}Loading SCSI Device...${NORMAL}"
	[ -n "$MODULES" ] && loadmodules SCSI $MODULES
	echo -n "${CRE}"
fi

# Check for IDE-Raid devices
if [ -z "$NORAID" ]
then
	echo -n "${CRE}${BLUE}Checking for RAID...${NORMAL}"
	FLAG=""
	[ -z "$FLAG" ] && chkinsmod ${moddir}/scsi/ataraid.*o && chkinsmod ${moddir}/scsi/silraid.*o && FLAG="on"
	[ -z "$FLAG" ] && chkinsmod ${moddir}/scsi/medley.*o  && FLAG="on"
	[ -z "$FLAG" ] && chkinsmod ${moddir}/scsi/pdcraid.*o
	unset FLAG
	echo -n "${CRE}"
fi

# Check for Firewire
if [ -z "$NOFIREWIRE" ]
then
	echo -n "${CRE}${BLUE}Checking for Firewire...${NORMAL}"
	FLAG=""
	[ -z "$FLAG" ] && chkinsmod ${moddir}/storage/ieee1394.*o || FLAG="on"
	[ -z "$FLAG" ] && chkinsmod ${moddir}/storage/ohci1394.*o || FLAG="on"
	[ -z "$FLAG" ] && chkinsmod ${moddir}/storage/sbp2.*o sbp2_serialize_io=1
	unset FLAG
	echo -n "${CRE}"
fi

# Check for Additional Modules
if [ -n "$ADDMODULES" ]
then
	chkinsmod ${moddir}/add/*.*o
fi

# Check for misc modules in expert mode
if [ -n "$INTERACTIVE" ]
then
	another=""
	answer=""
	while [ "$answer" != "n" -a "$answer" != "N" ]
	do
		echo -n "${CYAN}Do you want to load additional modules from $another floppy disk? [${WHITE}Y${CYAN}/n] ${NORMAL}"
		another="another"
		read answer
		case "$answer" in n*|N*) break; ;; esac
		if mountmodules new; then
			askmodules new $(cd ${moddir}/scsi; echo *.*o)
			[ -n "$MODULES" ] && loadmodules new $MODULES
			umountmodules current
		fi
	done
fi

## Enable or Disable DMA ##
for d in $(cd /proc/ide 2>/dev/null && echo hd[a-z]); do
	if [ -d "/proc/ide/$d" ]; then
		MODEL="$(cat /proc/ide/$d/model 2>/dev/null)"
		[ -z "$MODEL" ] && MODEL="[GENERIC IDE DEVICE]"
		if [ -z "$NODMA" ]; then
			echo "${BLUE}Enabling DMA acceleration for: ${MAGENTA}$d 	${YELLOW}[${MODEL}]${NORMAL}"
			echo "using_dma:1" >/proc/ide/$d/settings
		else
			echo "${BLUE}Disabling DMA acceleration for: ${MAGENTA}$d 	${YELLOW}[${MODEL}]${NORMAL}"
			echo "using_dma:0" >/proc/ide/$d/settings
		fi
	fi
done

## Mount Start ##
echo "${BLUE}Mounting Make One Linux System${NORMAL}"


## === Setup Mother System === ##
## Set device special files ##
loop0=/dev/loop0
loop1=/dev/loop1
if [ -z "$BOOTFROM" ]
then
	DEVICES="/dev/hd? /dev/pcd?"
	[ -f "/proc/scsi/scsi" ] && FOUND_SCSI="yes"
	[ -n "$FOUND_SCSI" ] && DEVICES="/dev/scd? /dev/scd?? $DEVICES"
	[ -n "$FOUND_SCSI" -a -z "$NOSCSI" ] && DEVICES="$DEVICES /dev/sd?[1-9] /dev/sd?[1-9][0-9]"
	DEVICES="$DEVICES /dev/ub?[1-9] /dev/ub?[1-9][0-9] /dev/hd?[1-9] /dev/hd?[1-9][0-9]"
else
	DEVICES="$BOOTFROM"
fi

## Search Mother System ##
# mount mother system
for i in $DEVICES
do
	echo -n "${CRE}${BLUE}Looking for CD/DVD Meida in: ${MAGENTA}$i${NORMAL}   "
	if pmount "$i" /sysroot "-o ro" >/dev/null 2>&1
	then
		# for Boot from Raw File System
		if [ -f "/sysroot${RAWFLAG}" ]
		then
			echo -n "${CRE} ${GREEN}Accessing Make One Linux Raw Filesystem at ${MAGENTA}$i${GREEN}...${NORMAL}"
			break
		fi
		# for Boot from Image File System
		if [ -f "/sysroot${IMAGEFLAG}" ]
		then
			echo -n "${CRE} ${GREEN}Accessing Make One Linux Image Filesystem at ${MAGENTA}$i${GREEN}...${NORMAL}"
			break
		fi
		umount /sysroot
	fi
done
MOTHER_DEV="$i"
MOTHER_FS="${FOUND_FS}"

# for toram/tohd options
if [ -n "${COPYTO}" ]
then
	echo
	echo -n "${CRE} ${GREEN}Copying SYSTEM to "

	mkdir /system
	umount /sysroot
	pmount "${MOTHER_DEV}" /system "-o ro" >/dev/null 2>&1
	FLAG=""
	# for toram
	if [ -n "${COPYTORAM}" ]
	then
		echo -n "${MAGENTA}ramdisk${GREEN}... Please be patient.${NORMAL}"
		mount -t tmpfs -o size="${COPYTORAM}" /dev/shm /sysroot >/dev/null 2>&1 || FLAG="on"
		MOTHER_DEV="/dev/shm"
		MOTHER_FS="tmpfs"
	# for tohd
	elif [ -n "${COPYTOHD}" ]
	then
		echo -n "${MAGENTA}${COPYTOHD}${GREEN}... Please be patient.${NORMAL}"
		pmount "${COPYTOHD}" /sysroot "-o rw" >/dev/null 2>&1 || FLAG="on"
		MOTHER_DEV="${COPYTOHD}"
		MOTHER_FS="${FOUND_FS}"
	fi
	# mount copyto device?
	if [ -z "${FLAG}" ]
	then
		cp -a /system/.[^.]* /sysroot/ >/dev/null 2>&1
		cp -a /system/* /sysroot/ >/dev/null 2>&1
		mount -o remount,ro "${MOTHER_DEV}" /sysroot >/dev/null 2>&1
	else
		echo "${CRE} ${RED}Copying failed. ${MOTHER_DEV} is not mountable. ${NORMAL}"
		echo
		startash
	fi
	unset FLAG
	umount /system
	rmdir /system
fi

## fstab and mtab for Mother System ##
if [ "${MODE}" = "rwmode" ]
then
	# remount mother system for writable
	mount -o remount,rw "${MOTHER_DEV}" /sysroot
	echo -e "${MOTHER_DEV}\t\t\t/sysroot\t\t${MOTHER_FS}\t\tdefaults\t\t\t0 0" >> /etc/fstab.in
	echo "${MOTHER_DEV} /sysroot ${MOTHER_FS} rw 0 0" >> /etc/mtab.in
else
	echo -e "${MOTHER_DEV}\t\t\t/sysroot\t\t${MOTHER_FS}\t\tro\t\t\t\t0 0" >> /etc/fstab.in
	echo "${MOTHER_DEV} /sysroot ${MOTHER_FS} ro 0 0" >> /etc/mtab.in
fi


## === Setup Main System === ##
## RAW Filesystem Mode ##
if [ -f "/sysroot${RAWFLAG}" ]
then
	for i in bin boot lib opt sbin srv usr; do
		/sysroot/lib/ld-linux.so.2 --library-path /sysroot/lib /sysroot/bin/rm -rf /$i
		/sysroot/lib/ld-linux.so.2 --library-path /sysroot/lib /sysroot/bin/ln -snf /sysroot/$i /$i
	done
	rmdir ${sysdir}
	ln -s /sysroot "${sysdir}"
	sysdir="/sysroot"
	MAINSYS_FS="$MOTHER_FS"
	MAINSYS_DEV="$MOTHER_DEV"

## Image Filesystem Mode ##
elif [ -f "/sysroot${IMAGEFLAG}" ]
then
	FLAG=""
	MAINSYS_DEV="${loop0}"
	# for squashfs
	if [ -z "${FLAG}" ]
	then
		chkinsmod "${moddir}"/squashfs.*o
		losetup "${loop0}" /sysroot${looproot} >/dev/null 2>&1
		mount -t squashfs -o ro "${loop0}" "${sysdir}" >/dev/null 2>&1 && FLAG="on"
		MAINSYS_FS="squashfs"
	fi
	# for cloop
	if [ -z "${FLAG}" ]
	then
    	echo "6" > /proc/sys/kernel/printk
		THREAD="clp_thread=1"
		for i in $CMDLINE; do
			case "$i" in chkblk=*|CHKBLK=*) eval $i;; esac
			[ -n "$chkblk" ] && CHKBLK="$chkblk";
			case "$i" in *noclpthread*|*NOCLPTHREAD*) THREAD="" ;; esac
		done
		RBLKS=""
		[ -n "$CHKBLK" ] && RBLKS="rblks=$chkblk"
		chkinsmod -f "${moddir}"/cloop.*o "$RBLKS" "$THREAD" file="/sysroot${looproot}"
		losetup "${loop0}" /sysroot${looproot} >/dev/null 2>&1
    	echo "0" > /proc/sys/kernel/printk
		mount -t cloop -o ro "${loop0}" "${sysdir}" >/dev/null 2>&1 && FLAG="on"
		MAINSYS_FS="cloop"
	fi
	# for another image
	if [ -z "${FLAG}" ]
	then
		losetup "${loop0}" /sysroot${looproot} >/dev/null 2>&1
		pmount "${loop0}" "${sysdir}" "-o ro" >/dev/null 2>&1 && FLAG="on"
		[ "${MODE}" = "rwmode" ] && mount -o remount,rw "${loop0}" "${sysdir}"
		MAINSYS_FS="$FOUND_FS"
	fi
	# found image?
	if [ -z "${FLAG}" ]
	then
		echo "${CRE}${RED}<< Mount Failed !! >>${NORMAL}"
		echo
		startash
	fi

	## fstab and mtab for Main System ##
	if [ "${MODE}" = "rwmode" ]
	then
		echo -e "${MAINSYS_DEV}\t\t\t/MOL\t\t\t${MAINSYS_FS}\t\tdefaults\t\t\t0 0" >> /etc/fstab.in
		echo "${MAINSYS_DEV} /MOL ${MAINSYS_FS} rw 0 0" >> /etc/mtab.in
	else
		echo -e "${MAINSYS_DEV}\t\t\t/MOL\t\t\t${MAINSYS_FS}\t\tro\t\t\t\t0 0" >> /etc/fstab.in
		echo "${MAINSYS_DEV} /MOL ${MAINSYS_FS} ro 0 0" >> /etc/mtab.in
	fi

## Cannot Mount Main System ##
else
	echo "${CRE}${RED}<< Mount Failed !! >>${NORMAL}"
	echo
	startash
fi


## === Post-Mount === ##
## Copy library cache ##
cat ${sysdir}/etc/ld.so.cache > /etc/ld.so.cache

## Enable kernel messages ##
echo
echo "6" > /proc/sys/kernel/printk

## Set unalias for busybox ##
unalias '['
unalias 'ash'
unalias 'cat'
unalias 'cp'
unalias 'chroot'
unalias 'echo'
unalias 'insmod'
unalias 'losetup'
unalias 'mkdir'
unalias 'mount'
unalias 'pivot_root'
#unalias 'rm'
unalias 'rmdir'
unalias 'rmmod'
unalias 'sh'
unalias 'test'
unalias 'umount'


## === Setup Writable System === ##
FLAG=""
## for Writable Device ##
if [ -z "${FLAG}" ]
then
	if pmount "${RWSYS_DEV}" /MOL+ "-o rw" >/dev/null 2>&1
	then
		FLAG="on"
		RWSYS_FS="$FOUND_FS"
		echo "${CRE}${BLUE}Created ${YELLOW}/MOL+ ${BLUE}on ${MAGENTA}${RWSYS_FS} writable device${NORMAL}"
	fi
fi

## for Writable Image File ##
if [ -z "${FLAG}" -a "${MODE}" = "rwmode" ]
then
	RWSYS_DEV="/sysroot${RWSYS_DEV}"
	if pmount "${RWSYS_DEV}" /MOL+ "-o loop,rw" >/dev/null 2>&1
	then
		FLAG="on"
		RWSYS_FS="$FOUND_FS"
		echo "${CRE}${BLUE}Created ${YELLOW}/MOL+ ${BLUE}on ${MAGENTA}${RWSYS_FS} writable image file${NORMAL}"
	fi
fi

## for RAMDISK ##
if [ -z "${FLAG}" ]
then
	#/bin/mount --move /ramdisk /MOL+ >/dev/null 2>&1 && FLAG="ramdisk"
	# memory information
	FOUNDMEM="$(awk '/MemTotal/{print $2}' /proc/meminfo)"
	TOTALMEM="$(awk 'BEGIN{m=0};/MemFree|Cached/{m+=$2};END{print m}' /proc/meminfo)"
	echo "${CRE}${BLUE}Total memory found: ${YELLOW}${FOUNDMEM} ${BLUE}KB${NORMAL}"
	
	# calc ram size
	MINSIZE=2000  # Minimum size of additional ram  partitions
	MINLEFT=16000 # At least this much memory minus 30% should remain when home and var are full.
	MAXSIZE="$(expr $TOTALMEM - $MINLEFT)" # Maximum ramdisk size
	RAMSIZE="$(expr $TOTALMEM / 5)"        # Default ramdisk size
	
	# create ramdisk
	if [ -n "$TOTALMEM" -a "$TOTALMEM" -gt "$MINLEFT" ]
	then
		[ -z "$RAMSIZE" ] && RAMSIZE=100000
		RAMSIZE=$(expr $RAMSIZE \* 4)
		echo -n "${CRE}${BLUE}Creating ${YELLOW}/MOL+ ${BLUE}(dynamic size=${YELLOW}${RAMSIZE}${BLUE}kb) on ${MAGENTA}shared memory${BLUE}...${NORMAL}"
		/bin/mount -t tmpfs -o "size=${RAMSIZE}k" /dev/shm /MOL+
		RWSYS_DEV="/dev/shm"
		RWSYS_FS="tmpfs"
		echo "${BLUE}Done.${NORMAL}"
	elif [ -z "$TOTALMEM" ]
	then
		echo "${CRE}${RED}<< Can't Get Memory Information. Failed !! >>${NORMAL}"
		echo
		echo "${CRE}${CYAN}Please hit Return to start ash.${NORMAL}"
		read a
		startash
	else
		echo "${CRE}${RED}<< Your Computer does NOT have enough Memory Size. Failed !! >>${NORMAL}"
		echo
		echo "${CRE}  Detected Memory Size : ${TOTALMEM}kb"
		echo "${CRE}  Required Memory Size : ${MINLEFT}kb"
		echo
		echo "${CRE}${CYAN}Please hit Return to start ash.${NORMAL}"
		read a
		startash
	fi
fi
unset FLAG
chmod 1755 /MOL+ # for sendmail

## fstab and mtab for Writable System ##
echo -e "${RWSYS_DEV}\t\t\t/MOL+\t\t\t${RWSYS_FS}\t\tdefaults\t\t\t0 0" >> /etc/fstab.in
grep "/MOL+" /etc/mtab >> /etc/mtab.in


## === Setup Overlaying System === ##
if [ "${MODE}" = "overlay" ]
then
	echo "${BLUE}Setup Overlaying System${NORMAL}"
	mkdir /UNIONFS
	modprobe unionfs
	/bin/mount -t unionfs -o dirs=/MOL+=rw:"${sysdir}"=ro none /UNIONFS

	echo -e "none\t\t\t\t/UNIONFS\t\tunionfs\t\tdefaults\t\t\t0 0" >> /etc/fstab.in
	echo "none /UNIONFS unionfs rw,dirs=/MOL+=rw:${sysdir}=ro,debug=0,err=tryleft,delete=all,copyup=preserve,setattr=left 0 0" >> /etc/mtab.in

	# creating some directories which was removed when MOL system created
	mkdir -p /UNIONFS/tmp /UNIONFS/var/tmp
	ln -snf ../var/tmp /UNIONFS/usr/tmp
	# change original files to this
	cp -a /etc/rc.d/rc.sysinit /UNIONFS/etc/rc.d/
	cp -a /etc/rc.d/init.d/halt /UNIONFS/etc/rc.d/init.d/
	cp -a /etc/rc.d/init.d/netfs /UNIONFS/etc/rc.d/init.d/
	cp -a /etc/fstab /UNIONFS/etc/
	cp -a /etc/mtab /UNIONFS/etc/
	# change original file to this after finishing linuxrc script
	cp -a /etc/X11/xorg.conf.in /UNIONFS/etc/X11/
	cp -a /etc/modprobe.conf.in /UNIONFS/etc/
	cp -a /etc/fstab.in /UNIONFS/etc/
	cp -a /etc/mtab.in /UNIONFS/etc/

	# move directories to unionfs
	for i in bin boot etc home lib opt root sbin srv tmp usr var; do
		rm -rf /$i
		/MOL/lib/ld-linux.so.2 --library-path /MOL/lib /MOL/bin/ln -snf /UNIONFS/$i /$i
	done

	chmod 1777 /tmp /var/tmp
	chmod 0755 /etc/sysconfig
	chmod 1755 /UNIONFS # for sendmail
	:> /var/run/utmp
	:> /var/run/wtmp


## === Setup Raw/Image System === ##
else
	[ -f "/sysroot${RAWFLAG}" ]   && echo "${BLUE}Setup Raw System${NORMAL}"
	[ -f "/sysroot${IMAGEFLAG}" ] && echo "${BLUE}Setup Image System${NORMAL}"
	## /home and /root ##
	echo -n "${CRE}${BLUE}Creating ${YELLOW}/home ${BLUE}and ${YELLOW}/root ${BLUE}directories...${NORMAL}"
	for u in $(echo ${sysdir}/home/* ${sysdir}/home/.[^.]* ${sysdir}/root)
	do
		u="${u#${sysdir}}"
		if grep "$u" /etc/passwd >/dev/null 2>&1
		then
			USER_D=$(grep "$u" /etc/passwd | head -n 1 | cut -d: -f1 2>/dev/null)
			GROUP_D=$(id -gn ${USER_D} 2>/dev/null)
			mkdir -p -m 0700 /MOL+$u
			case "$u" in */root) chmod 0750 /MOL+$u ;; esac
			if [ "${HOME}" = "skel" ]
			then
				cp -a ${sysdir}/etc/skel/.[^.]* /MOL+$u/ 2>/dev/null
			elif [ "${HOME}" = "myconf" ]
			then
				cp -a ${sysdir}$u/.[^.]* /MOL+$u/ 2>/dev/null
			else
				cp -a ${sysdir}$u/.[^.]* /MOL+$u/ 2>/dev/null
				cp -a ${sysdir}$u/*      /MOL+$u/ 2>/dev/null
			fi
			chown -Rf ${USER_D}:${GROUP_D} /MOL+$u
		else
			ln -s ${sysdir}$u /MOL+$u
		fi
	done
	ln -s /MOL+/home /
	ln -s /MOL+/root /
	echo "${BLUE}Done.${NORMAL}"


	## /var and /etc ##
	echo -n "${CRE}${BLUE}Creating ${YELLOW}/etc ${BLUE}and ${YELLOW}/var ${BLUE}directories...${NORMAL}"
	# move /etc and /var to writable system
	mv /etc /MOL+/
	mkdir -p /MOL+/var
	ln -s /MOL+/etc /
	ln -s /MOL+/var /
	# create writable dirs
	mkdir -p /MOL+/etc/cups
	mkdir -p /MOL+/etc/X11
	mkdir -p /MOL+/var/lib
	mkdir -p /MOL+/var/lock
	mkdir -p /MOL+/var/log/audit
	mkdir -p /MOL+/var/mail
	mkdir -p /MOL+/var/nis
	mkdir -p /MOL+/var/preserve
	mkdir -p /MOL+/var/run
	mkdir -p /MOL+/var/tmp
	mkdir -p /MOL+/var/opt
	mkdir -p /MOL+/var/spool/cups/tmp
	chmod 1777 /MOL+/var/tmp
	chmod 1770 /MOL+/var/spool/cups/tmp
	# copy writable files and dirs
	cp -a ${sysdir}/etc/cups/*.conf  /MOL+/etc/cups/ 2>/dev/null
	cp -a ${sysdir}/etc/adjtime      /MOL+/etc/ 2>/dev/null
	cp -a ${sysdir}/etc/asound.state /MOL+/etc/ 2>/dev/null
	cp -a ${sysdir}/etc/audit.rules  /MOL+/etc/ 2>/dev/null
	cp -a ${sysdir}/etc/exports      /MOL+/etc/ 2>/dev/null
	cp -a ${sysdir}/etc/group        /MOL+/etc/ 2>/dev/null
	cp -a ${sysdir}/etc/gshadow      /MOL+/etc/ 2>/dev/null
	cp -a ${sysdir}/etc/passwd       /MOL+/etc/ 2>/dev/null
	cp -a ${sysdir}/etc/resolv.conf  /MOL+/etc/ 2>/dev/null
	cp -a ${sysdir}/etc/shadow       /MOL+/etc/ 2>/dev/null
	cp -a ${sysdir}/etc/alternatives /MOL+/etc/ 2>/dev/null
	cp -a ${sysdir}/etc/ppp          /MOL+/etc/ 2>/dev/null
	cp -a ${sysdir}/etc/ssh          /MOL+/etc/ 2>/dev/null
	cp -a ${sysdir}/etc/sysconfig    /MOL+/etc/ 2>/dev/null
	cp -a ${sysdir}/var/opt/atokx2   /MOL+/var/opt/ 2>/dev/null
	cp -a ${sysdir}/var/local        /MOL+/var/ 2>/dev/null
	cp -a ${sysdir}/var/spool        /MOL+/var/ 2>/dev/null
	cp -a ${sysdir}/var/webmin       /MOL+/var/ 2>/dev/null
	cp -a ${sysdir}/var/lib/random-seed /MOL+/var/lib/ 2>/dev/null
	cp -a ${sysdir}/var/lib/xkb         /MOL+/var/lib/ 2>/dev/null
	cp -a ${sysdir}/var/lib/pcmcia      /MOL+/var/lib/ 2>/dev/null
	cp -a ${sysdir}/var/lib/dhcp*       /MOL+/var/lib/ 2>/dev/null
	cp -a ${sysdir}/var/lib/nfs         /MOL+/var/lib/ 2>/dev/null
	:> /MOL+/var/run/utmp
	:> /MOL+/var/run/wtmp
	# create links from cdrom for unwritable (remaining) files
	cp -aus ${sysdir}/etc/* /MOL+/etc/ 2>/dev/null
	cp -aus ${sysdir}/var/* /MOL+/var/ 2>/dev/null
	# fix broken links
	ln -snf ../../boot/grub/grub.conf /MOL+/etc/grub.conf 2>/dev/null
	ln -snf ../../../../sbin/ifup /MOL+/etc/sysconfig/network-scripts/ifup 2>/dev/null
	ln -snf ../../../../sbin/ifdown /MOL+/etc/sysconfig/network-scripts/ifdown 2>/dev/null
	# remove unnecessary files
	rm -f /MOL+/etc/passwd-
	rm -f /MOL+/etc/shadow-
	rm -f /MOL+/etc/group-
	rm -f /MOL+/etc/gshadow-
	rm -f /MOL+/etc/modprobe.conf
	rm -f /MOL+/etc/X11/XF86Config*
	rm -f /MOL+/etc/sysconfig/network-scripts/ifcfg-eth*
	rm -f /MOL+/etc/sysconfig/network-scripts/ifcfg-tr*
	rm -rf /MOL+/var/log/*
	echo "${BLUE}Done.${NORMAL}"

	## /tmp and /usr ##
	echo -n "${CRE}${BLUE}Creating ${YELLOW}/tmp ${BLUE}and ${YELLOW}/usr ${BLUE}directories...${NORMAL}"
	# /tmp
	mkdir -p -m 1777 /MOL+/tmp
	ln -snf /MOL+/tmp /
	# /usr
	mkdir -p /MOL+/usr
	for lnk in $(echo ${sysdir}/usr/*)
	do
		ln -snf "${lnk}" /MOL+/usr/
	done
	ln -snf /MOL+/var/tmp /MOL+/usr/tmp
	ln -snf /MOL+/usr /
	fixlink /MOL+/var/lib/xkb ${sysdir}/usr/X11R6/lib/X11/xkb/compiled /usr >/dev/null 2>&1
	echo "${BLUE}Done.${NORMAL}"
fi


## === Finish === ##
## now tell kernel where the real modprobe lives ##
echo "/sbin/modprobe" > /proc/sys/kernel/modprobe
## change root device from /dev/fd0 to /dev/ram0 ##
echo "0x100" > /proc/sys/kernel/real-root-dev
umount /proc
## stop kudzu to use auto configuration tools ##
chkconfig --level 0123456 kudzu off
echo "${CRE}${BLUE}Starting init process.${NORMAL}"
## give control to the init process ##
#rm -f /linuxrc
#rm -rf ${moddir} /exec
exit 0


