/*
 * Decompiled with CFR 0.152.
 */
package molden2molden;

import JGints.BasisFunction;
import JGints.MO;
import JGints.OverlapIntegrals;
import JGints.RadialPartOfBasisFunction;
import JGints.SphericalHarmonics;
import Polynom3D.Polynom3D;
import Polynom3D.YLM_Series;
import ProgramOptions.WarningManager;
import java.io.PrintStream;
import molden2molden.File47Import;
import molden2molden.m2mOptions;
import moldenio.MOLDEN_IO;

public class MoldenConvertor {
    PrintStream out = System.out;
    MOLDEN_IO molden_in = new MOLDEN_IO();
    MOLDEN_IO molden_out = null;
    m2mOptions options = new m2mOptions();

    private static int _Find_BS_with_Props(BasisFunction basisFunction, BasisFunction basisFunction2, int n, int n2, int n3, double d) {
        int n4 = 0;
        boolean bl = false;
        BasisFunction basisFunction3 = basisFunction;
        while (!bl && basisFunction3 != null) {
            boolean bl2 = false;
            if (basisFunction3.L == n && basisFunction3.Center_ID == basisFunction2.Center_ID && basisFunction3.coefs.length == basisFunction2.coefs.length && basisFunction3.additional_r_power == n3 && basisFunction3.exponents.length == basisFunction2.exponents.length) {
                bl2 = true;
                for (int i = 0; i < basisFunction3.coefs.length; ++i) {
                    bl2 &= Math.abs(basisFunction3.coefs[i] - basisFunction2.coefs[i]) <= d;
                    bl2 &= Math.abs(basisFunction3.exponents[i] - basisFunction2.exponents[i]) <= d;
                }
            }
            if (!(bl = bl2)) {
                n4 += 2 * basisFunction3.L + 1;
                basisFunction3 = basisFunction3._next;
                continue;
            }
            switch (n2) {
                case 0: {
                    return n4;
                }
                case 1: {
                    return n4 + 1;
                }
                case -1: {
                    return n4 + 2;
                }
                case 2: {
                    return n4 + 3;
                }
                case -2: {
                    return n4 + 4;
                }
                case 3: {
                    return n4 + 5;
                }
                case -3: {
                    return n4 + 6;
                }
                case 4: {
                    return n4 + 7;
                }
                case -4: {
                    return n4 + 8;
                }
            }
        }
        return -1;
    }

    public boolean CommandsCheck() {
        if (this.options.op_from_orca3_BF.get_boolean() && this.options.op_from_psi4b4_BF.get_boolean()) {
            WarningManager.warning_printf(" WARNING: using and -FromOrca3BF and -FromPsi4b4BF keys together might give senseless results!", new Object[0]);
        }
        if (this.options.op_to_orca3_BF.get_boolean() && this.options.op_to_psi4b4_BF.get_boolean()) {
            WarningManager.warning_printf(" WARNING: using and -ToOrca3BF and -ToPsi4b4BF keys together might give senseless results!", new Object[0]);
        }
        if (this.options.fname_in.get_String().isEmpty() && this.options.fname_in_BINAR.get_String().isEmpty()) {
            this.out.println("Cann't continue without an input file name!");
            return false;
        }
        if (this.options.fname_out.get_String().isEmpty() && this.options.fname_out_BINAR.get_String().isEmpty()) {
            this.out.println("Cann't continue without an output file name!");
            return false;
        }
        return true;
    }

    public boolean CONVERT() throws Exception {
        int n;
        int n2;
        int n3;
        File47Import file47Import;
        String string;
        boolean bl;
        boolean bl2 = false;
        if (!this.options.fname_in_BINAR.get_String().isEmpty()) {
            this.out.println(" Loading input molden from " + this.options.fname_in_BINAR.get_String() + " ...");
            bl2 = this.molden_in.Load_from_BMOLDEN(this.options.fname_in_BINAR.get_String());
        } else {
            this.out.println(" Loading input molden from " + this.options.fname_in.get_String() + " ...");
            bl2 = this.molden_in.Load_From_MOLDEN(this.options.fname_in.get_String());
        }
        if (!bl2) {
            this.out.println(" ERROR: Can not load data from " + this.options.fname_in.get_String());
            return false;
        }
        this.out.printf("Data loaded successfully.%n%n", new Object[0]);
        if (this.options.op_cart2spher.get_boolean() && this.molden_in.IsSpherical) {
            this.out.println(" ERROR: input molden file already uses pure spherical harmonics,");
            this.out.println("   -cart2spher key makes no sense and will be ignored!");
            this.options.op_cart2spher.set_data(false);
        }
        if (!this.options.op_coordsAngstroms.get_boolean() && !this.molden_in.Coords_in_AU) {
            this.out.println("Converting atomic coordinates from Angstroms to a.u. ...");
            this.molden_in.CoordsToAU();
        }
        if (this.options.op_coordsAngstroms.get_boolean() && this.molden_in.Coords_in_AU) {
            this.out.println("Converting atomic coordinates from a.u. to Angstroms ...");
            this.molden_in.CoordsToAngstroms();
        }
        Polynom3D[][] polynom3DArray = SphericalHarmonics.Get_Quick_YLM();
        boolean bl3 = bl = this.molden_in.HighestL > 4;
        if (bl) {
            WarningManager.warning_printf(" WARNING: input molden file contains %c-functions, which are not fully supported now! %n", Character.valueOf("spdfghijklmnopqr".charAt(this.molden_in.HighestL)));
        }
        if ((this.options.op_orca3signs.get_boolean() || this.options.op_from_orca3_BF.get_boolean() || this.options.op_to_orca3_BF.get_boolean()) && !this.molden_in.IsSpherical) {
            this.out.println(" ERROR: Orca is said to use pure spherical functions only, but the input molden file does not!");
            return false;
        }
        if (!this.options.File_GEOM47.get_String().isEmpty()) {
            string = this.options.File_GEOM47.get_String();
            this.out.println("Supressing geometry with the data from .47 file " + string);
            file47Import = new File47Import();
            file47Import.import_from_file(string);
            if (!file47Import.Insert_Geom_Into(this.molden_in)) {
                this.out.println("Error importing basis set data!");
                return false;
            }
        }
        if (!this.options.File_BS47.get_String().isEmpty()) {
            string = this.options.File_BS47.get_String();
            this.out.println("Supressing basis set with the data from .47 file " + string);
            file47Import = new File47Import();
            file47Import.import_from_file(string);
            if (!file47Import.Build_Basis_Set(this.molden_in)) {
                this.out.println("Error importing basis set data!");
                return false;
            }
        }
        if (!this.options.File_DS47.get_String().isEmpty()) {
            string = this.options.File_DS47.get_String();
            this.out.println("Supressing MO coefficients with the data from .47 file " + string);
            file47Import = new File47Import();
            file47Import.import_from_file(string);
            if (file47Import.nbas != this.molden_in.Basis.length) {
                this.out.printf("ERROR: the number of basis functions is different in %nthe input molden file and in the given .47 file", new Object[0]);
                return false;
            }
            if (!file47Import.Check_BF_order_and_create_remap(this.molden_in)) {
                this.out.println("ERROR: reordering of the .47 file basis set failed!");
                return false;
            }
            file47Import.Procude_NOs(this.molden_in);
        }
        double d = 0.0;
        double[] dArray = new double[]{1.0, 1.0, 3.0, 15.0, 35.0};
        if (this.options.op_from_orca3_BF.get_boolean() || this.options.op_from_psi4b4_BF.get_boolean()) {
            int n4;
            if (this.options.op_from_orca3_BF.get_boolean()) {
                this.out.println("Converting the basis set from the ORCA 3-style to a conventional MOLDEN style...");
            }
            if (this.options.op_from_psi4b4_BF.get_boolean()) {
                this.out.println("Converting the basis set from the PSI4.b4-style to a conventional MOLDEN style...");
            }
            for (n4 = 0; n4 < this.molden_in.RadialParts.length; ++n4) {
                int n5 = this.molden_in.RadialParts[n4].LUsedWith;
                n3 = 0;
                while (n3 < this.molden_in.RadialParts[n4].Coefs.length) {
                    d = OverlapIntegrals.primitive_int_1D_Sphr(2 * n5 + 2 + 2 * this.molden_in.RadialParts[n4].Addit_r_power, 2.0 * this.molden_in.RadialParts[n4].Exponents[n3]);
                    d *= Math.PI * 4;
                    d /= (double)(2 * n5 + 1);
                    if (this.options.op_from_orca3_BF.get_boolean()) {
                        d /= dArray[n5];
                    }
                    int n6 = n3++;
                    this.molden_in.RadialParts[n4].Coefs[n6] = this.molden_in.RadialParts[n4].Coefs[n6] * Math.sqrt(d);
                }
            }
            for (n4 = 0; n4 < this.molden_in.Basis.length; ++n4) {
                this.molden_in.Basis[n4].coefs = (double[])this.molden_in.RadialParts[this.molden_in.Basis[n4].RadialPart_ID].Coefs.clone();
            }
        }
        if ((this.options.op_from_psi4b4_BF.get_boolean() || this.options.op_from_psi4v1_MO.get_boolean()) && !this.molden_in.IsSpherical) {
            double[] dArray2 = SphericalHarmonics.molden_cart_norms2_over_4Pi();
            double[] dArray3 = new double[this.molden_in.Basis.length];
            for (n3 = 0; n3 < dArray3.length; ++n3) {
                dArray3[n3] = Math.sqrt(dArray2[this.molden_in.Basis[n3].m]) * Math.sqrt(2 * this.molden_in.Basis[n3].L + 1);
            }
            for (n3 = 0; n3 < this.molden_in.MOs.length; ++n3) {
                for (n2 = 0; n2 < dArray3.length; ++n2) {
                    int n7 = n2;
                    this.molden_in.MOs[n3].BS_Coefs[n7] = this.molden_in.MOs[n3].BS_Coefs[n7] * dArray3[n2];
                }
            }
        }
        if (this.options.op_orca3signs.get_boolean()) {
            this.out.println("Converting MO coefficients signs to make them compatible with a conventional MOLDEN spherical harmonics...");
            int n8 = 0;
            for (int i = 0; i < this.molden_in.Basis.length; ++i) {
                if (this.molden_in.Basis[i].L == 3) {
                    n8 += 2;
                }
                if (this.molden_in.Basis[i].L != 4) continue;
                n8 += 4;
            }
            int[] nArray = new int[n8];
            n3 = 0;
            for (n2 = 0; n2 < this.molden_in.Basis.length; ++n2) {
                if (this.molden_in.Basis[n2].L == 3 && this.molden_in.Basis[n2].m == -3) {
                    nArray[n3++] = n2;
                }
                if (this.molden_in.Basis[n2].L == 3 && this.molden_in.Basis[n2].m == 3) {
                    nArray[n3++] = n2;
                }
                if (this.molden_in.Basis[n2].L == 4 && this.molden_in.Basis[n2].m == -4) {
                    nArray[n3++] = n2;
                }
                if (this.molden_in.Basis[n2].L == 4 && this.molden_in.Basis[n2].m == 4) {
                    nArray[n3++] = n2;
                }
                if (this.molden_in.Basis[n2].L == 4 && this.molden_in.Basis[n2].m == -3) {
                    nArray[n3++] = n2;
                }
                if (this.molden_in.Basis[n2].L != 4 || this.molden_in.Basis[n2].m != 3) continue;
                nArray[n3++] = n2;
            }
            for (n2 = 0; n2 < this.molden_in.MOs.length; ++n2) {
                for (n3 = 0; n3 < nArray.length; ++n3) {
                    this.molden_in.MOs[n2].BS_Coefs[nArray[n3]] = -this.molden_in.MOs[n2].BS_Coefs[nArray[n3]];
                }
            }
        }
        if (this.options.op_normalizeBF.get_boolean()) {
            this.out.println("Forcing basis functions to be unity-normalized...");
            for (int i = 0; i < this.molden_in.RadialParts.length; ++i) {
                int n9;
                int n10 = this.molden_in.RadialParts[i].LUsedWith;
                n3 = this.molden_in.RadialParts[i].Coefs.length;
                double[] dArray4 = new double[n3];
                for (int j = 0; j < n3; ++j) {
                    dArray4[j] = OverlapIntegrals.primitive_int_1D_Sphr(2 * n10 + 2 + 2 * this.molden_in.RadialParts[i].Addit_r_power, 2.0 * this.molden_in.RadialParts[i].Exponents[j]);
                }
                double d2 = 0.0;
                for (n9 = 0; n9 < n3; ++n9) {
                    d2 += this.molden_in.RadialParts[i].Coefs[n9] * this.molden_in.RadialParts[i].Coefs[n9] / dArray4[n9] * OverlapIntegrals.primitive_int_1D_Sphr(2 * n10 + 2 + 2 * this.molden_in.RadialParts[i].Addit_r_power, 2.0 * this.molden_in.RadialParts[i].Exponents[n9]);
                    for (n = n9 + 1; n < n3; ++n) {
                        d2 += 2.0 * this.molden_in.RadialParts[i].Coefs[n9] / Math.sqrt(dArray4[n9]) * this.molden_in.RadialParts[i].Coefs[n] / Math.sqrt(dArray4[n]) * OverlapIntegrals.primitive_int_1D_Sphr(2 * n10 + 2 + 2 * this.molden_in.RadialParts[i].Addit_r_power, this.molden_in.RadialParts[i].Exponents[n9] + this.molden_in.RadialParts[i].Exponents[n]);
                    }
                }
                n9 = 0;
                while (n9 < this.molden_in.RadialParts[i].Coefs.length) {
                    int n11 = n9++;
                    this.molden_in.RadialParts[i].Coefs[n11] = this.molden_in.RadialParts[i].Coefs[n11] / Math.sqrt(d2);
                }
            }
        }
        if (this.options.op_cart2spher.get_boolean()) {
            int n12;
            int n13;
            int n14;
            this.molden_out = new MOLDEN_IO();
            this.molden_out.Allow_additional_r_power = true;
            this.molden_out.Centers = this.molden_in.Centers;
            this.molden_out.Coords_in_AU = this.molden_in.Coords_in_AU;
            this.molden_out.Title = " created by molden2molden from " + this.options.fname_in.get_String();
            YLM_Series[] yLM_SeriesArray = SphericalHarmonics.Cartesian_to_Pure();
            double[] dArray5 = SphericalHarmonics.molden_cart_norms2_over_4Pi();
            double[][] dArray6 = SphericalHarmonics.Get_Quick_YLM_Norm2(SphericalHarmonics.Get_Quick_YLM());
            for (int i = 0; i < yLM_SeriesArray.length; ++i) {
                int n15 = 0;
                while (n15 < yLM_SeriesArray[i].coefs.length) {
                    int n16 = n15;
                    yLM_SeriesArray[i].coefs[n16] = yLM_SeriesArray[i].coefs[n16] * Math.sqrt(dArray6[yLM_SeriesArray[i].Ls[n15]][yLM_SeriesArray[i].Ls[n15] + yLM_SeriesArray[i].Ms[n15]]);
                    int n17 = n15++;
                    yLM_SeriesArray[i].coefs[n17] = yLM_SeriesArray[i].coefs[n17] / Math.sqrt(dArray5[i]);
                }
            }
            int[][] nArrayArray = new int[this.molden_in.Basis.length][];
            double[][] dArrayArray = new double[this.molden_in.Basis.length][];
            for (int i = 0; i < this.molden_in.Basis.length; ++i) {
                nArrayArray[i] = new int[yLM_SeriesArray[this.molden_in.Basis[i].m].coefs.length];
                dArrayArray[i] = new double[yLM_SeriesArray[this.molden_in.Basis[i].m].coefs.length];
            }
            BasisFunction basisFunction = null;
            BasisFunction basisFunction2 = null;
            this.out.println("Creating a list of pure spherical harmonics...");
            n = 0;
            for (n14 = 0; n14 < this.molden_in.Basis.length; ++n14) {
                for (n13 = 0; n13 < yLM_SeriesArray[this.molden_in.Basis[n14].m].coefs.length; ++n13) {
                    boolean bl4;
                    int n18 = yLM_SeriesArray[this.molden_in.Basis[n14].m].Ls[n13];
                    n12 = this.molden_in.Basis[n14].L - n18 + this.molden_in.Basis[n14].additional_r_power;
                    int n19 = MoldenConvertor._Find_BS_with_Props(basisFunction, this.molden_in.Basis[n14], n18, yLM_SeriesArray[this.molden_in.Basis[n14].m].Ms[n13], n12, 0.0);
                    boolean bl5 = bl4 = n19 == -1;
                    if (n12 > 0 && this.options.IgnoreLowerLTerms.get_boolean()) {
                        bl4 = false;
                        ++n;
                    }
                    if (bl4) {
                        basisFunction2 = basisFunction == null ? (basisFunction = new BasisFunction(this.molden_in.Basis[n14])) : (basisFunction2._next = new BasisFunction(this.molden_in.Basis[n14]));
                        basisFunction2._next = null;
                        basisFunction2.L = n18;
                        basisFunction2.additional_r_power = n12;
                        n19 = MoldenConvertor._Find_BS_with_Props(basisFunction, this.molden_in.Basis[n14], n18, yLM_SeriesArray[this.molden_in.Basis[n14].m].Ms[n13], n12, 0.0);
                        if (n19 == -1) {
                            this.out.println("ERROR in creating basis function list: new function not found!");
                            return false;
                        }
                    }
                    nArrayArray[n14][n13] = n19;
                    dArrayArray[n14][n13] = yLM_SeriesArray[this.molden_in.Basis[n14].m].coefs[n13];
                }
            }
            n14 = 0;
            n13 = 0;
            BasisFunction basisFunction3 = basisFunction;
            if (basisFunction3 == null) {
                this.out.println("OOOPS! bf_first == null: no basis functions have been created...");
                return false;
            }
            while (basisFunction3 != null) {
                ++n14;
                n13 += 2 * basisFunction3.L + 1;
                basisFunction3 = basisFunction3._next;
            }
            this.out.printf("New number of basis functions: %4d, new number of radial parts: %4d%n", n13, n14);
            this.molden_out.RadialParts = new RadialPartOfBasisFunction[n14];
            basisFunction3 = basisFunction;
            for (n12 = 0; n12 < n14; ++n12) {
                this.molden_out.RadialParts[n12] = new RadialPartOfBasisFunction();
                this.molden_out.RadialParts[n12].CenterID = basisFunction3.Center_ID;
                this.molden_out.RadialParts[n12].LUsedWith = basisFunction3.L;
                this.molden_out.RadialParts[n12].Coefs = (double[])basisFunction3.coefs.clone();
                this.molden_out.RadialParts[n12].Exponents = (double[])basisFunction3.exponents.clone();
                this.molden_out.RadialParts[n12].Addit_r_power = basisFunction3.additional_r_power;
                basisFunction3 = basisFunction3._next;
            }
            this.molden_out.IsSpherical = true;
            this.out.println(" Transforming MO coefficients...");
            this.molden_out.MOs = new MO[this.molden_in.MOs.length];
            for (int i = 0; i < this.molden_out.MOs.length; ++i) {
                this.molden_out.MOs[i] = new MO(this.molden_in.MOs[i]);
                this.molden_out.MOs[i].BS_Coefs = null;
                this.molden_out.MOs[i].BS_Coefs = new double[n13];
                double d3 = 0.0;
                for (int j = 0; j < this.molden_in.Basis.length; ++j) {
                    for (int k = 0; k < nArrayArray[j].length; ++k) {
                        n12 = nArrayArray[j][k];
                        double d4 = dArrayArray[j][k] * this.molden_in.MOs[i].BS_Coefs[j];
                        if (n12 != -1) {
                            int n20 = n12;
                            this.molden_out.MOs[i].BS_Coefs[n20] = this.molden_out.MOs[i].BS_Coefs[n20] + d4;
                            continue;
                        }
                        if (!this.options.IgnoreLowerLTerms.get_boolean()) continue;
                        d3 += d4;
                    }
                }
                if (!(Math.abs(d3) > 1.0E-5)) continue;
                WarningManager.warning_printf("Warning: sum of ignored terms (~r^n with n>0) for MO %3d  %n   seems to be non-negligible (|sum| = %.3E)%n", i + 1, d3);
            }
            this.out.println(" Cartesian to pure transformation finished!");
            this.molden_in = this.molden_out;
        } else {
            this.molden_out = this.molden_in;
        }
        if (this.options.op_to_orca3_BF.get_boolean() || this.options.op_to_psi4b4_BF.get_boolean()) {
            if (this.options.op_to_orca3_BF.get_boolean()) {
                this.out.println("Converting the basis set from a conventional MOLDEN style to the ORCA 3-style...");
                if (!this.molden_in.IsSpherical) {
                    WarningManager.warning_printf(" WARNING: ORCA 3-style molden file with cartesian basis%n functions seems to be useless...", new Object[0]);
                }
            }
            if (this.options.op_to_psi4b4_BF.get_boolean()) {
                this.out.println("Converting the basis set from a conventional MOLDEN style to the PSI4.b4-style...");
                if (!this.molden_in.IsSpherical) {
                    this.out.println("Sorry, not implemented yet!");
                    return false;
                }
            }
            double[][] dArrayArray = new double[this.molden_in.HighestL + 1][];
            for (int i = 0; i <= this.molden_in.HighestL; ++i) {
                dArrayArray[i] = new double[2 * i + 1];
                double d5 = 1.0 / (double)(2 * i + 1);
                if (this.options.op_to_orca3_BF.get_boolean()) {
                    d5 /= dArray[i];
                }
                for (int j = -i; j <= i; ++j) {
                    dArrayArray[i][i + j] = d5;
                }
            }
            this.molden_in.UnNormalizePrimitives(dArrayArray);
            this.molden_out = this.molden_in;
        }
        this.out.print("Saving result as " + this.options.fname_out.get_String() + " ");
        boolean bl6 = false;
        if (!this.options.fname_out_BINAR.get_String().isEmpty()) {
            this.out.print(" (binary encoded)...");
            bl6 = this.molden_out.Save_as_BMOLDEN(this.options.fname_out_BINAR.get_String());
        } else {
            this.out.print(" (ascii encoded)...");
            bl6 = this.molden_out.Save_As_MOLDEN(this.options.fname_out.get_String());
        }
        if (!bl6) {
            this.out.println("ERROR saving file.");
            return false;
        }
        this.out.println("OK.");
        return true;
    }
}

