/*
 * Decompiled with CFR 0.152.
 */
package ProgramOptions;

import ProgramOptions.WarningManager;
import java.io.BufferedReader;
import java.io.PrintStream;

public class OptionParameter {
    private OptionParameter _next = null;
    private Object data;
    public String Name;
    public String Description;
    public static String default_double_format = " %.20E";
    public static String default_int_format = "%d";
    public PrintStream out = System.out;

    private void _init(OptionParameter optionParameter, String string, Object object, String string2) {
        if (optionParameter == null) {
            this._next = null;
        } else {
            OptionParameter optionParameter2 = optionParameter;
            while (optionParameter2._next != null) {
                optionParameter2 = optionParameter2._next;
            }
            optionParameter2._next = this;
        }
        this.Name = string;
        this.data = object;
        this.Description = string2;
    }

    public OptionParameter(OptionParameter optionParameter, String string, Object object, String string2) {
        this._init(optionParameter, string, object, string2);
    }

    public OptionParameter(OptionParameter optionParameter, String string, Object object) {
        this._init(optionParameter, string, object, "");
    }

    void On_Error(String string) {
        System.out.println("ERROR " + string);
    }

    public Object get_data() {
        return this.data;
    }

    public String get_String() {
        if (!(this.data instanceof String)) {
            this.On_Error(String.format("get_String() is impossible for option \"%s\" with Class.getName() = %s", this.Name, this.data.getClass().getName()));
        }
        return (String)this.data;
    }

    public double get_double() {
        if (!(this.data instanceof Double)) {
            this.On_Error(String.format("get_double() is impossible for option \"%s\" with Class.getName() = %s", this.Name, this.data.getClass().getName()));
        }
        return (Double)this.data;
    }

    public boolean get_boolean() {
        if (!(this.data instanceof Boolean)) {
            this.On_Error(String.format("get_boolean() is impossible for option \"%s\" with Class.getName() = %s", this.Name, this.data.getClass().getName()));
        }
        return (Boolean)this.data;
    }

    public int get_int() {
        if (!(this.data instanceof Integer)) {
            this.On_Error(String.format("get_int() is impossible for option \"%s\" with Class.getName() = %s", this.Name, this.data.getClass().getName()));
        }
        return (Integer)this.data;
    }

    public static String get_data_as_String(Object object) throws Exception {
        if (object instanceof String) {
            if (((String)object).isEmpty()) {
                return "(empty)";
            }
            return (String)object;
        }
        if (object instanceof Boolean) {
            return ((Boolean)object).toString();
        }
        if (object instanceof Double) {
            return String.format(default_double_format, (Double)object);
        }
        if (object instanceof Integer) {
            return String.format(default_int_format, (Integer)object);
        }
        if (object instanceof Object[]) {
            String string = "{ ";
            Object[] objectArray = (Object[])object;
            for (int i = 0; i < objectArray.length; ++i) {
                if (i > 0) {
                    string = string + ", ";
                }
                string = string + OptionParameter.get_data_as_String(objectArray[i]);
            }
            return string + " }";
        }
        throw new Exception(" The class of data is unknown!");
    }

    public String get_as_String() {
        try {
            return OptionParameter.get_data_as_String(this.data);
        }
        catch (Exception exception) {
            this.On_Error(exception.getMessage());
            return null;
        }
    }

    public void Print_as_List(OptionParameter optionParameter, String string) throws Exception {
        if (optionParameter == null) {
            optionParameter = this;
        }
        OptionParameter optionParameter2 = optionParameter;
        if (string == null) {
            string = "%s   %s%n";
        }
        while (optionParameter2 != null) {
            if (!(optionParameter2 instanceof Object[])) {
                this.out.printf(string, optionParameter2.Name, optionParameter2.get_as_String());
            } else {
                Object[] objectArray = (Object[])this.data;
                for (int i = 0; i < objectArray.length; ++i) {
                    this.out.printf(string, optionParameter2.Name, OptionParameter.get_data_as_String(objectArray[i]));
                }
            }
            optionParameter2 = optionParameter2._next;
        }
        this.out.flush();
    }

    public void PrintDescriptions(OptionParameter optionParameter, String string) {
        if (optionParameter == null) {
            optionParameter = this;
        }
        if (string == null) {
            string = "%s  %s%n";
        }
        while (optionParameter != null) {
            this.out.printf(string, optionParameter.Name, optionParameter.Description, optionParameter.get_as_String());
            optionParameter = optionParameter._next;
        }
    }

    public void set_data(Object object) {
        this.data = object;
    }

    private Object _parse_data(String string, Object object, boolean[] blArray) {
        blArray[0] = true;
        if (object instanceof Boolean) {
            return string == null ? true : Boolean.valueOf(string);
        }
        if (object instanceof String) {
            return string == null ? "" : string;
        }
        if (object instanceof Double) {
            return string == null ? new Double(0.0) : new Double(string);
        }
        if (object instanceof Integer) {
            return string == null ? new Integer(0) : new Integer(string);
        }
        blArray[0] = false;
        return object;
    }

    public void ReadDataFromString(String string) throws Exception {
        boolean[] blArray = new boolean[]{true};
        this.data = this._parse_data(string, this.data, blArray);
        if (!blArray[0]) {
            if (this.data instanceof Object[]) {
                if (string == null) {
                    this.out.println(" ERROR: value can not be empty for " + this.Name);
                } else {
                    Object[] objectArray = (Object[])this.data;
                    Object[] objectArray2 = new Object[objectArray.length + 1];
                    System.arraycopy((Object[])this.data, 0, objectArray2, 0, objectArray.length);
                    objectArray2[objectArray.length] = this._parse_data(string, objectArray[objectArray.length - 1], blArray);
                }
            } else {
                throw new Exception(" The class of data is unknown!");
            }
        }
    }

    public OptionParameter FindInListByName(OptionParameter optionParameter, String string, boolean bl) {
        if (optionParameter == null) {
            optionParameter = this;
        }
        OptionParameter optionParameter2 = optionParameter;
        boolean bl2 = false;
        while (optionParameter2 != null && !bl2) {
            bl2 = bl ? string.toLowerCase().equals(optionParameter2.Name.toLowerCase()) : string.equals(optionParameter2.Name);
            if (bl2) continue;
            optionParameter2 = optionParameter2._next;
        }
        return optionParameter2;
    }

    public void LoadOptionsFromCommandLine(String[] stringArray, OptionParameter optionParameter, boolean bl, boolean bl2) throws Exception {
        if (optionParameter == null) {
            optionParameter = this;
        }
        int n = 0;
        while (n < stringArray.length) {
            OptionParameter optionParameter2 = optionParameter.FindInListByName(null, stringArray[n], bl);
            if (optionParameter2 == null) {
                if (bl2) {
                    throw new Exception("parameter \"" + stringArray[n] + "\" is unknown!%n");
                }
                WarningManager.warning_printf("Warning: parameter \"%s\" is unknown!%n", stringArray[n]);
                ++n;
                continue;
            }
            if (optionParameter2.get_data() instanceof Boolean) {
                optionParameter2.set_data(true);
                ++n;
                continue;
            }
            if (++n < stringArray.length) {
                optionParameter2.ReadDataFromString(stringArray[n]);
                ++n;
                continue;
            }
            this.out.printf("ERROR: value missing for parameter \"%s\"; ignoring%n", stringArray[n - 1]);
        }
    }

    public void LoadOptionsFromFile(BufferedReader bufferedReader, OptionParameter optionParameter, boolean bl) throws Exception {
        String string;
        if (optionParameter == null) {
            optionParameter = this;
        }
        while ((string = bufferedReader.readLine()) != null) {
            OptionParameter optionParameter2;
            if ((string = string.replaceFirst("[ \\t]*", "")).isEmpty()) continue;
            int n = string.indexOf(32);
            String string2 = null;
            String string3 = null;
            if (n == -1) {
                string2 = string;
            } else {
                string2 = string.substring(0, n);
                if (n < string.length() && (string3 = string.substring(n + 1).replaceFirst("[ \\t]*", "")).isEmpty()) {
                    string3 = null;
                }
            }
            if ((optionParameter2 = optionParameter.FindInListByName(null, string2, bl)) == null) continue;
            optionParameter2.ReadDataFromString(string3);
        }
    }
}

