/*
 * Decompiled with CFR 0.152.
 */
package onpa;

import JGints.MO;
import JGints.SphericalHarmonics;
import Jama.Matrix;
import ProgramOptions.WarningManager;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.PrintWriter;
import moldenio.MOLDEN_IO;

public class printout
extends PrintStream {
    public static String Stars = "                          * * *                                         ";
    static String MatrixFloatNumberFormat = "%12.5f";
    static int MatrixLineWidth = 0;

    public printout(OutputStream outputStream) {
        super(outputStream);
    }

    public static void PrintStars() {
        System.out.println();
        System.out.println(Stars);
        System.out.println();
    }

    public static void Export_Orbitals(MOLDEN_IO mOLDEN_IO, Matrix matrix, double[] dArray, double[] dArray2, String string, boolean bl, String string2) throws Exception {
        int n;
        int n2;
        MOLDEN_IO mOLDEN_IO2 = new MOLDEN_IO();
        mOLDEN_IO2.CopyAllFrom(mOLDEN_IO);
        mOLDEN_IO2.IsSpherical = true;
        mOLDEN_IO2.Title = string2 != null ? string2 : "Natural Orbitals prepared by JANPA";
        if (bl) {
            double[][] dArray3 = SphericalHarmonics.Get_Quick_YLM_Norm2(SphericalHarmonics.Get_Quick_YLM());
            double[] dArray4 = new double[dArray3.length];
            for (n2 = 0; n2 < dArray4.length; ++n2) {
                dArray4[n2] = Math.sqrt(dArray3[n2][0]);
            }
            for (n2 = 0; n2 < mOLDEN_IO2.RadialParts.length; ++n2) {
                n = 0;
                while (n < mOLDEN_IO2.RadialParts[n2].Coefs.length) {
                    int n3 = n++;
                    mOLDEN_IO2.RadialParts[n2].Coefs[n3] = mOLDEN_IO2.RadialParts[n2].Coefs[n3] / dArray4[mOLDEN_IO2.RadialParts[n2].LUsedWith];
                }
            }
        }
        int n4 = matrix.getColumnDimension();
        int n5 = matrix.getRowDimension();
        mOLDEN_IO2.MOs = new MO[n5];
        if (dArray != null && n5 != dArray.length) {
            WarningManager.warning_printf("WARNING - internal fail in printout.Export_Orbitals: Orbitals_to_AO.getColumnDimension() != occupancies.length", new Object[0]);
        }
        if (dArray2 != null && n5 != dArray2.length) {
            WarningManager.warning_printf("WARNING - internal fail in printout.Export_Orbitals: Orbitals_to_AO.getColumnDimension() != Energies.length", new Object[0]);
        }
        if (mOLDEN_IO2.Basis.length != n4) {
            WarningManager.warning_printf("WARNING - internal fail in printout.Export_Orbitals: molden2.Basis.length != nBFs", new Object[0]);
        }
        for (n2 = 0; n2 < n5; ++n2) {
            mOLDEN_IO2.MOs[n2] = new MO();
            mOLDEN_IO2.MOs[n2].BS_Coefs = new double[n4];
            if (dArray != null) {
                mOLDEN_IO2.MOs[n2].Occupancy = dArray[n2];
            }
            mOLDEN_IO2.MOs[n2].Energy = 0.0;
            if (dArray2 != null) {
                mOLDEN_IO2.MOs[n2].Energy = dArray2[n2];
            }
            for (n = 0; n < n4; ++n) {
                mOLDEN_IO2.MOs[n2].BS_Coefs[n] = matrix.get(n2, n);
            }
        }
        mOLDEN_IO2.Save_As_MOLDEN(string);
    }

    private static void _Print_Matrix_Title_AO_basis(int n) {
        System.out.println(" <<<< _Print_Matrix_Title_AO_basis >>>>");
    }

    public static void _Print_Matrix_With_Header(Matrix matrix, String string) {
        System.out.println(string);
        printout._Print_Matrix_Title_AO_basis(15);
        matrix.print(13, 7);
    }

    public static void Print_Matrix(Matrix matrix, String string, String[] stringArray, String[] stringArray2, String string2) throws Exception {
        if (string2 == null || string2.isEmpty()) {
            return;
        }
        System.out.println();
        System.out.println("Exporting matrix \"" + string + "\" to " + string2);
        PrintWriter printWriter = new PrintWriter(string2);
        if (string != null) {
            printWriter.println(string);
        } else {
            printWriter.println("");
        }
        printWriter.printf("%d\t%d%n", matrix.getRowDimension(), matrix.getColumnDimension());
        if (stringArray == null) {
            printWriter.println();
        } else {
            for (int i = 0; i < stringArray.length; ++i) {
                if (MatrixLineWidth != 0 && i > 0 && i % MatrixLineWidth == 0) {
                    printWriter.println();
                }
                printWriter.printf("%s\t", stringArray[i]);
            }
            printWriter.println();
        }
        double[][] dArray = matrix.getArray();
        for (int i = 0; i < dArray.length; ++i) {
            for (int j = 0; j < dArray[i].length; ++j) {
                if (j == 0 || MatrixLineWidth != 0 && j % MatrixLineWidth == 0) {
                    printWriter.println();
                }
                printWriter.printf(MatrixFloatNumberFormat, dArray[i][j]);
                printWriter.print("\t");
            }
            if (stringArray2 == null) {
                printWriter.print("\t");
                continue;
            }
            printWriter.printf("\t%s", stringArray2[i]);
        }
        printWriter.close();
        System.out.println("done");
    }
}

