/*
 * Decompiled with CFR 0.152.
 */
package onpa;

import JGints.AtomicCenter;
import JGints.BasisFunction;
import JGints.JGintsCyl;
import JGints.MO;
import Jama.EigenvalueDecomposition;
import Jama.Matrix;
import MatrixHelper.EigenEngine;
import Polynom3D.Polynom3D;
import ProgramOptions.ProgTimer;
import ProgramOptions.WarningManager;
import java.io.PrintStream;
import moldenio.MOLDEN_IO;
import onpa.ono_options;
import onpa.printout;

public class NPA {
    public BasisFunction[] Basis = null;
    public AtomicCenter[] Centers = null;
    private boolean _data_loaded = false;
    public JGintsCyl bsIntegrals;
    public Matrix D_Global = null;
    public Matrix OverlapMatrix = null;
    public Matrix S05DS05 = null;
    public Matrix SDS = null;
    private Matrix OverlapMatrix_SQRT = null;
    public Matrix Overlap_NAO = null;
    public Matrix SDS_NAO = null;
    public Matrix NAO_2_AO = null;
    public Matrix PNAO_Overlap_Matrix = null;
    public BasisFunction[] NAO;
    public double[] NPA_charges = null;
    BasisFunction[] PNAOs;
    public String[] AO_Names;
    public String[] PNAO_Labels;
    Polynom3D[][] Quick_YLM;
    private ono_options options;
    public static PrintStream out = System.out;
    public boolean verbose_print = false;
    private double[][] AORadialPartsOverlap;
    private EigenEngine ee = null;
    final int[][] NMB_per_Atom = new int[][]{{1, 1, 2, 2, 2, 2, 2, 2, 2, 2, 3, 3, 3, 3, 3, 3, 3, 3, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 5, 5, 5, 5, 5, 5, 5, 5, 5, 4, 5, 5, 5, 5, 5, 5, 5, 5, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6}, {0, 0, 0, 0, 3, 3, 3, 3, 3, 3, 3, 3, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12, 15, 15, 15, 15, 15, 15}, {0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 15, 15, 10, 10, 10, 10, 10, 15, 10, 10, 10, 10, 10, 10, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 15}, {0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7}, {0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}};

    public NPA(ono_options ono_options2) {
        if (ono_options2 == null) {
            ono_options2 = new ono_options();
        }
        this.options = ono_options2;
        try {
            printout.MatrixFloatNumberFormat = ono_options2.MatrixFloatNumberFormat.get_String();
            printout.MatrixLineWidth = ono_options2.MatrixLineWidth.get_int();
            this.verbose_print = ono_options2.VerbosePrint.get_boolean();
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.ee = new EigenEngine();
        this.ee.glbPrint = ono_options2.glbPrint;
    }

    boolean Load_MO_From_MOLDEN(MOLDEN_IO mOLDEN_IO) throws Exception {
        Matrix matrix;
        int n;
        int n2;
        int n3;
        int n4;
        int n5;
        int n6;
        if (mOLDEN_IO == null) {
            return false;
        }
        this._data_loaded = false;
        this.Basis = mOLDEN_IO.Basis;
        this.Centers = mOLDEN_IO.Centers;
        int n7 = this.Basis.length;
        MO[] mOArray = mOLDEN_IO.MOs;
        out.println("Building overlap S and dipole matrices...");
        if (!this.options.Overlap_Naive.get_boolean()) {
            this.bsIntegrals = new JGintsCyl();
            this.bsIntegrals.ImportBasisFromMolden(mOLDEN_IO);
            ProgTimer progTimer = new ProgTimer();
            progTimer.Start();
            this.bsIntegrals.Build_Ovarlap_Matrix_PURE();
            out.printf("Overlap & dipole integrals evaluated in %.3f seconds%n", progTimer.Stop() / 1000.0);
            this.OverlapMatrix = new Matrix(this.bsIntegrals.OverlapMatrix);
        } else {
            int n8;
            this.OverlapMatrix = new Matrix(n7, n7, 0.0);
            for (n8 = 0; n8 < n7; ++n8) {
                this.Basis[n8].Quick_YLM = this.Quick_YLM;
            }
            for (n8 = 0; n8 < n7; ++n8) {
                for (n6 = n8; n6 < n7; ++n6) {
                    double d = this.Basis[n8].OverlapWith(this.Basis[n6]);
                    this.OverlapMatrix.set(n8, n6, d);
                    this.OverlapMatrix.set(n6, n8, d);
                }
            }
        }
        boolean bl = false;
        n6 = 0;
        boolean bl2 = false;
        out.println("Checking whether the basis functions are unity-normalized...");
        double[] dArray = new double[n7];
        double d = 0.0;
        int n9 = -1;
        for (n5 = 0; n5 < n7; ++n5) {
            dArray[n5] = this.OverlapMatrix.get(n5, n5);
            if (!(Math.abs(dArray[n5] - 1.0) > d)) continue;
            d = Math.abs(dArray[n5] - 1.0);
            n9 = n5;
        }
        out.printf(" Maximum deviation of the basis function norm2 from unity: BFN %d (0-based num.), max|norm2-1| = %.3E %n", n9, d);
        if (d > this.options.bf_nrm2_dev_threshold && this.options.do_BS_renormalize) {
            out.println("Trying to make basis functions unity-normalized...");
            for (n5 = 0; n5 < n7; ++n5) {
                for (int i = 0; i < n7; ++i) {
                    this.OverlapMatrix.set(n5, i, this.OverlapMatrix.get(n5, i) / dArray[n5] / dArray[i]);
                }
            }
        }
        if (d < this.options.bf_nrm2_dev_threshold || this.options.do_BS_renormalize) {
            bl = true;
        }
        out.println("Checking for the eigenvalues (linear (in)dependency) of the basis function overlap matrix...");
        EigenvalueDecomposition eigenvalueDecomposition = this.OverlapMatrix.eig();
        double d2 = 0.0;
        double[][] dArray2 = eigenvalueDecomposition.getD().getArray();
        d2 = Math.abs(dArray2[0][0]);
        for (n4 = 1; n4 < n7; ++n4) {
            if (!(Math.abs(dArray2[n4][n4]) < d2)) continue;
            d2 = Math.abs(dArray2[n4][n4]);
        }
        out.printf("The smallest eigenvalue of the basis function overlap matrix: %7.3E %n", d2);
        if (d2 < this.options.S_AO_lin_dep_thresh) {
            WarningManager.warning_printf("WARNING: the basis set functions seems to be linearly dependent!", new Object[0]);
            if (this.options.fail_if_lin_dep) {
                return false;
            }
        }
        for (n4 = 0; n4 < dArray2.length; ++n4) {
            dArray2[n4][n4] = Math.sqrt(dArray2[n4][n4]);
        }
        this.OverlapMatrix_SQRT = eigenvalueDecomposition.getV().times(new Matrix(dArray2)).times(eigenvalueDecomposition.getV().transpose());
        out.println("Checking whether the orbitals are unity-normalized...");
        d = 0.0;
        n9 = -1;
        n4 = mOArray.length;
        Matrix matrix2 = new Matrix(n4, n7);
        for (int i = 0; i < n4; ++i) {
            for (n3 = 0; n3 < n7; ++n3) {
                matrix2.set(i, n3, mOArray[i].BS_Coefs[n3]);
            }
        }
        if (this.options.do_MO_renormalize) {
            double[] dArray3 = new double[n4];
            for (n3 = 0; n3 < n4; ++n3) {
                dArray3[n3] = 0.0;
                for (n2 = 0; n2 < n7; ++n2) {
                    matrix2.set(n3, n2, mOArray[n3].BS_Coefs[n2]);
                    for (n = 0; n < n7; ++n) {
                        int n10 = n3;
                        dArray3[n10] = dArray3[n10] + mOArray[n3].BS_Coefs[n2] * mOArray[n3].BS_Coefs[n] * this.OverlapMatrix.get(n2, n);
                    }
                }
                if (!(Math.abs(dArray3[n3] - 1.0) > d)) continue;
                d = Math.abs(dArray[n3] - 1.0);
                n9 = n3;
            }
            out.printf(" Maximum deviation of the orbital norm2 from unity: MO %d (0-based num.), max|norm2-1| = %.3E %n", n9, d);
            if (d > this.options.mo_non1_renorm_thresh) {
                out.println("Trying to make MOs unity-normalized...");
                for (n3 = 0; n3 < n7; ++n3) {
                    n2 = 0;
                    while (n2 < n7) {
                        int n11 = n2++;
                        mOArray[n3].BS_Coefs[n11] = mOArray[n3].BS_Coefs[n11] / dArray[n3];
                    }
                }
            }
        }
        out.println("Checking MO overlap matrix...");
        double[][] dArray4 = this.ee.TransformMatrixToNewBasis(this.OverlapMatrix, matrix2, true).getArray();
        n3 = 0;
        n2 = n3 + 1;
        n = 0;
        for (int i = 0; i < n4; ++i) {
            if (Math.abs(dArray4[i][i] - 1.0) > Math.abs(dArray4[n][n] - 1.0)) {
                n = i;
            }
            for (int j = i + 1; j < n4; ++j) {
                if (!(Math.abs(dArray4[i][j]) > Math.abs(dArray4[n3][n2])) || mOArray[i].Spin != mOArray[j].Spin) continue;
                n3 = i;
                n2 = j;
            }
        }
        double d3 = Math.abs(dArray4[n][n] - 1.0);
        out.printf(" Maximum of MO |norm2-1|: %7.3E (MO %4d)%n", d3, n + 1);
        if (d3 < this.options.mo_nrm2_dev_threshold) {
            n6 = 1;
        } else {
            WarningManager.warning_printf("WARNING: molecular orbital normalization problem! This may spoil MO occupancies...", new Object[0]);
        }
        if (n4 > 1) {
            double d4 = Math.abs(dArray4[n3][n2]);
            out.printf(" Maximum absolute value of off-diagonal MO overlap element: %7.3E (< MO %4d | MO %4d >)%n", d4, n3 + 1, n2 + 1);
            if (d4 < this.options.mo_off_diag_threshold) {
                bl2 = true;
            } else {
                WarningManager.warning_printf("WARNING: molecular orbitals seem to be non-orthogonal ?!", new Object[0]);
            }
        } else {
            bl2 = true;
        }
        if (!bl || n6 == 0 || !bl2) {
            WarningManager.warning_printf("WARNING: input data seems to be improper!%n", new Object[0]);
        } else {
            out.println("First-order reduced density matrix is OK.");
        }
        out.println();
        int n12 = 0;
        for (int i = 0; i < mOLDEN_IO.MOs.length; ++i) {
            if (mOLDEN_IO.MOs[i].Spin <= 0) continue;
            ++n12;
        }
        if (n12 != 0 && n12 != mOLDEN_IO.MOs.length && n12 != mOLDEN_IO.MOs.length / 2) {
            WarningManager.warning_printf("WARNING: the system seems to be opened-shell!%nNote that this case is current not supported so that the obtained results will be meaningless!", new Object[0]);
        }
        this.AO_Names = NPA.Create_NAO_Labels(this.Basis);
        printout.Print_Matrix(this.OverlapMatrix, "The Overlap Matrix in spherical function AO basis:", this.AO_Names, this.AO_Names, this.options.S_Matrix_File.get_String());
        out.print("Building density matrix D... ");
        this.D_Global = new Matrix(n7, n7, 0.0);
        for (int i = 0; i < n7; ++i) {
            for (int j = i; j < n7; ++j) {
                double d5 = 0.0;
                for (int k = 0; k < mOArray.length; ++k) {
                    d5 += mOArray[k].BS_Coefs[i] * mOArray[k].BS_Coefs[j] * mOArray[k].Occupancy;
                }
                this.D_Global.set(i, j, d5);
                this.D_Global.set(j, i, d5);
            }
        }
        out.println("done.");
        printout.Print_Matrix(this.D_Global, "The D density Matrix in spherical function AO basis:", this.AO_Names, this.AO_Names, this.options.D_Matrix_File.get_String());
        out.print("Building D.S... ");
        Matrix matrix3 = this.D_Global.times(this.OverlapMatrix);
        out.println("done.");
        double d6 = matrix3.trace();
        out.printf("Total number of electrons: %f\n", d6);
        double d7 = 0.0;
        for (int i = 0; i < this.Centers.length; ++i) {
            d7 += this.Centers[i].Z;
        }
        out.printf("Sum of electrons charges and the nuclei charges: %7.5f %n", d7 - d6);
        out.println();
        out.println("Performing Mulliken and Lowdin population analyses...");
        this.S05DS05 = matrix = this.OverlapMatrix_SQRT.times(this.D_Global).times(this.OverlapMatrix_SQRT);
        double[] dArray5 = new double[this.Centers.length];
        double[] dArray6 = new double[this.Centers.length];
        for (int i = 0; i < n7; ++i) {
            int n13 = this.Basis[i].Center_ID - 1;
            dArray6[n13] = dArray6[n13] + matrix.get(i, i);
            int n14 = this.Basis[i].Center_ID - 1;
            dArray5[n14] = dArray5[n14] + matrix3.get(i, i);
        }
        String string = "%7s\t%8.5f\t%8.5f\t%8.5f\t%8.5f%n";
        out.printf("%7s\t%s\t%s\t%s\t%s%n", "Atom", "Mulliken  ", "Lowdin    ", "Mulliken", "Lowdin");
        out.printf("%7s\t%s\t%s\t%s\t%s%n", "", "Population", "Population", "Charge  ", "Charge");
        for (int i = 0; i < this.Centers.length; ++i) {
            out.printf(string, String.format("%s%d", this.Centers[i].Name, i + 1), dArray5[i], dArray6[i], this.Centers[i].Z - dArray5[i], this.Centers[i].Z - dArray6[i]);
        }
        out.println();
        out.print("Building S.D.S... ");
        this.SDS = this.ee.TransformMatrixToNewBasis(this.D_Global, this.OverlapMatrix, true);
        out.println("done.");
        printout.Print_Matrix(this.SDS, "S.D.S matrix in spherical function AO basis:", this.AO_Names, this.AO_Names, this.options.SDS_Matrix_File.get_String());
        out.println();
        this._data_loaded = true;
        return true;
    }

    BasisFunction[] IntracenterBasisOrthogonalization(BasisFunction[] basisFunctionArray, int n, Matrix matrix, Matrix matrix2) {
        int n2;
        if (!this._data_loaded) {
            return null;
        }
        BasisFunction[] basisFunctionArray2 = new BasisFunction[basisFunctionArray.length];
        boolean bl = basisFunctionArray.length != 0;
        int[] nArray = new int[n];
        for (int i = 0; i < basisFunctionArray.length; ++i) {
            if (basisFunctionArray[i].L <= nArray[basisFunctionArray[i].Center_ID - 1]) continue;
            nArray[basisFunctionArray[i].Center_ID - 1] = basisFunctionArray[i].L;
        }
        int[] nArray2 = new int[n];
        for (n2 = 0; n2 < basisFunctionArray.length; ++n2) {
            int n3 = basisFunctionArray[n2].Center_ID - 1;
            nArray2[n3] = nArray2[n3] + 1;
        }
        n2 = 0;
        for (int i = 0; i < n; ++i) {
            if (nArray2[i] <= n2) continue;
            n2 = nArray2[i];
        }
        int[] nArray3 = new int[basisFunctionArray.length];
        int[] nArray4 = new int[n];
        nArray4[0] = 0;
        for (int i = 1; i < n; ++i) {
            nArray4[i] = nArray4[i - 1] + nArray2[i - 1];
        }
        int[] nArray5 = (int[])nArray4.clone();
        for (int i = 0; i < basisFunctionArray.length; ++i) {
            nArray3[nArray5[basisFunctionArray[i].Center_ID - 1]] = i;
            int n4 = basisFunctionArray[i].Center_ID - 1;
            nArray5[n4] = nArray5[n4] + 1;
        }
        nArray5 = null;
        int[] nArray6 = new int[n2];
        int n5 = 0;
        int[] nArray7 = new int[n2];
        int n6 = 0;
        boolean bl2 = false;
        int n7 = 0;
        double[] dArray = new double[basisFunctionArray.length];
        int n8 = 0;
        if (this.verbose_print) {
            out.println("Producing natural orbitals for each center...");
        }
        for (int i = 0; i < n && bl; ++i) {
            for (int j = 0; j <= nArray[i]; ++j) {
                int n9;
                int n10;
                int n11;
                int n12;
                if (this.verbose_print) {
                    out.println("center = " + (i + 1) + ", L = " + j);
                }
                n5 = 0;
                n6 = 0;
                for (int k = nArray4[i]; k < nArray4[i] + nArray2[i]; ++k) {
                    int n13;
                    if (basisFunctionArray[nArray3[k]].L != j) continue;
                    bl2 = false;
                    n7 = basisFunctionArray[nArray3[k]].RadialPart_ID;
                    for (n13 = 0; !bl2 && n13 < n5; bl2 |= nArray6[n13] == n7, ++n13) {
                    }
                    if (!bl2) {
                        nArray6[n5] = n7;
                        ++n5;
                    }
                    bl2 = false;
                    for (n13 = 0; !bl2 && n13 < n6; bl2 |= nArray7[n13] == nArray3[k], ++n13) {
                    }
                    if (bl2) continue;
                    nArray7[n6] = nArray3[k];
                    ++n6;
                }
                double[][] dArray2 = new double[n5][n5];
                double[][] dArray3 = new double[n5][n5];
                for (int k = 0; k < n5; ++k) {
                    for (int i2 = k; i2 < n5; ++i2) {
                        dArray3[k][i2] = 0.0;
                        dArray2[k][i2] = 0.0;
                        int n14 = 0;
                        for (int i3 = 0; i3 < n6; ++i3) {
                            for (int i4 = i3; i4 < n6; ++i4) {
                                n12 = basisFunctionArray[nArray7[i3]].m == basisFunctionArray[nArray7[i4]].m ? 1 : 0;
                                n11 = basisFunctionArray[nArray7[i3]].RadialPart_ID == nArray6[k] ? 1 : 0;
                                boolean bl3 = basisFunctionArray[nArray7[i3]].RadialPart_ID == nArray6[i2];
                                n10 = basisFunctionArray[nArray7[i4]].RadialPart_ID == nArray6[k] ? 1 : 0;
                                int n15 = n9 = basisFunctionArray[nArray7[i4]].RadialPart_ID == nArray6[i2] ? 1 : 0;
                                if (n12 == 0 || (n11 == 0 || n9 == 0) && (!bl3 || n10 == 0)) continue;
                                ++n14;
                                double[] dArray4 = dArray3[k];
                                int n16 = i2;
                                dArray4[n16] = dArray4[n16] + matrix2.get(nArray7[i3], nArray7[i4]);
                                double[] dArray5 = dArray2[k];
                                int n17 = i2;
                                dArray5[n17] = dArray5[n17] + matrix.get(nArray7[i3], nArray7[i4]);
                            }
                        }
                        if (n14 > 0) {
                            double[] dArray6 = dArray3[k];
                            int n18 = i2;
                            dArray6[n18] = dArray6[n18] / (double)n14;
                            double[] dArray7 = dArray2[k];
                            int n19 = i2;
                            dArray7[n19] = dArray7[n19] / (double)n14;
                        }
                        dArray3[i2][k] = dArray3[k][i2];
                        dArray2[i2][k] = dArray2[k][i2];
                    }
                }
                Matrix matrix3 = new Matrix(dArray3);
                Matrix matrix4 = new Matrix(dArray2);
                Matrix[] matrixArray = this.ee.Generalized_EVD_SymmMatr(matrix4, matrix3);
                double[][] dArray8 = matrixArray[1].getArray();
                for (n12 = 0; n12 < n6; ++n12) {
                    basisFunctionArray2[n8] = new BasisFunction(j, basisFunctionArray[nArray7[n12]].m, null, basisFunctionArray.length);
                    basisFunctionArray2[n8].Center_ID = i + 1;
                    basisFunctionArray2[n8].RadialPart_ID = basisFunctionArray[nArray7[n12]].RadialPart_ID;
                    bl2 = false;
                    n11 = 0;
                    while (!bl2 && n11 < n5) {
                        if (bl2 |= nArray6[n11] == basisFunctionArray[nArray7[n12]].RadialPart_ID) continue;
                        ++n11;
                    }
                    basisFunctionArray2[n8].weight = matrixArray[0].get(n11, n11);
                    for (int k = 0; k < n6; ++k) {
                        if (basisFunctionArray[nArray7[k]].m != basisFunctionArray2[n8].m) continue;
                        bl2 = false;
                        n10 = 0;
                        while (!bl2 && n10 < n5) {
                            if (bl2 |= nArray6[n10] == basisFunctionArray[nArray7[k]].RadialPart_ID) continue;
                            ++n10;
                        }
                        basisFunctionArray2[n8].coefs[nArray7[k]] = dArray8[n10][n11];
                    }
                    if (this.options.glbPrint) {
                        double d = 0.0;
                        for (n9 = 0; n9 < basisFunctionArray.length; ++n9) {
                            out.printf("%12.5f", basisFunctionArray2[n8].coefs[n9]);
                            for (int k = 0; k < basisFunctionArray.length; ++k) {
                                d += basisFunctionArray2[n8].coefs[n9] * matrix2.get(n9, k) * basisFunctionArray2[n8].coefs[k];
                            }
                        }
                        out.printf("\n pnao %d: norm2 = %.7f \n", n8, d);
                    }
                    ++n8;
                }
            }
        }
        out.println(" Total number of natural functions produced: " + n8);
        if (this.verbose_print) {
            out.println(" weights of the natural functions produced:");
            double d = 0.0;
            for (int i = 0; i < n8; ++i) {
                out.printf("%15.7f", basisFunctionArray2[i].weight);
                d += basisFunctionArray2[i].weight;
            }
            out.println();
            out.printf(" sum = %12.7f%n%n", d);
        }
        return basisFunctionArray2;
    }

    public static String[] Create_NAO_Labels(BasisFunction[] basisFunctionArray) {
        String[] stringArray = new String[basisFunctionArray.length];
        for (int i = 0; i < basisFunctionArray.length; ++i) {
            String string = String.format("R%d*%s(%d)", basisFunctionArray[i].RadialPart_ID + 1, Character.valueOf("spdfg".charAt(basisFunctionArray[i].L)), basisFunctionArray[i].m);
            if (basisFunctionArray[i].additional_r_power != 0) {
                string = string + String.format("*r^%d", basisFunctionArray[i].additional_r_power);
            }
            stringArray[i] = !basisFunctionArray[i].NRB ? String.format("A%d: %s", basisFunctionArray[i].Center_ID, string) : String.format("A%d*: %s", basisFunctionArray[i].Center_ID, string);
        }
        return stringArray;
    }

    public static Matrix BasisFunctionsToMatrix(BasisFunction[] basisFunctionArray, boolean bl) {
        double[][] dArrayArray = new double[basisFunctionArray.length][];
        for (int i = 0; i < basisFunctionArray.length; ++i) {
            if (basisFunctionArray[i] != null) {
                if (bl) {
                    dArrayArray[i] = (double[])basisFunctionArray[i].coefs.clone();
                    continue;
                }
                dArrayArray[i] = basisFunctionArray[i].coefs;
                continue;
            }
            WarningManager.warning_printf("warning: uncomplete matrix!", new Object[0]);
        }
        Matrix matrix = basisFunctionArray.length > 0 ? new Matrix(dArrayArray) : new Matrix(0, 0);
        return matrix;
    }

    public static double[] BasisFunctionsToOccupancies(BasisFunction[] basisFunctionArray) {
        double[] dArray = new double[basisFunctionArray.length];
        for (int i = 0; i < basisFunctionArray.length; ++i) {
            if (basisFunctionArray[i] != null) {
                dArray[i] = basisFunctionArray[i].weight;
                continue;
            }
            WarningManager.warning_printf("warning: uncomplete matrix!", new Object[0]);
        }
        return dArray;
    }

    public static double max_offdiag(Matrix matrix) {
        double d = 0.0;
        double[][] dArray = matrix.getArray();
        for (int i = 0; i < dArray.length; ++i) {
            for (int j = i + 1; j < dArray[i].length; ++j) {
                if (dArray[i][j] > d) {
                    d = dArray[i][j];
                }
                if (!(dArray[j][i] > d)) continue;
                d = dArray[j][i];
            }
        }
        return d;
    }

    double NonUnitary_Norm2(Matrix matrix) {
        double d = 0.0;
        for (int i = 0; i < matrix.getRowDimension(); ++i) {
            for (int j = 0; j < matrix.getColumnDimension(); ++j) {
                double d2 = matrix.get(i, j);
                if (i == j) {
                    d += (d2 - 1.0) * (d2 - 1.0);
                    continue;
                }
                d += d2 * d2;
            }
        }
        return d;
    }

    boolean Create_NAOs() throws Exception {
        int n;
        int n2;
        Object object;
        int n3;
        int n4;
        String[] stringArray;
        Matrix matrix;
        int n5;
        int n6;
        int n7;
        int n8;
        int n9;
        double d;
        int n10;
        int n11;
        int n12;
        int n13;
        int n14;
        out.printf(printout.Stars + "%n%n", new Object[0]);
        out.printf("Creating NAOs%n%n", new Object[0]);
        out.printf("%nSTEP 1. Produce PNAOs%n%n", new Object[0]);
        this.PNAOs = this.IntracenterBasisOrthogonalization(this.Basis, this.Centers.length, this.SDS, this.OverlapMatrix);
        out.println("Sorting PNAOs...");
        int[] nArray = new int[this.PNAOs.length];
        for (n14 = 0; n14 < this.PNAOs.length; ++n14) {
            nArray[n14] = n14;
        }
        boolean bl = true;
        while (bl) {
            bl = false;
            for (n14 = 0; n14 < this.PNAOs.length - 1; ++n14) {
                if (!(this.PNAOs[nArray[n14]].weight < this.PNAOs[nArray[n14 + 1]].weight)) continue;
                bl = true;
                int n15 = nArray[n14];
                nArray[n14] = nArray[n14 + 1];
                nArray[n14 + 1] = n15;
            }
        }
        out.printf("%nSTEP 2. Split PNAOs into NMB / NRB sets%n%n", new Object[0]);
        out.println(" Number of basis functions in teh Natural Minimal Basis (NMB) set for each center: ");
        n14 = 5;
        int[] nArray2 = new int[n14];
        for (n13 = 0; n13 < this.Centers.length; ++n13) {
            n12 = new Double(this.Centers[n13].Z).intValue();
            if (n12 == 0) {
                WarningManager.warning_printf("Warning: center %d has zero nuclear charge; no NMB functions will be assigned to it!%n", n13 + 1);
            }
            for (n11 = 0; n11 < n14; ++n11) {
                nArray2[n11] = 0;
            }
            for (n11 = 0; n11 < this.PNAOs.length; ++n11) {
                if (this.PNAOs[nArray[n11]].Center_ID != n13 + 1) continue;
                this.PNAOs[nArray[n11]].NRB = false;
                int n16 = this.PNAOs[nArray[n11]].L;
                nArray2[n16] = nArray2[n16] + 1;
                int n17 = 0;
                if (n12 > 0) {
                    n17 = this.NMB_per_Atom[this.PNAOs[nArray[n11]].L][n12 - 1];
                }
                if (nArray2[this.PNAOs[nArray[n11]].L] <= n17) continue;
                this.PNAOs[nArray[n11]].NRB = true;
            }
            for (n11 = 0; n11 < n14; ++n11) {
                nArray2[n11] = 0;
            }
            for (n11 = 0; n11 < this.PNAOs.length; ++n11) {
                if (this.PNAOs[n11].Center_ID != n13 + 1 || this.PNAOs[n11].NRB) continue;
                int n18 = this.PNAOs[n11].L;
                nArray2[n18] = nArray2[n18] + 1;
            }
            out.printf("center %3d: ", n13 + 1);
            for (n11 = 0; n11 < n14; ++n11) {
                out.printf(" %2d of %c |", nArray2[n11], Character.valueOf("spdfg".charAt(n11)));
            }
            out.println();
        }
        nArray = null;
        n13 = 0;
        n12 = 0;
        for (n11 = 0; n11 < this.PNAOs.length; ++n11) {
            if (this.PNAOs[n11].NRB) {
                ++n12;
                continue;
            }
            ++n13;
        }
        out.printf("In total: NMB set has %d functions, NRB set has %d functions; %n%n", n13, n12);
        if (this.verbose_print) {
            out.println(" Does PNAO belong to NRB?: ");
            for (n11 = 0; n11 < this.PNAOs.length; ++n11) {
                out.printf("%15b", this.PNAOs[n11].NRB);
            }
            out.println();
        }
        int[] nArray3 = new int[n13];
        int[] nArray4 = new int[n12];
        int n19 = 0;
        int n20 = 0;
        for (int i = 0; i < this.PNAOs.length; ++i) {
            if (this.PNAOs[i].NRB) {
                nArray4[n19] = i;
                ++n19;
                continue;
            }
            nArray3[n20] = i;
            ++n20;
        }
        if (this.verbose_print) {
            out.println("Transforming overlap and SDS matrices to PNAO basis...");
        }
        Matrix matrix2 = NPA.BasisFunctionsToMatrix(this.PNAOs, false);
        this.PNAO_Labels = NPA.Create_NAO_Labels(this.PNAOs);
        this.PNAO_Overlap_Matrix = this.ee.TransformMatrixToNewBasis(this.OverlapMatrix, matrix2, true);
        printout.Print_Matrix(this.PNAO_Overlap_Matrix, "PNAO overlap matrix:", this.PNAO_Labels, this.PNAO_Labels, this.options.PNAO_OverlapMatrix_File.get_String());
        out.printf("Trace of the PNAO overlap matrix: %.7f (should be equal to %d, the total number of PNAOs)\n", this.PNAO_Overlap_Matrix.trace(), this.PNAOs.length);
        Matrix matrix3 = this.ee.TransformMatrixToNewBasis(this.SDS, matrix2, true);
        out.println(" The trace of SDS matrix in PNAO basis = " + matrix3.trace());
        printout.Print_Matrix(matrix3, "The S.D.S matrix in PNAO basis:", this.PNAO_Labels, this.PNAO_Labels, this.options.PNAO_SDS_Matrix_File.get_String());
        out.printf("%nSTEP 3. Weighted orthogonalization of NMB PNAOs%n%n", new Object[0]);
        Matrix matrix4 = new Matrix(this.PNAOs.length, this.PNAOs.length, 0.0);
        for (int i = 0; i < n12; ++i) {
            matrix4.set(nArray4[i], nArray4[i], 1.0);
        }
        Matrix matrix5 = this.PNAO_Overlap_Matrix.getMatrix(nArray3, nArray3);
        Matrix matrix6 = matrix3.getMatrix(nArray3, nArray3);
        String[] stringArray2 = new String[n13];
        for (int i = 0; i < n13; ++i) {
            stringArray2[i] = String.format("A%d: R%d*%s(%d)", this.PNAOs[nArray3[i]].Center_ID, this.PNAOs[nArray3[i]].RadialPart_ID + 1, Character.valueOf("spdfg".charAt(this.PNAOs[nArray3[i]].L)), this.PNAOs[nArray3[i]].m);
        }
        printout.Print_Matrix(matrix5, "NMB_old overlap:", stringArray2, stringArray2, this.options.NMB_old_Overlap_Matrix_File.get_String());
        printout.Print_Matrix(matrix6, "NMB_old SDS:", stringArray2, stringArray2, this.options.NMB_old_SDS_Matrix_File.get_String());
        Matrix matrix7 = new Matrix(n13, n13, 0.0);
        double d2 = this.PNAOs[nArray3[0]].weight;
        for (n10 = 0; n10 < n13; ++n10) {
            d = this.PNAOs[nArray3[n10]].weight;
            if (d < d2) {
                d2 = d;
            }
            for (n9 = n10; n9 < n13; ++n9) {
                double d3 = this.PNAOs[nArray3[n9]].weight;
                double d4 = matrix5.get(n10, n9) * d * d3;
                matrix7.set(n10, n9, d4);
                matrix7.set(n9, n10, d4);
            }
        }
        out.println(" min weight of NMB PNAO = " + d2);
        matrix7 = this.ee.Matrix_minus05(matrix7);
        for (n10 = 0; n10 < n13; ++n10) {
            d = this.PNAOs[nArray3[n10]].weight;
            for (n9 = 0; n9 < n13; ++n9) {
                matrix4.set(nArray3[n9], nArray3[n10], d * matrix7.get(n10, n9));
            }
        }
        Matrix matrix8 = this.ee.TransformMatrixToNewBasis(this.PNAO_Overlap_Matrix, matrix4, true);
        Matrix matrix9 = this.ee.TransformMatrixToNewBasis(matrix3, matrix4, true);
        if (this.verbose_print) {
            out.println("Weights of NMB PNAOs:");
            double d5 = 0.0;
            for (int i = 0; i < nArray3.length; ++i) {
                d5 += matrix9.get(nArray3[i], nArray3[i]);
                out.printf("%4d\t%4d\t%.15f%n", i, nArray3[i], matrix9.get(nArray3[i], nArray3[i]));
            }
            out.printf("sum of NMB weights = %.10f %n", d5);
        }
        out.printf("%nSTEP 4. Schmidt orthogonalization of NRBs to new NMBs%n%n", new Object[0]);
        BasisFunction[] basisFunctionArray = new BasisFunction[n12];
        for (n9 = 0; n9 < basisFunctionArray.length; ++n9) {
            basisFunctionArray[n9] = new BasisFunction(this.PNAOs[nArray4[n9]].L, this.PNAOs[nArray4[n9]].m, null, this.PNAOs.length);
            basisFunctionArray[n9].Center_ID = this.PNAOs[nArray4[n9]].Center_ID;
            basisFunctionArray[n9].RadialPart_ID = this.PNAOs[nArray4[n9]].RadialPart_ID;
            basisFunctionArray[n9].coefs[nArray4[n9]] = 1.0;
            basisFunctionArray[n9].NRB = true;
        }
        for (n9 = 0; n9 < basisFunctionArray.length; ++n9) {
            for (int i = 0; i < n13; ++i) {
                int n21 = nArray3[i];
                basisFunctionArray[n9].coefs[n21] = basisFunctionArray[n9].coefs[n21] - matrix8.get(nArray3[i], nArray4[n9]);
            }
        }
        Matrix matrix10 = new Matrix(this.PNAOs.length, this.PNAOs.length, 0.0);
        for (n8 = 0; n8 < n12; ++n8) {
            for (n7 = 0; n7 < this.PNAOs.length; ++n7) {
                matrix10.set(nArray4[n8], n7, basisFunctionArray[n8].coefs[n7]);
            }
        }
        for (n8 = 0; n8 < n13; ++n8) {
            matrix10.set(nArray3[n8], nArray3[n8], 1.0);
        }
        matrix8 = this.ee.TransformMatrixToNewBasis(matrix8, matrix10, true);
        matrix9 = this.ee.TransformMatrixToNewBasis(matrix9, matrix10, true);
        if (this.verbose_print) {
            out.println("Diagonal elements of SDS matrix after 1-st Schmidt transformation for new NRB functions:");
            double d6 = 0.0;
            for (int i = 0; i < nArray4.length; ++i) {
                d6 += matrix9.get(nArray4[i], nArray4[i]);
                out.printf("%4d\t%4d\t%.15f%n", i, nArray4[i], matrix9.get(nArray4[i], nArray4[i]));
            }
            out.printf("Sum of NRB 'occupancies' = %.10f %n", d6);
        }
        out.printf("%nSTEP 5. Intracenter naturalization of new NRBs%n%n", new Object[0]);
        Matrix matrix11 = new Matrix(this.PNAOs.length, this.PNAOs.length, 0.0);
        for (n7 = 0; n7 < n13; ++n7) {
            matrix11.set(nArray3[n7], nArray3[n7], 1.0);
        }
        String[] stringArray3 = NPA.Create_NAO_Labels(basisFunctionArray);
        Matrix matrix12 = matrix8.getMatrix(nArray4, nArray4);
        Matrix matrix13 = matrix9.getMatrix(nArray4, nArray4);
        printout.Print_Matrix(matrix12, "NRB_old overlap:", stringArray3, stringArray3, this.options.NRB_old_Overlap_Matrix_File.get_String());
        BasisFunction[] basisFunctionArray2 = this.IntracenterBasisOrthogonalization(basisFunctionArray, this.Centers.length, matrix13, matrix12);
        String[] stringArray4 = NPA.Create_NAO_Labels(basisFunctionArray2);
        Matrix matrix14 = NPA.BasisFunctionsToMatrix(basisFunctionArray2, false);
        Matrix matrix15 = this.ee.TransformMatrixToNewBasis(matrix12, matrix14, true);
        printout.Print_Matrix(matrix15, "NRB_new overlap:", stringArray3, stringArray3, this.options.NRB_new_Overlap_Matrix_File.get_String());
        for (int i = 0; i < n12; ++i) {
            for (n6 = 0; n6 < n12; ++n6) {
                matrix11.set(nArray4[i], nArray4[n6], basisFunctionArray2[i].coefs[n6]);
            }
        }
        matrix8 = this.ee.TransformMatrixToNewBasis(matrix8, matrix11, true);
        printout.Print_Matrix(matrix8, "Overlap_new", this.PNAO_Labels, this.PNAO_Labels, this.options.S_Matrix_after_ON2_File.get_String());
        matrix9 = this.ee.TransformMatrixToNewBasis(matrix9, matrix11, true);
        printout.Print_Matrix(matrix9, "SDS_new", this.PNAO_Labels, this.PNAO_Labels, this.options.SDS_Matrix_after_ON2_File.get_String());
        if (this.verbose_print) {
            out.println(" NMB and NRB weights and occupancies after intracenter naturalization of NRBs");
            double d7 = 0.0;
            out.println("LocNum.\tGlobNum.\t<phi|SDS|phi>");
            for (n5 = 0; n5 < nArray3.length; ++n5) {
                d7 += matrix9.get(nArray3[n5], nArray3[n5]);
                out.printf("%4d\t%4d\t%.10f%n", n5, nArray3[n5], matrix9.get(nArray3[n5], nArray3[n5]));
            }
            out.printf("Sum of NMB SDS diagonal terms = %.10f %n", d7);
            d7 = 0.0;
            out.println("LocNum.\tGlobNum.\t<phi|SDS|phi>\tweight\tNRB label");
            for (n5 = 0; n5 < nArray4.length; ++n5) {
                d7 += matrix9.get(nArray4[n5], nArray4[n5]);
                out.printf("%4d\t%4d\t%.10f\t%.10f\t%s%n", n5, nArray4[n5], matrix9.get(nArray4[n5], nArray4[n5]), basisFunctionArray2[n5].weight, this.PNAO_Labels[nArray4[n5]]);
            }
            out.printf("Sum of NRB SDS diagonal terms = %.10f %n", d7);
        }
        out.printf("%nSTEP 6. Weighted orthogonalization of naturalized NRBs%n%n", new Object[0]);
        Matrix matrix16 = new Matrix(this.PNAOs.length, this.PNAOs.length, 0.0);
        for (n6 = 0; n6 < n13; ++n6) {
            matrix16.set(nArray3[n6], nArray3[n6], 1.0);
        }
        Matrix matrix17 = null;
        n5 = this.options.NRB_OW_Straightforward.get_boolean() ? 1 : 0;
        double d8 = this.options.Heavy_NRB_Threshold.get_double();
        if (n5 != 0) {
            if (this.verbose_print) {
                out.println("Using a direct WSW orthogonalization for all NRB functions.");
            }
            matrix = new Matrix(n12, n12, 0.0);
            d2 = n12 > 0 ? basisFunctionArray2[0].weight : 0.0;
            for (int i = 0; i < n12; ++i) {
                matrix.set(i, i, basisFunctionArray2[i].weight);
                if (!(basisFunctionArray2[i].weight < d2)) continue;
                d2 = basisFunctionArray2[i].weight;
            }
            out.println(" min weight = " + d2);
            stringArray = new Matrix(n12, n12, 0.0);
            for (n4 = 0; n4 < n12; ++n4) {
                for (n3 = 0; n3 < n12; ++n3) {
                    double d9 = basisFunctionArray2[n4].weight * matrix15.get(n4, n3) * basisFunctionArray2[n3].weight;
                    stringArray.set(n4, n3, d9);
                }
            }
            matrix17 = matrix.times(this.ee.Matrix_minus05((Matrix)stringArray));
        } else {
            int n22;
            int n23;
            if (this.verbose_print) {
                out.printf("Using a WSWSL orthogonalization for NRB functions with occ. Threshold = %.3E%n", d8);
            }
            double d10 = 0.0;
            for (n4 = 0; n4 < n12; ++n4) {
                if (!(basisFunctionArray2[n4].weight > d10)) continue;
                d10 = basisFunctionArray2[n4].weight;
            }
            out.printf("Maximum weight of NRB function = %.5E%n", d10);
            n4 = 0;
            n3 = 0;
            d2 = n12 > 0 ? basisFunctionArray2[0].weight : 0.0;
            for (int i = 0; i < n12; ++i) {
                if (basisFunctionArray2[i].weight > d8) {
                    ++n4;
                } else {
                    ++n3;
                }
                if (!(basisFunctionArray2[i].weight < d2)) continue;
                d2 = basisFunctionArray2[i].weight;
            }
            out.println(" min weight = " + d2);
            if (this.verbose_print) {
                out.printf("'Heavily occupied NRB set' has %d of %d functions%n", n4, n12);
            }
            int[] nArray5 = new int[n4];
            int[] nArray6 = new int[n3];
            object = new Matrix(n4, n4, 0.0);
            n4 = 0;
            n3 = 0;
            for (int i = 0; i < n12; ++i) {
                if (basisFunctionArray2[i].weight > d8) {
                    nArray5[n4] = i;
                    ((Matrix)object).set(n4, n4, basisFunctionArray2[i].weight);
                    ++n4;
                    continue;
                }
                nArray6[n3++] = i;
            }
            Matrix matrix18 = matrix15.getMatrix(nArray5, nArray5);
            Matrix matrix19 = new Matrix(n4, n4, 0.0);
            for (int i = 0; i < n4; ++i) {
                for (n23 = i; n23 < n4; ++n23) {
                    double d11 = matrix15.get(nArray5[i], nArray5[n23]);
                    matrix19.set(i, n23, d11 *= basisFunctionArray2[nArray5[i]].weight * basisFunctionArray2[nArray5[n23]].weight);
                    matrix19.set(n23, i, d11);
                }
            }
            Matrix matrix20 = ((Matrix)object).times(this.ee.Matrix_minus05(matrix19));
            matrix17 = new Matrix(n12, n12, 0.0);
            matrix17.setMatrix(nArray5, nArray5, matrix20);
            for (n23 = 0; n23 < n3; ++n23) {
                matrix17.set(nArray6[n23], nArray6[n23], 1.0);
            }
            Matrix matrix21 = this.ee.TransformMatrixToNewBasis(matrix15, matrix17.transpose(), true);
            printout.Print_Matrix(matrix21, "new_NRB_Overlap before Schmidt", null, null, this.options.NRB_Overlap_after_OW_heavy_File.get_String());
            Matrix matrix22 = new Matrix(n12, n12, 0.0);
            for (n22 = 0; n22 < n12; ++n22) {
                matrix22.set(n22, n22, 1.0);
            }
            for (n22 = 0; n22 < n3; ++n22) {
                for (int i = 0; i < n4; ++i) {
                    double d12 = matrix22.get(nArray6[n22], nArray5[i]);
                    matrix22.set(nArray6[n22], nArray5[i], d12 -= matrix21.get(nArray6[n22], nArray5[i]));
                }
            }
            matrix17 = matrix17.times(matrix22.transpose());
            matrix21 = this.ee.TransformMatrixToNewBasis(matrix15, matrix17.transpose(), true);
            printout.Print_Matrix(matrix21, "new_NRB_Overlap after Schmidt", null, null, this.options.NRB_Overlap_after_OS2_File.get_String());
            if (n3 > 0) {
                Matrix matrix23 = matrix21.getMatrix(nArray6, nArray6);
                Matrix matrix24 = this.ee.Matrix_minus05(matrix23);
                Matrix matrix25 = new Matrix(n12, n12, 0.0);
                for (int i = 0; i < n12; ++i) {
                    matrix25.set(i, i, 1.0);
                }
                matrix25.setMatrix(nArray6, nArray6, matrix24);
                matrix17 = matrix17.times(matrix25.transpose());
            }
        }
        matrix = this.ee.TransformMatrixToNewBasis(matrix15, matrix17.transpose(), true);
        printout.Print_Matrix(matrix, "NRB new overlap", null, null, this.options.NRB_Overlap_after_OW2_final_File.get_String());
        out.printf(" |S_NRB - 1| = %.5E (Should be VERY close to zero!)%n", Math.sqrt(this.NonUnitary_Norm2(matrix)));
        matrix16.setMatrix(nArray4, nArray4, matrix17.transpose());
        stringArray = NPA.Create_NAO_Labels(this.Basis);
        printout.Print_Matrix(matrix16, "2-nd WSW transformation matrix:", null, stringArray, this.options.OW2_File.get_String());
        matrix8 = this.ee.TransformMatrixToNewBasis(matrix8, matrix16, true);
        printout.Print_Matrix(matrix8, "Overlap matrix in almost-NAO basis (obtained after OW2 step):", this.PNAO_Labels, this.PNAO_Labels, this.options.S_Matrix_after_OW2_File.get_String());
        matrix9 = this.ee.TransformMatrixToNewBasis(matrix9, matrix16, true);
        printout.Print_Matrix(matrix9, "SDS matrix in almost-NAO basis (obtained after OW2 step):", this.PNAO_Labels, this.PNAO_Labels, this.options.SDS_Matrix_after_OW2_File.get_String());
        if (this.verbose_print) {
            out.println("Diagonal elements of SDS before the final intracenter naturalization step:");
            for (n4 = 0; n4 < this.Centers.length; ++n4) {
                double d13 = 0.0;
                for (int i = 0; i < this.Basis.length; ++i) {
                    if (this.PNAOs[i].Center_ID - 1 != n4) continue;
                    d13 += matrix9.get(i, i);
                }
                out.printf("center %d: %.4f\n", n4 + 1, d13);
            }
        }
        out.printf("%nSTEP 7. Final Intracenter Natural Transformation withing the full set of functions%n%n", new Object[0]);
        this.options.dont_print_matrices = false;
        this.NAO = this.IntracenterBasisOrthogonalization(this.PNAOs, this.Centers.length, matrix9, matrix8);
        Matrix matrix26 = NPA.BasisFunctionsToMatrix(this.NAO, false);
        Matrix matrix27 = matrix26.times(matrix16).times(matrix11).times(matrix10).times(matrix4);
        this.NAO_2_AO = matrix27.times(matrix2);
        this.Overlap_NAO = this.ee.TransformMatrixToNewBasis(matrix8, matrix26, true);
        double d14 = this.NonUnitary_Norm2(this.Overlap_NAO);
        out.printf(" SQRT{ SUM[(NaoOverlap_ij - delta_ij)^2] } = %.2e (should be VERY close to zero) %n", Math.sqrt(d14));
        out.printf(" max_offdiag = %.2e (should be VERY close to zero) %n", NPA.max_offdiag(this.Overlap_NAO));
        if (Math.sqrt(d14) > 1.0E-10) {
            WarningManager.warning_printf(" WARNING: NAOs seem to be not strictly orthogonalized!", new Object[0]);
        }
        this.SDS_NAO = this.ee.TransformMatrixToNewBasis(matrix9, matrix26, true);
        out.println(printout.Stars);
        out.printf("%n Final NAO occupancies and leading AO terms:%n%n", new Object[0]);
        object = new double[this.NAO.length];
        out.printf("%5s %20s %10s %40s%n", "NAO #", "Name", "Occupancy", "Leading term");
        for (n2 = 0; n2 < this.NAO.length; ++n2) {
            object[n2] = this.NAO[n2].weight;
            this.NAO[n2].weight = this.SDS_NAO.get(n2, n2);
            this.NAO[n2].NRB = this.PNAOs[n2].NRB;
            out.printf("%5d %20s %10.7f ", n2 + 1, this.PNAO_Labels[n2], this.NAO[n2].weight);
            int n24 = 0;
            for (int i = 0; i < this.Basis.length; ++i) {
                if (!(Math.abs(this.NAO_2_AO.get(n2, i)) > Math.abs(this.NAO_2_AO.get(n2, n24)))) continue;
                n24 = i;
            }
            double d15 = this.NAO_2_AO.get(n2, n24);
            out.printf("%40s", String.format("(%.2f)*BF[%d = %s]", d15, n24 + 1, this.AO_Names[n24]));
            out.printf("%n", new Object[0]);
        }
        printout.Print_Matrix(this.SDS_NAO, " S.D.S in NAO basis:", this.PNAO_Labels, this.PNAO_Labels, this.options.SDS_NAO_File.get_String());
        printout.Print_Matrix(this.NAO_2_AO, "AO-to-NAO transformation matrix:", this.PNAO_Labels, this.AO_Names, this.options.NAO2AO_File.get_String());
        out.println(" trace = " + this.SDS_NAO.trace());
        out.printf("%nFinal electron populations and NPA charges:%n%n", new Object[0]);
        out.println("Center\tNuclear\t Electron  \t  NMB       \tNPA   ");
        out.println("      \t charge\t population\t  population\tcharge");
        this.NPA_charges = new double[this.Centers.length];
        for (n2 = 0; n2 < this.Centers.length; ++n2) {
            double d16 = 0.0;
            double d17 = 0.0;
            for (int i = 0; i < this.Basis.length; ++i) {
                if (this.NAO[i].Center_ID - 1 != n2) continue;
                d16 += this.NAO[i].weight;
                if (this.NAO[i].NRB) continue;
                d17 += this.NAO[i].weight;
            }
            this.NPA_charges[n2] = this.Centers[n2].Z - d16;
            out.printf("%5s\t%7.1f\t%11.7f\t%12.7f\t%13.10f\n", String.format("%s%d", this.Centers[n2].Name, n2 + 1), this.Centers[n2].Z, d16, d17, this.Centers[n2].Z - d16);
        }
        out.println();
        out.printf("Angular momentum contributions of the total atomic population:%n%n", new Object[0]);
        out.print("   Cntr");
        double[] dArray = new double[5];
        for (n = 0; n < dArray.length; ++n) {
            out.printf("%12s", Character.valueOf("spdfghijklmnopqrs".charAt(n)));
        }
        out.println();
        for (n = 0; n < this.Centers.length; ++n) {
            int n25;
            for (n25 = 0; n25 < dArray.length; ++n25) {
                dArray[n25] = 0.0;
            }
            for (n25 = 0; n25 < this.Basis.length; ++n25) {
                if (this.NAO[n25].Center_ID - 1 != n) continue;
                int n26 = this.NAO[n25].L;
                dArray[n26] = dArray[n26] + this.NAO[n25].weight;
            }
            out.printf("%7s", String.format("%s%d", this.Centers[n].Name, n + 1));
            for (n25 = 0; n25 < dArray.length; ++n25) {
                out.printf("%12.7f", dArray[n25]);
            }
            out.println();
        }
        out.println();
        return true;
    }

    public static Matrix BondIndexes_Generic(int n, BasisFunction[] basisFunctionArray, Matrix matrix) {
        int n2;
        int n3;
        Matrix matrix2 = new Matrix(n, n, 0.0);
        double[][] dArray = matrix2.getArray();
        for (n3 = 0; n3 < basisFunctionArray.length; ++n3) {
            for (n2 = n3 + 1; n2 < basisFunctionArray.length; ++n2) {
                double[] dArray2 = dArray[basisFunctionArray[n3].Center_ID - 1];
                int n4 = basisFunctionArray[n2].Center_ID - 1;
                dArray2[n4] = dArray2[n4] + matrix.get(n3, n2) * matrix.get(n2, n3);
            }
        }
        for (n3 = 0; n3 < n; ++n3) {
            for (n2 = n3 + 1; n2 < n; ++n2) {
                dArray[n2][n3] = dArray[n3][n2];
            }
        }
        for (n3 = 0; n3 < n; ++n3) {
            double d = 0.0;
            dArray[n3][n3] = 0.0;
            for (int i = 0; i < n; ++i) {
                d += dArray[n3][i];
            }
            dArray[n3][n3] = d;
        }
        return matrix2;
    }

    public Matrix BondIndexes() {
        return NPA.BondIndexes_Generic(this.Centers.length, this.NAO, this.SDS_NAO);
    }

    public void MutualDensities() {
        out.printf("NAO-atoms contributions to the densities @ nuclei:%n", new Object[0]);
        for (int i = 0; i < this.Centers.length; ++i) {
            double[] dArray = this.Centers[i].R0;
            double[] dArray2 = new double[this.Basis.length];
            for (int j = 0; j < this.Basis.length; ++j) {
                this.Basis[j].Quick_YLM = this.Quick_YLM;
                dArray2[j] = this.Basis[j].EvaluateAtPoint(dArray, this.Basis[j].R0);
            }
            double[] dArray3 = new double[this.NAO.length];
            for (int j = 0; j < this.NAO.length; ++j) {
                dArray3[j] = 0.0;
                for (int k = 0; k < this.Basis.length; ++k) {
                    int n = j;
                    dArray3[n] = dArray3[n] + this.NAO_2_AO.get(j, k) * dArray2[k];
                }
            }
            out.printf("Nucleus %3d:", i + 1);
            double d = 0.0;
            for (int j = 0; j < this.Centers.length; ++j) {
                double d2 = 0.0;
                for (int k = 0; k < this.NAO.length; ++k) {
                    if (this.NAO[k].Center_ID != j + 1) continue;
                    for (int i2 = 0; i2 < this.Basis.length; ++i2) {
                        if (this.NAO[i2].Center_ID != j + 1) continue;
                        d2 += this.SDS_NAO.get(k, i2) * dArray3[k] * dArray3[i2];
                    }
                }
                out.printf("\t%.5f", d2);
                d += d2;
            }
            out.printf("\t|\t%.5f%n", d);
        }
    }
}

