/*
 * Decompiled with CFR 0.152.
 */
package moldenio;

import JGints.AtomicCenter;
import JGints.BasisFunction;
import JGints.MO;
import JGints.OverlapIntegrals;
import JGints.RadialPartOfBasisFunction;
import ProgramOptions.WarningManager;
import java.io.BufferedReader;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.EOFException;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.PrintStream;
import java.io.PrintWriter;

public class MOLDEN_IO {
    public PrintStream out = System.out;
    private final boolean debugPrint = false;
    public boolean IsSpherical = false;
    public BasisFunction[] Basis;
    private BasisFunction FirstBasisFunction = null;
    private int NBasisFunctions = 0;
    public int HighestL = 0;
    public final String spdf = "spdfg";
    public RadialPartOfBasisFunction[] RadialParts = null;
    public boolean Allow_additional_r_power = false;
    public String Title = null;
    public MO[] MOs;
    private MO FirstMO = null;
    public boolean Coords_in_AU = false;
    public AtomicCenter[] Centers;
    private AtomicCenter FirstAtom = null;
    private boolean use_5D = false;
    private boolean use_7F = false;
    private boolean use_9G = false;
    private final int section_unknown = -1;
    private final int section_MOLDEN = 0;
    private final int section_Title = 1;
    private final int section_Atoms = 2;
    private final int section_GTO = 3;
    private final int section_MO = 4;
    private final int section_5D = 5;
    private final int section_5D7F = 6;
    private final int section_9G = 7;
    public final int[] CartesianHarmonicsCount = new int[]{1, 3, 6, 10, 15};
    public final int[] First_Cart_m_for_L = new int[]{0, 1, 4, 10, 20};
    public boolean print_MO_info = false;
    public String MOCoefLineFormat = "%3d %20.12f%n";
    final int bmolden_section_FLAGS = 1;
    final int bmolden_section_GEOMETRY = 2;
    final int bmolden_section_BASIS = 3;
    final int bmolden_section_MO = 4;
    final int bmolden_flagID_CoordsAUAngstrs = 11;
    final int bmolden_flagID_5D = 23;
    final int bmolden_flagID_7F = 24;
    final int bmolden_flagID_9G = 25;
    static final String bmoldeng_signature = "BMOLDENG";
    public static final double BohrRadius = 0.52917721092;

    public void _RadialParts_Alloc(int n) {
        this.RadialParts = new RadialPartOfBasisFunction[n];
    }

    private int _Parse_Section_ID(String string) {
        if ((string = string.toUpperCase()).contains("[MOLDEN FORMAT]")) {
            return 0;
        }
        if (string.contains("[TITLE]")) {
            return 1;
        }
        if (string.contains("[ATOMS]")) {
            return 2;
        }
        if (string.contains("[GTO]")) {
            return 3;
        }
        if (string.contains("[MO]")) {
            return 4;
        }
        if (string.contains("[5D]")) {
            return 5;
        }
        if (string.contains("[5D7F]")) {
            return 6;
        }
        if (string.contains("[9G]")) {
            return 7;
        }
        return -1;
    }

    private void _BS_List_To_Array() throws Exception {
        int n = 0;
        BasisFunction basisFunction = this.FirstBasisFunction;
        while (basisFunction != null) {
            if (basisFunction.L != -1) {
                this.NBasisFunctions = this.IsSpherical ? (this.NBasisFunctions += 2 * basisFunction.L + 1) : (this.NBasisFunctions += this.CartesianHarmonicsCount[basisFunction.L]);
            } else {
                throw new Exception("SP shells are not supported!");
            }
            basisFunction.RadialPart_ID = n++;
            basisFunction = basisFunction._next;
        }
        this.out.printf("Total number of basis functions: %d\n", this.NBasisFunctions);
        this.out.printf("Total number of different contractions (radial parts): %d\n", n);
        this.out.printf("Highest angular momentum: %s (Lmax = %d)\n", (new String[]{"s", "p", "d", "f", "g"})[this.HighestL], this.HighestL);
        this.Basis = new BasisFunction[this.NBasisFunctions];
        this._RadialParts_Alloc(n);
        basisFunction = this.FirstBasisFunction;
        int n2 = 0;
        while (basisFunction != null) {
            this.RadialParts[n2] = new RadialPartOfBasisFunction();
            this.RadialParts[n2].Exponents = (double[])basisFunction.exponents.clone();
            this.RadialParts[n2].Coefs = (double[])basisFunction.coefs.clone();
            this.RadialParts[n2].CenterID = basisFunction.Center_ID;
            this.RadialParts[n2].LUsedWith = basisFunction.L;
            this.RadialParts[n2].Addit_r_power = basisFunction.additional_r_power;
            ++n2;
            basisFunction = basisFunction._next;
        }
        basisFunction = this.FirstBasisFunction;
        n2 = 0;
        while (basisFunction != null) {
            this.Basis[n2] = basisFunction;
            ++n2;
            if (basisFunction.L != -1) {
                int n3;
                if (this.IsSpherical) {
                    for (n3 = 1; n3 <= basisFunction.L; ++n3) {
                        this.Basis[n2] = new BasisFunction(basisFunction);
                        this.Basis[n2].m = n3;
                        this.Basis[++n2] = new BasisFunction(basisFunction);
                        this.Basis[n2].m = -n3;
                        ++n2;
                    }
                }
                if (!this.IsSpherical) {
                    basisFunction.m = this.First_Cart_m_for_L[basisFunction.L];
                    n3 = this.First_Cart_m_for_L[basisFunction.L] + 1;
                    while (n3 < this.First_Cart_m_for_L[basisFunction.L] + this.CartesianHarmonicsCount[basisFunction.L]) {
                        this.Basis[n2] = new BasisFunction(basisFunction);
                        this.Basis[n2].m = n3++;
                        ++n2;
                    }
                }
            } else {
                throw new Exception("sp shells are not supported!");
            }
            BasisFunction basisFunction2 = basisFunction._next;
            basisFunction._next = null;
            basisFunction = basisFunction2;
        }
    }

    public boolean Load_From_MOLDEN(String string) throws Exception {
        int n;
        int n2;
        String string2;
        FileReader fileReader = new FileReader(string);
        BufferedReader bufferedReader = new BufferedReader(fileReader, 32768);
        this.Title = new String();
        AtomicCenter atomicCenter = null;
        BasisFunction basisFunction = null;
        BasisFunction basisFunction2 = null;
        int n3 = -1;
        int n4 = 0;
        MO mO = null;
        int n5 = 0;
        int n6 = 0;
        if (!bufferedReader.readLine().toUpperCase().contains("[MOLDEN FORMAT]")) {
            return false;
        }
        while ((string2 = bufferedReader.readLine()) != null) {
            boolean bl = false;
            switch (n3) {
                case 1: {
                    bl = string2.contains("[");
                    if (bl) break;
                    this.Title = this.Title + string2;
                    break;
                }
                case 2: {
                    bl = string2.contains("[");
                    if (bl) break;
                    String[] stringArray = string2.trim().split(" +");
                    atomicCenter = this.FirstAtom == null ? (this.FirstAtom = new AtomicCenter()) : (atomicCenter._next = new AtomicCenter());
                    atomicCenter.Name = stringArray[0];
                    atomicCenter.ID = Integer.parseInt(stringArray[1]);
                    atomicCenter.Z = Double.parseDouble(stringArray[2]);
                    for (n2 = 0; n2 < 3; ++n2) {
                        atomicCenter.R0[n2] = Double.parseDouble(stringArray[3 + n2]);
                    }
                    break;
                }
                case 3: {
                    bl = string2.contains("[");
                    if (bl || string2.trim().equals("")) break;
                    String[] stringArray = string2.trim().split(" +");
                    n4 = Integer.parseInt(stringArray[0]);
                    while ((string2 = bufferedReader.readLine()) != null & !string2.trim().equals("")) {
                        stringArray = string2.trim().split(" +");
                        n2 = 0;
                        if (stringArray[0].toLowerCase().matches("[a-z]+[0-9]+")) {
                            if (!this.Allow_additional_r_power) {
                                throw new Exception("Extended molden command found (" + stringArray[0] + ") but Allow_additional_r_power is false.");
                            }
                            String[] stringArray2 = stringArray[0].toLowerCase().split("[a-z]+");
                            n2 = Integer.parseInt(stringArray2[1]);
                            stringArray[0] = stringArray[0].split("[0-9]+")[0];
                        }
                        n6 = -2;
                        if (stringArray[0].toLowerCase().equals("s")) {
                            n6 = 0;
                        } else if (stringArray[0].toLowerCase().equals("p")) {
                            n6 = 1;
                        } else if (stringArray[0].toLowerCase().equals("d")) {
                            n6 = 2;
                        } else if (stringArray[0].toLowerCase().equals("f")) {
                            n6 = 3;
                        } else if (stringArray[0].toLowerCase().equals("g")) {
                            n6 = 4;
                        } else if (stringArray[0].toLowerCase().equals("sp")) {
                            n6 = -1;
                        }
                        n5 = Integer.parseInt(stringArray[1]);
                        basisFunction2 = new BasisFunction(n6, 0, this.Centers[n4 - 1].R0, n5);
                        basisFunction2.Center_ID = n4;
                        basisFunction2.additional_r_power = n2;
                        basisFunction = basisFunction == null ? (this.FirstBasisFunction = basisFunction2) : (basisFunction._next = basisFunction2);
                        if (n6 == -1) {
                            basisFunction2.L = 0;
                            basisFunction2.m = 0;
                            basisFunction = basisFunction._next = new BasisFunction(basisFunction2);
                            basisFunction.L = 1;
                            if (this.HighestL < 1) {
                                this.HighestL = 1;
                            }
                        } else if (this.HighestL < n6) {
                            this.HighestL = n6;
                        }
                        for (n = 0; n < n5; ++n) {
                            string2 = bufferedReader.readLine();
                            stringArray = string2.trim().toUpperCase().replace("D", "E").split(" +");
                            if (n6 == -1) {
                                basisFunction.exponents[n] = basisFunction2.exponents[n] = Double.parseDouble(stringArray[0]);
                                basisFunction2.coefs[n] = Double.parseDouble(stringArray[1]);
                                basisFunction.coefs[n] = Double.parseDouble(stringArray[2]);
                                continue;
                            }
                            basisFunction.exponents[n] = Double.parseDouble(stringArray[0]);
                            basisFunction.coefs[n] = Double.parseDouble(stringArray[1]);
                        }
                    }
                    break;
                }
                case 4: {
                    String[] stringArray;
                    n2 = 0;
                    bl = string2.contains("[");
                    if (bl) break;
                    n = 0;
                    while (n == 0) {
                        mO = this.FirstMO == null ? (this.FirstMO = new MO()) : (mO._next = new MO());
                        ++n2;
                        mO.BS_Coefs = new double[this.Basis.length];
                        while (string2 != null && string2.contains("=")) {
                            String string3 = string2.toLowerCase();
                            if (string3.contains("ene=")) {
                                mO.Energy = Double.parseDouble(string3.split("=")[1].trim());
                            } else if (string3.contains("occup=")) {
                                mO.Occupancy = Double.parseDouble(string3.split("=")[1].trim());
                            }
                            if (string3.contains("spin=")) {
                                if (string3.contains("alpha")) {
                                    mO.Spin = 1;
                                }
                                if (string3.contains("beta")) {
                                    mO.Spin = -1;
                                }
                            }
                            string2 = bufferedReader.readLine();
                        }
                        if (this.print_MO_info) {
                            this.out.printf("MO %d: Energy = %.7f, Occupancy = %.7f\n", n2, mO.Energy, mO.Occupancy);
                        }
                        while (string2 != null && !string2.contains("=")) {
                            stringArray = string2.trim().split(" +");
                            mO.BS_Coefs[Integer.parseInt((String)stringArray[0]) - 1] = Double.parseDouble(stringArray[1]);
                            string2 = bufferedReader.readLine();
                            n = string2 == null ? 1 : 0;
                            if (n != 0) continue;
                            bl = string2.contains("[");
                            n = bl ? 1 : 0;
                        }
                    }
                    break;
                }
                default: {
                    bl = string2.contains("[");
                }
            }
            if (!bl) continue;
            switch (n3) {
                case 2: {
                    n2 = 0;
                    atomicCenter = this.FirstAtom;
                    while (atomicCenter != null) {
                        ++n2;
                        atomicCenter = atomicCenter._next;
                    }
                    this.Centers = new AtomicCenter[n2];
                    atomicCenter = this.FirstAtom;
                    for (n = 0; n < n2; ++n) {
                        this.Centers[n] = atomicCenter;
                        atomicCenter = this.Centers[n]._next;
                    }
                    break;
                }
            }
            n3 = this._Parse_Section_ID(string2);
            switch (n3) {
                case 5: 
                case 6: {
                    this.use_5D = true;
                    this.use_7F = true;
                    n3 = -1;
                    break;
                }
                case 7: {
                    this.use_9G = true;
                    n3 = -1;
                    break;
                }
                case 2: {
                    this.Coords_in_AU = string2.toUpperCase().contains("AU");
                    break;
                }
                case 4: {
                    this.IsSpherical = this.use_5D & this.use_7F;
                    if (this.HighestL >= 4) {
                        this.IsSpherical &= this.use_9G;
                    }
                    this.out.println("Basis functions are spherical: " + this.IsSpherical);
                    this._BS_List_To_Array();
                    break;
                }
                case 0: {
                    break;
                }
                case -1: {
                    WarningManager.warning_printf("WARNING: section \"%s\" is not supported!%n", string2);
                }
            }
        }
        bufferedReader.close();
        fileReader.close();
        if (this.FirstMO == null) {
            return false;
        }
        if (this.Basis == null) {
            return false;
        }
        n2 = 0;
        mO = this.FirstMO;
        while (mO != null) {
            ++n2;
            mO = mO._next;
        }
        this.out.printf("Total number of MO: %d\n", n2);
        this.MOs = new MO[n2];
        mO = this.FirstMO;
        for (n = 0; n < n2; ++n) {
            this.MOs[n] = mO;
            mO = this.MOs[n]._next;
        }
        return true;
    }

    public boolean CopyAllFrom(MOLDEN_IO mOLDEN_IO) {
        int n;
        this.IsSpherical = mOLDEN_IO.IsSpherical;
        this.Basis = new BasisFunction[mOLDEN_IO.Basis.length];
        for (n = 0; n < this.Basis.length; ++n) {
            this.Basis[n] = new BasisFunction(mOLDEN_IO.Basis[n]);
        }
        this.NBasisFunctions = mOLDEN_IO.NBasisFunctions;
        this.HighestL = mOLDEN_IO.HighestL;
        this.Allow_additional_r_power = mOLDEN_IO.Allow_additional_r_power;
        this.RadialParts = new RadialPartOfBasisFunction[mOLDEN_IO.RadialParts.length];
        for (n = 0; n < this.RadialParts.length; ++n) {
            this.RadialParts[n] = mOLDEN_IO.RadialParts[n].CreateClone();
        }
        this.Title = new String(mOLDEN_IO.Title);
        this.MOs = new MO[mOLDEN_IO.MOs.length];
        for (n = 0; n < this.MOs.length; ++n) {
            this.MOs[n] = new MO(mOLDEN_IO.MOs[n]);
        }
        this.Coords_in_AU = mOLDEN_IO.Coords_in_AU;
        this.Centers = new AtomicCenter[mOLDEN_IO.Centers.length];
        for (n = 0; n < this.Centers.length; ++n) {
            this.Centers[n] = new AtomicCenter(mOLDEN_IO.Centers[n]);
        }
        this.use_5D = mOLDEN_IO.use_5D;
        this.use_7F = mOLDEN_IO.use_7F;
        this.use_9G = mOLDEN_IO.use_9G;
        return true;
    }

    public void ToUnnormalizedPrimitiveCoefs() {
        for (int i = 0; i < this.RadialParts.length; ++i) {
            int n = this.RadialParts[i].LUsedWith;
            for (int j = 0; j < this.RadialParts[i].Coefs.length; ++j) {
                if (this.RadialParts[i].Addit_r_power != 0) {
                    int n2 = j;
                    this.RadialParts[i].Coefs[n2] = this.RadialParts[i].Coefs[n2] / Math.sqrt(OverlapIntegrals.primitive_int_1D_Sphr(2 * n + 2 + 2 * this.RadialParts[i].Addit_r_power, 2.0 * this.RadialParts[i].Exponents[j]));
                    continue;
                }
                int n3 = j;
                this.RadialParts[i].Coefs[n3] = this.RadialParts[i].Coefs[n3] / Math.sqrt(OverlapIntegrals.primitive_int_1D_Sphr(2 * n + 2, 2.0 * this.RadialParts[i].Exponents[j]));
            }
        }
    }

    public void ToNormalizedPrimitiveCoefs() {
        for (int i = 0; i < this.RadialParts.length; ++i) {
            int n = this.RadialParts[i].LUsedWith;
            for (int j = 0; j < this.RadialParts[i].Coefs.length; ++j) {
                if (this.RadialParts[i].Addit_r_power != 0) {
                    int n2 = j;
                    this.RadialParts[i].Coefs[n2] = this.RadialParts[i].Coefs[n2] * Math.sqrt(OverlapIntegrals.primitive_int_1D_Sphr(2 * n + 2 + 2 * this.RadialParts[i].Addit_r_power, 2.0 * this.RadialParts[i].Exponents[j]));
                    continue;
                }
                int n3 = j;
                this.RadialParts[i].Coefs[n3] = this.RadialParts[i].Coefs[n3] * Math.sqrt(OverlapIntegrals.primitive_int_1D_Sphr(2 * n + 2, 2.0 * this.RadialParts[i].Exponents[j]));
            }
        }
    }

    public double[] EvaluateOrbitalsAtPoint(boolean[] blArray, double[] dArray) {
        int n;
        double[] dArray2 = new double[this.MOs.length];
        double[] dArray3 = new double[this.Basis.length];
        for (n = 0; n < this.Basis.length; ++n) {
            dArray3[n] = this.Basis[n].EvaluateAtPoint(dArray, this.Basis[n].R0);
        }
        for (n = 0; n < this.MOs.length; ++n) {
            dArray2[n] = 0.0;
            if (blArray != null && (blArray == null || !blArray[n])) continue;
            for (int i = 0; i < this.Basis.length; ++i) {
                int n2 = n;
                dArray2[n2] = dArray2[n2] + dArray3[i] * this.MOs[n].BS_Coefs[i];
            }
        }
        return dArray2;
    }

    public double EvaluateDensityAtPoint(double[] dArray) {
        double[] dArray2 = this.EvaluateOrbitalsAtPoint(null, dArray);
        double d = 0.0;
        for (int i = 0; i < this.MOs.length; ++i) {
            d += this.MOs[i].Occupancy * dArray2[i] * dArray2[i];
        }
        return d;
    }

    public boolean Save_As_MOLDEN(String string) throws Exception {
        int n;
        int n2;
        PrintWriter printWriter = new PrintWriter(string);
        printWriter.println("[Molden Format]");
        printWriter.println("[Title]");
        printWriter.println(this.Title);
        printWriter.println();
        if (this.Coords_in_AU) {
            printWriter.println("[Atoms] AU");
        } else {
            printWriter.println("[Atoms] Angs");
        }
        for (n2 = 0; n2 < this.Centers.length; ++n2) {
            printWriter.printf("%-2s%4d %3.0f  %20.10f %20.10f %20.10f %n", this.Centers[n2].Name, n2 + 1, this.Centers[n2].Z, this.Centers[n2].R0[0], this.Centers[n2].R0[1], this.Centers[n2].R0[2]);
        }
        printWriter.println("[GTO]");
        for (n2 = 0; n2 < this.Centers.length; ++n2) {
            printWriter.printf("%3d 0 %n", n2 + 1);
            for (n = 0; n < this.RadialParts.length; ++n) {
                if (this.RadialParts[n].CenterID != n2 + 1) continue;
                if (this.RadialParts[n].Addit_r_power == 0) {
                    printWriter.printf("%s%4d 1.0  %n", Character.valueOf("spdfgh".charAt(this.RadialParts[n].LUsedWith)), this.RadialParts[n].Coefs.length);
                } else {
                    if (!this.Allow_additional_r_power) {
                        throw new Exception(" Radial part #" + n + " attempts using additional_r_power>0 but Allow_additional_r_power is false!");
                    }
                    printWriter.printf("%s%d%4d 1.0  %n", Character.valueOf("spdfgh".charAt(this.RadialParts[n].LUsedWith)), this.RadialParts[n].Addit_r_power, this.RadialParts[n].Coefs.length);
                }
                for (int i = 0; i < this.RadialParts[n].Coefs.length; ++i) {
                    printWriter.printf("%20.10f %20.10f %n", this.RadialParts[n].Exponents[i], this.RadialParts[n].Coefs[i]);
                }
            }
            printWriter.println();
        }
        if (this.IsSpherical) {
            printWriter.println("[5D]");
            printWriter.println("[9G]");
        }
        if (this.MOs != null) {
            printWriter.println("[MO]");
            for (n2 = 0; n2 < this.MOs.length; ++n2) {
                printWriter.printf(" Sym=     1a%n", new Object[0]);
                printWriter.printf(" Ene=%22.14E%n", this.MOs[n2].Energy);
                if (this.MOs[n2].Spin == 1) {
                    printWriter.printf(" Spin= Alpha%n", new Object[0]);
                } else {
                    printWriter.printf(" Spin= Beta%n", new Object[0]);
                }
                printWriter.printf(" Occup=%9.6f%n", this.MOs[n2].Occupancy);
                for (n = 0; n < this.MOs[n2].BS_Coefs.length; ++n) {
                    printWriter.printf(this.MOCoefLineFormat, n + 1, this.MOs[n2].BS_Coefs[n]);
                }
            }
        }
        printWriter.close();
        return true;
    }

    public boolean Save_as_BMOLDEN(String string) throws Exception {
        int n;
        FileOutputStream fileOutputStream = new FileOutputStream(string);
        DataOutputStream dataOutputStream = new DataOutputStream(fileOutputStream);
        dataOutputStream.writeChars(bmoldeng_signature);
        dataOutputStream.writeInt(this.Title.length());
        dataOutputStream.writeChars(this.Title);
        dataOutputStream.writeInt(1);
        dataOutputStream.writeInt(4);
        dataOutputStream.writeInt(11);
        if (this.Coords_in_AU) {
            dataOutputStream.writeInt(1);
        } else {
            dataOutputStream.writeInt(0);
        }
        dataOutputStream.writeInt(23);
        if (this.use_5D) {
            dataOutputStream.writeInt(1);
        } else {
            dataOutputStream.writeInt(0);
        }
        dataOutputStream.writeInt(24);
        if (this.use_7F) {
            dataOutputStream.writeInt(1);
        } else {
            dataOutputStream.writeInt(0);
        }
        dataOutputStream.writeInt(25);
        if (this.use_9G) {
            dataOutputStream.writeInt(1);
        } else {
            dataOutputStream.writeInt(0);
        }
        dataOutputStream.writeInt(2);
        dataOutputStream.writeInt(this.Centers.length);
        for (n = 0; n < this.Centers.length; ++n) {
            this.Centers[n].SaveToDataStream(dataOutputStream);
        }
        dataOutputStream.writeInt(3);
        dataOutputStream.writeInt(this.RadialParts.length);
        for (n = 0; n < this.RadialParts.length; ++n) {
            this.RadialParts[n].SaveToDataStream(dataOutputStream);
        }
        dataOutputStream.writeInt(4);
        dataOutputStream.writeInt(this.MOs.length);
        for (n = 0; n < this.MOs.length; ++n) {
            this.MOs[n].SaveToDataStream(dataOutputStream);
        }
        dataOutputStream.close();
        fileOutputStream.close();
        return true;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean Load_from_BMOLDEN(String string) throws Exception {
        int n;
        FileInputStream fileInputStream = new FileInputStream(string);
        DataInputStream dataInputStream = new DataInputStream(fileInputStream);
        char[] cArray = new char[dataInputStream.readInt()];
        for (int i = 0; i < cArray.length; ++i) {
            cArray[i] = dataInputStream.readChar();
        }
        if (!bmoldeng_signature.equals(cArray)) {
            return false;
        }
        char[] cArray2 = new char[dataInputStream.readInt()];
        for (n = 0; n < cArray2.length; ++n) {
            cArray2[n] = dataInputStream.readChar();
        }
        this.Title = String.valueOf(cArray2);
        try {
            block16: while (true) {
                n = dataInputStream.readInt();
                int n2 = dataInputStream.readInt();
                switch (n) {
                    case 1: {
                        int n3 = 0;
                        while (true) {
                            if (n3 >= n2) continue block16;
                            int n4 = dataInputStream.readInt();
                            int n5 = dataInputStream.readInt();
                            switch (n4) {
                                case 11: {
                                    this.Coords_in_AU = n5 != 0;
                                    break;
                                }
                                case 23: {
                                    this.use_5D = n5 != 0;
                                    break;
                                }
                                case 24: {
                                    this.use_7F = n5 != 0;
                                    break;
                                }
                                case 25: {
                                    this.use_9G = n5 != 0;
                                    break;
                                }
                                default: {
                                    WarningManager.warning_printf("WARNING: flag ID %d unknown! Ignored!%n", n4);
                                }
                            }
                            ++n3;
                        }
                    }
                    case 2: {
                        this.Centers = new AtomicCenter[n2];
                        int n3 = 0;
                        while (true) {
                            if (n3 >= n2) continue block16;
                            this.Centers[n3] = new AtomicCenter();
                            this.Centers[n3].ReadFromDataStream(dataInputStream);
                            ++n3;
                        }
                    }
                    case 3: {
                        int n6;
                        int n3;
                        this.RadialParts = new RadialPartOfBasisFunction[n2];
                        for (n3 = 0; n3 < n2; ++n3) {
                            this.RadialParts[n3] = new RadialPartOfBasisFunction();
                            this.RadialParts[n3].ReadFromDataStream(dataInputStream);
                        }
                        n3 = 0;
                        this.HighestL = 0;
                        for (int i = 0; i < n2; ++i) {
                            n3 |= this.RadialParts[i].Addit_r_power > 0 ? 1 : 0;
                            if (this.RadialParts[i].LUsedWith <= this.HighestL) continue;
                            this.HighestL = this.RadialParts[i].LUsedWith;
                        }
                        if (!this.Allow_additional_r_power && n3 != 0) {
                            throw new Exception("Addit_r_power > 0 found for one of radial parts, but Allow_additional_r_power is false.");
                        }
                        this.IsSpherical = this.use_5D & this.use_7F;
                        if (this.HighestL >= 4) {
                            this.IsSpherical &= this.use_9G;
                        }
                        this.out.println("Basis functions are spherical: " + this.IsSpherical);
                        this.FirstBasisFunction = null;
                        BasisFunction basisFunction = null;
                        for (n6 = 0; n6 < this.RadialParts.length; ++n6) {
                            BasisFunction basisFunction2 = new BasisFunction(this.RadialParts[n6].LUsedWith, 0, this.Centers[this.RadialParts[n6].CenterID - 1].R0, this.RadialParts[n6].Exponents.length);
                            basisFunction = this.FirstBasisFunction == null ? (this.FirstBasisFunction = basisFunction2) : (basisFunction._next = basisFunction2);
                        }
                        this._BS_List_To_Array();
                        break;
                    }
                    case 4: {
                        int n6;
                        this.MOs = new MO[n2];
                        for (n6 = 0; n6 < n2; ++n6) {
                            this.MOs[n6] = new MO();
                            this.MOs[n6].ReadFromDataStream(dataInputStream);
                        }
                    }
                }
            }
        }
        catch (EOFException eOFException) {
            dataInputStream.close();
            fileInputStream.close();
            return true;
        }
    }

    public void ScaleCoords(double d) {
        int n;
        for (n = 0; n < this.Centers.length; ++n) {
            int n2 = 0;
            while (n2 < 3) {
                int n3 = n2++;
                this.Centers[n].R0[n3] = this.Centers[n].R0[n3] * d;
            }
        }
        if (this.Basis != null) {
            for (n = 0; n < this.Basis.length; ++n) {
                this.Basis[n].R0 = this.Centers[this.Basis[n].Center_ID - 1].R0;
            }
        }
    }

    public void CoordsToAU() {
        if (this.Coords_in_AU) {
            return;
        }
        this.ScaleCoords(1.8897261245650618);
        this.Coords_in_AU = true;
    }

    public void CoordsToAngstroms() {
        if (!this.Coords_in_AU) {
            return;
        }
        this.ScaleCoords(0.52917721092);
        this.Coords_in_AU = false;
    }

    public void UnNormalizePrimitives(double[][] dArray) {
        int n;
        int n2;
        int n3;
        if (!this.IsSpherical) {
            this.out.println("ERROR: MOLDEN_IO.UnnormalizePrimitives() currently works with spherical basis sets only!");
            return;
        }
        double d = 0.0;
        for (n3 = 0; n3 < this.RadialParts.length; ++n3) {
            n2 = this.RadialParts[n3].LUsedWith;
            n = 0;
            while (n < this.RadialParts[n3].Coefs.length) {
                d = this.RadialParts[n3].Addit_r_power != 0 ? OverlapIntegrals.primitive_int_1D_Sphr(2 * n2 + 2 + 2 * this.RadialParts[n3].Addit_r_power, 2.0 * this.RadialParts[n3].Exponents[n]) : OverlapIntegrals.primitive_int_1D_Sphr(2 * n2 + 2, 2.0 * this.RadialParts[n3].Exponents[n]);
                int n4 = n++;
                this.RadialParts[n3].Coefs[n4] = this.RadialParts[n3].Coefs[n4] / Math.sqrt((d *= Math.PI * 4) * dArray[n2][0]);
            }
        }
        for (n3 = 0; n3 < this.Basis.length; ++n3) {
            n2 = this.Basis[n3].L;
            n = 0;
            while (n < this.Basis[n3].coefs.length) {
                d = OverlapIntegrals.primitive_int_1D_Sphr(2 * n2 + 2 + 2 * this.Basis[n3].additional_r_power, 2.0 * this.Basis[n3].exponents[n]);
                int n5 = n++;
                this.Basis[n3].coefs[n5] = this.Basis[n3].coefs[n5] / Math.sqrt((d *= Math.PI * 4) * dArray[n2][n2 + this.Basis[n3].m]);
            }
        }
    }

    public double[][] get_MO2AO_array(boolean bl) {
        double[][] dArrayArray = new double[this.MOs.length][];
        for (int i = 0; i < this.MOs.length; ++i) {
            if (bl) {
                dArrayArray[i] = new double[this.Basis.length];
                System.arraycopy(this.MOs[i].BS_Coefs, 0, dArrayArray[i], 0, this.Basis.length);
                continue;
            }
            dArrayArray[i] = this.MOs[i].BS_Coefs;
        }
        return dArrayArray;
    }
}

