/*
 * Decompiled with CFR 0.152.
 */
package JGints;

import JGints.SphericalHarmonics;

public class Polynom_rho_z {
    public double[][] cf_matrix = null;
    private double[][] tmp_matrix = null;
    public int last_active_rho_power = 0;
    public int last_active_z_power = 0;
    private Polynom_rho_z stackPointer = null;

    private void fieldsCopy(Polynom_rho_z polynom_rho_z, boolean bl) {
        this.last_active_z_power = polynom_rho_z.last_active_z_power;
        this.last_active_rho_power = polynom_rho_z.last_active_rho_power;
        if (bl) {
            this.cf_matrix = new double[polynom_rho_z.cf_matrix.length][];
            for (int i = 0; i < polynom_rho_z.cf_matrix.length; ++i) {
                this.cf_matrix[i] = (double[])polynom_rho_z.cf_matrix[i].clone();
            }
        } else {
            this.cf_matrix = polynom_rho_z.cf_matrix;
        }
    }

    private Polynom_rho_z(Polynom_rho_z polynom_rho_z) {
        this.fieldsCopy(polynom_rho_z, true);
    }

    public Polynom_rho_z(int n, int n2) {
        this.cf_matrix = new double[n + 1][n2 + 1];
        this.cf_matrix[0][0] = 1.0;
        this.tmp_matrix = new double[n + 1][n2 + 1];
        this.last_active_rho_power = 0;
        this.last_active_z_power = 0;
    }

    public void pushToStack() {
        Polynom_rho_z polynom_rho_z = new Polynom_rho_z(this);
        polynom_rho_z.stackPointer = this.stackPointer;
        this.stackPointer = polynom_rho_z;
    }

    public void restoreFromStack(boolean bl) {
        Polynom_rho_z polynom_rho_z = this.stackPointer;
        if (polynom_rho_z == null) {
            return;
        }
        this.fieldsCopy(polynom_rho_z, !bl);
        if (bl) {
            this.stackPointer = polynom_rho_z.stackPointer;
        }
    }

    private void _swap_old_new() {
        double[][] dArray = this.cf_matrix;
        this.cf_matrix = this.tmp_matrix;
        this.tmp_matrix = dArray;
    }

    public void mul_sq(double d, double d2, double d3) {
        int n;
        int n2;
        int n3;
        for (n3 = 0; n3 <= this.last_active_z_power; ++n3) {
            for (int i = 0; i <= this.last_active_rho_power; ++i) {
                this.tmp_matrix[n3 + 2][i] = d * this.cf_matrix[n3][i];
            }
        }
        for (n3 = 0; n3 <= this.last_active_rho_power + 2; ++n3) {
            this.tmp_matrix[0][n3] = 0.0;
            this.tmp_matrix[1][n3] = 0.0;
        }
        for (n3 = 0; n3 <= this.last_active_z_power + 2; ++n3) {
            this.tmp_matrix[n3][this.last_active_rho_power + 1] = 0.0;
            this.tmp_matrix[n3][this.last_active_rho_power + 2] = 0.0;
        }
        double d4 = d * 2.0 * d3;
        for (n2 = 0; n2 <= this.last_active_z_power; ++n2) {
            for (n = 0; n <= this.last_active_rho_power; ++n) {
                double[] dArray = this.tmp_matrix[n2 + 1];
                int n4 = n;
                dArray[n4] = dArray[n4] - d4 * this.cf_matrix[n2][n];
            }
        }
        for (n2 = 0; n2 <= this.last_active_z_power; ++n2) {
            for (n = 0; n <= this.last_active_rho_power; ++n) {
                double[] dArray = this.tmp_matrix[n2];
                int n5 = n + 2;
                dArray[n5] = dArray[n5] + d2 * this.cf_matrix[n2][n];
            }
        }
        d4 = d * d3 * d3;
        for (n2 = 0; n2 <= this.last_active_z_power; ++n2) {
            for (n = 0; n <= this.last_active_rho_power; ++n) {
                double[] dArray = this.tmp_matrix[n2];
                int n6 = n;
                dArray[n6] = dArray[n6] + d4 * this.cf_matrix[n2][n];
            }
        }
        this.last_active_rho_power += 2;
        this.last_active_z_power += 2;
        this._swap_old_new();
    }

    public void mul_lin(double d) {
        int n;
        System.arraycopy(this.cf_matrix[this.last_active_z_power], 0, this.cf_matrix[this.last_active_z_power + 1], 0, this.last_active_rho_power + 1);
        for (n = this.last_active_z_power; n >= 1; --n) {
            for (int i = 0; i <= this.last_active_rho_power; ++i) {
                double[] dArray = this.cf_matrix[n];
                int n2 = i;
                dArray[n2] = dArray[n2] * -d;
                double[] dArray2 = this.cf_matrix[n];
                int n3 = i;
                dArray2[n3] = dArray2[n3] + this.cf_matrix[n - 1][i];
            }
        }
        n = 0;
        while (n <= this.last_active_rho_power) {
            double[] dArray = this.cf_matrix[0];
            int n4 = n++;
            dArray[n4] = dArray[n4] * -d;
        }
        ++this.last_active_z_power;
    }

    public void mul_AssocLeg(int n, int n2, double d) {
        double[] dArray = SphericalHarmonics.ALegRootsSquared[n][Math.abs(n2)];
        int n3 = dArray.length;
        for (int i = 0; i < n3; ++i) {
            this.mul_sq(1.0 - dArray[i], -dArray[i], d);
        }
        if ((n - Math.abs(n2)) % 2 == 1) {
            this.mul_lin(d);
        }
    }

    public void mul_r2(int n, double d) {
        for (int i = 0; i < n; ++i) {
            this.mul_sq(1.0, 1.0, d);
        }
    }

    public void printout() {
        for (int i = 0; i < this.cf_matrix.length; ++i) {
            boolean bl = false;
            for (int j = 0; j < this.cf_matrix[i].length; ++j) {
                if (!(Math.abs(this.cf_matrix[i][j]) > 1.0E-10)) continue;
                System.out.printf(" %+.3f * z^%d * rho^%d ", this.cf_matrix[i][j], i, j);
                bl = true;
            }
            if (!bl) continue;
            System.out.println();
        }
        System.out.println("---");
    }
}

