/*
 * Decompiled with CFR 0.152.
 */
package CLPO;

import CLPO.IntArrayList;
import CLPO.PairEdge;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;

public class Blossom {
    private static final boolean DEBUG = false;
    private final PairEdge[] edges;
    private final int nedge;
    private final int nvertex;
    private final double maxweight;
    private final int[] endpoint;
    private final IntArrayList[] neighbend;
    private final int[] mate;
    private final int[] label;
    private final int[] labelend;
    private final int[] inblossom;
    private final int[] blossomparent;
    private final IntArrayList[] blossomchilds;
    private final int[] blossombase;
    private final IntArrayList[] blossomendps;
    private final int[] bestedge;
    private final int[][] blossombestedges;
    private final IntArrayList unusedblossoms;
    private final double[] dualvar;
    private final boolean[] allowedge;
    private final IntArrayList queue;

    /*
     * WARNING - void declaration
     */
    public Blossom(PairEdge[] pairEdgeArray) {
        IntArrayList intArrayList;
        int n;
        void objectArray;
        this.edges = pairEdgeArray;
        int n2 = pairEdgeArray.length;
        int n3 = 0;
        PairEdge[] pairEdgeArray2 = pairEdgeArray;
        int n4 = pairEdgeArray2.length;
        boolean bl = false;
        while (objectArray < n4) {
            PairEdge pairEdge = pairEdgeArray2[objectArray];
            assert (pairEdge.a >= 0);
            assert (pairEdge.b >= 0);
            assert (pairEdge.a != pairEdge.b);
            if (pairEdge.a >= n3) {
                n3 = pairEdge.a + 1;
            }
            if (pairEdge.b >= n3) {
                n3 = pairEdge.b + 1;
            }
            ++objectArray;
        }
        this.nedge = n2;
        this.nvertex = n3;
        double d = 0.0;
        for (PairEdge nArray : pairEdgeArray) {
            if (!(nArray.wt > d)) continue;
            d = nArray.wt;
        }
        this.maxweight = d;
        int[] nArray = new int[2 * n2];
        int n5 = 0;
        for (int i = 0; i < n2; ++i) {
            nArray[n5++] = pairEdgeArray[i].a;
            nArray[n5++] = pairEdgeArray[i].b;
        }
        this.endpoint = nArray;
        IntArrayList[] intArrayListArray = new IntArrayList[n3];
        for (n = 0; n < intArrayListArray.length; ++n) {
            intArrayListArray[n] = new IntArrayList();
        }
        for (n = 0; n < n2; ++n) {
            intArrayListArray[pairEdgeArray[n].a].add(2 * n + 1);
            intArrayListArray[pairEdgeArray[n].b].add(2 * n);
        }
        this.neighbend = intArrayListArray;
        int[] nArray2 = new int[n3];
        Arrays.fill(nArray2, -1);
        this.mate = nArray2;
        int[] nArray3 = new int[2 * n3];
        this.label = nArray3;
        int[] nArray4 = new int[2 * n3];
        Arrays.fill(nArray4, -1);
        this.labelend = nArray4;
        int[] nArray5 = new int[n3];
        for (int i = 0; i < n3; ++i) {
            nArray5[i] = i;
        }
        this.inblossom = nArray5;
        int[] nArray6 = new int[2 * n3];
        Arrays.fill(nArray6, -1);
        this.blossomparent = nArray6;
        IntArrayList[] intArrayListArray2 = new IntArrayList[2 * n3];
        this.blossomchilds = intArrayListArray2;
        int[] nArray7 = new int[n3 * 2];
        Arrays.fill(nArray7, -1);
        for (int i = 0; i < n3; ++i) {
            nArray7[i] = i;
        }
        this.blossombase = nArray7;
        IntArrayList[] intArrayListArray3 = new IntArrayList[2 * n3];
        this.blossomendps = intArrayListArray3;
        int[] nArray8 = new int[2 * n3];
        Arrays.fill(nArray8, -1);
        this.bestedge = nArray8;
        int[][] nArrayArray = new int[2 * n3][];
        this.blossombestedges = nArrayArray;
        IntArrayList intArrayList2 = new IntArrayList();
        for (int i = 0; i < n3; ++i) {
            intArrayList2.add(i + n3);
        }
        this.unusedblossoms = intArrayList2;
        double[] dArray = new double[n3 * 2];
        for (int i = 0; i < n3; ++i) {
            dArray[i] = d;
        }
        this.dualvar = dArray;
        boolean[] blArray = new boolean[n2];
        this.allowedge = blArray;
        this.queue = intArrayList = new IntArrayList();
    }

    private double slack(int n) {
        return this.dualvar[this.edges[n].a] + this.dualvar[this.edges[n].b] - 2.0 * this.edges[n].wt;
    }

    private IntArrayList blossomLeaves(int n) {
        IntArrayList intArrayList = new IntArrayList();
        if (n < this.nvertex) {
            intArrayList.add(n);
        } else {
            Iterator iterator = this.blossomchilds[n].iterator();
            while (iterator.hasNext()) {
                int n2 = (Integer)iterator.next();
                if (n2 < this.nvertex) {
                    intArrayList.add(n2);
                    continue;
                }
                Iterator iterator2 = this.blossomLeaves(n2).iterator();
                while (iterator2.hasNext()) {
                    int n3 = (Integer)iterator2.next();
                    intArrayList.add(n3);
                }
            }
        }
        return intArrayList;
    }

    private void assignLabel(int n, int n2, int n3) {
        int n4 = this.inblossom[n];
        assert (this.label[n] == 0 && this.label[n4] == 0);
        this.label[n] = this.label[n4] = n2;
        this.labelend[n] = this.labelend[n4] = n3;
        this.bestedge[n4] = -1;
        this.bestedge[n] = -1;
        if (n2 == 1) {
            this.queue.addAll(this.blossomLeaves(n4));
        } else if (n2 == 2) {
            int n5 = this.blossombase[n4];
            assert (this.mate[n5] >= 0);
            this.assignLabel(this.endpoint[this.mate[n5]], 1, this.mate[n5] ^ 1);
        }
    }

    private int scanBlossom(int n, int n2) {
        int n3;
        IntArrayList intArrayList = new IntArrayList();
        int n4 = -1;
        while (n != -1 || n2 != -1) {
            int n5 = this.inblossom[n];
            if ((this.label[n5] & 4) != 0) {
                n4 = this.blossombase[n5];
                break;
            }
            assert (this.label[n5] == 1);
            intArrayList.add(n5);
            this.label[n5] = 5;
            assert (this.labelend[n5] == this.mate[this.blossombase[n5]]);
            if (this.labelend[n5] == -1) {
                n = -1;
            } else {
                n = this.endpoint[this.labelend[n5]];
                n5 = this.inblossom[n];
                assert (this.label[n5] == 2);
                assert (this.labelend[n5] >= 0);
                n = this.endpoint[this.labelend[n5]];
            }
            if (n2 == -1) continue;
            n3 = n;
            n = n2;
            n2 = n3;
        }
        Iterator iterator = intArrayList.iterator();
        while (iterator.hasNext()) {
            n3 = (Integer)iterator.next();
            this.label[n3] = 1;
        }
        return n4;
    }

    private void addBlossom(int n, int n2) {
        IntArrayList intArrayList;
        IntArrayList intArrayList2;
        int n3 = this.edges[n2].a;
        int n4 = this.edges[n2].b;
        int n5 = this.inblossom[n];
        int n6 = this.inblossom[n3];
        int n7 = this.inblossom[n4];
        int n8 = this.unusedblossoms.popInt();
        this.blossombase[n8] = n;
        this.blossomparent[n8] = -1;
        this.blossomparent[n5] = n8;
        this.blossomchilds[n8] = intArrayList2 = new IntArrayList();
        this.blossomendps[n8] = intArrayList = new IntArrayList();
        while (n6 != n5) {
            this.blossomparent[n6] = n8;
            intArrayList2.add(n6);
            intArrayList.add(this.labelend[n6]);
            assert (this.label[n6] == 2 || this.label[n6] == 1 && this.labelend[n6] == this.mate[this.blossombase[n6]]);
            assert (this.labelend[n6] >= 0);
            n3 = this.endpoint[this.labelend[n6]];
            n6 = this.inblossom[n3];
        }
        intArrayList2.add(n5);
        Collections.reverse(intArrayList2);
        Collections.reverse(intArrayList);
        intArrayList.add(2 * n2);
        while (n7 != n5) {
            this.blossomparent[n7] = n8;
            intArrayList2.add(n7);
            intArrayList.add(this.labelend[n7] ^ 1);
            assert (this.label[n7] == 2 || this.label[n7] == 1 && this.labelend[n7] == this.mate[this.blossombase[n7]]);
            assert (this.labelend[n7] >= 0);
            n4 = this.endpoint[this.labelend[n7]];
            n7 = this.inblossom[n4];
        }
        assert (this.label[n5] == 1);
        this.label[n8] = 1;
        this.labelend[n8] = this.labelend[n5];
        this.dualvar[n8] = 0.0;
        Object object = this.blossomLeaves(n8).iterator();
        while (object.hasNext()) {
            int n9 = (Integer)object.next();
            if (this.label[this.inblossom[n9]] == 2) {
                this.queue.add(n9);
            }
            this.inblossom[n9] = n8;
        }
        object = new int[2 * this.nvertex];
        Arrays.fill((int[])object, -1);
        Object object2 = intArrayList2.iterator();
        while (object2.hasNext()) {
            Object object3;
            int[][] nArrayArray;
            Object object4;
            int n10 = (Integer)object2.next();
            if (this.blossombestedges[n10] == null) {
                object4 = this.blossomLeaves(n10);
                nArrayArray = new int[((ArrayList)object4).size()][];
                for (object3 = (Object)false; object3 < ((ArrayList)object4).size(); ++object3) {
                    IntArrayList intArrayList3 = this.neighbend[((IntArrayList)object4).getInt((int)object3)];
                    nArrayArray[object3] = new int[intArrayList3.size()];
                    for (int i = 0; i < intArrayList3.size(); ++i) {
                        nArrayArray[object3][i] = intArrayList3.getInt(i) / 2;
                    }
                }
            } else {
                nArrayArray = new int[][]{this.blossombestedges[n10]};
            }
            object4 = nArrayArray;
            object3 = ((Object)object4).length;
            for (int i = 0; i < object3; ++i) {
                Object object5;
                for (Object object6 : object5 = object4[i]) {
                    int n11;
                    int n12 = this.edges[object6].a;
                    int n13 = this.edges[object6].b;
                    if (this.inblossom[n13] == n8) {
                        n13 = n12;
                    }
                    if ((n11 = this.inblossom[n13]) == n8 || this.label[n11] != 1 || object[n11] != -1 && !(this.slack((int)object6) < this.slack((int)object[n11]))) continue;
                    object[n11] = object6;
                }
            }
            this.blossombestedges[n10] = null;
            this.bestedge[n10] = -1;
        }
        object2 = new IntArrayList();
        for (Object object3 : object) {
            if (object3 == -1) continue;
            ((ArrayList)object2).add((int)object3);
        }
        this.blossombestedges[n8] = ((IntArrayList)object2).toIntArray();
        this.bestedge[n8] = -1;
        for (Object object3 : (Object)this.blossombestedges[n8]) {
            if (this.bestedge[n8] != -1 && !(this.slack((int)object3) < this.slack(this.bestedge[n8]))) continue;
            this.bestedge[n8] = (int)object3;
        }
    }

    private void expandBlossom(int n, boolean bl) {
        int n2;
        int n3;
        Iterator iterator = this.blossomchilds[n].iterator();
        while (iterator.hasNext()) {
            n3 = (Integer)iterator.next();
            this.blossomparent[n3] = -1;
            if (n3 < this.nvertex) {
                this.inblossom[n3] = n3;
                continue;
            }
            if (bl && this.dualvar[n3] == 0.0) {
                this.expandBlossom(n3, bl);
                continue;
            }
            Iterator iterator2 = this.blossomLeaves(n3).iterator();
            while (iterator2.hasNext()) {
                n2 = (Integer)iterator2.next();
                this.inblossom[n2] = n3;
            }
        }
        if (!bl && this.label[n] == 2) {
            int n4;
            assert (this.labelend[n] >= 0);
            int n5 = this.inblossom[this.endpoint[this.labelend[n] ^ 1]];
            n3 = this.blossomchilds[n].indexOf(n5);
            if ((n3 & 1) != 0) {
                n3 -= this.blossomchilds[n].size();
                n2 = 1;
                n4 = 0;
            } else {
                n2 = -1;
                n4 = 1;
            }
            int n6 = this.labelend[n];
            while (n3 != 0) {
                this.label[this.endpoint[n6 ^ 1]] = 0;
                this.label[this.endpoint[this.blossomendps[n].getInt((int)((this.blossomendps[n].size() + (n3 - n4)) % this.blossomendps[n].size())) ^ n4 ^ 1]] = 0;
                this.assignLabel(this.endpoint[n6 ^ 1], 2, n6);
                this.allowedge[this.blossomendps[n].getInt((int)((this.blossomendps[n].size() + (n3 - n4)) % this.blossomendps[n].size())) / 2] = true;
                n6 = this.blossomendps[n].getInt((this.blossomendps[n].size() + ((n3 += n2) - n4)) % this.blossomendps[n].size()) ^ n4;
                this.allowedge[n6 / 2] = true;
                n3 += n2;
            }
            int n7 = this.blossomchilds[n].getInt(n3);
            this.label[n7] = 2;
            this.label[this.endpoint[n6 ^ 1]] = 2;
            this.labelend[this.endpoint[n6 ^ 1]] = this.labelend[n7] = n6;
            this.bestedge[n7] = -1;
            n3 += n2;
            while (this.blossomchilds[n].getInt((this.blossomchilds[n].size() + n3) % this.blossomchilds[n].size()) != n5) {
                n7 = this.blossomchilds[n].getInt((this.blossomchilds[n].size() + n3) % this.blossomchilds[n].size());
                if (this.label[n7] == 1) {
                    n3 += n2;
                    continue;
                }
                int n8 = -1;
                Iterator iterator3 = this.blossomLeaves(n7).iterator();
                while (iterator3.hasNext()) {
                    int n9;
                    n8 = n9 = ((Integer)iterator3.next()).intValue();
                    if (this.label[n9] == 0) continue;
                    break;
                }
                assert (n8 != -1);
                if (this.label[n8] != 0) {
                    assert (this.label[n8] == 2);
                    assert (this.inblossom[n8] == n7);
                    this.label[n8] = 0;
                    this.label[this.endpoint[this.mate[this.blossombase[n7]]]] = 0;
                    this.assignLabel(n8, 2, this.labelend[n8]);
                }
                n3 += n2;
            }
        }
        this.labelend[n] = -1;
        this.label[n] = -1;
        this.blossomendps[n] = null;
        this.blossomchilds[n] = null;
        this.blossombase[n] = -1;
        this.blossombestedges[n] = null;
        this.bestedge[n] = -1;
        this.unusedblossoms.add(n);
    }

    private void augmentBlossom(int n, int n2) {
        int n3;
        int n4;
        int n5;
        int n6;
        int n7 = n2;
        while (this.blossomparent[n7] != n) {
            n7 = this.blossomparent[n7];
        }
        if (n7 >= this.nvertex) {
            this.augmentBlossom(n7, n2);
        }
        int n8 = n6 = this.blossomchilds[n].indexOf(n7);
        if ((n6 & 1) != 0) {
            n8 -= this.blossomchilds[n].size();
            n5 = 1;
            n4 = 0;
        } else {
            n5 = -1;
            n4 = 1;
        }
        while (n8 != 0) {
            n7 = this.blossomchilds[n].getInt((this.blossomchilds[n].size() + (n8 += n5)) % this.blossomchilds[n].size());
            n3 = this.blossomendps[n].getInt((this.blossomendps[n].size() + (n8 - n4)) % this.blossomendps[n].size()) ^ n4;
            if (n7 >= this.nvertex) {
                this.augmentBlossom(n7, this.endpoint[n3]);
            }
            if ((n7 = this.blossomchilds[n].getInt((this.blossomchilds[n].size() + (n8 += n5)) % this.blossomchilds[n].size())) >= this.nvertex) {
                this.augmentBlossom(n7, this.endpoint[n3 ^ 1]);
            }
            this.mate[this.endpoint[n3]] = n3 ^ 1;
            this.mate[this.endpoint[n3 ^ 1]] = n3;
        }
        for (n3 = 0; n3 < n6; ++n3) {
            this.blossomchilds[n].add(this.blossomchilds[n].getInt(n3));
            this.blossomendps[n].add(this.blossomendps[n].getInt(n3));
        }
        this.blossomchilds[n].removeElements(0, n6);
        this.blossomendps[n].removeElements(0, n6);
        this.blossombase[n] = this.blossombase[this.blossomchilds[n].getInt(0)];
        assert (this.blossombase[n] == n2);
    }

    private void augmentMatching(int n) {
        int n2 = this.edges[n].a;
        int n3 = this.edges[n].b;
        block0: for (int[] nArray : new int[][]{{n2, 2 * n + 1}, {n3, 2 * n}}) {
            int n4 = nArray[0];
            int n5 = nArray[1];
            while (true) {
                int n6 = this.inblossom[n4];
                assert (this.label[n6] == 1);
                assert (this.labelend[n6] == this.mate[this.blossombase[n6]]);
                if (n6 >= this.nvertex) {
                    this.augmentBlossom(n6, n4);
                }
                this.mate[n4] = n5;
                if (this.labelend[n6] == -1) continue block0;
                int n7 = this.endpoint[this.labelend[n6]];
                int n8 = this.inblossom[n7];
                assert (this.label[n8] == 2);
                assert (this.labelend[n8] >= 0);
                n4 = this.endpoint[this.labelend[n8]];
                int n9 = this.endpoint[this.labelend[n8] ^ 1];
                assert (this.blossombase[n8] == n7);
                if (n8 >= this.nvertex) {
                    this.augmentBlossom(n8, n9);
                }
                this.mate[n9] = this.labelend[n8];
                n5 = this.labelend[n8] ^ 1;
            }
        }
    }

    public int[] maxWeightMatching() {
        int n;
        if (this.edges.length == 0) {
            return new int[0];
        }
        for (n = 0; n < this.nvertex; ++n) {
            int n2;
            int n3;
            Arrays.fill(this.label, 0);
            Arrays.fill(this.bestedge, -1);
            for (n3 = this.nvertex; n3 < this.blossombestedges.length; ++n3) {
                this.blossombestedges[n3] = null;
            }
            Arrays.fill(this.allowedge, false);
            this.queue.clear();
            for (n3 = 0; n3 < this.nvertex; ++n3) {
                if (this.mate[n3] != -1 || this.label[this.inblossom[n3]] != 0) continue;
                this.assignLabel(n3, 1, -1);
            }
            n3 = 0;
            block3: while (true) {
                double d;
                int n4;
                int n5;
                int n6;
                int n7;
                if (!this.queue.isEmpty() && n3 == 0) {
                    n2 = this.queue.popInt();
                    assert (this.label[this.inblossom[n2]] == 1);
                    Iterator iterator = this.neighbend[n2].iterator();
                    while (true) {
                        if (!iterator.hasNext()) continue block3;
                        n7 = (Integer)iterator.next();
                        n6 = n7 / 2;
                        int n8 = this.endpoint[n7];
                        if (this.inblossom[n2] == this.inblossom[n8]) continue;
                        double d2 = Double.MAX_VALUE;
                        if (!this.allowedge[n6] && (d2 = this.slack(n6)) <= 0.0) {
                            this.allowedge[n6] = true;
                        }
                        if (this.allowedge[n6]) {
                            if (this.label[this.inblossom[n8]] == 0) {
                                this.assignLabel(n8, 2, n7 ^ 1);
                                continue;
                            }
                            if (this.label[this.inblossom[n8]] == 1) {
                                n5 = this.scanBlossom(n2, n8);
                                if (n5 >= 0) {
                                    this.addBlossom(n5, n6);
                                    continue;
                                }
                                this.augmentMatching(n6);
                                n3 = 1;
                                continue block3;
                            }
                            if (this.label[n8] != 0) continue;
                            assert (this.label[this.inblossom[n8]] == 2);
                            this.label[n8] = 2;
                            this.labelend[n8] = n7 ^ 1;
                            continue;
                        }
                        if (this.label[this.inblossom[n8]] == 1) {
                            n5 = this.inblossom[n2];
                            if (this.bestedge[n5] != -1 && !(d2 < this.slack(this.bestedge[n5]))) continue;
                            this.bestedge[n5] = n6;
                            continue;
                        }
                        if (this.label[n8] != 0 || this.bestedge[n8] != -1 && !(d2 < this.slack(this.bestedge[n8]))) continue;
                        this.bestedge[n8] = n6;
                    }
                }
                if (n3 != 0) break;
                n2 = -1;
                double d3 = Double.MAX_VALUE;
                n7 = Integer.MAX_VALUE;
                n6 = Integer.MAX_VALUE;
                n2 = 1;
                for (n4 = 0; n4 < this.nvertex; ++n4) {
                    d3 = Math.min(d3, this.dualvar[n4]);
                }
                for (n4 = 0; n4 < this.nvertex; ++n4) {
                    if (this.label[this.inblossom[n4]] != 0 || this.bestedge[n4] == -1) continue;
                    d = this.slack(this.bestedge[n4]);
                    if (n2 != -1 && !(d < d3)) continue;
                    d3 = d;
                    n2 = 2;
                    n7 = this.bestedge[n4];
                }
                for (n4 = 0; n4 < 2 * this.nvertex; ++n4) {
                    if (this.blossomparent[n4] != -1 || this.label[n4] != 1 || this.bestedge[n4] == -1) continue;
                    d = this.slack(this.bestedge[n4]);
                    double d4 = d / 2.0;
                    if (n2 != -1 && !(d4 < d3)) continue;
                    d3 = d4;
                    n2 = 3;
                    n7 = this.bestedge[n4];
                }
                for (n4 = this.nvertex; n4 < 2 * this.nvertex; ++n4) {
                    if (this.blossombase[n4] < 0 || this.blossomparent[n4] != -1 || this.label[n4] != 2 || n2 != -1 && !(this.dualvar[n4] < d3)) continue;
                    d3 = this.dualvar[n4];
                    n2 = 4;
                    n6 = n4;
                }
                for (n4 = 0; n4 < this.nvertex; ++n4) {
                    if (this.label[this.inblossom[n4]] == 1) {
                        int n9 = n4;
                        this.dualvar[n9] = this.dualvar[n9] - d3;
                        continue;
                    }
                    if (this.label[this.inblossom[n4]] != 2) continue;
                    int n10 = n4;
                    this.dualvar[n10] = this.dualvar[n10] + d3;
                }
                for (n4 = this.nvertex; n4 < 2 * this.nvertex; ++n4) {
                    if (this.blossombase[n4] < 0 || this.blossomparent[n4] != -1) continue;
                    if (this.label[n4] == 1) {
                        int n11 = n4;
                        this.dualvar[n11] = this.dualvar[n11] + d3;
                        continue;
                    }
                    if (this.label[n4] != 2) continue;
                    int n12 = n4;
                    this.dualvar[n12] = this.dualvar[n12] - d3;
                }
                if (n2 == 1) break;
                if (n2 == 2) {
                    this.allowedge[n7] = true;
                    n4 = this.edges[n7].a;
                    int n13 = this.edges[n7].b;
                    if (this.label[this.inblossom[n4]] == 0) {
                        n5 = n4;
                        n4 = n13;
                        n13 = n5;
                    }
                    assert (this.label[this.inblossom[n4]] == 1);
                    this.queue.add(n4);
                    continue;
                }
                if (n2 == 3) {
                    this.allowedge[n7] = true;
                    n4 = this.edges[n7].a;
                    int n14 = this.edges[n7].b;
                    assert (this.label[this.inblossom[n4]] == 1);
                    this.queue.add(n4);
                    continue;
                }
                if (n2 != 4) continue;
                this.expandBlossom(n6, false);
            }
            if (n3 == 0) break;
            for (n2 = this.nvertex; n2 < 2 * this.nvertex; ++n2) {
                if (this.blossomparent[n2] != -1 || this.blossombase[n2] < 0 || this.label[n2] != 1 || this.dualvar[n2] != 0.0) continue;
                this.expandBlossom(n2, true);
            }
        }
        for (n = 0; n < this.nvertex; ++n) {
            if (this.mate[n] < 0) continue;
            this.mate[n] = this.endpoint[this.mate[n]];
        }
        for (n = 0; n < this.nvertex; ++n) {
            assert (this.mate[n] == -1 || this.mate[this.mate[n]] == n);
        }
        return this.mate;
    }
}

