/*
 * Decompiled with CFR 0.152.
 */
package CLPO;

import Jama.Matrix;
import MatrixHelper.EigenEngine;
import MatrixHelper.Sorter;

public class AtomicHybrids {
    public int[] NAO_indices;
    public Matrix U;
    private Matrix U_saved;
    public int nValidHybrids = 0;
    public int[] friendAtomIndex;
    public int[] friendHybridIndex;
    private int[][] friendRefs_saved;

    AtomicHybrids(int[] nArray) {
        this.NAO_indices = nArray;
        this.U = new Matrix(nArray.length, nArray.length);
        this.nValidHybrids = 0;
        this.friendAtomIndex = new int[nArray.length];
        this.friendHybridIndex = new int[nArray.length];
        this.friendRefs_saved = new int[2][];
    }

    public void backup_U() {
        this.U_saved = this.U.copy();
    }

    public void restore_U() {
        this.U = this.U_saved.copy();
    }

    public void backup_bonding() {
        int n = this.friendAtomIndex.length;
        this.friendRefs_saved[0] = new int[n];
        System.arraycopy(this.friendAtomIndex, 0, this.friendRefs_saved[0], 0, n);
        n = this.friendHybridIndex.length;
        this.friendRefs_saved[1] = new int[n];
        System.arraycopy(this.friendHybridIndex, 0, this.friendRefs_saved[1], 0, n);
    }

    public void restore_bonding() {
        int n = this.friendRefs_saved[0].length;
        this.friendAtomIndex = new int[n];
        System.arraycopy(this.friendRefs_saved[0], 0, this.friendAtomIndex, 0, n);
        n = this.friendRefs_saved[1].length;
        this.friendHybridIndex = new int[n];
        System.arraycopy(this.friendRefs_saved[1], 0, this.friendHybridIndex, 0, n);
    }

    public Matrix getHybrid(int n) {
        return this.U.getMatrix(0, this.NAO_indices.length - 1, n, n);
    }

    public double hybridScalarMul(int n, Matrix matrix) {
        double d = 0.0;
        int n2 = matrix.getRowDimension();
        for (int i = 0; i < n2; ++i) {
            d += this.U.get(i, n) * matrix.get(i, 0);
        }
        return d;
    }

    public boolean appendHybrid(double[] dArray) {
        if (this.nValidHybrids == this.NAO_indices.length) {
            return false;
        }
        for (int i = 0; i < dArray.length; ++i) {
            this.U.set(i, this.nValidHybrids, dArray[i]);
        }
        ++this.nValidHybrids;
        return true;
    }

    public boolean testLinIndep(double d, double[][] dArray) {
        if (this.nValidHybrids <= 1 && dArray == null) {
            return true;
        }
        Matrix matrix = this.U.getMatrix(0, this.NAO_indices.length - 1, 0, this.nValidHybrids - 1);
        Matrix matrix2 = matrix.transpose().times(matrix);
        if (this.nValidHybrids <= 1 && dArray != null) {
            dArray[0] = new double[]{matrix2.get(0, 0)};
            return true;
        }
        Object[] objectArray = Sorter.sorted_eigenData(matrix2.eig(), -1);
        double[] dArray2 = (double[])objectArray[0];
        if (dArray != null) {
            dArray[0] = dArray2;
        }
        return dArray2[dArray2.length - 1] > d;
    }

    public boolean appendHybridIfLinIndep(double d, double[] dArray) {
        if (!this.appendHybrid(dArray)) {
            return false;
        }
        if (this.testLinIndep(d, null)) {
            return true;
        }
        --this.nValidHybrids;
        return false;
    }

    public void symmetrOrth() {
        if (this.nValidHybrids <= 1) {
            return;
        }
        Matrix matrix = this.U.getMatrix(0, this.NAO_indices.length - 1, 0, this.nValidHybrids - 1);
        this.U.setMatrix(0, this.NAO_indices.length - 1, 0, this.nValidHybrids - 1, EigenEngine.symmetrOrth(matrix));
    }
}

