/*
 * Decompiled with CFR 0.152.
 */
package nwchem2molden;

import JGints.AtomicCenter;
import JGints.BasisFunction;
import JGints.MO;
import JGints.OverlapIntegrals;
import JGints.RadialPartOfBasisFunction;
import JGints.SphericalHarmonics;
import Polynom3D.Polynom3D;
import java.io.BufferedReader;
import java.io.FileReader;
import moldenio.MOLDEN_IO;
import nwchem2molden.BasisSetLoader;
import nwchem2molden.PeriodicTableData;

public class nw2moldenConverter {
    public MOLDEN_IO molden = new MOLDEN_IO();
    public boolean do_basis_comparison = true;
    public BasisSetLoader Extended_Basis_Info = null;

    private String[] _matches_fmts(BufferedReader bufferedReader, String[] stringArray) throws Exception {
        String[] stringArray2 = new String[stringArray.length];
        for (int i = 0; i < stringArray.length; ++i) {
            String string = bufferedReader.readLine();
            if (string == null) {
                return null;
            }
            if (!string.matches(stringArray[i])) {
                return null;
            }
            stringArray2[i] = string;
        }
        return stringArray2;
    }

    private String FourLinesHeaderParse(BufferedReader bufferedReader, String string) throws Exception {
        String string2;
        boolean bl = true;
        if (string == null) {
            string2 = bufferedReader.readLine();
            if (string2 == null) {
                return null;
            }
        } else {
            string2 = string;
        }
        if (!string2.matches(" +[a-zA-Z]+ \\(.+\\)")) {
            return null;
        }
        String string3 = string2.split("\\(")[0].trim();
        String[] stringArray = new String[]{" +\\-+", " +Exponent +Coefficients +", " +\\-+ +\\-+"};
        if (this._matches_fmts(bufferedReader, stringArray) == null) {
            return null;
        }
        return string3;
    }

    private String ParseElementBasis(BufferedReader bufferedReader, int n, BasisFunction basisFunction) throws Exception {
        String string = null;
        double[] dArray = new double[1000];
        double[] dArray2 = new double[1000];
        int n2 = 0;
        boolean bl = false;
        String string2 = " +[0-9]+ +[SPDFGHI]+ +[E0-9\\.\\-\\+\\,]+ +[0-9\\.\\,\\-\\+]+";
        boolean bl2 = false;
        while (!bl) {
            string = bufferedReader.readLine();
            bl = string == null;
            if (bl) continue;
            if (string.equals("")) {
                bl = bl2;
                if (bl) continue;
                basisFunction.coefs = new double[n2];
                basisFunction.exponents = new double[n2];
                System.arraycopy(dArray2, 0, basisFunction.exponents, 0, n2);
                System.arraycopy(dArray, 0, basisFunction.coefs, 0, n2);
                n2 = 0;
                bl2 = true;
                continue;
            }
            bl = !string.matches(string2);
            if (bl) continue;
            if (bl2) {
                basisFunction._next = new BasisFunction(null);
                basisFunction._next.IsSpherical = basisFunction.IsSpherical;
                basisFunction = basisFunction._next;
            }
            bl2 = false;
            basisFunction.Center_ID = n;
            String[] stringArray = string.split(" +");
            basisFunction.L = "SPDFGHI".indexOf(stringArray[2].toUpperCase());
            if (stringArray[2].length() > 1) {
                System.out.printf(" ERROR: \"%s\" type of basis functions is unknown!%n", stringArray[2]);
            }
            dArray2[n2] = Double.parseDouble(stringArray[3]);
            dArray[n2] = Double.parseDouble(stringArray[4]);
            ++n2;
        }
        return string;
    }

    public boolean _Parse_OUT_File(String string, MOLDEN_IO mOLDEN_IO) throws Exception {
        int n;
        Object object;
        String string2;
        FileReader fileReader = new FileReader(string);
        BufferedReader bufferedReader = new BufferedReader(fileReader);
        String string3 = null;
        boolean bl = false;
        boolean bl2 = false;
        int n2 = 0;
        AtomicCenter atomicCenter = null;
        AtomicCenter atomicCenter2 = null;
        BasisFunction basisFunction = null;
        BasisFunction basisFunction2 = null;
        double d = 1.0;
        while ((string2 = bufferedReader.readLine()) != null) {
            String[] stringArray;
            String[] stringArray2;
            bl = string2.matches(" +Basis \\\".+\\\" -> \\\".+\\\" \\(cartesian\\)");
            bl2 = string2.matches(" +Basis \\\".+\\\" -> \\\".+\\\" \\(spherical\\)");
            if (bl || bl2) {
                string3 = string2;
                string2 = bufferedReader.readLine();
                if (!string2.matches(" +\\-+")) {
                    bl2 = false;
                    bl = false;
                }
            }
            if (bl) {
                System.out.println(" CARTESIAN basis set information found:");
                mOLDEN_IO.IsSpherical = false;
            }
            if (bl2) {
                System.out.println(" SPHERICAL ('PURE') basis set information found:");
                mOLDEN_IO.IsSpherical = true;
            }
            if (bl || bl2) {
                System.out.println(string3);
                System.out.println(" reading basis set information...");
                basisFunction = null;
                object = null;
                basisFunction2 = null;
                do {
                    if ((stringArray2 = this.FourLinesHeaderParse(bufferedReader, (String)object)) == null) continue;
                    System.out.printf(" Basis for %s%n", new Object[]{stringArray2});
                    if (basisFunction2 == null) {
                        basisFunction = basisFunction2 = new BasisFunction(null);
                    } else {
                        basisFunction2 = basisFunction2._next = new BasisFunction(null);
                    }
                    basisFunction2.IsSpherical = mOLDEN_IO.IsSpherical;
                    object = this.ParseElementBasis(bufferedReader, PeriodicTableData.Name_to_Z((String)stringArray2), basisFunction2);
                    while (basisFunction2._next != null) {
                        basisFunction2 = basisFunction2._next;
                    }
                } while (stringArray2 != null);
                string2 = object;
            }
            if (string2.trim().matches("XYZ format geometry")) {
                // empty if block
            }
            if (!string2.matches(" +Geometry \\\".+\\\" -> \\\".*\\\"") || (stringArray2 = this._matches_fmts(bufferedReader, (String[])(object = new String[]{" +\\-+", "", " +Output coordinates in.+", "", " +No.+ +Tag.+ +Charge.+ +X.+ +Y.+ +Z", " +\\-+ +\\-+ +\\-+ +\\-+ +\\-+ +\\-+"}))) == null) continue;
            System.out.println(" Geometry information found ");
            System.out.printf(" geomrtey units: \"%s\"%n", stringArray2[2]);
            try {
                stringArray = null;
                stringArray = stringArray2[2].toLowerCase().split("\\(scale by")[1].split("to convert to a\\.u\\.")[0];
                stringArray = stringArray.trim();
                d = Double.parseDouble((String)stringArray);
            }
            catch (Exception exception) {
                d = 1.0;
                System.out.println("WARNING: failed to read a coefficient for transformation of coords. to a.u.");
                System.out.println(" a value of 1.0 is assumed");
            }
            atomicCenter = null;
            n2 = 0;
            atomicCenter2 = null;
            while (!(string2 = bufferedReader.readLine()).equals("")) {
                if (atomicCenter2 == null) {
                    atomicCenter = atomicCenter2 = new AtomicCenter();
                } else {
                    atomicCenter2 = atomicCenter2._next = new AtomicCenter();
                }
                stringArray = string2.split(" +");
                atomicCenter2.ID = Integer.parseInt(stringArray[1]);
                atomicCenter2.Name = stringArray[2];
                atomicCenter2.Z = Double.parseDouble(stringArray[3]);
                for (n = 0; n < 3; ++n) {
                    atomicCenter2.R0[n] = Double.parseDouble(stringArray[4 + n]);
                }
                ++n2;
            }
        }
        bufferedReader.close();
        fileReader.close();
        System.out.println(" Reading finished.");
        if (atomicCenter == null) {
            System.out.println("ERROR: no information about molecular geometry has been found!");
            return false;
        }
        System.out.printf(" %d atomic centers found%n", n2);
        if (basisFunction == null) {
            System.out.println("ERROR: no information about the basis set has been found!");
            return false;
        }
        object = string3.split("\\\"")[1].split("\\\"")[0].trim();
        mOLDEN_IO.Title = object;
        mOLDEN_IO.Centers = new AtomicCenter[n2];
        mOLDEN_IO.Coords_in_AU = true;
        atomicCenter2 = atomicCenter;
        for (int i = 0; i < n2; ++i) {
            mOLDEN_IO.Centers[i] = atomicCenter2;
            int n3 = 0;
            while (n3 < 3) {
                int n4 = n3++;
                mOLDEN_IO.Centers[i].R0[n4] = mOLDEN_IO.Centers[i].R0[n4] * d;
            }
            atomicCenter2 = atomicCenter2._next;
        }
        if (this.Extended_Basis_Info != null) {
            System.out.println("Using extended information about the basis set from an external source.");
            basisFunction2 = basisFunction;
            int[] nArray = new int[PeriodicTableData.all_elements.length + 1];
            while (basisFunction2 != null) {
                BasisFunction basisFunction3 = this.Extended_Basis_Info.TheBasis[basisFunction2.Center_ID][nArray[basisFunction2.Center_ID]];
                n = 1;
                if (basisFunction2.L != basisFunction3.L) {
                    System.out.printf(" ERROR: different L for Z = %2d, bs # %d%n", basisFunction2.Center_ID, nArray[basisFunction2.Center_ID]);
                    n = 0;
                }
                if (basisFunction2.coefs.length != basisFunction3.coefs.length) {
                    System.out.printf(" ERROR: different number of primitives for Z = %2d, bs # %d%n", basisFunction2.Center_ID, nArray[basisFunction2.Center_ID]);
                    n = 0;
                }
                if (n != 0) {
                    int n5;
                    double d2 = 0.0;
                    for (n5 = 0; n5 < basisFunction2.coefs.length; ++n5) {
                        d2 += Math.abs(basisFunction2.exponents[n5] - basisFunction3.exponents[n5]);
                    }
                    for (n5 = 0; n5 < basisFunction2.coefs.length; ++n5) {
                        d2 += Math.abs(basisFunction2.coefs[n5] - basisFunction3.coefs[n5]);
                    }
                    if (this.do_basis_comparison && d2 > 1.0E-4) {
                        System.out.printf("ERROR: coefs./exponents look very different for Z = %2d, bs # %d%n", basisFunction2.Center_ID, nArray[basisFunction2.Center_ID]);
                        n = 0;
                    }
                }
                if (n != 0) {
                    basisFunction2.coefs = basisFunction3.coefs;
                    basisFunction2.exponents = basisFunction3.exponents;
                }
                int n6 = basisFunction2.Center_ID;
                nArray[n6] = nArray[n6] + 1;
                basisFunction2 = basisFunction2._next;
            }
        }
        int n7 = 0;
        for (int i = 0; i < mOLDEN_IO.Centers.length; ++i) {
            basisFunction2 = basisFunction;
            while (basisFunction2 != null) {
                if ((double)basisFunction2.Center_ID == mOLDEN_IO.Centers[i].Z) {
                    ++n7;
                }
                basisFunction2 = basisFunction2._next;
            }
        }
        System.out.printf("Total number of radial parts of basis functions: %d%n", n7);
        mOLDEN_IO.RadialParts = new RadialPartOfBasisFunction[n7];
        SphericalHarmonics sphericalHarmonics = new SphericalHarmonics();
        Polynom3D[][] polynom3DArray = sphericalHarmonics.Get_Quick_YLM_Norm4PI();
        double[][] dArray = SphericalHarmonics.Get_Quick_YLM_Norm2(sphericalHarmonics.Get_Quick_YLM());
        double[] dArray2 = sphericalHarmonics.molden_cart_norms2_over_4Pi();
        OverlapIntegrals overlapIntegrals = new OverlapIntegrals();
        basisFunction2 = basisFunction;
        int n8 = 0;
        while (basisFunction2 != null) {
            BasisFunction basisFunction4 = new BasisFunction(basisFunction2);
            int n9 = 0;
            while (n9 < basisFunction4.coefs.length) {
                double d3 = Math.PI * 4 * OverlapIntegrals.primitive_int_1D_Sphr(2 * basisFunction4.L + 2, 2.0 * basisFunction4.exponents[n9]);
                int n10 = n9++;
                basisFunction4.coefs[n10] = basisFunction4.coefs[n10] / Math.sqrt(d3);
            }
            basisFunction4.Quick_YLM = polynom3DArray;
            basisFunction4.OI = overlapIntegrals;
            basisFunction4.R0 = new double[]{0.0, 0.0, 0.0};
            double d4 = basisFunction4.OverlapWith(basisFunction4);
            int n11 = 0;
            while (n11 < basisFunction2.coefs.length) {
                int n12 = n11++;
                basisFunction2.coefs[n12] = basisFunction2.coefs[n12] / Math.sqrt(d4);
            }
            basisFunction2 = basisFunction2._next;
        }
        n8 = 0;
        for (int i = 0; i < mOLDEN_IO.Centers.length; ++i) {
            basisFunction2 = basisFunction;
            while (basisFunction2 != null) {
                if ((double)basisFunction2.Center_ID == mOLDEN_IO.Centers[i].Z) {
                    mOLDEN_IO.RadialParts[n8] = new RadialPartOfBasisFunction();
                    mOLDEN_IO.RadialParts[n8].CenterID = i + 1;
                    mOLDEN_IO.RadialParts[n8].Exponents = basisFunction2.exponents;
                    mOLDEN_IO.RadialParts[n8].LUsedWith = basisFunction2.L;
                    mOLDEN_IO.RadialParts[n8].Coefs = basisFunction2.coefs;
                    ++n8;
                }
                basisFunction2 = basisFunction2._next;
            }
        }
        return true;
    }

    private double[] _read_doubles(BufferedReader bufferedReader, int n) throws Exception {
        double[] dArray = new double[n];
        int n2 = 0;
        while (n2 < n) {
            String string = bufferedReader.readLine();
            if (string == null) {
                return null;
            }
            String[] stringArray = string.trim().split(" +");
            for (int i = 0; i < stringArray.length; ++i) {
                dArray[n2] = Double.parseDouble(stringArray[i]);
                ++n2;
            }
        }
        return dArray;
    }

    public boolean _Parse_ASC_File(String string, MOLDEN_IO mOLDEN_IO) throws Exception {
        int n;
        int n2;
        FileReader fileReader = new FileReader(string);
        BufferedReader bufferedReader = new BufferedReader(fileReader);
        String string2 = mOLDEN_IO.Title;
        System.out.println(" Reading orbitals from " + string);
        for (n2 = 0; n2 < 4; ++n2) {
            bufferedReader.readLine();
        }
        System.out.println("\"scftype20\": " + bufferedReader.readLine());
        System.out.println("Date: " + bufferedReader.readLine());
        System.out.println("job type: " + bufferedReader.readLine());
        for (n2 = 0; n2 < 3; ++n2) {
            bufferedReader.readLine();
        }
        String string3 = bufferedReader.readLine();
        System.out.println("basis set name: " + string3);
        if (!string3.equals(string2)) {
            System.out.printf("WARNING: basis set name in asc file (\"%s\") and log file (\"%s\") differ%n", string3, string2);
        }
        if ((n2 = Integer.parseInt(bufferedReader.readLine().trim())) != 1) {
            System.out.println("ERROR: asc files with more than one set of orbitals are not supported!");
            return false;
        }
        int n3 = Integer.parseInt(bufferedReader.readLine().trim());
        int n4 = Integer.parseInt(bufferedReader.readLine().trim());
        System.out.printf(" There are %d basis functions and %d orbitals%n", n3, n4);
        if (n4 < n3) {
            System.out.println("WARNING: the number of orbitals is less than the number of basis functions%n");
        }
        mOLDEN_IO.MOs = new MO[n4];
        double[] dArray = this._read_doubles(bufferedReader, n3);
        if (dArray == null) {
            System.out.println("ERROR: can not read orbital occupations.");
            return false;
        }
        for (int i = 0; i < n4; ++i) {
            mOLDEN_IO.MOs[i] = new MO();
            mOLDEN_IO.MOs[i].Occupancy = dArray[i];
        }
        double[] dArray2 = this._read_doubles(bufferedReader, n3);
        if (dArray == null) {
            System.out.println("ERROR: can not read orbital energies.");
            return false;
        }
        boolean bl = true;
        for (n = 0; n < n4 && bl; ++n) {
            bl = dArray2[n] > 0.0;
        }
        if (bl) {
            System.out.println("WARNING: There are no negative values in the set of orbital energies");
            System.out.println(" (this is typical for non-SCF type calculations).");
            System.out.println(" These values will not be written to molden file!");
            for (n = 0; n < n4; ++n) {
                mOLDEN_IO.MOs[n].Energy = 0.0;
            }
        } else {
            for (n = 0; n < n4; ++n) {
                mOLDEN_IO.MOs[n].Energy = dArray2[n];
            }
        }
        for (n = 0; n < n4; ++n) {
            mOLDEN_IO.MOs[n].BS_Coefs = this._read_doubles(bufferedReader, n3);
        }
        double[] dArray3 = SphericalHarmonics.molden_cart_norms2_over_4Pi();
        int n5 = 0;
        if (mOLDEN_IO.IsSpherical) {
            for (int i = 0; i < mOLDEN_IO.RadialParts.length; ++i) {
                double[] dArray4;
                int n6;
                if (mOLDEN_IO.RadialParts[i].LUsedWith == 2) {
                    for (n6 = 0; n6 < n4; ++n6) {
                        dArray4 = new double[]{mOLDEN_IO.MOs[n6].BS_Coefs[n5 + 2], -mOLDEN_IO.MOs[n6].BS_Coefs[n5 + 3], mOLDEN_IO.MOs[n6].BS_Coefs[n5 + 1], mOLDEN_IO.MOs[n6].BS_Coefs[n5 + 4], mOLDEN_IO.MOs[n6].BS_Coefs[n5 + 0]};
                        System.arraycopy(dArray4, 0, mOLDEN_IO.MOs[n6].BS_Coefs, n5, dArray4.length);
                    }
                }
                if (mOLDEN_IO.RadialParts[i].LUsedWith == 3) {
                    for (n6 = 0; n6 < n4; ++n6) {
                        dArray4 = new double[]{mOLDEN_IO.MOs[n6].BS_Coefs[n5 + 3], -mOLDEN_IO.MOs[n6].BS_Coefs[n5 + 4], mOLDEN_IO.MOs[n6].BS_Coefs[n5 + 2], mOLDEN_IO.MOs[n6].BS_Coefs[n5 + 5], mOLDEN_IO.MOs[n6].BS_Coefs[n5 + 1], -mOLDEN_IO.MOs[n6].BS_Coefs[n5 + 6], mOLDEN_IO.MOs[n6].BS_Coefs[n5 + 0]};
                        System.arraycopy(dArray4, 0, mOLDEN_IO.MOs[n6].BS_Coefs, n5, dArray4.length);
                    }
                }
                if (mOLDEN_IO.RadialParts[i].LUsedWith == 4) {
                    for (n6 = 0; n6 < n4; ++n6) {
                        dArray4 = new double[]{mOLDEN_IO.MOs[n6].BS_Coefs[n5 + 4], -mOLDEN_IO.MOs[n6].BS_Coefs[n5 + 5], mOLDEN_IO.MOs[n6].BS_Coefs[n5 + 3], mOLDEN_IO.MOs[n6].BS_Coefs[n5 + 6], mOLDEN_IO.MOs[n6].BS_Coefs[n5 + 2], -mOLDEN_IO.MOs[n6].BS_Coefs[n5 + 7], mOLDEN_IO.MOs[n6].BS_Coefs[n5 + 1], mOLDEN_IO.MOs[n6].BS_Coefs[n5 + 8], mOLDEN_IO.MOs[n6].BS_Coefs[n5 + 0]};
                        System.arraycopy(dArray4, 0, mOLDEN_IO.MOs[n6].BS_Coefs, n5, dArray4.length);
                    }
                }
                n5 += 2 * mOLDEN_IO.RadialParts[i].LUsedWith + 1;
            }
        } else {
            for (int i = 0; i < mOLDEN_IO.RadialParts.length; ++i) {
                int n7;
                double[] dArray5;
                int n8;
                if (mOLDEN_IO.RadialParts[i].LUsedWith == 0) {
                    ++n5;
                }
                if (mOLDEN_IO.RadialParts[i].LUsedWith == 1) {
                    n5 += 3;
                }
                if (mOLDEN_IO.RadialParts[i].LUsedWith == 2) {
                    for (n8 = 0; n8 < n4; ++n8) {
                        dArray5 = new double[]{mOLDEN_IO.MOs[n8].BS_Coefs[n5 + 0], mOLDEN_IO.MOs[n8].BS_Coefs[n5 + 3], mOLDEN_IO.MOs[n8].BS_Coefs[n5 + 5], mOLDEN_IO.MOs[n8].BS_Coefs[n5 + 1] * Math.sqrt(dArray3[7] * 5.0), mOLDEN_IO.MOs[n8].BS_Coefs[n5 + 2] * Math.sqrt(dArray3[8] * 5.0), mOLDEN_IO.MOs[n8].BS_Coefs[n5 + 4] * Math.sqrt(dArray3[9] * 5.0)};
                        System.arraycopy(dArray5, 0, mOLDEN_IO.MOs[n8].BS_Coefs, n5, dArray5.length);
                    }
                    n5 += 6;
                }
                if (mOLDEN_IO.RadialParts[i].LUsedWith == 3) {
                    for (n8 = 0; n8 < n4; ++n8) {
                        dArray5 = new double[]{mOLDEN_IO.MOs[n8].BS_Coefs[n5 + 0], mOLDEN_IO.MOs[n8].BS_Coefs[n5 + 6], mOLDEN_IO.MOs[n8].BS_Coefs[n5 + 9], mOLDEN_IO.MOs[n8].BS_Coefs[n5 + 3], mOLDEN_IO.MOs[n8].BS_Coefs[n5 + 1], mOLDEN_IO.MOs[n8].BS_Coefs[n5 + 2], mOLDEN_IO.MOs[n8].BS_Coefs[n5 + 5], mOLDEN_IO.MOs[n8].BS_Coefs[n5 + 8], mOLDEN_IO.MOs[n8].BS_Coefs[n5 + 7], mOLDEN_IO.MOs[n8].BS_Coefs[n5 + 4]};
                        for (n7 = 0; n7 < dArray5.length; ++n7) {
                            int n9 = n7;
                            dArray5[n9] = dArray5[n9] * Math.sqrt(dArray3[10 + n7] * 7.0);
                        }
                        System.arraycopy(dArray5, 0, mOLDEN_IO.MOs[n8].BS_Coefs, n5, dArray5.length);
                    }
                    n5 += 10;
                }
                if (mOLDEN_IO.RadialParts[i].LUsedWith != 4) continue;
                for (n8 = 0; n8 < n4; ++n8) {
                    dArray5 = new double[]{mOLDEN_IO.MOs[n8].BS_Coefs[n5 + 0], mOLDEN_IO.MOs[n8].BS_Coefs[n5 + 10], mOLDEN_IO.MOs[n8].BS_Coefs[n5 + 14], mOLDEN_IO.MOs[n8].BS_Coefs[n5 + 1], mOLDEN_IO.MOs[n8].BS_Coefs[n5 + 2], mOLDEN_IO.MOs[n8].BS_Coefs[n5 + 6], mOLDEN_IO.MOs[n8].BS_Coefs[n5 + 11], mOLDEN_IO.MOs[n8].BS_Coefs[n5 + 9], mOLDEN_IO.MOs[n8].BS_Coefs[n5 + 13], mOLDEN_IO.MOs[n8].BS_Coefs[n5 + 3], mOLDEN_IO.MOs[n8].BS_Coefs[n5 + 5], mOLDEN_IO.MOs[n8].BS_Coefs[n5 + 12], mOLDEN_IO.MOs[n8].BS_Coefs[n5 + 4], mOLDEN_IO.MOs[n8].BS_Coefs[n5 + 7], mOLDEN_IO.MOs[n8].BS_Coefs[n5 + 8]};
                    for (n7 = 0; n7 < dArray5.length; ++n7) {
                        int n10 = n7;
                        dArray5[n10] = dArray5[n10] * Math.sqrt(dArray3[20 + n7] * 9.0);
                    }
                    System.arraycopy(dArray5, 0, mOLDEN_IO.MOs[n8].BS_Coefs, n5, dArray5.length);
                }
                n5 += 15;
            }
        }
        bufferedReader.close();
        fileReader.close();
        return true;
    }
}

