/*
 * Decompiled with CFR 0.152.
 */
package onpa;

import CLPO.CT_Estimator;
import CLPO.PropertyOptimizedOrbitals;
import JGints.AtomicCenter;
import JGints.SphericalHarmonics;
import Jama.Matrix;
import MatrixHelper.EigenEngine;
import Polynom3D.Polynom3D;
import ProgramOptions.OptionParameter;
import ProgramOptions.ProgTimer;
import ProgramOptions.WarningManager;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.util.Locale;
import moldenio.MOLDEN_IO;
import onpa.NPA;
import onpa.ono_options;
import onpa.printout;

public class Main {
    static String Version = "2.02 (13-01-2019)";
    static PrintStream out = System.out;
    private static ono_options Options = new ono_options();

    static void Print_NMB_Submatrix(NPA nPA, Matrix matrix) {
        int n;
        out.printf("%15s", "orbital#");
        for (n = 0; n < nPA.NAO.length; ++n) {
            if (nPA.PNAOs[n].NRB) continue;
            out.printf("%15s", nPA.PNAO_Labels[n]);
        }
        out.println();
        for (n = 0; n < nPA.NAO.length; ++n) {
            if (nPA.PNAOs[n].NRB) continue;
            out.printf("%4d %11s", n + 1, nPA.PNAO_Labels[n]);
            for (int i = 0; i < nPA.NAO.length; ++i) {
                if (nPA.PNAOs[i].NRB) continue;
                out.printf("%15.7f", matrix.get(n, i));
            }
            out.println();
        }
    }

    private static void ShowBanner() {
        out.println(" * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *");
        out.println(" *    janpa: A cross-platform open-source implementation of NPA        * ");
        out.println(" *    and other electronic structure analysis methods with Java        * ");
        out.println(" *        A part of JANPA package,   http://janpa.sourceforge.net      * ");
        out.printf(" *                    Version: %20s                    * %n", Version);
        out.println(" * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *");
        out.println();
        out.println(" (c) Tymofii Nikolaienko, 2014-2019");
        out.println();
        out.println(" If any results obtained with this program are published,");
        out.println(" or for any other reasons, please, cite this work as: ");
        out.println(" 1) T.Y.Nikolaienko, L.A.Bulavin; Int. J. Quantum Chem. (2019), ");
        out.println("    Vol.119, page e25798, DOI: 10.1002/qua.25798");
        out.println(" 2) T.Y.Nikolaienko, L.A.Bulavin, D.M.Hovorun; Comput.Theor.Chem.(2014),");
        out.println("    Vol.1050, pages 15-22, DOI: 10.1016/j.comptc.2014.10.002");
        printout.PrintStars();
    }

    private static void print_bond_indices(Matrix matrix, AtomicCenter[] atomicCenterArray, String string) throws Exception {
        int n;
        int n2;
        int n3 = atomicCenterArray.length;
        out.println("Wiberg-Mayer bond indices (based on density matrix in NAO basis):");
        out.printf("%10s", "Centr. A/B");
        for (n2 = 0; n2 < n3; ++n2) {
            out.printf("%10d", n2 + 1);
        }
        out.println();
        for (n2 = 0; n2 < n3; ++n2) {
            out.printf("%7d   ", n2 + 1);
            for (n = 0; n < n2; ++n) {
                out.printf("%10s", "");
            }
            out.printf(" (%7.4f)", matrix.get(n2, n2));
            for (n = n2 + 1; n < n3; ++n) {
                out.printf("%10.4f", matrix.get(n2, n));
            }
            out.println();
        }
        if (!string.isEmpty()) {
            String[] stringArray = new String[n3];
            for (n = 0; n < n3; ++n) {
                stringArray[n] = String.format("%s%d", atomicCenterArray[n].Name, n + 1);
            }
            printout.Print_Matrix(matrix, "Wiberg-Mayer bond indices computed in NAO basis (note: diagonal elements are atomic 'valencies' (sums of all bond orders in current line)):", stringArray, stringArray, string);
        }
    }

    public static void main(String[] stringArray) throws Exception {
        String string;
        String string2;
        String string3;
        String[] stringArray2;
        Object[] objectArray;
        String[] stringArray3;
        int n;
        Object object;
        Object object2;
        Object object3;
        ProgTimer progTimer = new ProgTimer();
        Locale.setDefault(Locale.US);
        String string4 = null;
        Main.ShowBanner();
        OptionParameter cfr_ignored_0 = Main.Options.Heavy_NRB_Threshold;
        OptionParameter.default_double_format = "%.2E";
        if (stringArray.length < 1) {
            out.println("Usage: ");
            out.println(" java -jar janpa.jar input-molden-file");
            out.println("or ");
            out.println(" java -jar janpa.jar -i input-molden-file [other possible options]");
            out.println();
            out.println("where possible options are: ");
            out.println();
            Main.Options._FirstOption.PrintDescriptions(null, " %s:  %s (default: %s)%n%n");
            printout.PrintStars();
            return;
        }
        if (stringArray.length == 1) {
            string4 = stringArray[0];
            Main.Options.Input_Molden_File.ReadDataFromString(string4);
        } else {
            Main.Options._FirstOption.LoadOptionsFromCommandLine(stringArray, null, true, true);
            object3 = Main.Options.Parameter_File.get_String();
            if (!((String)object3).isEmpty()) {
                Main.Options._FirstOption.LoadOptionsFromFile(new BufferedReader(new FileReader((String)object3)), null, true);
            }
            Main.Options._FirstOption.LoadOptionsFromCommandLine(stringArray, null, true, true);
            string4 = Main.Options.Input_Molden_File.get_String();
        }
        if (string4 == null || string4.isEmpty()) {
            out.println("Error: no file name of the input molden file provided.");
            return;
        }
        if (!new File(string4).isFile()) {
            out.printf("ERROR: \"%s\" can not be opened or is not a file.%n", string4);
            return;
        }
        out.printf("Settings used in this run:%n%n", new Object[0]);
        Main.Options._FirstOption.Print_as_List(null, " %s: %s%n");
        printout.PrintStars();
        out.println("Loading MOLDEN from " + string4);
        object3 = new MOLDEN_IO();
        object3 = new MOLDEN_IO();
        ((MOLDEN_IO)object3).Allow_additional_r_power = true;
        if (!((MOLDEN_IO)object3).Load_From_MOLDEN(string4)) {
            out.println("Error loading data");
            return;
        }
        out.println();
        out.println("Data loaded successfully");
        out.printf(" Number of basis functions: %d; number of molecular orbitals: %d %n", ((MOLDEN_IO)object3).Basis.length, ((MOLDEN_IO)object3).MOs.length);
        out.println();
        if (!((MOLDEN_IO)object3).IsSpherical) {
            out.println(" ERROR: Input molden file does not have a 'pure' ('spherical') basis set!");
            out.println(" Try using molden2molden -cart2pure to convert it.");
            return;
        }
        NPA nPA = new NPA(Options);
        EigenEngine eigenEngine = new EigenEngine();
        eigenEngine.glbPrint = Main.Options.glbPrint;
        ((MOLDEN_IO)object3).CoordsToAU();
        if (Main.Options.PrintGeometry.get_boolean()) {
            out.printf("%nCartesian coordinates of the atoms (in atomic units):%n", new Object[0]);
            out.printf("%s\t%s\t%s\t%s\t%s\t%s%n", "ID", "Element", "Nucl.Chrg.", "     X     ", "     Y     ", "     Z     ");
            for (int i = 0; i < ((MOLDEN_IO)object3).Centers.length; ++i) {
                out.printf("%d\t%s\t%.1f\t%.10f\t%.10f\t%.10f%n", i + 1, ((MOLDEN_IO)object3).Centers[i].Name, ((MOLDEN_IO)object3).Centers[i].Z, ((MOLDEN_IO)object3).Centers[i].R0[0], ((MOLDEN_IO)object3).Centers[i].R0[1], ((MOLDEN_IO)object3).Centers[i].R0[2]);
            }
            printout.PrintStars();
        }
        Polynom3D[][] polynom3DArray = SphericalHarmonics.Get_Quick_YLM_Norm4PI();
        nPA.Quick_YLM = polynom3DArray;
        if (!Main.Options.Overlap_Naive.get_boolean()) {
            ((MOLDEN_IO)object3).ToUnnormalizedPrimitiveCoefs();
        } else {
            double[][] dArray = SphericalHarmonics.Get_Quick_YLM_Norm2(polynom3DArray);
            ((MOLDEN_IO)object3).UnNormalizePrimitives(dArray);
        }
        boolean bl = nPA.Load_MO_From_MOLDEN((MOLDEN_IO)object3);
        if (!bl) {
            out.println(" MOLDEN data is not acceptable!");
            return;
        }
        nPA.Create_NAOs();
        printout.PrintStars();
        Matrix matrix = nPA.BondIndexes();
        Main.print_bond_indices(matrix, nPA.Centers, Main.Options.WiebergBondOrders_File.get_String());
        printout.PrintStars();
        PropertyOptimizedOrbitals propertyOptimizedOrbitals = new PropertyOptimizedOrbitals();
        propertyOptimizedOrbitals.createCLPOs(nPA.SDS_NAO, nPA.NAO, nPA.Centers, Options);
        printout.PrintStars();
        out.println("Atomic connectivity analysis based on CLPO bonding graph:");
        out.println();
        int[] nArray = propertyOptimizedOrbitals.LOconnectivity(propertyOptimizedOrbitals.CLPO_descript, nPA.NPA_charges);
        printout.PrintStars();
        new CT_Estimator(propertyOptimizedOrbitals.CLPO_descript, nPA.SDS_NAO).new_CT(nArray);
        if (!Main.Options.Charges_File.get_String().isEmpty()) {
            object2 = Main.Options.Charges_File.get_String();
            out.println("Writing NPA charges to\t" + (String)object2);
            object = new PrintWriter(new FileOutputStream((String)object2));
            for (n = 0; n < nPA.Centers.length; ++n) {
                ((PrintWriter)object).printf("%.16f%n", nPA.NPA_charges[n]);
            }
            ((PrintWriter)object).close();
        }
        ((MOLDEN_IO)object3).ToNormalizedPrimitiveCoefs();
        object2 = NPA.BasisFunctionsToMatrix(nPA.PNAOs, false);
        object = NPA.BasisFunctionsToOccupancies(nPA.PNAOs);
        n = 0;
        if (((MOLDEN_IO)object3).MOs.length < ((MOLDEN_IO)object3).Basis.length) {
            out.printf(" No information about virtual molecular orbitals was found%n Fock matrix will not be analyzed.%n", new Object[0]);
        }
        Matrix matrix2 = null;
        Matrix matrix3 = null;
        Matrix matrix4 = null;
        if (Main.Options.do_Fock.get_boolean()) {
            n = 1;
        }
        printout.PrintStars();
        if (n != 0) {
            stringArray3 = NPA.Create_NAO_Labels(nPA.NAO);
            out.println("Fock matrix analysis in NAO basis");
            out.println();
            objectArray = new Matrix(((MOLDEN_IO)object3).MOs.length, ((MOLDEN_IO)object3).MOs.length, 0.0);
            for (int i = 0; i < ((MOLDEN_IO)object3).MOs.length; ++i) {
                objectArray.set(i, i, ((MOLDEN_IO)object3).MOs[i].Energy);
            }
            out.println("Building MO -> AO matrix...");
            Matrix matrix5 = new Matrix(((MOLDEN_IO)object3).get_MO2AO_array(false));
            out.println("Inverting MO -> AO matrix...");
            stringArray2 = matrix5.inverse();
            out.println("Transforming Fock matrix to AO basis...");
            matrix3 = eigenEngine.TransformMatrixToNewBasis((Matrix)objectArray, (Matrix)stringArray2, true);
            printout.Print_Matrix(matrix3, "Fock matrix in AO basis", nPA.AO_Names, nPA.AO_Names, Main.Options.Fock_AO_File.get_String());
            out.println("Transforming Fock matrix to NAO basis...");
            matrix2 = eigenEngine.TransformMatrixToNewBasis(matrix3, nPA.NAO_2_AO, true);
            printout.Print_Matrix(matrix2, "Fock matrix in NAO basis", stringArray3, stringArray3, Main.Options.Fock_NAO_File.get_String());
            out.printf("NAO\t          Label\tHost\toccup.\t<NAO|F|NAO>%n", new Object[0]);
            out.printf("   \t               \tatom\t      \t           %n", new Object[0]);
            for (int i = 0; i < nPA.NAO.length; ++i) {
                out.printf("%d\t%15s\t%d\t%.7f\t%.7f%n", i + 1, stringArray3[i], nPA.NAO[i].Center_ID, nPA.NAO[i].weight, matrix2.get(i, i));
            }
            matrix4 = eigenEngine.TransformMatrixToNewBasis(matrix3, (Matrix)object2, true);
            if (Main.Options.PrintNBMSubmatrices.get_boolean()) {
                out.println("Fock submatrix in NMB PNAO basis");
                Main.Print_NMB_Submatrix(nPA, matrix4);
                out.println("PNAO overlap submatrix in NMB PNAO basis");
                Main.Print_NMB_Submatrix(nPA, nPA.PNAO_Overlap_Matrix);
                out.println("Fock submatrix in NMB NAO basis");
                Main.Print_NMB_Submatrix(nPA, matrix2);
            }
        }
        if (!Main.Options.PNAO_Molden_File.get_String().isEmpty()) {
            out.println("Writing PNAOs to\t" + Main.Options.PNAO_Molden_File.get_String());
            stringArray3 = null;
            if (matrix4 != null) {
                out.println("Note: diagonal elements of the Fock matrix in PNAO baiss will be used as PNAO energies");
                stringArray3 = (String[])new double[nPA.PNAOs.length];
                for (int i = 0; i < nPA.PNAOs.length; ++i) {
                    stringArray3[i] = (String)matrix4.get(i, i);
                }
            }
            printout.Export_Orbitals((MOLDEN_IO)object3, (Matrix)object2, (double[])object, (double[])stringArray3, Main.Options.PNAO_Molden_File.get_String(), false, "PNAOs");
        }
        if (!Main.Options.PNAO2AO_File.get_String().isEmpty()) {
            printout.Print_Matrix((Matrix)object2, "Pre-NAOs in AO basis", nPA.PNAO_Labels, nPA.AO_Names, Main.Options.PNAO2AO_File.get_String());
        }
        stringArray3 = (String[])NPA.BasisFunctionsToOccupancies(nPA.NAO);
        if (!Main.Options.NAO_Molden_File.get_String().isEmpty()) {
            out.println("Writing NAOs to\t" + Main.Options.NAO_Molden_File.get_String());
            objectArray = null;
            if (matrix2 != null) {
                out.println("Note: diagonal elements of the Fock matrix in NAO baiss will be used as NAO energies");
                objectArray = new double[nPA.NAO.length];
                for (int i = 0; i < nPA.NAO.length; ++i) {
                    objectArray[i] = (Matrix)matrix2.get(i, i);
                }
            }
            printout.Export_Orbitals((MOLDEN_IO)object3, nPA.NAO_2_AO, (double[])stringArray3, (double[])objectArray, Main.Options.NAO_Molden_File.get_String(), false, "NAOs");
        }
        if (!Main.Options.CLPO2LHO_File.get_String().isEmpty()) {
            printout.Print_Matrix(propertyOptimizedOrbitals.CLPO_descript.LO_to_Hybrids, "CLPOs in LHO basis", propertyOptimizedOrbitals.CLPO_descript.Hybrid_labels, propertyOptimizedOrbitals.CLPO_descript.LO_labels, Main.Options.CLPO2LHO_File.get_String());
        }
        if (!Main.Options.LHO2NAO_File.get_String().isEmpty()) {
            printout.Print_Matrix(propertyOptimizedOrbitals.CLPO_descript.NAO_to_Hybrids.transpose(), "LHOs in NAO basis", nPA.PNAO_Labels, propertyOptimizedOrbitals.CLPO_descript.Hybrid_labels, Main.Options.LHO2NAO_File.get_String());
        }
        if (!Main.Options.LPO2AHO_File.get_String().isEmpty()) {
            printout.Print_Matrix(propertyOptimizedOrbitals.LPO_descript.LO_to_Hybrids, "LPOs in AHO basis", propertyOptimizedOrbitals.LPO_descript.Hybrid_labels, propertyOptimizedOrbitals.LPO_descript.LO_labels, Main.Options.LPO2AHO_File.get_String());
        }
        if (!Main.Options.AHO2NAO_File.get_String().isEmpty()) {
            printout.Print_Matrix(propertyOptimizedOrbitals.LPO_descript.NAO_to_Hybrids.transpose(), "AHOs in NAO basis", nPA.PNAO_Labels, propertyOptimizedOrbitals.LPO_descript.Hybrid_labels, Main.Options.AHO2NAO_File.get_String());
        }
        objectArray = new Matrix[4];
        String[] stringArray4 = new String[4];
        stringArray2 = new String[4];
        String string5 = Main.Options.LHO_Molden_File.get_String();
        if (!string5.isEmpty()) {
            objectArray[0] = propertyOptimizedOrbitals.CLPO_descript.NAO_to_Hybrids.transpose();
            stringArray4[0] = string5;
            stringArray2[0] = "LHOs";
        }
        if (!(string3 = Main.Options.CLPO_Molden_File.get_String()).isEmpty()) {
            objectArray[1] = propertyOptimizedOrbitals.CLPO_descript.LO_to_Hybrids.times(propertyOptimizedOrbitals.CLPO_descript.NAO_to_Hybrids.transpose());
            stringArray4[1] = string3;
            stringArray2[1] = "CLPOs";
        }
        if (!(string2 = Main.Options.AHO_Molden_File.get_String()).isEmpty()) {
            objectArray[2] = propertyOptimizedOrbitals.LPO_descript.NAO_to_Hybrids.transpose();
            stringArray4[2] = string2;
            stringArray2[2] = "AHOs";
        }
        if (!(string = Main.Options.LPO_Molden_File.get_String()).isEmpty()) {
            objectArray[3] = propertyOptimizedOrbitals.LPO_descript.LO_to_Hybrids.times(propertyOptimizedOrbitals.LPO_descript.NAO_to_Hybrids.transpose());
            stringArray4[3] = string;
            stringArray2[3] = "LPOs";
        }
        for (int i = 0; i < objectArray.length; ++i) {
            int n2;
            if (objectArray[i] == null) continue;
            Matrix matrix6 = objectArray[i].times(nPA.NAO_2_AO);
            Matrix matrix7 = objectArray[i].times(nPA.SDS_NAO);
            int n3 = nPA.NAO.length;
            double[] dArray = new double[n3];
            for (int j = 0; j < n3; ++j) {
                for (n2 = 0; n2 < n3; ++n2) {
                    int n4 = j;
                    dArray[n4] = dArray[n4] + matrix7.get(j, n2) * objectArray[i].get(j, n2);
                }
            }
            out.printf("Writing %s to\t%s%n", stringArray2[i], stringArray4[i]);
            out.printf("Please, note that 'Energy' of the orbitals in MOLDEN file will simply be set to their sequential numbers!%n%n", new Object[0]);
            double[] dArray2 = new double[n3];
            for (n2 = 0; n2 < n3; ++n2) {
                dArray2[n2] = n2;
            }
            printout.Export_Orbitals((MOLDEN_IO)object3, matrix6, dArray, dArray2, stringArray4[i], false, stringArray2[i]);
        }
        progTimer.Stop();
        WarningManager.summarizeWarnings();
        progTimer.Print();
        printout.PrintStars();
    }
}

