/*
 * Decompiled with CFR 0.152.
 */
package JGints;

import JGints.AtomicCenter;
import JGints.BasisFunction;
import JGints.NestedFunctionsDerivs;
import JGints.OverlapIntegrals;
import JGints.Polynom_rho_z;
import JGints.RadialPartOfBasisFunction;
import JGints.RealWignerAdapt;
import JGints.SphericalHarmonics;
import Jama.Matrix;
import Polynom3D.Polynom3D;
import ProgramOptions.ProgTimer;
import java.io.PrintStream;
import java.util.Locale;
import moldenio.MOLDEN_IO;

public class JGintsCyl {
    public BasisFunction[] basis;
    public RadialPartOfBasisFunction[] RadialParts;
    public AtomicCenter[] centers;
    public double[][] OverlapMatrix;
    public double[][][] DipoleMatrix;
    PrintStream out = System.out;
    final int[][] P2moldenP = new int[][]{{0}, {1, -1, 0}, {-2, -1, 0, 1, 2}, {-3, -2, -1, 0, 1, 2, 3}, {-4, -3, -2, -1, 0, 1, 2, 3, 4}};
    final int[][] moldenP2P = new int[][]{{0}, {0, 1, -1}, {-2, -1, 0, 1, 2}, {-3, -2, -1, 0, 1, 2, 3}, {-4, -3, -2, -1, 0, 1, 2, 3, 4}};
    private double[] ra_new = new double[]{0.0, 0.0, 0.0};
    private double[] rb_new = new double[]{0.0, 0.0, 0.0};
    private Polynom3D YLM1;
    private Polynom3D YLM2;
    private OverlapIntegrals OI = new OverlapIntegrals();
    private NestedFunctionsDerivs derivComputer = new NestedFunctionsDerivs();
    private final int PrimitiveGOverlapInt_resultsLEN = 4;

    private double[] ThetaPhi(double[] dArray, double[] dArray2) {
        double[] dArray3 = new double[3];
        for (int i = 0; i < 3; ++i) {
            dArray3[i] = dArray2[i] - dArray[i];
        }
        double[] dArray4 = new double[]{Math.atan2(Math.sqrt(dArray3[1] * dArray3[1] + dArray3[0] * dArray3[0]), dArray3[2]), Math.atan2(dArray3[1], dArray3[0])};
        return dArray4;
    }

    double[][] Wigner2MOLDEN(double[][] dArray, int n) {
        double[][] dArray2 = new double[2 * n + 1][2 * n + 1];
        for (int i = -n; i <= n; ++i) {
            for (int j = -n; j <= n; ++j) {
                dArray2[n + i][n + j] = dArray[n + this.moldenP2P[n][n + i]][n + this.moldenP2P[n][n + j]];
            }
        }
        return dArray2;
    }

    double[][] WignerTranspose(double[][] dArray, int n) {
        double[][] dArray2 = new double[2 * n + 1][2 * n + 1];
        for (int i = -n; i <= n; ++i) {
            for (int j = -n; j <= n; ++j) {
                dArray2[n + i][n + j] = dArray[n + j][n + i];
            }
        }
        return dArray2;
    }

    public static void PrimitiveGOverlapInt(double d, int n, double d2, int n2, double d3, int n3, double d4, int n4, int n5, double[][] dArray, boolean bl) {
        int n6;
        double d5 = d + d3;
        double d6 = (d * d2 + d3 * d4) / d5;
        double d7 = Math.exp(-d * d3 * (d4 - d2) * (d4 - d2) / d5);
        int n7 = n + n3 + n2 + n4;
        int n8 = n5;
        double[] dArray2 = new double[n7 + 2];
        dArray2[0] = Math.sqrt(Math.PI / d5);
        for (int i = 2; i < dArray2.length; i += 2) {
            dArray2[i] = dArray2[i - 2] * (double)(i - 1) / 2.0 / d5;
        }
        double[] dArray3 = new double[n7 + 3];
        dArray3[1] = 0.5 / d5;
        for (n6 = 3; n6 < dArray3.length; n6 += 2) {
            dArray3[n6] = dArray3[n6 - 2] * (double)(n6 - 1) / 2.0 / d5;
        }
        dArray3[0] = Math.sqrt(Math.PI / d5) * 0.5;
        for (n6 = 2; n6 < dArray3.length; n6 += 2) {
            dArray3[n6] = dArray3[n6 - 2] * (double)(n6 - 1) / 2.0 / d5;
        }
        dArray[0] = new double[2 * n5 + 1];
        if (bl) {
            dArray[1] = new double[n5 + 1];
            dArray[2] = new double[n5 + 1];
            dArray[3] = new double[n5 + 2];
        }
        Polynom_rho_z polynom_rho_z = new Polynom_rho_z(n7, n7);
        polynom_rho_z.mul_r2(n2 / 2, d2 - d6);
        polynom_rho_z.mul_r2(n4 / 2, d4 - d6);
        for (int i = 0; i <= n && i - 1 <= n3; ++i) {
            double d8;
            double d9;
            polynom_rho_z.pushToStack();
            polynom_rho_z.mul_AssocLeg(n, i, d2 - d6);
            boolean bl2 = i <= n && i <= n3;
            boolean bl3 = i + 1 <= n3 && bl;
            boolean bl4 = i >= 1 && i - 1 <= n3 && bl;
            double d10 = d7 * SphericalHarmonics.ALegNormalizer[n][n + i];
            if (bl2) {
                if (bl3 || bl4) {
                    polynom_rho_z.pushToStack();
                }
                polynom_rho_z.mul_AssocLeg(n3, i, d4 - d6);
                d9 = 0.0;
                double d11 = 0.0;
                for (int j = 0; j <= polynom_rho_z.last_active_z_power; ++j) {
                    double d12 = 0.0;
                    for (int k = 0; k <= polynom_rho_z.last_active_rho_power; ++k) {
                        d12 += polynom_rho_z.cf_matrix[j][k] * dArray3[k + 2 * i + 1];
                    }
                    d9 += dArray2[j] * d12;
                    d11 += dArray2[j + 1] * d12;
                }
                double d13 = Math.PI;
                if (i == 0) {
                    d13 *= 2.0;
                }
                double d14 = d10 * d13 * SphericalHarmonics.ALegNormalizer[n3][n3 + i];
                d11 *= d14;
                dArray[0][n5 - i] = d9 *= d14;
                dArray[0][n5 + i] = d9;
                if (bl) {
                    dArray[1][i] = d11;
                }
                if (bl3 || bl4) {
                    polynom_rho_z.restoreFromStack(true);
                }
            }
            if (bl3) {
                if (bl4) {
                    polynom_rho_z.pushToStack();
                }
                polynom_rho_z.mul_AssocLeg(n3, i + 1, d4 - d6);
                d9 = 0.0;
                for (int j = 0; j <= polynom_rho_z.last_active_z_power; ++j) {
                    d8 = 0.0;
                    for (int k = 0; k <= polynom_rho_z.last_active_rho_power; ++k) {
                        d8 += polynom_rho_z.cf_matrix[j][k] * dArray3[k + 2 * i + 3];
                    }
                    d9 += dArray2[j] * d8;
                }
                d9 *= d10;
                dArray[2][i] = (d9 *= SphericalHarmonics.ALegNormalizer[n3][n3 + i + 1]) * 0.5;
                if (bl4) {
                    polynom_rho_z.restoreFromStack(true);
                }
            }
            if (bl4) {
                polynom_rho_z.mul_AssocLeg(n3, i - 1, d4 - d6);
                d9 = 0.0;
                for (int j = 0; j <= polynom_rho_z.last_active_z_power; ++j) {
                    d8 = 0.0;
                    for (int k = 0; k <= polynom_rho_z.last_active_rho_power; ++k) {
                        d8 += polynom_rho_z.cf_matrix[j][k] * dArray3[k + 2 * i + 1];
                    }
                    d9 += dArray2[j] * d8;
                }
                d9 *= d10;
                dArray[3][i] = (d9 *= SphericalHarmonics.ALegNormalizer[n3][n3 + i - 1]) * 0.5;
            }
            polynom_rho_z.restoreFromStack(true);
        }
    }

    private static double[] transformDipoleIntegrals(double[][] dArray, int n, int n2, double[] dArray2, double[] dArray3) {
        int n3;
        double[] dArray4 = new double[3];
        dArray4[2] = dArray2[n] * dArray[n][n2] * dArray3[n2];
        if (n > 0) {
            dArray4[1] = dArray2[n - 1] * dArray[n - 1][n2] * dArray3[n2];
            dArray4[0] = dArray2[n + 1] * dArray[n + 1][n2] * dArray3[n2];
        }
        if (n2 > 0) {
            dArray4[1] = dArray4[1] + dArray2[n] * dArray[n][n2 - 1] * dArray3[n2 - 1];
            dArray4[0] = dArray4[0] + dArray2[n] * dArray[n][n2 + 1] * dArray3[n2 + 1];
        }
        int n4 = n;
        if (n2 < n) {
            n4 = n2;
        }
        for (n3 = 1; n3 <= n4; ++n3) {
            dArray4[2] = dArray4[2] + dArray2[n + n3] * dArray[n + n3][n2 + n3] * dArray3[n2 + n3];
            dArray4[2] = dArray4[2] + dArray2[n - n3] * dArray[n - n3][n2 - n3] * dArray3[n2 - n3];
        }
        for (n3 = 1; n3 <= n - 1 && n3 <= n2; ++n3) {
            dArray4[1] = dArray4[1] + dArray2[n - n3 - 1] * dArray[n - n3 - 1][n2 + n3] * dArray3[n2 + n3];
            dArray4[1] = dArray4[1] + dArray2[n + n3 + 1] * dArray[n + n3 + 1][n2 - n3] * dArray3[n2 - n3];
            dArray4[0] = dArray4[0] + dArray2[n + n3 + 1] * dArray[n + n3 + 1][n2 + n3] * dArray3[n2 + n3];
            dArray4[0] = dArray4[0] + dArray2[n - n3 - 1] * dArray[n - n3 - 1][n2 - n3] * dArray3[n2 - n3];
        }
        for (n3 = 1; n3 <= n && n3 <= n2 - 1; ++n3) {
            dArray4[1] = dArray4[1] + dArray2[n - n3] * dArray[n - n3][n2 + n3 + 1] * dArray3[n2 + n3 + 1];
            dArray4[1] = dArray4[1] + dArray2[n + n3] * dArray[n + n3][n2 - n3 - 1] * dArray3[n2 - n3 - 1];
            dArray4[0] = dArray4[0] + dArray2[n + n3] * dArray[n + n3][n2 + n3 + 1] * dArray3[n2 + n3 + 1];
            dArray4[0] = dArray4[0] + dArray2[n - n3] * dArray[n - n3][n2 - n3 - 1] * dArray3[n2 - n3 - 1];
        }
        return dArray4;
    }

    public void Build_Ovarlap_Matrix_PURE() {
        int n;
        int n2;
        double d;
        int n3;
        int n4;
        double d2;
        double d3;
        double d4;
        int n5;
        int n6;
        int n7;
        int n8;
        int n9;
        Object object;
        int n10;
        int n11;
        int n12;
        int n13;
        int n14;
        int n15;
        int n16;
        int n17 = this.RadialParts.length;
        int n18 = 0;
        int n19 = 0;
        int[][] nArrayArray = new int[n17][];
        int[] nArray = new int[n17];
        for (n16 = 0; n16 < this.basis.length; ++n16) {
            int n20 = this.basis[n16].RadialPart_ID;
            nArray[n20] = nArray[n20] + 1;
        }
        for (n16 = 0; n16 < n17; ++n16) {
            nArrayArray[n16] = new int[nArray[n16]];
            nArray[n16] = 0;
        }
        int n21 = 0;
        while (n21 < this.basis.length) {
            n16 = this.basis[n21].RadialPart_ID;
            nArrayArray[n16][nArray[n16]] = n21++;
            int n22 = n16;
            nArray[n22] = nArray[n22] + 1;
        }
        nArray = null;
        int[][] nArrayArray2 = new int[n17][];
        for (n21 = 0; n21 < n17; ++n21) {
            int n23 = this.RadialParts[n21].LUsedWith;
            nArrayArray2[n21] = new int[2 * n23 + 1];
            for (n15 = 0; n15 < nArrayArray[n21].length; ++n15) {
                n14 = nArrayArray[n21][n15];
                n13 = this.moldenP2P[n23][n23 + this.basis[n14].m];
                nArrayArray2[n21][n23 + n13] = n14;
            }
        }
        int[][] nArrayArray3 = new int[this.centers.length][];
        int[] nArray2 = new int[this.centers.length];
        for (n15 = 0; n15 < n17; ++n15) {
            int n24 = this.RadialParts[n15].CenterID - 1;
            nArray2[n24] = nArray2[n24] + 1;
        }
        for (n15 = 0; n15 < this.centers.length; ++n15) {
            nArrayArray3[n15] = new int[nArray2[n15]];
            nArray2[n15] = 0;
        }
        for (n14 = 0; n14 < n17; ++n14) {
            n15 = this.RadialParts[n14].CenterID - 1;
            nArrayArray3[n15][nArray2[n15]] = n14;
            int n25 = n15;
            nArray2[n25] = nArray2[n25] + 1;
            if (this.RadialParts[n14].Addit_r_power > 2 * n19) {
                n19 = this.RadialParts[n14].Addit_r_power / 2;
            }
            if (this.RadialParts[n14].LUsedWith <= n18) continue;
            n18 = this.RadialParts[n14].LUsedWith;
        }
        nArray2 = null;
        this.OverlapMatrix = new double[this.basis.length][this.basis.length];
        this.DipoleMatrix = new double[this.basis.length][this.basis.length][3];
        for (int i = 0; i < this.DipoleMatrix.length; ++i) {
            this.DipoleMatrix[i][i] = new double[3];
            for (n12 = i + 1; n12 < this.DipoleMatrix.length; n12 += 1) {
                this.DipoleMatrix[i][n12] = new double[3];
                this.DipoleMatrix[n12][i] = this.DipoleMatrix[i][n12];
            }
        }
        double[][] dArrayArray = new double[4][];
        n12 = 1;
        for (n11 = 0; n11 < this.centers.length; ++n11) {
            for (n10 = n11 + 1; n10 < this.centers.length; ++n10) {
                int n26;
                double[] dArray = (double[])this.centers[n11].R0.clone();
                double[] dArray2 = (double[])this.centers[n10].R0.clone();
                for (int i = 0; i < 3; ++i) {
                    int n27 = i;
                    dArray2[n27] = dArray2[n27] - dArray[i];
                    dArray[i] = 0.0;
                }
                double[] dArray3 = this.ThetaPhi(dArray, dArray2);
                object = RealWignerAdapt.newAxisCoords(dArray3[0], dArray3[1]);
                double[] dArray4 = new double[]{0.0, 0.0, 0.0};
                double d5 = Math.sqrt(dArray2[0] * dArray2[0] + dArray2[1] * dArray2[1] + dArray2[2] * dArray2[2]);
                double[] dArray5 = new double[]{0.0, 0.0, d5};
                double[][][] dArray6 = RealWignerAdapt.create_sincos(dArray3[0], dArray3[1]);
                n9 = 0;
                for (n8 = 0; n8 < nArrayArray3[n11].length; ++n8) {
                    if (this.RadialParts[nArrayArray3[n11][n8]].LUsedWith <= n9) continue;
                    n9 = this.RadialParts[nArrayArray3[n11][n8]].LUsedWith;
                }
                n8 = 0;
                for (n7 = 0; n7 < nArrayArray3[n10].length; ++n7) {
                    if (this.RadialParts[nArrayArray3[n10][n7]].LUsedWith <= n8) continue;
                    n8 = this.RadialParts[nArrayArray3[n10][n7]].LUsedWith;
                }
                n7 = n9;
                if (n8 > n7) {
                    n7 = n8;
                }
                double[][][] dArrayArray2 = new double[n7 + 1][][];
                for (n26 = 0; n26 <= n7; ++n26) {
                    dArrayArray2[n26] = RealWignerAdapt.Wigner(dArray6, n26);
                    dArrayArray2[n26] = this.WignerTranspose(dArrayArray2[n26], n26);
                }
                for (n26 = 0; n26 < nArrayArray3[n11].length; ++n26) {
                    n14 = nArrayArray3[n11][n26];
                    n6 = this.RadialParts[n14].LUsedWith;
                    for (int i = 0; i < nArrayArray3[n10].length; ++i) {
                        int n28;
                        double[] dArray7;
                        int n29;
                        int n30;
                        n13 = nArrayArray3[n10][i];
                        n5 = this.RadialParts[n13].LUsedWith;
                        int n31 = n6;
                        if (n5 < n31) {
                            n31 = n5;
                        }
                        double[] dArray8 = new double[2 * n31 + 1];
                        double[][] dArray9 = new double[2 * n6 + 1][2 * n5 + 1];
                        for (n30 = 0; n30 < this.RadialParts[n14].Exponents.length; ++n30) {
                            d4 = this.RadialParts[n14].Exponents[n30];
                            d3 = this.RadialParts[n14].Coefs[n30];
                            for (n29 = 0; n29 < this.RadialParts[n13].Exponents.length; ++n29) {
                                double d6;
                                int n32;
                                d2 = this.RadialParts[n13].Exponents[n29];
                                JGintsCyl.PrimitiveGOverlapInt(d4, n6, dArray4[2], this.RadialParts[n14].Addit_r_power, d2, n5, dArray5[2], this.RadialParts[n13].Addit_r_power, n31, dArrayArray, n12 != 0);
                                double d7 = d3 * this.RadialParts[n13].Coefs[n29];
                                for (n32 = -n31; n32 <= n31; ++n32) {
                                    int n33 = n31 + n32;
                                    dArray8[n33] = dArray8[n33] + dArrayArray[0][n31 + n32] * d7;
                                }
                                if (!n12) continue;
                                for (n32 = 0; n32 <= n31; ++n32) {
                                    double[] dArray10 = dArrayArray[1];
                                    int n34 = n32;
                                    dArray10[n34] = dArray10[n34] + d5 * d2 / (d4 + d2) * dArrayArray[0][n31 + n32];
                                    double[] dArray11 = dArray9[n6 + n32];
                                    int n35 = n5 + n32;
                                    dArray11[n35] = dArray11[n35] + dArrayArray[1][n32] * d7;
                                    dArray9[n6 - n32][n5 - n32] = dArray9[n6 + n32][n5 + n32];
                                }
                                double[] dArray12 = dArrayArray[2];
                                dArray7 = dArrayArray[3];
                                if (n5 > 0) {
                                    double[] dArray13 = dArray9[n6];
                                    int n36 = n5 - 1;
                                    dArray13[n36] = dArray13[n36] + d7 * dArray12[0] * 2.0 * Math.PI;
                                    dArray9[n6][n5 + 1] = dArray9[n6][n5 - 1];
                                }
                                if (n6 > 0) {
                                    double[] dArray14 = dArray9[n6 - 1];
                                    int n37 = n5;
                                    dArray14[n37] = dArray14[n37] + d7 * dArray7[1] * 2.0 * Math.PI;
                                    dArray9[n6 + 1][n5] = dArray9[n6 - 1][n5];
                                }
                                for (n28 = 2; n28 <= n6 && n28 - 1 <= n5; ++n28) {
                                    d6 = dArray7[n28] * d7 * Math.PI;
                                    double[] dArray15 = dArray9[n6 + n28];
                                    int n38 = n5 + n28 - 1;
                                    dArray15[n38] = dArray15[n38] + d6;
                                    double[] dArray16 = dArray9[n6 + n28];
                                    int n39 = n5 - n28 + 1;
                                    dArray16[n39] = dArray16[n39] - d6;
                                    double[] dArray17 = dArray9[n6 - n28];
                                    int n40 = n5 - n28 + 1;
                                    dArray17[n40] = dArray17[n40] + d6;
                                    double[] dArray18 = dArray9[n6 - n28];
                                    int n41 = n5 + n28 - 1;
                                    dArray18[n41] = dArray18[n41] + d6;
                                }
                                for (n28 = 1; n28 <= n6 && n28 + 1 <= n5; ++n28) {
                                    d6 = dArray12[n28] * d7 * Math.PI;
                                    double[] dArray19 = dArray9[n6 + n28];
                                    int n42 = n5 + n28 + 1;
                                    dArray19[n42] = dArray19[n42] + d6;
                                    double[] dArray20 = dArray9[n6 + n28];
                                    int n43 = n5 - n28 - 1;
                                    dArray20[n43] = dArray20[n43] + d6;
                                    double[] dArray21 = dArray9[n6 - n28];
                                    int n44 = n5 - n28 - 1;
                                    dArray21[n44] = dArray21[n44] + d6;
                                    double[] dArray22 = dArray9[n6 - n28];
                                    int n45 = n5 + n28 + 1;
                                    dArray22[n45] = dArray22[n45] - d6;
                                }
                            }
                        }
                        for (n30 = 0; n30 < nArrayArray[n14].length; ++n30) {
                            n4 = nArrayArray[n14][n30];
                            n29 = n6 + this.moldenP2P[n6][n6 + this.basis[n4].m];
                            for (int j = 0; j < nArrayArray[n13].length; ++j) {
                                n3 = nArrayArray[n13][j];
                                int n46 = n5 + this.moldenP2P[n5][n5 + this.basis[n3].m];
                                d = 0.0;
                                for (int k = -n31; k <= n31; ++k) {
                                    d += dArray8[n31 + k] * dArrayArray2[n6][n29][n6 + k] * dArrayArray2[n5][n46][n5 + k];
                                }
                                this.OverlapMatrix[n4][n3] = d;
                                this.OverlapMatrix[n3][n4] = d;
                                if (!n12) continue;
                                double[] dArray23 = JGintsCyl.transformDipoleIntegrals(dArray9, n6, n5, dArrayArray2[n6][n29], dArrayArray2[n5][n46]);
                                dArray7 = this.DipoleMatrix[n4][n3];
                                for (n28 = 0; n28 < 3; ++n28) {
                                    dArray7[n28] = 0.0;
                                    for (int k = 0; k < 3; ++k) {
                                        int n47 = n28;
                                        dArray7[n47] = dArray7[n47] + object[n28][k] * dArray23[k];
                                    }
                                    int n48 = n28;
                                    dArray7[n48] = dArray7[n48] + this.centers[n11].R0[n28] * d;
                                }
                            }
                        }
                    }
                }
            }
        }
        for (n2 = 0; n2 < this.centers.length; ++n2) {
            for (int i = 0; i < nArrayArray3[n2].length; ++i) {
                n14 = nArrayArray3[n2][i];
                n6 = this.RadialParts[n14].LUsedWith;
                double d8 = 0.0;
                n11 = this.RadialParts[n14].Addit_r_power;
                for (int j = i; j < nArrayArray3[n2].length; ++j) {
                    n13 = nArrayArray3[n2][j];
                    n5 = this.RadialParts[n13].LUsedWith;
                    boolean bl = n5 == n6;
                    int n49 = n = Math.abs(n5 - n6) == 1 && n12 != 0 ? 1 : 0;
                    if (!bl && n == 0) continue;
                    n10 = this.RadialParts[n13].Addit_r_power;
                    d8 = 0.0;
                    double d9 = 0.0;
                    for (n9 = 0; n9 < this.RadialParts[n14].Coefs.length; ++n9) {
                        d4 = this.RadialParts[n14].Exponents[n9];
                        d3 = this.RadialParts[n14].Coefs[n9];
                        for (n8 = 0; n8 < this.RadialParts[n13].Coefs.length; ++n8) {
                            d2 = this.RadialParts[n13].Exponents[n8];
                            double d10 = this.RadialParts[n13].Coefs[n8];
                            if (bl) {
                                d8 += OverlapIntegrals.primitive_int_1D_Sphr(2 + 2 * n6 + n11 + n10, d4 + d2) * d3 * d10;
                            }
                            if (n == 0) continue;
                            d9 += OverlapIntegrals.primitive_int_1D_Sphr(2 + n6 + n5 + 1 + n11 + n10, d4 + d2) * d3 * d10;
                        }
                    }
                    for (n9 = 0; n9 < nArrayArray[n14].length; ++n9) {
                        n4 = nArrayArray[n14][n9];
                        n8 = this.basis[n4].m;
                        for (n7 = 0; n7 < nArrayArray[n13].length; ++n7) {
                            n3 = nArrayArray[n13][n7];
                            int n50 = this.basis[n3].m;
                            if (n50 != n8 || !bl) continue;
                            this.OverlapMatrix[n4][n3] = d = d8;
                            this.OverlapMatrix[n3][n4] = d;
                        }
                    }
                    if (n == 0) continue;
                    this.setAtomicDipolesNonDiag(nArrayArray2, n6, n5, n14, n13, d9);
                }
            }
        }
        if (n12) {
            for (n2 = 0; n2 < this.centers.length; ++n2) {
                for (int i = 0; i < nArrayArray3[n2].length; ++i) {
                    n14 = nArrayArray3[n2][i];
                    for (int j = i; j < nArrayArray3[n2].length; ++j) {
                        n13 = nArrayArray3[n2][j];
                        object = this.centers[n2].R0;
                        for (int k = 0; k < nArrayArray[n14].length; ++k) {
                            n4 = nArrayArray[n14][k];
                            for (int i2 = 0; i2 < nArrayArray[n13].length; ++i2) {
                                n3 = nArrayArray[n13][i2];
                                if (n3 < n4) continue;
                                for (n = 0; n < 3; ++n) {
                                    double[] dArray = this.DipoleMatrix[n4][n3];
                                    int n51 = n;
                                    dArray[n51] = dArray[n51] + object[n] * this.OverlapMatrix[n4][n3];
                                }
                            }
                        }
                    }
                }
            }
        }
    }

    private void setAtomicDipolesNonDiag(int[][] nArray, int n, int n2, int n3, int n4, double d) {
        int n5;
        int n6;
        int n7;
        double d2;
        int n8;
        int n9;
        int n10;
        int n11;
        for (int i = 0; i <= n && i <= n2; ++i) {
            double d3 = n > n2 ? ((double)(n2 - i) + 1.0) * ((double)(n2 + i) + 1.0) / ((double)(2 * n2) + 1.0) / ((double)(2 * n2) + 3.0) : (double)((n2 - i) * (n2 + i)) / ((double)(2 * n2) - 1.0) / ((double)(2 * n2) + 1.0);
            d3 = Math.sqrt(d3);
            n11 = nArray[n3][n + i];
            n10 = nArray[n4][n2 + i];
            this.DipoleMatrix[n11][n10][2] = d3 * d;
            if (i <= 0) continue;
            n11 = nArray[n3][n - i];
            n10 = nArray[n4][n2 - i];
            this.DipoleMatrix[n11][n10][2] = d3 * d;
        }
        double d4 = 0.5 * d / Math.sqrt(((double)(n + n2) + 2.0) * (double)(n + n2));
        if (n > 0) {
            n9 = nArray[n3][n + 1];
            n8 = nArray[n3][n - 1];
            n10 = nArray[n4][n2 + 0];
            d2 = n > n2 ? Math.sqrt(2 * (n2 + 2) * (n2 + 1)) * d4 : -Math.sqrt(2 * n2 * (n2 - 1)) * d4;
            this.DipoleMatrix[n9][n10][0] = d2;
            this.DipoleMatrix[n8][n10][1] = d2;
        }
        if (n2 > 0) {
            n11 = nArray[n3][n + 0];
            n9 = nArray[n4][n2 + 1];
            n8 = nArray[n4][n2 - 1];
            d2 = n > n2 ? -Math.sqrt(2 * n2 * (n2 + 1)) * d4 : Math.sqrt(2 * n2 * (n2 + 1)) * d4;
            this.DipoleMatrix[n11][n9][0] = d2;
            this.DipoleMatrix[n11][n8][1] = d2;
        }
        for (n9 = 1; n9 <= n && n9 <= n2 - 1; ++n9) {
            d2 = n > n2 ? -Math.sqrt((n2 - n9 + 1) * (n2 - n9)) * d4 : Math.sqrt((n2 + n9 + 1) * (n2 + n9)) * d4;
            n8 = nArray[n3][n + n9];
            n7 = nArray[n3][n - n9];
            n6 = nArray[n4][n2 + n9 + 1];
            n5 = nArray[n4][n2 - n9 - 1];
            this.DipoleMatrix[n8][n6][0] = d2;
            this.DipoleMatrix[n8][n5][1] = d2;
            this.DipoleMatrix[n7][n5][0] = d2;
            this.DipoleMatrix[n7][n6][1] = -d2;
        }
        for (n9 = 2; n9 <= n && n9 <= n2 + 1; ++n9) {
            d2 = n > n2 ? Math.sqrt((n2 + n9 + 1) * (n2 + n9)) * d4 : -Math.sqrt((n2 - n9 + 1) * (n2 - n9)) * d4;
            n8 = nArray[n3][n + n9];
            n7 = nArray[n3][n - n9];
            n6 = nArray[n4][n2 + n9 - 1];
            n5 = nArray[n4][n2 - n9 + 1];
            this.DipoleMatrix[n8][n6][0] = d2;
            this.DipoleMatrix[n8][n5][1] = -d2;
            this.DipoleMatrix[n7][n5][0] = d2;
            this.DipoleMatrix[n7][n6][1] = d2;
        }
    }

    public void ImportBasisFromMolden(MOLDEN_IO mOLDEN_IO) {
        this.basis = mOLDEN_IO.Basis;
        this.centers = mOLDEN_IO.Centers;
        this.RadialParts = mOLDEN_IO.RadialParts;
    }

    private void _Naive(Polynom3D[][] polynom3DArray) {
        double d;
        ProgTimer progTimer = new ProgTimer();
        Matrix matrix = new Matrix(this.basis.length, this.basis.length);
        for (int i = 0; i < this.basis.length; ++i) {
            for (int j = i; j < this.basis.length; ++j) {
                this.basis[i].Quick_YLM = polynom3DArray;
                try {
                    d = this.basis[i].OverlapWith(this.basis[j]);
                    matrix.set(i, j, d);
                    matrix.set(j, i, d);
                    continue;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        progTimer.Stop();
        progTimer.Print();
        this.out.println("========================");
        Matrix matrix2 = new Matrix(this.OverlapMatrix);
        Matrix matrix3 = matrix.minus(matrix2);
        d = 0.0;
        int n = 0;
        int n2 = 0;
        for (int i = 0; i < this.basis.length; ++i) {
            for (int j = 0; j < this.basis.length; ++j) {
                if (!(Math.abs(matrix3.get(i, j)) > d)) continue;
                d = Math.abs(matrix3.get(i, j));
                n = i;
                n2 = j;
            }
        }
        this.out.printf("%.20E:  %.20f v.s. %.20f observed in: %d, %d%n", d, matrix.get(n, n2), matrix2.get(n, n2), n, n2);
    }

    public void _test() throws Exception {
        MOLDEN_IO mOLDEN_IO = new MOLDEN_IO();
        mOLDEN_IO.Allow_additional_r_power = true;
        String string = "M:\\abInitio\\JANPA\\tests_my\\conf_462_gRJ_vQz_CART_C2P.molden";
        mOLDEN_IO.Load_From_MOLDEN(string);
        mOLDEN_IO.CoordsToAU();
        Object object = new double[5][];
        double[][] dArrayArray = new double[5][];
        for (int i = 0; i < ((double[][])object).length; ++i) {
            object[i] = new double[2 * i + 1];
            dArrayArray[i] = new double[2 * i + 1];
            for (int j = 0; j < 2 * i + 1; ++j) {
                object[i][j] = 1.0;
                dArrayArray[i][j] = 0.07957747154594767;
            }
        }
        mOLDEN_IO.ToUnnormalizedPrimitiveCoefs();
        this.ImportBasisFromMolden(mOLDEN_IO);
        ProgTimer progTimer = new ProgTimer();
        progTimer.Start();
        this.Build_Ovarlap_Matrix_PURE();
        progTimer.Stop();
        progTimer.Print();
        this.out.println("Naive method...");
        mOLDEN_IO = new MOLDEN_IO();
        mOLDEN_IO.Allow_additional_r_power = true;
        mOLDEN_IO.Load_From_MOLDEN(string);
        mOLDEN_IO.CoordsToAU();
        Polynom3D[][] polynom3DArray = SphericalHarmonics.Get_Quick_YLM_Norm4PI();
        object = SphericalHarmonics.Get_Quick_YLM_Norm2(polynom3DArray);
        mOLDEN_IO.UnNormalizePrimitives((double[][])object);
        this.ImportBasisFromMolden(mOLDEN_IO);
        this._Naive(polynom3DArray);
    }

    private double[][] rot_vec(double[] dArray) {
        double d;
        double[][] dArray2 = new double[3][3];
        dArray2[0][0] = dArray[1];
        dArray2[0][1] = -dArray[0];
        dArray2[0][2] = 0.0;
        dArray2[1][1] = d = Math.sqrt(dArray[1] * dArray[1] + dArray[0] * dArray[0]);
        dArray2[1][2] = dArray[2];
        dArray2[1][0] = Math.atan2(d, dArray[2]);
        double[] dArray3 = dArray2[0];
        dArray3[0] = dArray3[0] / d;
        double[] dArray4 = dArray2[0];
        dArray4[1] = dArray4[1] / d;
        return dArray2;
    }

    private double[] rotate_vec_to_new(double[] dArray, double[] dArray2) {
        double[][] dArray3 = this.rot_vec(dArray2);
        double d = dArray3[1][2];
        double d2 = dArray3[1][1];
        double[] dArray4 = new double[3];
        double d3 = dArray3[0][0];
        double d4 = dArray3[0][1];
        double d5 = dArray[0] * d3 + dArray[1] * d4;
        dArray4[0] = dArray[0] * d + (1.0 - d) * d3 * d5 - d2 * (d4 * dArray[2] - 0.0 * dArray[1]);
        dArray4[1] = dArray[1] * d + (1.0 - d) * d4 * d5 - d2 * (0.0 * dArray[0] - d3 * dArray[2]);
        dArray4[2] = dArray[2] * d + (1.0 - d) * 0.0 * d5 - d2 * (d3 * dArray[1] - d4 * dArray[0]);
        return dArray4;
    }

    private double[] rotate_vec_from_new(double[] dArray, double[] dArray2) {
        double[][] dArray3 = this.rot_vec(dArray2);
        double d = dArray3[1][2];
        double d2 = dArray3[1][1];
        double[] dArray4 = new double[3];
        double d3 = dArray3[0][0];
        double d4 = dArray3[0][1];
        double d5 = dArray[0] * d3 + dArray[1] * d4;
        dArray4[0] = dArray[0] * d + (1.0 - d) * d3 * d5 + d2 * (d4 * dArray[2] - 0.0 * dArray[1]);
        dArray4[1] = dArray[1] * d + (1.0 - d) * d4 * d5 + d2 * (0.0 * dArray[0] - d3 * dArray[2]);
        dArray4[2] = dArray[2] * d + (1.0 - d) * 0.0 * d5 + d2 * (d3 * dArray[1] - d4 * dArray[0]);
        return dArray4;
    }

    private void print_vec(double[] dArray) {
        for (int i = 0; i < 3; ++i) {
            this.out.printf("%.5f\t", dArray[i]);
        }
        this.out.println();
    }

    private double[] nZ(double[] dArray, double[] dArray2) {
        int n;
        double[] dArray3 = new double[3];
        double d = 0.0;
        for (n = 0; n < 3; ++n) {
            dArray3[n] = dArray2[n] - dArray[n];
            d += dArray3[n] * dArray3[n];
        }
        d = Math.sqrt(d);
        n = 0;
        while (n < 3) {
            int n2 = n++;
            dArray3[n2] = dArray3[n2] / d;
        }
        return dArray3;
    }

    private double[] ThetaPhi_2_n(double[] dArray) {
        double[] dArray2 = new double[]{Math.sin(dArray[0]) * Math.cos(dArray[1]), Math.sin(dArray[0]) * Math.sin(dArray[1]), Math.cos(dArray[0])};
        return dArray2;
    }

    private double Overlap(BasisFunction basisFunction, BasisFunction basisFunction2) throws Exception {
        int n;
        for (int i = 0; i < 3; ++i) {
            int n2 = i;
            basisFunction2.R0[n2] = basisFunction2.R0[n2] - basisFunction.R0[i];
            basisFunction.R0[i] = 0.0;
        }
        double[] dArray = this.ThetaPhi(basisFunction.R0, basisFunction2.R0);
        double[] dArray2 = this.ThetaPhi_2_n(dArray);
        double[][][] dArray3 = RealWignerAdapt.create_sincos(dArray[0], dArray[1]);
        double[][] dArray4 = RealWignerAdapt.Wigner(dArray3, basisFunction.L);
        double[][] dArray5 = RealWignerAdapt.Wigner(dArray3, basisFunction2.L);
        dArray4 = this.WignerTranspose(dArray4, basisFunction.L);
        dArray5 = this.WignerTranspose(dArray5, basisFunction2.L);
        double[] dArray6 = this.rotate_vec_from_new(basisFunction.R0, dArray2);
        double[] dArray7 = this.rotate_vec_from_new(basisFunction2.R0, dArray2);
        BasisFunction basisFunction3 = new BasisFunction(basisFunction);
        basisFunction3.R0 = dArray6;
        basisFunction3.OI = new OverlapIntegrals();
        BasisFunction basisFunction4 = new BasisFunction(basisFunction2);
        basisFunction4.R0 = dArray7;
        int n3 = basisFunction.L;
        if (basisFunction2.L < n3) {
            n3 = basisFunction2.L;
        }
        double[] dArray8 = new double[2 * n3 + 1];
        for (n = -n3; n <= n3; ++n) {
            basisFunction3.m = this.P2moldenP[basisFunction.L][basisFunction.L + n];
            basisFunction4.m = this.P2moldenP[basisFunction2.L][basisFunction2.L + n];
            dArray8[n3 + n] = basisFunction3.OverlapWith(basisFunction4);
        }
        n = basisFunction.L + this.moldenP2P[basisFunction.L][basisFunction.L + basisFunction.m];
        int n4 = basisFunction2.L + this.moldenP2P[basisFunction2.L][basisFunction2.L + basisFunction2.m];
        double d = 0.0;
        for (int i = -n3; i <= n3; ++i) {
            d += dArray8[n3 + i] * dArray4[n][basisFunction.L + i] * dArray5[n4][basisFunction2.L + i];
        }
        return d;
    }

    private void ___aaa() throws Exception {
        Object object;
        Object object2;
        int n;
        MOLDEN_IO mOLDEN_IO = new MOLDEN_IO();
        mOLDEN_IO.Load_From_MOLDEN("Z:\\DNA_software\\twfn\\OpenNAO\\CONVERTERS\\ORCA\\kr3_avtz_spher_ORCA_m2m.molden");
        mOLDEN_IO.CoordsToAU();
        Polynom3D[][] polynom3DArray = SphericalHarmonics.Get_Quick_YLM();
        double[][] dArray = SphericalHarmonics.Get_Quick_YLM_Norm2(polynom3DArray);
        mOLDEN_IO.UnNormalizePrimitives(dArray);
        for (n = 0; n < mOLDEN_IO.Basis.length; ++n) {
            this.out.printf("%d  at center %d  L = %d %n", n, mOLDEN_IO.Basis[n].Center_ID, mOLDEN_IO.Basis[n].L);
        }
        for (n = 0; n < mOLDEN_IO.Basis.length; ++n) {
            for (int i = n + 1; i < mOLDEN_IO.Basis.length; ++i) {
                double d;
                if (mOLDEN_IO.Basis[n].Center_ID == mOLDEN_IO.Basis[i].Center_ID || mOLDEN_IO.Basis[n].L < 1 || mOLDEN_IO.Basis[i].L < 1) continue;
                object2 = mOLDEN_IO.Basis[n];
                object = mOLDEN_IO.Basis[i];
                ((BasisFunction)object2).Quick_YLM = polynom3DArray;
                ((BasisFunction)object).Quick_YLM = polynom3DArray;
                ((BasisFunction)object2).OI = new OverlapIntegrals();
                double d2 = ((BasisFunction)object2).OverlapWith((BasisFunction)object);
                if (!(Math.abs((d2 - (d = this.Overlap((BasisFunction)object2, (BasisFunction)object))) / d2) > 1.0E-12) || !(Math.abs(d2 - d) > 1.0E-15)) continue;
                this.out.printf("EXACT = %.20f   NEW = %.20f,  DIFF = %.3E%n", d2, d, d2 - d);
            }
        }
        BasisFunction basisFunction = mOLDEN_IO.Basis[82];
        BasisFunction basisFunction2 = mOLDEN_IO.Basis[28];
        basisFunction.OI = new OverlapIntegrals();
        this.out.printf("EXACT = %n%.20f%n", basisFunction.OverlapWith(basisFunction2));
        this.out.printf("NEW = %n%.20f%n", this.Overlap(basisFunction, basisFunction2));
        basisFunction.Quick_YLM = polynom3DArray;
        basisFunction2.Quick_YLM = polynom3DArray;
        object2 = basisFunction.R0;
        object = basisFunction2.R0;
        double[] dArray2 = this.ThetaPhi((double[])object2, (double[])object);
        double[] dArray3 = this.ThetaPhi_2_n(dArray2);
        double[] dArray4 = new double[]{(double)(object2[0] + 0.2 * object[0]), (double)(object2[1] + 0.3 * object[1]), (double)(object2[2] + 0.3 * object[2])};
        int n2 = 0;
        for (int i = 0; i < 10000; ++i) {
            dArray4[0] = Math.random() * 10.0;
            dArray4[1] = Math.random() * 10.0;
            dArray4[2] = Math.random() * 10.0;
            dArray2 = new double[]{Math.random() * Math.PI, Math.random() * 2.0 * Math.PI};
            dArray3 = this.ThetaPhi_2_n(dArray2);
            double[] dArray5 = this.rotate_vec_to_new(dArray4, dArray3);
            int n3 = (int)(Math.random() * 2.0) + 1;
            int n4 = (int)(Math.random() * (double)(n3 + 1));
            if (Math.random() > 0.5) {
                n4 = -n4;
            }
            double d = polynom3DArray[n3][n4 += n3].EvaluateAtPoint(dArray4);
            double[][] dArray6 = RealWignerAdapt.Wigner(RealWignerAdapt.create_sincos(dArray2[0], dArray2[1]), n3);
            dArray6 = this.Wigner2MOLDEN(dArray6, n3);
            double d3 = 0.0;
            for (int j = 0; j < 2 * n3 + 1; ++j) {
                d3 += dArray6[n4][j] * polynom3DArray[n3][j].EvaluateAtPoint(dArray5);
            }
            if (Math.abs((d - d3) / d) > 1.0E-12) {
                this.out.printf("L = %d; M = %d; r[0] = %.20f; r[1] = %.20f; r[2] = %.20f;%n // ref = %.20f v = %.20f%n", n3, n4, dArray4[0], dArray4[1], dArray4[2], d, d3);
                continue;
            }
            ++n2;
        }
        this.out.println("PASSED = " + n2);
        this.out.println();
    }

    private void _test1() {
        int n;
        Polynom3D[][] polynom3DArray = SphericalHarmonics.Get_Quick_YLM();
        double[][] dArray = SphericalHarmonics.Get_Quick_YLM_Norm2(polynom3DArray);
        int n2 = 2;
        int n3 = 4;
        int n4 = n = -1;
        double d = 1.0;
        double d2 = 1.0;
        double d3 = -0.3;
        double d4 = 0.5;
        int[] nArray = new int[]{1, -1, 0};
        int n5 = n2 == 1 ? nArray[n2 + n] : n;
        int n6 = n3 == 1 ? nArray[n3 + n4] : n4;
        BasisFunction basisFunction = new BasisFunction(n2, n5, new double[]{0.0, 0.0, d3}, 1);
        basisFunction.coefs[0] = 1.0;
        basisFunction.exponents[0] = d;
        BasisFunction basisFunction2 = new BasisFunction(n3, n6, new double[]{0.0, 0.0, d4}, 1);
        basisFunction2.coefs[0] = 1.0;
        basisFunction2.exponents[0] = d2;
        basisFunction.Quick_YLM = polynom3DArray;
        basisFunction2.Quick_YLM = polynom3DArray;
        basisFunction.OI = new OverlapIntegrals();
        basisFunction2.OI = new OverlapIntegrals();
        polynom3DArray[n2][n2 + n5].Print();
        double d5 = 0.0;
        double d6 = 0.0;
        double d7 = 0.0;
        double d8 = OverlapIntegrals.primitive_int_1D_Sphr(2 + (n2 + n2), d + d);
        double d9 = OverlapIntegrals.primitive_int_1D_Sphr(2 + (n3 + n3), d2 + d2);
        try {
            d5 = basisFunction.OverlapWith(basisFunction2);
            d7 = basisFunction2.OverlapWith(basisFunction2) / d8;
            d6 = basisFunction.OverlapWith(basisFunction) / d9;
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        System.out.printf("exact = %.12f %n", d5 /= Math.sqrt(d6 * d7));
        double d10 = 0.0;
        System.out.printf("  new = %.12f %n", d10);
    }

    public static void main(String[] stringArray) throws Exception {
        Locale.setDefault(Locale.US);
        JGintsCyl jGintsCyl = new JGintsCyl();
        jGintsCyl._test();
    }
}

