/*
 * Decompiled with CFR 0.152.
 */
package JGints;

import java.io.DataInputStream;
import java.io.DataOutputStream;

public class AtomicCenter {
    public String Name;
    public int ID;
    public double Z;
    public double[] R0 = new double[3];
    public AtomicCenter _next = null;

    public AtomicCenter() {
    }

    public AtomicCenter(AtomicCenter atomicCenter) {
        this.Name = new String(atomicCenter.Name);
        this.ID = atomicCenter.ID;
        this.Z = atomicCenter.Z;
        this.R0 = (double[])atomicCenter.R0.clone();
        this._next = atomicCenter._next;
    }

    public void SaveToDataStream(DataOutputStream dataOutputStream) throws Exception {
        dataOutputStream.writeInt(this.ID);
        dataOutputStream.writeInt(this.Name.length());
        dataOutputStream.writeChars(this.Name);
        dataOutputStream.writeDouble(this.Z);
        dataOutputStream.writeDouble(this.R0[0]);
        dataOutputStream.writeDouble(this.R0[1]);
        dataOutputStream.writeDouble(this.R0[2]);
    }

    public void ReadFromDataStream(DataInputStream dataInputStream) throws Exception {
        int n;
        this.ID = dataInputStream.readInt();
        char[] cArray = new char[dataInputStream.readInt()];
        for (n = 0; n < cArray.length; ++n) {
            cArray[n] = dataInputStream.readChar();
        }
        this.Name = String.valueOf(cArray);
        cArray = null;
        this.Z = dataInputStream.readDouble();
        this.R0 = new double[3];
        for (n = 0; n < 3; ++n) {
            this.R0[n] = dataInputStream.readDouble();
        }
    }

    public double distanceTo(double[] dArray) {
        double d = 0.0;
        for (int i = 0; i < 3; ++i) {
            d += (this.R0[i] - dArray[i]) * (this.R0[i] - dArray[i]);
        }
        return Math.sqrt(d);
    }
}

