/*
 * Decompiled with CFR 0.152.
 */
package CLPO;

import CLPO.LOdescription;
import Jama.Matrix;
import MatrixHelper.EigenEngine;
import java.io.PrintStream;

public class CT_Estimator {
    static PrintStream out = System.out;
    private LOdescription LOs;
    public Matrix SDS_LOs;
    public double ct_threshold = 0.01;

    public CT_Estimator(LOdescription lOdescription, Matrix matrix) {
        this.LOs = lOdescription;
        Matrix matrix2 = lOdescription.NAO_to_Hybrids.times(lOdescription.LO_to_Hybrids.transpose());
        this.SDS_LOs = EigenEngine.TransformSymmetricMatrixToNewBasis(matrix, matrix2.transpose());
    }

    private int[] ensureCLPOsIntrafragment(int[] nArray) {
        int[] nArray2 = new int[this.LOs.hybridsOfLO.length];
        for (int i = 0; i < this.LOs.hybridsOfLO.length; ++i) {
            int n;
            int[] nArray3 = this.LOs.hybridsOfLO[i];
            boolean bl = true;
            nArray2[i] = n = nArray[this.LOs.hostAtomOfHybrid[nArray3[0]]];
            for (int j = 1; j < nArray3.length; ++j) {
                bl &= nArray[this.LOs.hostAtomOfHybrid[nArray3[j]]] == n;
            }
            if (bl) continue;
            out.printf("ERROR: CLPO %d has hybrids belonging to different fragments!%n", i + 1);
            nArray2[i] = -1;
        }
        return nArray2;
    }

    private double perform_CT(int n, int n2, int[] nArray) {
        double d = 0.0;
        double d2 = 1.0;
        double d3 = 1.0;
        int n3 = nArray.length;
        int n4 = 0;
        double d4 = 0.0;
        out.println(" orb.num.   description  occup.  -->  charge, e  -->   occup.   description  orb.num.");
        for (int i = 0; i < n3; ++i) {
            if (nArray[i] != n) continue;
            double d5 = this.SDS_LOs.get(i, i);
            for (int j = 0; j < n3; ++j) {
                if (j == i || nArray[j] != n2) continue;
                double d6 = this.SDS_LOs.get(j, j);
                if (!(d5 > d2) || !(d6 < d5) || !(d6 < d3)) continue;
                double d7 = this.SDS_LOs.get(i, j);
                double d8 = d7 * d7 / d5;
                if (d8 > this.ct_threshold) {
                    out.printf(" %5d %15s  %7.4f  -->   %7.5f   -->  %7.4f  %15s %5d%n", i + 1, this.LOs.LO_labels[i], d5, d8, d6, this.LOs.LO_labels[j], j + 1);
                } else {
                    ++n4;
                    d4 += d8;
                }
                d += d8;
            }
        }
        out.println();
        out.printf("%d orbital pairs with total charge transfer of %.5f were not printed%n", n4, d4);
        out.println();
        return d;
    }

    public void new_CT(int[] nArray) {
        int n;
        out.println("Approximate charge transfer analysis in CLPO basis");
        out.println("NOTE: this is an experimental feature AND IS SUBJECT TO CHANGE!");
        out.println(" We expect to have the underlying theory published soon...");
        out.println("");
        out.printf("Threshold for printing: %.5f %n", this.ct_threshold);
        out.println("");
        int n2 = 0;
        for (int i = 0; i < nArray.length; ++i) {
            if (nArray[i] <= n2) continue;
            n2 = nArray[i];
        }
        double[] dArray = new double[n2];
        double[] dArray2 = new double[n2];
        int n3 = this.SDS_LOs.getRowDimension();
        int[] nArray2 = this.ensureCLPOsIntrafragment(nArray);
        out.println("IntrAfragment charge transfers (conjugation analysis, etc.)");
        for (n = 1; n <= n2; ++n) {
            out.printf("CT within fragment %d%n%n", n);
            this.perform_CT(n, n, nArray2);
        }
        out.println();
        out.println("IntErfragment charge transfers (donor-acceptor analysis, etc.)");
        out.println();
        for (n = 1; n <= n2; ++n) {
            for (int i = n + 1; i <= n2; ++i) {
                out.printf("CT between from fragment %d to fragment %d%n", n, i);
                double d = this.perform_CT(n, i, nArray2);
                int n4 = n - 1;
                dArray[n4] = dArray[n4] + d;
                int n5 = i - 1;
                dArray2[n5] = dArray2[n5] + d;
                out.printf("CT between from fragment %d to fragment %d%n", i, n);
                d = this.perform_CT(i, n, nArray2);
                int n6 = i - 1;
                dArray[n6] = dArray[n6] + d;
                int n7 = n - 1;
                dArray2[n7] = dArray2[n7] + d;
            }
        }
        out.println("Inter-molecular charge transfer summary (NEW):");
        out.println("Mol  Accepted -Donated  =  got_electrons");
        for (n = 0; n < n2; ++n) {
            out.printf("%3d  +%.5f -%.5f  =   %+.5f%n", n + 1, dArray2[n], dArray[n], dArray2[n] - dArray[n]);
        }
    }
}

