package sample.block;

import sample.CvsGame;
import mokit.exception.MktUIException;
import mokit.ui.G;
import mokit.ui.MktImage;

public class Ball {

	// 摜̕
	private int w = 11;
	
	// 摜̍
	private int h = 11;
	
	// 摜̕\ʒuX	
	private int x;
	
	// 摜̕\ʒuY
	private int y;

	// Xړx
	private int speed_x;

	// Yړx
	private int speed_y;

	// 摜CX^X
	private MktImage img;

	// Q[Jn
	private boolean is_start = false;

	// hbv
	private boolean is_out = false;

	public Ball() {

		img = new MktImage();
		try{
			img.setImage("ball.gif");
			img.setTransparent(255, 255, 255);
		}catch(MktUIException e){
			e.printStackTrace();
		}

		init();
	}
	
	public void init(){
		
		x = (CvsGame.FRAME_SX + CvsGame.FRAME_WIDTH) / 2 - w / 2;
		y = 210;
		speed_x = 3;
		speed_y = 3;
		is_start = false;
		is_out = false;
	}
	
	public void speedUp(){
		
		speed_x += 1;
		speed_y += 1;
	}

	public void paint() {

		G.drawImage(img, x, y);
	}

	public MktImage getImage() {

		return img;
	}

	public void start() {

		is_start = true;
	}
	
	public void move() {

		if(!is_start) return;

		if(speed_x > 0){
			if(x + speed_x < CvsGame.FRAME_SX + CvsGame.FRAME_WIDTH - w){
				x += speed_x;
			}else{
				speed_x *= -1;
			}
		}else{
			if(x + speed_x > CvsGame.FRAME_SX){
				x += speed_x;
			}else{
				speed_x *= -1;
			}
		}

		if(speed_y > 0){
			if(y + speed_y < CvsGame.FRAME_SY + CvsGame.FRAME_HEIGHT - h){
				y += speed_y;
			}else{
				// out
				y += 30;
				is_out = true;
			}
		}else{
			if(y + speed_y > CvsGame.FRAME_SY){
				y += speed_y;
			}else{
				speed_y *= -1;
			}
		}
	}

	public void moveWithBar(int speed) {

		if(!is_start){
			x += speed;
		}
	}

	public void chkBarHit(Bar bar) {

		int px = x + w / 2;
		int py = y + h;

		int[] b = bar.getSize();

		if(py >= b[1] && py <= b[1] + b[3]){

			// ɓ΍
			if(px >= b[0] && px <= b[0] + b[2] / 3){
				if(speed_x > 0){
					speed_x *= -1;
				}
				if(speed_y > 0){
					speed_y *= -1;
				}

			// EɓΉE
			}else if(px >= b[0] + b[2] / 3 * 2 && px <= b[0] + b[2]){
				if(speed_x < 0){
					speed_x *= -1;
				}
				if(speed_y > 0){
					speed_y *= -1;
				}

			// S߂ɓ΂܂
			}else if(px >= b[0] && px <= b[0] + b[2]){
				if(speed_y > 0){
					speed_y *= -1;
				}
			}
		}
	}

	public boolean chkBlockHit(Block block) {

		int px = x + w / 2;
		int py = y + h / 2;

		int[] b = block.getSize();

		if(py >= b[1] && py <= b[1] + b[3]){
			
			// ɓ΍
			if(px >= b[0] && px <= b[0] + b[2] / 3){
				if(speed_x > 0){
					speed_x *= -1;
				}
				//̔肪Kv..
				speed_y *= -1;
				
				return true;

			// EɓΉE
			}else if(px >= b[0] + b[2] / 3 * 2 && px <= b[0] + b[2]){
				if(speed_x < 0){
					speed_x *= -1;
				}
				//̔肪Kv..
				speed_y *= -1;
				
				return true;

			// S߂ɓ΂܂
			}else if(px >= b[0] && px <= b[0] + b[2]){
				speed_y *= -1;
				
				return true;
			}
		}
		return false;
	}
	
	public boolean chkOut(){
		return is_out;
	}

}
