/*
 * Decompiled with CFR 0.152.
 */
package mokit.io;

import com.nttdocomo.io.ConnectionException;
import com.nttdocomo.io.HttpConnection;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStreamWriter;
import java.util.Vector;
import javax.microedition.io.Connector;
import mokit.common.BaseMain;
import mokit.exception.HttpException;
import mokit.interfaces.HttpReceivedEvent;

public class HttpManager
extends Thread {
    private static HttpManager _manager;
    private Vector _que;
    private boolean _isRun;
    private static final int WAIT_QUE = 2000;

    private HttpManager() {
        if (_manager == null) {
            _manager = this;
        }
    }

    public static HttpManager getInstance() {
        if (_manager == null) {
            new HttpManager();
        }
        return _manager;
    }

    public void initQueThread() {
        if (this._isRun && this._que != null) {
            return;
        }
        this._que = new Vector();
        this._isRun = true;
        this.start();
    }

    public void stopQueThread() {
        this._isRun = false;
    }

    public void push(HttpReceivedEvent httpReceivedEvent, String string, String string2, String[] stringArray) throws HttpException {
        if (this._que == null) {
            throw new HttpException(2, "[push-null] url=" + string + ", post=" + string2);
        }
        this._que.addElement(new HttpQue(httpReceivedEvent, string, string2, stringArray));
    }

    private HttpQue pop() {
        HttpQue httpQue = (HttpQue)this._que.elementAt(0);
        this._que.removeElementAt(0);
        return httpQue;
    }

    public boolean hasQue() {
        if (this._que == null) {
            return false;
        }
        return this._que.size() > 0;
    }

    public void run() {
        while (this._isRun) {
            if (this.hasQue()) {
                HttpQue httpQue = this.pop();
                try {
                    byte[] byArray = this.requestHttp(httpQue.getUrl(), httpQue.getPostPrm());
                    httpQue.getReciever().httpReceived(byArray, httpQue.getOption());
                }
                catch (Exception exception) {
                    httpQue.getReciever().httpErrReceived(exception.getMessage(), httpQue.getOption());
                }
                continue;
            }
            try {
                Thread.sleep(2000L);
            }
            catch (Exception exception) {}
        }
        this._que = null;
    }

    public byte[] requestHttp(String string) throws IOException, HttpException {
        return this.requestHttp(string, null);
    }

    public synchronized byte[] requestHttp(String string, String string2) throws IOException, HttpException {
        string = BaseMain.getPath() + string;
        byte[] byArray = null;
        byte[] byArray2 = new byte[10240];
        HttpConnection httpConnection = null;
        InputStream inputStream = null;
        ByteArrayOutputStream byteArrayOutputStream = null;
        try {
            int n;
            if (string2 != null) {
                httpConnection = (HttpConnection)Connector.open((String)string, (int)3, (boolean)true);
                httpConnection.setRequestMethod("POST");
                httpConnection.setRequestProperty("Content-Type", "application/x-www-form-urlencoded");
                OutputStreamWriter outputStreamWriter = new OutputStreamWriter(httpConnection.openOutputStream());
                outputStreamWriter.write(string2, 0, string2.length());
                outputStreamWriter.close();
            } else {
                httpConnection = (HttpConnection)Connector.open((String)string, (int)1, (boolean)true);
                httpConnection.setRequestMethod("GET");
            }
            httpConnection.connect();
            if (httpConnection.getResponseCode() != 200) {
                throw new HttpException(0, "[requestHttp-status] url=" + string + ", post=" + string2);
            }
            inputStream = httpConnection.openInputStream();
            byteArrayOutputStream = new ByteArrayOutputStream();
            while ((n = inputStream.read(byArray2)) > 0) {
                byteArrayOutputStream.write(byArray2, 0, n);
            }
            byteArrayOutputStream.close();
            inputStream.close();
            httpConnection.close();
            byArray = byteArrayOutputStream.toByteArray();
        }
        catch (ConnectionException connectionException) {
            throw new HttpException(1, "[requestHttp-connection] url=" + string + ", post=" + string2);
        }
        catch (IOException iOException) {
            throw new IOException("[requestHttp-io] url=" + string + ", post=" + string2);
        }
        finally {
            try {
                if (inputStream != null) {
                    inputStream.close();
                }
                if (byteArrayOutputStream != null) {
                    byteArrayOutputStream.close();
                }
                if (httpConnection != null) {
                    httpConnection.close();
                }
            }
            catch (IOException iOException) {}
            byteArrayOutputStream = null;
            inputStream = null;
            httpConnection = null;
        }
        return byArray;
    }

    private class HttpQue {
        private HttpReceivedEvent _reciever;
        private String _url;
        private String _post;
        private String[] _option;

        public HttpQue(HttpReceivedEvent httpReceivedEvent, String string, String string2, String[] stringArray) {
            this._reciever = httpReceivedEvent;
            this._url = string;
            this._post = string2;
            this._option = stringArray;
        }

        public HttpReceivedEvent getReciever() {
            return this._reciever;
        }

        public String getUrl() {
            return this._url;
        }

        public String getPostPrm() {
            return this._post;
        }

        public String[] getOption() {
            return this._option;
        }
    }
}

