/*
 * Decompiled with CFR 0.152.
 */
package mokit.common;

import com.nttdocomo.ui.Canvas;
import com.nttdocomo.ui.Graphics;
import mokit.common.G;
import mokit.util.Logger;

public class BaseCanvas
extends Canvas {
    public static final int UP = 17;
    public static final int DOWN = 19;
    public static final int LEFT = 16;
    public static final int RIGHT = 18;
    public static final int SELECT = 20;
    public static final int KEY_0 = 0;
    public static final int KEY_1 = 1;
    public static final int KEY_2 = 2;
    public static final int KEY_3 = 3;
    public static final int KEY_4 = 4;
    public static final int KEY_5 = 5;
    public static final int KEY_6 = 6;
    public static final int KEY_7 = 7;
    public static final int KEY_8 = 8;
    public static final int KEY_9 = 9;
    public static final int KEY_AST = 10;
    public static final int KEY_PND = 11;
    public static final int KEY_IAPP = 24;
    public static final int KEY_SOFT1 = 21;
    public static final int KEY_SOFT2 = 22;
    public static final int KEY_NONE = -999;
    public static final int SOFT_LABEL_1 = 0;
    public static final int SOFT_LABEL_2 = 1;
    public static final int PRESSED_EVENT = 0;
    public static final int RELEASED_EVENT = 1;
    private static int keyEvent;
    private static int keyState;
    private static boolean continueThread;
    private static int retValue;

    public void paint(Graphics g) {
        G.setGraphics(g);
        G.lock();
        this.paintCvs();
        G.unlock(true);
    }

    public void repaintCvs() {
        G.lock();
        this.paintCvs();
        G.unlock(true);
    }

    public void paintCvs() {
    }

    public int startCvsThread(int time) {
        Logger.add("SYSTEM", "[cvs] startCvsThread(" + time + ")");
        continueThread = true;
        keyEvent = -999;
        keyState = 0;
        while (continueThread) {
            this.exe(keyEvent, keyState);
            keyEvent = -999;
            try {
                Thread.sleep(time);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return retValue;
    }

    public void exe(int keyEvent, int keyState) {
    }

    public void endCvsThread(int nextMode) {
        retValue = nextMode;
        continueThread = false;
    }

    public void setSoftLabel(String key1, String key2) {
        if (key1 != null) {
            this.setSoftLabel(0, key1);
        }
        if (key2 != null) {
            this.setSoftLabel(1, key2);
        }
    }

    public void processEvent(int type, int param) {
        keyState = this.getKeypadState();
        if (type == 0) {
            keyEvent = param;
        }
    }

    public boolean checkMultiKey(int key1, int key2) {
        return (1 << key1 & keyState) != 0 && (1 << key2 & keyState) != 0;
    }

    public boolean checkKey(int key) {
        return (1 << key & keyState) != 0 || keyEvent == key;
    }
}

