=begin

= mod_img - An Apache module for image processing.

== What is mod_img?

mod_img is an Apache module for image processing.

It is possible to give the "on the fly" processed image
without website author work to web browsers.

Supported methods:
* ((<"magnification and reduction"|Sizes>))
* ((<"file type conversion"|File types>))
* ((<"trimming"|Trimming>))

== Required environment

* Apache 1.3.x or later
  (Apache 1.3.26 is tested. Apache2 is not supported.)
* Imlib2 1.0.5 or later
  (Imlib2 1.0.5 is tested.)

== Installation

(1) Type `./configure' to create Makefile.
(2) Type `make' to compile.
(3) Switch root user.
(4) Type `make install' to install files.
(5) Edit `httpd.conf'.
(6) Restart Apache.

== Available options in httpd.conf

: ImgOutputType

  The default output file type.

: ImgMaxRatio

  The ratio of the image size to permit.
  The default is 1.0.

: ImgWorkDirectory

  The directory to use for work files.
  The default, it's read from environment variables "TMPDIR", "TMP" or "TEMP" or chosen "/tmp".

: ImgKeepWorkFiles

  Available value is...
  : On
    Keep all work files.
  : Off
    Automatically remove all work files.
  The default is On.

== Available options in Web browser

=== Sizes

: width=WIDTH

  Specify the output image width.
  ex:
  * width=600 => 600 pixels
  * width=x0.5 => 0.5 times

: height=HEIGHT

  Same as with=, but use for image height.

: size=SIZE

  Specify the manificient of the output image.
  size=x0.5 is same as width=0.5&height=x0.5

=== File types

: type=MIMETYPE

  Specify the output file type.
  Available file types is...
  * image/bmp
  * image/gif
  * image/jpeg
  * image/png
  * image/x-portable-anymap
  * image/tiff
  * image/x-pixmap

=== Trimming

: trim=X,Y,WIDTH,HEIGHT

  Specify the output file position.
  ex: trim=10,20,320,480

=end

html-title: mod_img
