/******************************************************************************
 * Copyright (C) 2007 Tetsuya Kimata <kimata@acapulco.dyndns.org>
 *
 * All rights reserved.
 *
 * This software is provided 'as-is', without any express or implied
 * warranty.  In no event will the authors be held liable for any
 * damages arising from the use of this software.
 *
 * Permission is granted to anyone to use this software for any
 * purpose, including commercial applications, and to alter it and
 * redistribute it freely, subject to the following restrictions:
 *
 * 1. The origin of this software must not be misrepresented; you must
 *    not claim that you wrote the original software. If you use this
 *    software in a product, an acknowledgment in the product
 *    documentation would be appreciated but is not required.
 *
 * 2. Altered source versions must be plainly marked as such, and must
 *    not be misrepresented as being the original software.
 *
 * 3. This notice may not be removed or altered from any source
 *    distribution.
 *
 * $Id: cgi_uploader.cpp 2512 2007-07-09 12:04:26Z svn $
 *****************************************************************************/

/**
 * @file
 * @brief CGI のエントリ関数群．
 */

#include "Environment.h"

#include <iostream>

#include "cgi_uploader.h"
#include "uploader_handler.h"

#include "CGIResponse.h"
#include "UploaderConfigReader.h"
#include "SourceInfo.h"

#define TEMPLATE_INSTANTIATION
#define RESPONSE_TYPE_CGI
#include "uploader_handler.cpp"

SOURCE_INFO_ADD("$Id: cgi_uploader.cpp 2512 2007-07-09 12:04:26Z svn $");

// #define BENCHMARK 1

int main(int argc, const char * const *argv)
{
    apr_pool_t *pool;
    apr_pool_t *handler_pool;
    const char *arg;
    UploaderConfig *config;
    int status;

    apr_app_initialize(&argc, &argv, NULL);
    apr_pool_create(&pool, NULL);

    try {
        arg = getenv("PATH_INFO");
        if (arg == NULL) {
            std::cout << "Location: http://";
            std::cout << CGIResponse::get_env(pool, "SERVER_NAME");

            if ((strcmp(CGIResponse::get_env(pool, "SERVER_PORT"),
                        "80") != 0)) {
                std::cout << ":" << CGIResponse::get_env(pool, "SERVER_PORT");
            }

            std::cout << CGIResponse::get_env(pool, "SCRIPT_NAME") << "/\r\n\r\n";
            return EXIT_SUCCESS;
        }

        config = UploaderConfigReader::read(pool, CONF_FILE_NAME);
        config->child_init();

#ifdef BENCHMARK
        for (apr_size_t i = 0; i < BENCHMARK; ++i) {
#endif
            apr_pool_create(&handler_pool, NULL);
            CGIResponse::Handle handle(pool);

            status = uploader_command_handler<CGIResponse>
                (&handle, config, arg);

            apr_pool_destroy(handler_pool);
#ifdef BENCHMARK
        }
#endif
        exit(0);
        apr_terminate();

        return status;
    } catch(const char *message) {
        // できれば Internal Server Error にしたいけど，問い合わせが多
        // くなりそうなので...
        std::cout << "Content-type: text/html; charset=EUC_JP\r\n\r\n";
        std::cout << "Fatal Error: " << message << std::endl;

        apr_terminate();

        return EXIT_FAILURE;
    }
}

// Local Variables:
// mode: c++
// coding: utf-8-dos
// End:
