/******************************************************************************
 * Copyright (C) 2006 Tetsuya Kimata <kimata@acapulco.dyndns.org>
 *
 * All rights reserved.
 *
 * This software is provided 'as-is', without any express or implied
 * warranty.  In no event will the authors be held liable for any
 * damages arising from the use of this software.
 *
 * Permission is granted to anyone to use this software for any
 * purpose, including commercial applications, and to alter it and
 * redistribute it freely, subject to the following restrictions:
 *
 * 1. The origin of this software must not be misrepresented; you must
 *    not claim that you wrote the original software. If you use this
 *    software in a product, an acknowledgment in the product
 *    documentation would be appreciated but is not required.
 *
 * 2. Altered source versions must be plainly marked as such, and must
 *    not be misrepresented as being the original software.
 *
 * 3. This notice may not be removed or altered from any source
 *    distribution.
 *
 * $Id: CGIResponseWriter.h 2508 2007-07-06 22:47:18Z svn $
 *****************************************************************************/

#ifndef CGI_RESPONSE_WRITER_H
#define CGI_RESPONSE_WRITER_H

#include "Environment.h"

#include <iostream>

#include "apr_file_io.h"

#include "ResponseWriter.h"
#include "CGIResponse.h"


/**
 * @brief コンソールにでレスポンスを書き出すクラス．
 */
class CGIResponseWriter: public ResponseWriter
{
public:
    CGIResponseWriter(CGIResponse::Handle *r=NULL)
    {

    };
    void write(const char *str, apr_size_t length) const
    {
        std::cout.write(str, static_cast<std::streamsize>(length));
#ifdef DEBUG_TemplateExecutor
        std::cout.flush();
#endif
    };
    void write(const char *str) const
    {
        std::cout << str;
#ifdef DEBUG_TemplateExecutor
        std::cout.flush();
#endif
    };
    void write(int i) const
    {
        std::cout << i;
#ifdef DEBUG_TemplateExecutor
        std::cout.flush();
#endif
    };
    void finish() const
    {
        std::cout.flush();
    };
    static bool is_sendfile_enabled(CGIResponse::Handle *r){
        return false;
    };
    static int sendfile(CGIResponse::Handle *r,
                        apr_file_t *file, apr_uint64_t length)
    {
        char buffer[SYS_PAGE_SIZE];

        for (apr_size_t read_size = sizeof(buffer);
             apr_file_read(file, buffer, &read_size) == APR_SUCCESS;) {
            std::cout.write(buffer, static_cast<std::streamsize>(read_size));
        }

        return OK;
    };
};

#endif

// Local Variables:
// mode: c++
// coding: utf-8-dos
// End:
