/******************************************************************************
 * Copyright (C) 2006 Tetsuya Kimata <kimata@acapulco.dyndns.org>
 *
 * All rights reserved.
 *
 * This software is provided 'as-is', without any express or implied
 * warranty.  In no event will the authors be held liable for any
 * damages arising from the use of this software.
 *
 * Permission is granted to anyone to use this software for any
 * purpose, including commercial applications, and to alter it and
 * redistribute it freely, subject to the following restrictions:
 *
 * 1. The origin of this software must not be misrepresented; you must
 *    not claim that you wrote the original software. If you use this
 *    software in a product, an acknowledgment in the product
 *    documentation would be appreciated but is not required.
 *
 * 2. Altered source versions must be plainly marked as such, and must
 *    not be misrepresented as being the original software.
 *
 * 3. This notice may not be removed or altered from any source
 *    distribution.
 *
 * $Id: DownloadFlowController.h 2235 2006-12-10 17:36:52Z svn $
 *****************************************************************************/

#ifndef DOWNLOAD_FLOW_CONTROLLER_H
#define DOWNLOAD_FLOW_CONTROLLER_H

#include "Environment.h"

#include <cstdlib>

#include "apr_shm.h"
#include "apr_time.h"
#include "apr_network_io.h"
#include "AtomicWrapper.h"

#include "FlowController.h"
#include "Macro.h"
#include "Uncopyable.h"

using namespace std;

/**
 * @brief ダウンロードのフロー制御を行うクラス．
 */
class DownloadFlowController: public FlowController
{
public:
    DownloadFlowController();
    bool add_session(apr_sockaddr_t *ip_address);
    void remove_session(apr_sockaddr_t *ip_address);

    static DownloadFlowController *get_instance(apr_shm_t *shm);
    static apr_size_t get_memory_size();

    static void dump_list(DownloadFlowController *flow_controller);

private:
    typedef struct Downloader {
        apr_size_t ip_address_size;
        apr_uint32_t ip_address[sizeof(address_type)/sizeof(apr_uint32_t)];
        apr_size_t session_count;
    } downloader_t;

    bool downloader_list_add(apr_sockaddr_t *ip_address);
    downloader_t *downloader_list_get(apr_sockaddr_t *ip_address);

    static void dump_downloader(downloader_t *downloader);

    apr_atomic_t lock_;
    apr_size_t downloader_count_;
    downloader_t downloader_list_[DLD_MAX_SESSION_COUNT];
};

#endif

// Local Variables:
// mode: c++
// coding: utf-8-dos
// End:
