/******************************************************************************
 * mod_uploader / ThumbnailWriter.h
 ******************************************************************************
 * Copyright (C) 2005 Tetsuya Kimata <kimata@acapulco.dyndns.org>
 *
 * All rights reserved.
 *
 * This software is provided 'as-is', without any express or implied
 * warranty.  In no event will the authors be held liable for any
 * damages arising from the use of this software.
 *
 * Permission is granted to anyone to use this software for any
 * purpose, including commercial applications, and to alter it and
 * redistribute it freely, subject to the following restrictions:
 *
 * 1. The origin of this software must not be misrepresented; you must
 *    not claim that you wrote the original software. If you use this
 *    software in a product, an acknowledgment in the product
 *    documentation would be appreciated but is not required.
 *
 * 2. Altered source versions must be plainly marked as such, and must
 *    not be misrepresented as being the original software.
 *
 * 3. This notice may not be removed or altered from any source
 *    distribution.
 *
 * $Id: ThumbnailWriter.h 704 2005-09-19 19:33:13Z svn $
 *****************************************************************************/

#ifdef HAVE_CONFIG_H
#include "mod_uploader_config.h"
#endif

#ifdef MAKE_THUMBNAIL
#ifndef THUMBNAILWRITER_H
#define THUMBNAILWRITER_H

#if defined(HAVE_FFMPEG_AVCODEC_H) && defined(HAVE_FFMPEG_AVFORMAT_H) && defined(HAVE_FFMPEG_AVIO_H)
#define HAVE_FFMPEG
#endif

#include "UploadItemReader.h"

#include "apr_pools.h"

#ifdef HAVE_FFMPEG
#include <ffmpeg/avformat.h>
#endif

#include <list>

using namespace std;

namespace Magick {
    class Image;
    class Geometry;
}

/**
 * Υͥ륯饹
 */
class ThumbnailWriter
{
public:
    static const char FILE_SUFFIX[];

    ThumbnailWriter(apr_pool_t *pool,
                    const char *file_dir, const char *thumb_dir);
    void write(const char *file_name);

    static const char *create_thumb_path(apr_pool_t *pool,
                                         const char *thumb_dir,
                                         const char *file_path);

private:
    static const apr_size_t MAGICK_SIZE_LIMIT;
    static const apr_size_t WIDTH_LIMIT;
    static const apr_size_t HEIGHT_LIMIT;
    static const apr_size_t BUFFER_SIZE;
    static const double FRAME_SAMPLE_SEC;
    static const double FRAME_DELAY_SEC;
    static const apr_size_t FRAME_NUMBER;
#ifdef HAVE_FFMPEG
    static const PixelFormat FRAME_PIXEL_FORMAT;
#endif

    ThumbnailWriter(const ThumbnailWriter&);
    ThumbnailWriter &operator=(const ThumbnailWriter&);

    bool create_image_thumb(apr_pool_t *pool, const char *file_name);
    bool open_image_file(apr_pool_t *pool, const char *file_name,
                         void **file_buffer, apr_size_t *size);

#ifdef HAVE_FFMPEG
    bool create_movie_thumb(apr_pool_t *pool, const char *file_name);
    bool open_movie_file(apr_pool_t *pool, const char *file_path,
                         AVFormatContext **format_context);
    bool open_movie_context(apr_pool_t *pool, const char *file_path,
                            AVFormatContext **format_context,
                            AVCodecContext **codec_context, AVCodec **codec,
                            int *video_index);
    void close_movie_context(AVFormatContext *format_context, AVCodecContext *codec_context);
    void read_movie_frame(AVFormatContext *format_context, AVCodecContext *codec_context,
                          AVFrame *frame, AVPicture *picture, int video_index,
                          double frame_sample, double frame_delay,
                          apr_size_t frame_number, list<Magick::Image> &frame_list);
#endif

    void adjust_size(Magick::Geometry &size) const;

    apr_pool_t *pool_;
    const char * const file_dir_;
    const char * const thumb_dir_;
};

#endif

#endif

// Local Variables:
// mode: c++
// buffer-file-coding-system: euc-japan-dos
// End:
